/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.joml.Quaternionfc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.legacy.client.LegacyOptions;

@Mixin(value={ItemInHandRenderer.class})
public abstract class ItemInHandRendererMixin {
    @Shadow
    @Final
    private Minecraft minecraft;

    @Shadow
    protected abstract void renderPlayerArm(PoseStack var1, MultiBufferSource var2, int var3, float var4, float var5, HumanoidArm var6);

    @Shadow
    protected abstract void applyItemArmTransform(PoseStack var1, HumanoidArm var2, float var3);

    @Shadow
    protected abstract void applyItemArmAttackTransform(PoseStack var1, HumanoidArm var2, float var3);

    @Shadow
    public abstract void renderItem(LivingEntity var1, ItemStack var2, ItemDisplayContext var3, PoseStack var4, MultiBufferSource var5, int var6);

    @Inject(method={"renderPlayerArm"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderPlayerArm(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, float f, float g, HumanoidArm humanoidArm, CallbackInfo ci) {
        if (this.minecraft.player == null || this.minecraft.player.isRemoved()) {
            ci.cancel();
        }
    }

    @Inject(method={"renderMapHand"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderMapHand(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, HumanoidArm humanoidArm, CallbackInfo ci) {
        if (this.minecraft.player == null || this.minecraft.player.isRemoved()) {
            ci.cancel();
        }
    }

    @Inject(method={"renderHandsWithItems"}, at={@At(value="HEAD")})
    public void renderItemLight(float f, PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, LocalPlayer localPlayer, int i, CallbackInfo ci, @Local(ordinal=0, argsOnly=true) LocalIntRef original) {
        int light = this.getLight(localPlayer.getMainHandItem(), localPlayer.getOffhandItem());
        if (((Boolean)LegacyOptions.itemLightingInHand.get()).booleanValue() && light > 0) {
            original.set(LightTexture.pack((int)light, (int)LightTexture.sky((int)i)));
        }
    }

    @Unique
    private int getLight(ItemStack mainHand, ItemStack offHand) {
        int n;
        int n2;
        BlockItem item;
        Item item2 = mainHand.getItem();
        if (item2 instanceof BlockItem) {
            item = (BlockItem)item2;
            n2 = item.getBlock().defaultBlockState().getLightEmission();
        } else {
            n2 = 0;
        }
        item2 = offHand.getItem();
        if (item2 instanceof BlockItem) {
            item = (BlockItem)item2;
            n = item.getBlock().defaultBlockState().getLightEmission();
        } else {
            n = 0;
        }
        return Math.max(n2, n);
    }

    @Inject(method={"renderArmWithItem"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;pushPose()V", shift=At.Shift.AFTER)})
    private void renderItemInHand(AbstractClientPlayer abstractClientPlayer, float f, float g, InteractionHand interactionHand, float h, ItemStack itemStack, float i, PoseStack poseStack, MultiBufferSource multiBufferSource, int j, CallbackInfo ci) {
        int screenWidth = this.minecraft.getWindow().getScreenWidth();
        int screenHeight = this.minecraft.getWindow().getScreenHeight();
        HumanoidArm humanoidArm = interactionHand == InteractionHand.MAIN_HAND ? abstractClientPlayer.getMainArm() : abstractClientPlayer.getMainArm().getOpposite();
        float d = ((float)screenWidth - (float)screenHeight * 16.0f / 9.0f) / (float)screenWidth;
        if (d != 0.0f) {
            poseStack.translate((float)(humanoidArm == HumanoidArm.RIGHT ? 1 : -1) * d / 4.0f, 0.0f, d / 4.0f);
        }
    }

    @Inject(method={"renderArmWithItem"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;pushPose()V", shift=At.Shift.AFTER)}, cancellable=true)
    private void renderArmWithItem(AbstractClientPlayer abstractClientPlayer, float f, float g, InteractionHand interactionHand, float h, ItemStack itemStack, float i, PoseStack poseStack, MultiBufferSource multiBufferSource, int j, CallbackInfo ci) {
        int k;
        if (!abstractClientPlayer.getUseItem().is(Items.CROSSBOW)) {
            return;
        }
        HumanoidArm humanoidArm = interactionHand == InteractionHand.MAIN_HAND ? abstractClientPlayer.getMainArm() : abstractClientPlayer.getMainArm().getOpposite();
        int n = k = humanoidArm == HumanoidArm.RIGHT ? 1 : -1;
        if (abstractClientPlayer.isUsingItem() && abstractClientPlayer.getUseItemRemainingTicks() > 0 && abstractClientPlayer.getUsedItemHand() == interactionHand) {
            if (!abstractClientPlayer.isInvisible()) {
                poseStack.pushPose();
                float duration = CrossbowItem.getChargeDuration((ItemStack)abstractClientPlayer.getUseItem(), (LivingEntity)abstractClientPlayer);
                float c = Mth.clamp((float)((float)abstractClientPlayer.getTicksUsingItem() + f), (float)0.0f, (float)duration);
                poseStack.mulPose((Quaternionfc)Axis.YN.rotationDegrees((float)k * 20.0f));
                poseStack.translate((double)((float)k * Mth.lerp((float)(c / duration), (float)0.2f, (float)0.85f)), 0.0, 0.54);
                this.renderPlayerArm(poseStack, multiBufferSource, j, -1.0f, 0.5f, humanoidArm.getOpposite());
                poseStack.popPose();
            }
            this.applyItemTransforms(poseStack, h, humanoidArm, i, k);
            float l = (float)itemStack.getUseDuration((LivingEntity)abstractClientPlayer) - ((float)abstractClientPlayer.getUseItemRemainingTicks() - f + 1.0f);
            float m = l / (float)CrossbowItem.getChargeDuration((ItemStack)itemStack, (LivingEntity)abstractClientPlayer);
            if (m > 1.0f) {
                m = 1.0f;
            }
            if (m > 0.1f) {
                float n2 = Mth.sin((float)((l - 0.1f) * 1.3f));
                float o = m - 0.1f;
                float p = n2 * o;
                poseStack.translate(p * 0.0f, p * 0.004f, p * 0.0f);
            }
            poseStack.translate((double)k * 0.2, (double)-0.1f, (double)(m * 0.04f) - 0.2);
            poseStack.scale(1.0f, 1.0f, 1.0f + m * 0.2f);
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)k * 25.0f));
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)k * 25.0f));
        } else {
            this.applyItemTransforms(poseStack, h, humanoidArm, i, k);
            if (CrossbowItem.isCharged((ItemStack)itemStack) && h < 0.001f && interactionHand == InteractionHand.MAIN_HAND) {
                poseStack.translate((float)k * -0.641864f, 0.0f, 0.0f);
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)k * 10.0f));
            }
        }
        this.renderItem((LivingEntity)abstractClientPlayer, itemStack, humanoidArm == HumanoidArm.RIGHT ? ItemDisplayContext.FIRST_PERSON_RIGHT_HAND : ItemDisplayContext.FIRST_PERSON_LEFT_HAND, poseStack, multiBufferSource, j);
        ci.cancel();
        poseStack.popPose();
    }

    @Unique
    private void applyItemTransforms(PoseStack poseStack, float h, HumanoidArm humanoidArm, float i, int k) {
        float lx = -0.4f * Mth.sin((float)(Mth.sqrt((float)h) * (float)Math.PI));
        float mx = 0.2f * Mth.sin((float)(Mth.sqrt((float)h) * ((float)Math.PI * 2)));
        float n = -0.2f * Mth.sin((float)(h * (float)Math.PI));
        poseStack.translate((float)k * lx, mx, n);
        this.applyItemArmTransform(poseStack, humanoidArm, i);
        this.applyItemArmAttackTransform(poseStack, humanoidArm, h);
    }
}

