/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReceiver;
import com.llamalad7.mixinextras.sugar.Local;
import java.text.DecimalFormat;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.TooltipDisplay;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.base.Bearer;
import wily.factoryapi.base.config.FactoryConfig;
import wily.legacy.Legacy4J;
import wily.legacy.config.LegacyCommonOptions;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin {
    @ModifyArg(method={"getStyledHoverName"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/chat/MutableComponent;withStyle(Lnet/minecraft/ChatFormatting;)Lnet/minecraft/network/chat/MutableComponent;", ordinal=0))
    public ChatFormatting getStyledHoverName(ChatFormatting arg) {
        return ChatFormatting.GOLD;
    }

    @Unique
    private DecimalFormat getLegacyDecimalFormat(DecimalFormat instance) {
        instance.setMinimumFractionDigits(FactoryConfig.hasCommonConfigEnabled(LegacyCommonOptions.legacyCombat) ? 1 : 0);
        return instance;
    }

    @Shadow
    public abstract void forEachModifier(EquipmentSlotGroup var1, BiConsumer<Holder<Attribute>, AttributeModifier> var2);

    @Shadow
    protected abstract void addModifierTooltip(Consumer<Component> var1, Player var2, Holder<Attribute> var3, AttributeModifier var4);

    @ModifyExpressionValue(method={"addModifierTooltip"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/attributes/AttributeModifier;is(Lnet/minecraft/resources/ResourceLocation;)Z")})
    private boolean addModifierTooltip(boolean original) {
        return !FactoryConfig.hasCommonConfigEnabled(LegacyCommonOptions.legacyCombat) && original;
    }

    @Inject(method={"addModifierTooltip"}, at={@At(value="HEAD")}, cancellable=true)
    private void addModifierTooltip(Consumer<Component> consumer, Player player, Holder<Attribute> holder, AttributeModifier attributeModifier, CallbackInfo ci) {
        if (FactoryConfig.hasCommonConfigEnabled(LegacyCommonOptions.legacyCombat) && attributeModifier.is(Item.BASE_ATTACK_SPEED_ID)) {
            ci.cancel();
        }
    }

    @ModifyExpressionValue(method={"addModifierTooltip"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/attributes/AttributeModifier;amount()D")})
    private double addModifierTooltip(double original, @Local(argsOnly=true) AttributeModifier modifier) {
        return (double)(modifier.is(Item.BASE_ATTACK_DAMAGE_ID) ? Legacy4J.getItemDamageModifier((ItemStack)this) : 0.0f) + original;
    }

    @Inject(method={"addModifierTooltip"}, at={@At(value="RETURN")})
    private void addModifierTooltipNoDamage(Consumer<Component> consumer, Player player, Holder<Attribute> holder, AttributeModifier attributeModifier, CallbackInfo ci, @Local(ordinal=1) double e) {
        if (e == 0.0 && FactoryConfig.hasCommonConfigEnabled(LegacyCommonOptions.legacyCombat)) {
            consumer.accept((Component)Component.translatable((String)("attribute.modifier.plus." + attributeModifier.operation().id()), (Object[])new Object[]{this.getLegacyDecimalFormat(ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT).format(e), Component.translatable((String)((Attribute)holder.value()).getDescriptionId())}).withStyle(ChatFormatting.GRAY));
        }
    }

    @ModifyReceiver(method={"addModifierTooltip"}, at={@At(value="INVOKE", target="Ljava/text/DecimalFormat;format(D)Ljava/lang/String;")})
    private DecimalFormat addModifierTooltip(DecimalFormat instance, double v) {
        return this.getLegacyDecimalFormat(instance);
    }

    @Redirect(method={"addAttributeTooltips"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;forEachModifier(Lnet/minecraft/world/entity/EquipmentSlotGroup;Ljava/util/function/BiConsumer;)V"))
    private void addAttributeTooltips(ItemStack instance, EquipmentSlotGroup equipmentSlotGroup, BiConsumer<Holder<Attribute>, AttributeModifier> biConsumer, Consumer<Component> consumer, TooltipDisplay tooltipDisplay, @Nullable Player player) {
        Bearer noSpace = Bearer.of((Object)true);
        this.forEachModifier(equipmentSlotGroup, (holder, attributeModifier) -> {
            if (((Boolean)noSpace.get()).booleanValue()) {
                consumer.accept(CommonComponents.EMPTY);
                if (!FactoryConfig.hasCommonConfigEnabled(LegacyCommonOptions.legacyCombat)) {
                    consumer.accept((Component)Component.translatable((String)("item.modifiers." + equipmentSlotGroup.getSerializedName())).withStyle(ChatFormatting.GRAY));
                }
                noSpace.set((Object)false);
            }
            this.addModifierTooltip(consumer, player, (Holder<Attribute>)holder, (AttributeModifier)attributeModifier);
        });
    }
}

