/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.textures.TextureFormat;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_10366;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11241;
import net.minecraft.class_11245;
import net.minecraft.class_11246;
import net.minecraft.class_11256;
import net.minecraft.class_11278;
import net.minecraft.class_11527;
import net.minecraft.class_11528;
import net.minecraft.class_11540;
import net.minecraft.class_11659;
import net.minecraft.class_11684;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_8030;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import wily.factoryapi.util.ColorUtil;
import wily.legacy.client.BufferSourceWrapper;
import wily.legacy.client.LegacyFeatureRenderDispatcher;
import wily.legacy.client.LegacyGuiItemRenderState;
import wily.legacy.client.LegacyOptions;

public class LegacyGuiItemRenderer
implements AutoCloseable {
    public static final Logger LOGGER = LogManager.getLogger((String)"legacy_gui_item_renderer");
    private static final int MAXIMUM_ITEM_ATLAS_SIZE = RenderSystem.getDevice().getMaxTextureSize();
    public static float OPACITY = 1.0f;
    private final int size;
    private final float opacity;
    private final Map<Object, AtlasPosition> atlasPositions = new Object2ObjectOpenHashMap();
    private final Map<Object, class_11527> oversizedItemRenderers = new Object2ObjectOpenHashMap();
    private final class_11278 itemsProjectionMatrixBuffer = new class_11278("items", -1000.0f, 1000.0f, true);
    @Nullable
    private GpuTexture itemsAtlas;
    @Nullable
    private GpuTextureView itemsAtlasView;
    @Nullable
    private GpuTexture itemsAtlasDepth;
    @Nullable
    private GpuTextureView itemsAtlasDepthView;
    private int itemAtlasX;
    private int itemAtlasY;
    private int cachedGuiScale;
    private boolean isValid = true;

    public LegacyGuiItemRenderer(int size, float opacity) {
        this.size = size;
        this.opacity = opacity;
    }

    public LegacyGuiItemRenderer(long sizopacity) {
        this((int)(sizopacity >> 32), Float.intBitsToFloat((int)sizopacity));
    }

    public static void pushOpacity(float hudOpacity) {
        OPACITY = hudOpacity;
    }

    public static void popOpacity() {
        OPACITY = 1.0f;
    }

    public static void secureTranslucentRender(boolean translucent, float alpha, Consumer<Boolean> render) {
        if (!translucent) {
            render.accept(false);
            return;
        }
        LegacyGuiItemRenderer.pushOpacity(alpha);
        render.accept(true);
        LegacyGuiItemRenderer.popOpacity();
    }

    public static float getXScale(Matrix3x2f matrix) {
        return class_3532.method_15355((float)(matrix.m00() * matrix.m00() + matrix.m01() * matrix.m01()));
    }

    public static float getYScale(Matrix3x2f matrix) {
        return class_3532.method_15355((float)(matrix.m10() * matrix.m10() + matrix.m11() * matrix.m11()));
    }

    public static int getScale(Matrix3x2f matrix) {
        return Math.round(Math.max(LegacyGuiItemRenderer.getXScale(matrix), LegacyGuiItemRenderer.getYScale(matrix)) * 16.0f);
    }

    private void createAtlasTextures(int i) {
        GpuDevice gpuDevice = RenderSystem.getDevice();
        this.itemsAtlas = gpuDevice.createTexture("UI items atlas", 12, TextureFormat.RGBA8, i, i, 1, 1);
        this.itemsAtlas.setTextureFilter(FilterMode.NEAREST, false);
        this.itemsAtlasView = gpuDevice.createTextureView(this.itemsAtlas);
        this.itemsAtlasDepth = gpuDevice.createTexture("UI items atlas depth", 8, TextureFormat.DEPTH32, i, i, 1, 1);
        this.itemsAtlasDepthView = gpuDevice.createTextureView(this.itemsAtlasDepth);
        gpuDevice.createCommandEncoder().clearColorAndDepthTextures(this.itemsAtlas, 0, this.itemsAtlasDepth, 1.0);
    }

    public void prepareItemElements(class_11684 dispatcher, class_11659 submitNodeCollector, class_4597.class_4598 bufferSource, class_11246 renderState, int frameNumber) {
        if (!renderState.method_71078().isEmpty()) {
            int i = this.getGuiScaleInvalidatingItemAtlasIfChanged();
            int j = this.size * i;
            int k = this.calculateAtlasSizeInPixels(renderState, j);
            if (this.itemsAtlas == null) {
                this.createAtlasTextures(k);
            }
            RenderSystem.outputColorTextureOverride = this.itemsAtlasView;
            RenderSystem.outputDepthTextureOverride = this.itemsAtlasDepthView;
            RenderSystem.setProjectionMatrix((GpuBufferSlice)this.itemsProjectionMatrixBuffer.method_71092((float)k, (float)k), (class_10366)class_10366.field_54954);
            class_310.method_1551().field_1773.method_71114().method_71034(class_308.class_11274.field_60027);
            class_4587 poseStack = new class_4587();
            MutableBoolean mutableBoolean = new MutableBoolean(false);
            MutableBoolean mutableBoolean2 = new MutableBoolean(false);
            renderState.method_71064(guiItemRenderState -> {
                if (LegacyGuiItemRenderState.of(guiItemRenderState).size() != this.size) {
                    return;
                }
                if (!((Boolean)LegacyOptions.enhancedItemTranslucency.get()).booleanValue() && LegacyGuiItemRenderState.of(guiItemRenderState).opacity() != this.opacity) {
                    return;
                }
                if (guiItemRenderState.method_72125() != null) {
                    mutableBoolean2.setTrue();
                } else {
                    class_11540 trackingItemStackRenderState = guiItemRenderState.method_72121();
                    AtlasPosition atlasPosition = this.atlasPositions.get(trackingItemStackRenderState.method_72239());
                    if (atlasPosition == null || trackingItemStackRenderState.method_70948() && atlasPosition.lastAnimatedOnFrame != frameNumber) {
                        boolean bl;
                        if (this.itemAtlasX + j > k) {
                            this.itemAtlasX = 0;
                            this.itemAtlasY += j;
                        }
                        boolean bl2 = bl = trackingItemStackRenderState.method_70948() && atlasPosition != null;
                        if (!bl && this.itemAtlasY + j > k) {
                            if (mutableBoolean.isFalse()) {
                                LOGGER.warn("Trying to render too many items in GUI at the same time. Skipping some of them.");
                                mutableBoolean.setTrue();
                            }
                        } else {
                            int l;
                            int kx = bl ? atlasPosition.x : this.itemAtlasX;
                            int n = l = bl ? atlasPosition.y : this.itemAtlasY;
                            if (bl) {
                                RenderSystem.getDevice().createCommandEncoder().clearColorAndDepthTextures(this.itemsAtlas, 0, this.itemsAtlasDepth, 1.0, kx, k - l - j, j, j);
                            }
                            this.renderItemToAtlas(dispatcher, submitNodeCollector, bufferSource, trackingItemStackRenderState, poseStack, kx, l, j);
                            float f = (float)kx / (float)k;
                            float g = (float)(k - l) / (float)k;
                            this.submitBlitFromItemAtlas(renderState, (class_11245)guiItemRenderState, f, g, j, k);
                            if (bl) {
                                atlasPosition.lastAnimatedOnFrame = frameNumber;
                            } else {
                                this.atlasPositions.put(guiItemRenderState.method_72121().method_72239(), new AtlasPosition(this.itemAtlasX, this.itemAtlasY, f, g, frameNumber));
                                this.itemAtlasX += j;
                            }
                        }
                    } else {
                        this.submitBlitFromItemAtlas(renderState, (class_11245)guiItemRenderState, atlasPosition.u, atlasPosition.v, j, k);
                    }
                }
            });
            RenderSystem.outputColorTextureOverride = null;
            RenderSystem.outputDepthTextureOverride = null;
            if (mutableBoolean2.getValue().booleanValue()) {
                renderState.method_71064(guiItemRenderState -> {
                    if (LegacyGuiItemRenderState.of(guiItemRenderState).size() != this.size) {
                        return;
                    }
                    if (!((Boolean)LegacyOptions.enhancedItemTranslucency.get()).booleanValue() && LegacyGuiItemRenderState.of(guiItemRenderState).opacity() != this.opacity) {
                        return;
                    }
                    if (guiItemRenderState.method_72125() != null) {
                        class_11540 trackingItemStackRenderState = guiItemRenderState.method_72121();
                        class_11527 oversizedItemRenderer = this.oversizedItemRenderers.computeIfAbsent(trackingItemStackRenderState.method_72239(), object -> new class_11527(bufferSource));
                        class_8030 screenRectangle = guiItemRenderState.method_72125();
                        class_11528 oversizedItemRenderState = new class_11528(guiItemRenderState, screenRectangle.method_49620(), screenRectangle.method_49618(), screenRectangle.method_49621(), screenRectangle.method_49619());
                        oversizedItemRenderer.method_70913((class_11256)oversizedItemRenderState, renderState, i);
                    }
                });
            }
        }
    }

    private void submitBlitFromItemAtlas(class_11246 renderState, class_11245 guiItemRenderState, float f, float g, int i, int j) {
        float h = f + (float)i / (float)j;
        float k = g + (float)(-i) / (float)j;
        float opacity = LegacyGuiItemRenderState.of(guiItemRenderState).opacity();
        renderState.method_71996(new class_11241(opacity == 1.0f || (Boolean)LegacyOptions.enhancedItemTranslucency.get() == false ? class_10799.field_59968 : class_10799.field_56883, class_11231.method_70900((GpuTextureView)this.itemsAtlasView), guiItemRenderState.method_72120(), guiItemRenderState.method_72122(), guiItemRenderState.method_72123(), guiItemRenderState.method_72122() + 16, guiItemRenderState.method_72123() + 16, f, h, g, k, opacity == 1.0f || (Boolean)LegacyOptions.enhancedItemTranslucency.get() == false ? -1 : ColorUtil.withAlpha((int)0xFFFFFF, (float)opacity), guiItemRenderState.method_72124(), null));
    }

    private void renderItemToAtlas(class_11684 featureRenderDispatcher, class_11659 submitNodeCollector, class_4597.class_4598 bufferSource, class_11540 trackingItemStackRenderState, class_4587 poseStack, int x, int y, int k) {
        boolean bl;
        poseStack.method_22903();
        poseStack.method_46416((float)x + (float)k / 2.0f, (float)y + (float)k / 2.0f, 0.0f);
        poseStack.method_22905((float)k, (float)(-k), (float)k);
        boolean bl2 = bl = !trackingItemStackRenderState.method_65608();
        if (bl) {
            class_310.method_1551().field_1773.method_71114().method_71034(class_308.class_11274.field_60026);
        } else {
            class_310.method_1551().field_1773.method_71114().method_71034(class_308.class_11274.field_60027);
        }
        if (this.opacity != 1.0f && !((Boolean)LegacyOptions.enhancedItemTranslucency.get()).booleanValue()) {
            LegacyFeatureRenderDispatcher.of(featureRenderDispatcher).setBufferSource(BufferSourceWrapper.translucent(bufferSource, this.opacity));
        }
        RenderSystem.enableScissorForRenderTypeDraws((int)x, (int)(this.itemsAtlas.getHeight(0) - y - k), (int)k, (int)k);
        trackingItemStackRenderState.method_65604(poseStack, submitNodeCollector, 0xF000F0, class_4608.field_21444, 0);
        featureRenderDispatcher.method_73002();
        bufferSource.method_22993();
        LegacyFeatureRenderDispatcher.of(featureRenderDispatcher).setBufferSource(bufferSource);
        RenderSystem.disableScissorForRenderTypeDraws();
        poseStack.method_22909();
    }

    private int calculateAtlasSizeInPixels(class_11246 renderState, int i) {
        int j;
        Set set = renderState.method_71078();
        if (this.atlasPositions.isEmpty()) {
            j = set.size();
        } else {
            j = this.atlasPositions.size();
            for (Object object : set) {
                if (this.atlasPositions.containsKey(object)) continue;
                ++j;
            }
        }
        if (this.itemsAtlas != null) {
            int k = this.itemsAtlas.getWidth(0) / i;
            int l = k * k;
            if (j < l) {
                return this.itemsAtlas.getWidth(0);
            }
            this.invalidateItemAtlas();
        }
        int k = set.size();
        int l = class_3532.method_70659((int)(k + k / 2));
        return Math.clamp((long)class_3532.method_15339((int)(l * i)), 512, MAXIMUM_ITEM_ATLAS_SIZE);
    }

    private int getGuiScaleInvalidatingItemAtlasIfChanged() {
        int i = class_310.method_1551().method_22683().method_4495();
        if (i != this.cachedGuiScale) {
            this.invalidateItemAtlas();
            for (class_11527 oversizedItemRenderer : this.oversizedItemRenderers.values()) {
                oversizedItemRenderer.method_72117();
            }
            this.cachedGuiScale = i;
        }
        return i;
    }

    @Override
    public void close() {
        this.invalidateItemAtlas();
    }

    private void invalidateItemAtlas() {
        this.itemAtlasX = 0;
        this.itemAtlasY = 0;
        this.atlasPositions.clear();
        if (this.itemsAtlas != null) {
            this.itemsAtlas.close();
            this.itemsAtlas = null;
        }
        if (this.itemsAtlasView != null) {
            this.itemsAtlasView.close();
            this.itemsAtlasView = null;
        }
        if (this.itemsAtlasDepth != null) {
            this.itemsAtlasDepth.close();
            this.itemsAtlasDepth = null;
        }
        if (this.itemsAtlasDepthView != null) {
            this.itemsAtlasDepthView.close();
            this.itemsAtlasDepthView = null;
        }
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void markValid() {
        this.isValid = true;
    }

    public void markInvalid() {
        this.isValid = false;
    }

    public static final class AtlasPosition {
        final int x;
        final int y;
        final float u;
        final float v;
        int lastAnimatedOnFrame;

        AtlasPosition(int i, int j, float f, float g, int k) {
            this.x = i;
            this.y = j;
            this.u = f;
            this.v = g;
            this.lastAnimatedOnFrame = k;
        }
    }
}

