/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_327;
import net.minecraft.class_3283;
import net.minecraft.class_3288;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3414;
import net.minecraft.class_342;
import net.minecraft.class_3518;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5375;
import net.minecraft.class_5489;
import net.minecraft.class_6382;
import net.minecraft.class_7367;
import net.minecraft.class_7529;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8028;
import net.minecraft.class_8494;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.config.FactoryConfig;
import wily.factoryapi.util.DynamicUtil;
import wily.factoryapi.util.ListMap;
import wily.legacy.Legacy4J;
import wily.legacy.client.CommonColor;
import wily.legacy.client.GlobalPacks;
import wily.legacy.client.LegacyClientWorldSettings;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyLoadingScreen;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.client.screen.ScrollableRenderer;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public record PackAlbum(String id, int version, class_2561 displayName, class_2561 description, Optional<class_2960> iconSprite, Optional<class_2960> backgroundSprite, List<String> packs, Optional<String> displayPack) {
    public static final Codec<PackAlbum> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.fieldOf("id").forGetter(PackAlbum::id), (App)Codec.INT.optionalFieldOf("version", (Object)0).forGetter(PackAlbum::version), (App)DynamicUtil.getComponentCodec().fieldOf("name").forGetter(PackAlbum::displayName), (App)DynamicUtil.getComponentCodec().fieldOf("description").forGetter(PackAlbum::description), (App)class_2960.field_25139.optionalFieldOf("icon").forGetter(PackAlbum::iconSprite), (App)class_2960.field_25139.optionalFieldOf("background").forGetter(PackAlbum::backgroundSprite), (App)Codec.STRING.listOf().fieldOf("packs").forGetter(PackAlbum::packs), (App)Codec.STRING.optionalFieldOf("displayPack").forGetter(PackAlbum::displayPack)).apply((Applicative)i, PackAlbum::new));
    public static final Codec<List<PackAlbum>> LIST_CODEC = CODEC.listOf();
    public static final ListMap<String, PackAlbum> resourceAlbums = new ListMap();
    public static final List<PackAlbum> DEFAULT_RESOURCE_ALBUMS = new ArrayList<PackAlbum>();
    public static final String RESOURCE_ALBUMS = "resource_albums";
    public static final Path RESOURCE_ALBUMS_PATH = class_310.method_1551().field_1697.toPath().resolve("resource_albums");
    @Deprecated
    public static final Path RESOURCE_ASSORTS_PATH = class_310.method_1551().field_1697.toPath().resolve("resource_assorts");
    public static final class_2561 ALBUM_OPTIONS = class_2561.method_43471((String)"legacy.menu.album_options");
    public static final class_2561 ALBUM_OPTIONS_MESSAGE = class_2561.method_43471((String)"legacy.menu.album_options_message");
    public static final class_2561 ADD_ALBUM = class_2561.method_43471((String)"legacy.menu.add_album");
    public static final class_2561 EDIT_ALBUM = class_2561.method_43471((String)"legacy.menu.edit_album");
    public static final class_2561 REMOVE_ALBUM = class_2561.method_43471((String)"legacy.menu.remove_album");
    public static final Gson GSON = new GsonBuilder().create();
    public static final PackAlbum MINECRAFT = PackAlbum.registerDefaultResource("minecraft", 2, (class_2561)class_2561.method_43471((String)"legacy.menu.albums.resource.minecraft"), (class_2561)class_2561.method_43471((String)"legacy.menu.albums.resource.minecraft.description"), null, Legacy4J.createModLocation("icon/background"), PackAlbum.getMinecraftResourcePacks(), "vanilla");
    public static final PackAlbum MINECRAFT_CLASSIC_TEXTURES = PackAlbum.registerDefaultResource("minecraft_classic", 1, (class_2561)class_2561.method_43471((String)"legacy.menu.albums.resource.minecraft_classic"), (class_2561)class_2561.method_43471((String)"legacy.menu.albums.resource.minecraft_classic.description"), Legacy4J.createModLocation("icon/minecraft_classic"), Legacy4J.createModLocation("icon/minecraft_classic_background"), PackAlbum.getMinecraftClassicResourcePacks(), null);
    public static final Stocker<String> defaultResourceAlbum = Stocker.of((Object)PackAlbum.MINECRAFT.id);

    public static List<String> getMinecraftResourcePacks() {
        return new ArrayList<String>(List.of("vanilla", FactoryAPI.getLoader().isForgeLike() ? "mod_resources" : "fabric", "legacy:legacy_waters"));
    }

    public static List<String> getMinecraftClassicResourcePacks() {
        List<String> album = PackAlbum.getMinecraftResourcePacks();
        album.add(album.size() - 1, "programmer_art");
        if (FactoryAPI.getLoader().isForgeLike()) {
            album.add(album.size() - 1, "legacy:programmer_art");
        }
        return album;
    }

    public static PackAlbum getDefaultResourceAlbum() {
        return PackAlbum.resourceById((String)defaultResourceAlbum.get());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PackAlbum)) return false;
        PackAlbum a = (PackAlbum)obj;
        if (!a.id.equals(this.id)) return false;
        return true;
    }

    public PackAlbum withPacks(List<String> packs) {
        return new PackAlbum(this.id, this.version, this.displayName, this.description, this.iconSprite, this.backgroundSprite, packs, this.displayPack);
    }

    public static void init() {
        List<PackAlbum> albums = Files.exists(RESOURCE_ASSORTS_PATH, new LinkOption[0]) ? PackAlbum.load(RESOURCE_ASSORTS_PATH, DEFAULT_RESOURCE_ALBUMS, defaultResourceAlbum, true) : Collections.emptyList();
        albums.forEach(PackAlbum::registerResource);
        if (!Files.exists(RESOURCE_ALBUMS_PATH, new LinkOption[0]) || !albums.isEmpty()) {
            PackAlbum.save(RESOURCE_ALBUMS_PATH, DEFAULT_RESOURCE_ALBUMS, defaultResourceAlbum);
        }
        if (albums.isEmpty()) {
            PackAlbum.load();
        }
    }

    public static PackAlbum resourceById(String s) {
        return (PackAlbum)resourceAlbums.getOrDefault((Object)s, (Object)MINECRAFT);
    }

    public static void load() {
        resourceAlbums.clear();
        PackAlbum.load(RESOURCE_ALBUMS_PATH, DEFAULT_RESOURCE_ALBUMS, defaultResourceAlbum).forEach(PackAlbum::registerResource);
    }

    public static List<PackAlbum> load(Path path, List<PackAlbum> defaultAlbums, Stocker<String> selected) {
        return PackAlbum.load(path, defaultAlbums, selected, false);
    }

    public static List<PackAlbum> load(Path path, List<PackAlbum> defaultAlbums, Stocker<String> selected, boolean deprecated) {
        ArrayList<String> order = new ArrayList<String>();
        Path orderJson = path.resolveSibling(String.valueOf(path.getFileName()) + ".json");
        String defaultAlbum = PackAlbum.MINECRAFT.id;
        try (BufferedReader r2 = Files.newBufferedReader(orderJson, Charsets.UTF_8);){
            JsonObject obj = (JsonObject)GSON.getAdapter(JsonObject.class).read(new JsonReader((Reader)r2));
            defaultAlbum = obj.getAsJsonPrimitive("default").getAsString();
            for (JsonElement e : obj.getAsJsonArray("order")) {
                if (!(e instanceof JsonPrimitive)) continue;
                order.add(e.getAsString());
            }
        }
        catch (IOException r2) {
            // empty catch block
        }
        for (int i = defaultAlbums.size() - 1; i >= 0; --i) {
            PackAlbum a = defaultAlbums.get(i);
            if (order.contains(a.id)) continue;
            order.add(0, a.id);
        }
        ArrayList<PackAlbum> list = new ArrayList<PackAlbum>();
        try (Stream<Path> s = Files.walk(path, new FileVisitOption[0]).sorted(Comparator.comparingInt(p -> {
            int i = order.indexOf(FilenameUtils.getBaseName((String)p.getFileName().toString()));
            return i < 0 ? order.size() : i;
        }));){
            for (Path p2 : s::iterator) {
                if (!p2.toString().endsWith(".json")) continue;
                try {
                    BufferedReader r = Files.newBufferedReader(p2, Charsets.UTF_8);
                    try {
                        CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)class_3518.method_15255((Reader)r)).result().ifPresent(list::add);
                    }
                    finally {
                        if (r == null) continue;
                        r.close();
                    }
                }
                catch (IOException e) {
                    Legacy4J.LOGGER.warn("Failed to load {}, this album won't be loaded", (Object)p2, (Object)e);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (deprecated) {
            FileUtils.deleteQuietly((File)path.toFile());
            FileUtils.deleteQuietly((File)orderJson.toFile());
            if (list.isEmpty()) {
                return Collections.emptyList();
            }
        }
        for (int i = defaultAlbums.size() - 1; i >= 0; --i) {
            PackAlbum a = defaultAlbums.get(i);
            int index = list.indexOf(a);
            if (index < 0) {
                list.add(0, a);
                continue;
            }
            if (a.version <= ((PackAlbum)list.get((int)index)).version) continue;
            list.set(index, a);
        }
        selected.set((Object)defaultAlbum);
        return list;
    }

    public static void save() {
        PackAlbum.save(RESOURCE_ALBUMS_PATH, resourceAlbums.values(), defaultResourceAlbum);
    }

    public static void save(Path path, Collection<PackAlbum> albums, Stocker<String> selected) {
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectory(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                Legacy4J.LOGGER.warn("Failed to make albums directory {}", (Object)path, (Object)e);
            }
        } else {
            FileUtils.listFiles((File)path.toFile(), (String[])new String[]{"json"}, (boolean)true).forEach(File::delete);
        }
        ArrayList<String> order = new ArrayList<String>();
        for (PackAlbum album : albums) {
            order.add(album.id);
            Path p = path.resolve(album.id + ".json");
            try (JsonWriter w = new JsonWriter((Writer)Files.newBufferedWriter(p, Charsets.UTF_8, new OpenOption[0]));){
                w.setSerializeNulls(false);
                w.setIndent("  ");
                class_3518.method_43677((JsonWriter)w, (JsonElement)((JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)album).result().orElseThrow()), null);
            }
            catch (IOException e) {
                Legacy4J.LOGGER.warn("Failed to write {}, this album won't be saved", (Object)p, (Object)e);
            }
        }
        Path orderJson = path.resolveSibling(String.valueOf(path.getFileName()) + ".json");
        try (JsonWriter w = new JsonWriter((Writer)Files.newBufferedWriter(orderJson, Charsets.UTF_8, new OpenOption[0]));){
            w.setSerializeNulls(false);
            w.setIndent("  ");
            JsonArray a = new JsonArray();
            order.forEach(arg_0 -> ((JsonArray)a).add(arg_0));
            JsonObject obj = new JsonObject();
            obj.add("default", (JsonElement)new JsonPrimitive((String)selected.get()));
            obj.add("order", (JsonElement)a);
            class_3518.method_43677((JsonWriter)w, (JsonElement)obj, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static PackAlbum registerResource(PackAlbum a) {
        resourceAlbums.put((Object)a.id(), (Object)a);
        return a;
    }

    public static PackAlbum registerDefaultResource(String id, int version, class_2561 displayName, class_2561 description, class_2960 iconSprite, class_2960 backgroundSprite, List<String> packs, String displayPack) {
        return PackAlbum.registerDefaultResource(new PackAlbum(id, version, displayName, description, Optional.ofNullable(iconSprite), Optional.ofNullable(backgroundSprite), packs, Optional.ofNullable(displayPack)));
    }

    public static PackAlbum registerDefaultResource(PackAlbum a) {
        DEFAULT_RESOURCE_ALBUMS.add(a);
        return a;
    }

    public static void applyDefaultResourceAlbum() {
        List<String> oldSelection = PackAlbum.getSelectableIds(class_310.method_1551().method_1520());
        ((GlobalPacks)GlobalPacks.globalResources.get()).applyPacks(class_310.method_1551().method_1520(), PackAlbum.getDefaultResourceAlbum().packs());
        if (!oldSelection.equals(PackAlbum.getSelectableIds(class_310.method_1551().method_1520()))) {
            class_310.method_1551().method_1521();
            PackAlbum.updateSavedResourcePacks();
        }
    }

    public static void updateSavedResourcePacks() {
        class_310.method_1551().field_1690.field_1887.clear();
        class_310.method_1551().field_1690.field_1846.clear();
        class_310.method_1551().method_1520().method_14444().forEach(p -> {
            if (p.method_14460().method_14437()) {
                class_310.method_1551().field_1690.field_1887.add(p.method_14463());
            } else {
                class_310.method_1551().field_1690.field_1846.add(p.method_14463());
            }
        });
    }

    public static List<String> getSelectedIds(class_3283 packRepository) {
        return packRepository.method_14444().stream().map(class_3288::method_14463).toList();
    }

    public static List<String> getSelectableIds(class_3283 packRepository) {
        return packRepository.method_14444().stream().filter(pack -> !FactoryAPIPlatform.isPackHidden((class_3288)pack)).map(class_3288::method_14463).toList();
    }

    public boolean isValidPackDisplay(class_3283 packRepository) {
        String id = this.getDisplayPackId();
        if (id == null) {
            return false;
        }
        return packRepository.method_14449(id) != null;
    }

    public String getDisplayPackId() {
        return this.displayPack.orElse(this.packs.isEmpty() ? null : this.packs.get(this.packs.size() - 1));
    }

    public static ConfirmationScreen createAlbumEditScreen(class_437 parent, class_2561 title, class_2561 defaultName, class_2561 defaultDescription, BiConsumer<class_2561, class_2561> editAlbum) {
        final class_342 nameBox = new class_342(class_310.method_1551().field_1772, 0, 0, 200, 20, (class_2561)class_2561.method_43471((String)"legacy.menu.album_info"));
        final class_7529 descriptionBox = new class_7529(class_310.method_1551().field_1772, 0, 0, 200, 60, defaultDescription, nameBox.method_25369());
        nameBox.method_47404(defaultName);
        return new ConfirmationScreen(parent, 230, 184, title, nameBox.method_25369(), p -> editAlbum.accept((class_2561)(nameBox.method_1882().isBlank() ? defaultName : class_2561.method_43470((String)nameBox.method_1882())), (class_2561)(descriptionBox.method_44405().isBlank() ? defaultDescription : class_2561.method_43470((String)descriptionBox.method_44405())))){

            @Override
            protected void method_25426() {
                super.method_25426();
                nameBox.method_48229(this.panel.x + 15, this.panel.y + 45);
                this.method_37063((class_364)nameBox);
                descriptionBox.method_48229(this.panel.x + 15, this.panel.y + 69);
                this.method_37063((class_364)descriptionBox);
            }
        };
    }

    public static class Selector
    extends class_339
    implements ControlTooltip.ActionHolder {
        public static final String TEMPLATE_ALBUM = "template_album";
        public static final class_2960 DEFAULT_ICON = FactoryAPI.createVanillaLocation((String)"textures/misc/unknown_pack.png");
        private static final Map<String, class_2960> packIcons = Maps.newHashMap();
        private static final Map<String, class_2960> packBackgrounds = Maps.newHashMap();
        private final ListMap<String, PackAlbum> albums;
        public final Stocker.Sizeable scrolledList;
        private final class_2561 screenComponent;
        public PackAlbum savedAlbum;
        protected final PackAlbum initialAlbum;
        private final Path packPath;
        private final Consumer<Selector> reloadChanges;
        private final FactoryConfig<GlobalPacks> globalPacks;
        private final boolean hasTooltip;
        public int selectedIndex;
        private final class_3283 packRepository;
        private final class_310 minecraft;
        protected final List<String> oldSelection;
        protected final LegacyScrollRenderer scrollRenderer = new LegacyScrollRenderer();
        public final ScrollableRenderer scrollableRenderer = new ScrollableRenderer(this.scrollRenderer);
        public final BiFunction<class_2561, Integer, class_5489> labelsCache = class_156.method_34865((c, i) -> class_5489.method_30890((class_327)class_310.method_1551().field_1772, (class_2561)c, (int)i));

        public static Selector resources(int i, int j, int k, int l, boolean hasTooltip) {
            return new Selector(i, j, k, l, LegacyComponents.RESOURCE_ALBUMS, LegacyComponents.SHOW_RESOURCE_PACKS, (ListMap)resourceAlbums, class_310.method_1551().method_1496() ? LegacyClientWorldSettings.of(class_310.method_1551().method_1576().method_27728()).getSelectedResourceAlbum() : PackAlbum.resourceById((String)defaultResourceAlbum.get()), class_310.method_1551().method_1520(), class_310.method_1551().method_1479(), Selector::reloadResourcesChanges, (FactoryConfig)GlobalPacks.globalResources, hasTooltip){

                @Override
                public void applyChanges(boolean reloadAndSave) {
                    super.applyChanges(reloadAndSave);
                    if (!class_310.method_1551().method_1496()) {
                        defaultResourceAlbum.set((Object)this.savedAlbum.id());
                        PackAlbum.save();
                    }
                }
            };
        }

        public static Selector resources(int i, int j, int k, int l, boolean hasTooltip, PackAlbum selectedAlbum) {
            return new Selector(i, j, k, l, LegacyComponents.RESOURCE_ALBUMS, LegacyComponents.SHOW_RESOURCE_PACKS, resourceAlbums, selectedAlbum, class_310.method_1551().method_1520(), class_310.method_1551().method_1479(), Selector::reloadResourcesChanges, GlobalPacks.globalResources, hasTooltip);
        }

        public Selector(int i2, int j, int k, int l, class_2561 component, class_2561 screenComponent, ListMap<String, PackAlbum> albums, PackAlbum savedAlbum, class_3283 packRepository, Path packPath, Consumer<Selector> reloadChanges, FactoryConfig<GlobalPacks> globalPacks, boolean hasTooltip) {
            super(i2, j, k, l, component);
            this.screenComponent = screenComponent;
            this.savedAlbum = this.initialAlbum = savedAlbum;
            this.packPath = packPath;
            this.reloadChanges = reloadChanges;
            this.globalPacks = globalPacks;
            this.hasTooltip = hasTooltip;
            this.albums = albums;
            this.minecraft = class_310.method_1551();
            this.packRepository = packRepository;
            this.oldSelection = PackAlbum.getSelectedIds(packRepository);
            this.scrolledList = new Stocker.Sizeable(Integer.valueOf(0));
            if (albums.size() > this.getMaxPacks()) {
                this.scrolledList.max = albums.size() - this.getMaxPacks();
            }
            this.setSelectedIndex(savedAlbum == null ? 0 : ((List)albums.values()).indexOf(savedAlbum));
            while (this.selectedIndex >= (Integer)this.scrolledList.get() + this.getMaxPacks() && this.scrolledList.add(1) != 0) {
            }
            this.updateTooltip();
        }

        public void updateTooltip() {
            if (this.hasTooltip) {
                this.method_47400(class_7919.method_47408((class_2561)this.getSelectedAlbum().description(), (class_2561)this.getSelectedAlbum().displayName()));
            }
        }

        public void renderTooltipBox(class_332 guiGraphics, class_8021 panel) {
            this.renderTooltipBox(guiGraphics, panel, 0);
        }

        public void renderTooltipBox(class_332 guiGraphics, class_8021 panel, int xOffset) {
            this.renderTooltipBox(guiGraphics, panel.method_46426() + panel.method_25368() - 2 + xOffset, panel.method_46427() + 5, 161, panel.method_25364() - 10);
        }

        public void renderTooltipBox(class_332 graphics, int x, int y, int width, int height) {
            if (this.hasTooltip) {
                return;
            }
            ScreenUtil.renderPointerPanel(graphics, x, y, width, height);
            if (this.getSelectedAlbum() != null) {
                boolean p = this.getSelectedAlbum().isValidPackDisplay(this.packRepository);
                if (this.getSelectedAlbum().iconSprite().isPresent()) {
                    FactoryGuiGraphics.of((class_332)graphics).blitSprite(this.getSelectedAlbum().iconSprite().get(), x + 7, y + 5, 32, 32);
                } else {
                    FactoryGuiGraphics.of((class_332)graphics).blit(p ? Selector.getPackIcon(this.packRepository.method_14449(this.getSelectedAlbum().getDisplayPackId())) : DEFAULT_ICON, x + 7, y + 5, 0.0f, 0.0f, 32, 32, 32, 32);
                }
                graphics.method_44379(x + 40, y + 4, x + 148, y + 44);
                this.labelsCache.apply(this.getSelectedAlbum().displayName(), 108).method_30893(graphics, x + 43, y + 8, 12, 0xFFFFFF);
                graphics.method_44380();
                class_2960 background = this.getSelectedAlbum().backgroundSprite.orElse(p ? Selector.getPackBackground(this.packRepository.method_14449(this.getSelectedAlbum().getDisplayPackId())) : null);
                class_5489 label = this.labelsCache.apply(this.getSelectedAlbum().description(), 145);
                this.scrollableRenderer.render(graphics, x + 8, y + 40, 146, 12 * (background == null ? 14 : 7), () -> label.method_30893(graphics, x + 8, y + 40, 12, 0xFFFFFF));
                if (background != null) {
                    if (this.getSelectedAlbum().backgroundSprite().isPresent()) {
                        FactoryGuiGraphics.of((class_332)graphics).blitSprite(background, x + 8, y + height - 78, 145, 72);
                    } else {
                        FactoryGuiGraphics.of((class_332)graphics).blit(background, x + 8, y + height - 78, 0.0f, 0.0f, 145, 72, 145, 72);
                    }
                }
            }
        }

        public boolean method_25404(int i, int j, int k) {
            if (this.method_25367() && this.field_22763) {
                if (i == 88) {
                    this.openPackSelectionScreen();
                    return true;
                }
                if (class_8494.method_51255((int)i)) {
                    this.savedAlbum = this.getSelectedAlbum();
                    this.method_25354(class_310.method_1551().method_1483());
                    return true;
                }
                if (i == 263 || i == 262) {
                    if (this.selectedIndex == (Integer)this.scrolledList.get() + (i == 263 ? 0 : this.getMaxPacks() - 1)) {
                        this.updateScroll(i == 263 ? -1 : 1, true);
                    }
                    this.setSelectedIndex(this.selectedIndex + (i == 263 ? -1 : 1));
                    ScreenUtil.playSimpleUISound((class_3414)LegacyRegistries.SCROLL.get(), 1.0f);
                    return true;
                }
                if (i == 79) {
                    final class_437 screen = class_310.method_1551().field_1755;
                    this.minecraft.method_1507((class_437)new ConfirmationScreen(this.minecraft.field_1755, 230, 133, ALBUM_OPTIONS, ALBUM_OPTIONS_MESSAGE, b -> {}){

                        @Override
                        protected void addButtons() {
                            this.renderableVList.addRenderable((class_4068)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.cancel"), b -> this.method_25419()).method_46431());
                            this.renderableVList.addRenderable((class_4068)class_4185.method_46430((class_2561)ADD_ALBUM, b -> {
                                int repeat = 0;
                                while (!PackAlbum.resourceById(Selector.TEMPLATE_ALBUM + (String)(repeat > 0 ? "_" + repeat : "")).equals(MINECRAFT)) {
                                    ++repeat;
                                }
                                String id = Selector.TEMPLATE_ALBUM + (String)(repeat > 0 ? "_" + repeat : "");
                                this.field_22787.method_1507((class_437)PackAlbum.createAlbumEditScreen(this.parent, b.method_25369(), (class_2561)class_2561.method_43469((String)"legacy.menu.albums.resource.template", (Object[])new Object[]{repeat}), (class_2561)class_2561.method_43471((String)"legacy.menu.albums.resource.template.description"), (name, description) -> this.field_22787.method_1507((class_437)new class_5375(packRepository, r -> {
                                    resourceAlbums.put((Object)id, (Object)new PackAlbum(id, 0, (class_2561)name, (class_2561)description, Optional.empty(), Optional.empty(), PackAlbum.getSelectableIds(packRepository), Optional.empty()));
                                    PackAlbum.save();
                                    class_310.method_1551().method_1507(this.parent);
                                    packRepository.method_14447(oldSelection);
                                    this.updateSavedAlbum();
                                    this.setSelectedIndex(albums.size());
                                }, packPath, this.field_22785))));
                            }).method_46431());
                            this.renderableVList.addRenderable((class_4068)class_4185.method_46430((class_2561)EDIT_ALBUM, b -> {
                                PackAlbum editAlbum = this.getSelectedAlbum();
                                this.field_22787.method_1507((class_437)PackAlbum.createAlbumEditScreen(this.parent, b.method_25369(), editAlbum.displayName, editAlbum.description, (name, description) -> {
                                    resourceAlbums.put((Object)editAlbum.id(), (Object)new PackAlbum(editAlbum.id(), editAlbum.version(), (class_2561)name, (class_2561)description, editAlbum.iconSprite(), editAlbum.backgroundSprite(), editAlbum.packs(), editAlbum.displayPack()));
                                    PackAlbum.save();
                                    class_310.method_1551().method_1507(this.parent);
                                    packRepository.method_14447(oldSelection);
                                    this.updateSavedAlbum();
                                }));
                            }).method_46431());
                            class_4185 removeButton = class_4185.method_46430((class_2561)REMOVE_ALBUM, b -> {
                                albums.remove((Object)this.getSelectedAlbum().id());
                                PackAlbum.save();
                                this.updateSavedAlbum();
                                this.setSelectedIndex(0);
                                this.field_22787.method_1507(screen);
                            }).method_46431();
                            this.renderableVList.addRenderable((class_4068)removeButton);
                            if (DEFAULT_RESOURCE_ALBUMS.stream().anyMatch(a -> a.equals(this.getSelectedAlbum()))) {
                                removeButton.field_22763 = false;
                            }
                        }
                    });
                    return true;
                }
            }
            return super.method_25404(i, j, k);
        }

        public void setSelectedIndex(int index) {
            if (this.selectedIndex == index) {
                return;
            }
            this.selectedIndex = Stocker.cyclic((int)0, (int)index, (int)this.albums.size());
            this.scrollableRenderer.scrolled.set(Integer.valueOf(0));
            this.scrollableRenderer.scrolled.max = Math.max((int)0, (int)(this.labelsCache.apply(this.getSelectedAlbum().description(), 145).method_30887() - (this.getSelectedAlbum().backgroundSprite.orElse(this.getSelectedAlbum().isValidPackDisplay(this.packRepository) ? Selector.getPackBackground(this.packRepository.method_14449(this.getSelectedAlbum().getDisplayPackId())) : null) == null ? 20 : 7)));
            this.updateTooltip();
        }

        public void applyChanges(boolean reloadAndSave) {
            ((GlobalPacks)this.globalPacks.get()).applyPacks(this.packRepository, this.savedAlbum.packs());
            if (class_310.method_1551().method_1496()) {
                LegacyClientWorldSettings.of(class_310.method_1551().method_1576().method_27728()).setSelectedResourceAlbum(this.savedAlbum);
            }
            if (reloadAndSave) {
                this.reloadChanges.accept(this);
            }
        }

        public static void applyResourceChanges(class_310 minecraft, List<String> oldSelection, List<String> newSelection, Runnable runnable) {
            ((GlobalPacks)GlobalPacks.globalResources.get()).applyPacks(minecraft.method_1520(), newSelection);
            minecraft.method_1507((class_437)new LegacyLoadingScreen());
            if (!oldSelection.equals(PackAlbum.getSelectedIds(minecraft.method_1520()))) {
                PackAlbum.updateSavedResourcePacks();
                class_310.method_1551().method_1521().thenRun(runnable);
            } else {
                runnable.run();
            }
        }

        public static void reloadResourcesChanges(Selector selector) {
            if (!selector.oldSelection.equals(PackAlbum.getSelectedIds(selector.packRepository))) {
                PackAlbum.updateSavedResourcePacks();
                class_310.method_1551().method_1521();
            }
        }

        public void openPackSelectionScreen() {
            if (this.minecraft.field_1755 != null) {
                class_437 screen = this.minecraft.field_1755;
                this.packRepository.method_14447(this.getSelectedAlbum().packs());
                List<String> oldSelection = PackAlbum.getSelectedIds(this.packRepository);
                this.minecraft.method_1507((class_437)new class_5375(this.packRepository, p -> {
                    if (!oldSelection.equals(PackAlbum.getSelectedIds(p))) {
                        this.albums.put((Object)this.getSelectedAlbum().id(), (Object)this.getSelectedAlbum().withPacks(List.copyOf(PackAlbum.getSelectableIds(p))));
                        this.updateSavedAlbum();
                        PackAlbum.save();
                    }
                    this.minecraft.method_1507(screen);
                    this.packRepository.method_14447(this.oldSelection);
                }, this.packPath, this.method_25369()));
            }
        }

        public void updateSavedAlbum() {
            this.savedAlbum = (PackAlbum)this.albums.getOrDefault((Object)this.savedAlbum.id(), (Object)this.initialAlbum);
        }

        public void method_25365(boolean bl) {
            if (!bl && this.savedAlbum != null) {
                this.setSelectedIndex(((List)this.albums.values()).indexOf(this.savedAlbum));
            }
            super.method_25365(bl);
        }

        public void method_25348(double d, double e) {
            if (class_437.method_25442()) {
                this.openPackSelectionScreen();
                return;
            }
            int visibleCount = 0;
            for (int index = 0; index < this.albums.size() && visibleCount < this.getMaxPacks(); ++visibleCount, ++index) {
                double d2 = this.method_46426() + 20 + 30 * index;
                int n = this.method_46427();
                Objects.requireNonNull(this.minecraft.field_1772);
                if (!ScreenUtil.isMouseOver(d, e, d2, n + 9 + 3, 30, 30)) continue;
                this.setSelectedIndex(index + (Integer)this.scrolledList.get());
                this.savedAlbum = this.getSelectedAlbum();
                this.method_25354(class_310.method_1551().method_1483());
                return;
            }
            super.method_25348(d, e);
        }

        public boolean method_25401(double d, double e, double f, double g) {
            if (this.updateScroll((int)Math.signum((double)g), false)) {
                return true;
            }
            return super.method_25401(d, e, f, g);
        }

        public boolean updateScroll(int i, boolean cyclic) {
            if (this.scrolledList.max > 0 && ((Integer)this.scrolledList.get() <= this.scrolledList.max && i > 0 || (Integer)this.scrolledList.get() >= 0 && i < 0)) {
                return this.scrolledList.add(i, cyclic) != 0;
            }
            return false;
        }

        protected int getMaxPacks() {
            return (this.field_22758 - 40) / 30;
        }

        protected void method_48579(class_332 guiGraphics, int i, int j, float f) {
            class_327 font = this.minecraft.field_1772;
            FactoryGuiGraphics factoryGuiGraphics = FactoryGuiGraphics.of((class_332)guiGraphics);
            int n = this.method_46426() - 1;
            int n2 = this.method_46427();
            Objects.requireNonNull(font);
            int n3 = n2 + 9 - 1;
            Objects.requireNonNull(this.minecraft.field_1772);
            factoryGuiGraphics.blitSprite(LegacySprites.PANEL_RECESS, n, n3, this.field_22758 + 2, this.field_22759 + 2 - 9);
            int visibleCount = 0;
            RenderSystem.enableBlend();
            for (int index = 0; index < this.albums.size() && visibleCount < this.getMaxPacks(); ++visibleCount, ++index) {
                PackAlbum album = (PackAlbum)this.albums.getByIndex(Math.min((int)(this.albums.size() - 1), (int)((Integer)this.scrolledList.get() + index)));
                if (album.iconSprite().isPresent()) {
                    FactoryGuiGraphics factoryGuiGraphics2 = FactoryGuiGraphics.of((class_332)guiGraphics);
                    int n4 = this.method_46426() + 21 + 30 * index;
                    int n5 = this.method_46427();
                    Objects.requireNonNull(font);
                    factoryGuiGraphics2.blitSprite(album.iconSprite().get(), n4, n5 + 9 + 4, 28, 28);
                } else {
                    FactoryGuiGraphics factoryGuiGraphics3 = FactoryGuiGraphics.of((class_332)guiGraphics);
                    class_2960 class_29602 = album.isValidPackDisplay(this.packRepository) ? Selector.getPackIcon(this.packRepository.method_14449(album.getDisplayPackId())) : DEFAULT_ICON;
                    int n6 = this.method_46426() + 21 + 30 * index;
                    int n7 = this.method_46427();
                    Objects.requireNonNull(font);
                    factoryGuiGraphics3.blit(class_29602, n6, n7 + 9 + 4, 0.0f, 0.0f, 28, 28, 28, 28);
                }
                if ((Integer)this.scrolledList.get() + index != this.selectedIndex) continue;
                FactoryGuiGraphics factoryGuiGraphics4 = FactoryGuiGraphics.of((class_332)guiGraphics);
                int n8 = this.method_46426() + 20 + 30 * index;
                int n9 = this.method_46427();
                Objects.requireNonNull(font);
                factoryGuiGraphics4.blitSprite(LegacySprites.PACK_HIGHLIGHTED, n8, n9 + 9 + 3, 30, 30);
            }
            RenderSystem.disableBlend();
            guiGraphics.method_51448().method_22903();
            if (!this.method_25367()) {
                guiGraphics.method_51448().method_46416(0.5f, 0.5f, 0.0f);
            }
            guiGraphics.method_51439(font, this.method_25369(), this.method_46426() + 2, this.method_46427(), this.method_25367() ? ScreenUtil.getDefaultTextColor() : (Integer)CommonColor.INVENTORY_GRAY_TEXT.get(), this.method_25367());
            guiGraphics.method_51448().method_22909();
            if (this.scrolledList.max > 0) {
                if ((Integer)this.scrolledList.get() < this.scrolledList.max) {
                    int n10 = this.method_46426() + this.field_22758 - 12;
                    int n11 = this.method_46427();
                    Objects.requireNonNull(font);
                    int n12 = n11 + 9;
                    Objects.requireNonNull(font);
                    this.scrollRenderer.renderScroll(guiGraphics, class_8028.field_41829, n10, n12 + (this.field_22759 - 9 - 11) / 2);
                }
                if ((Integer)this.scrolledList.get() > 0) {
                    int n13 = this.method_46426() + 8;
                    int n14 = this.method_46427();
                    Objects.requireNonNull(font);
                    int n15 = n14 + 9;
                    Objects.requireNonNull(font);
                    this.scrollRenderer.renderScroll(guiGraphics, class_8028.field_41828, n13, n15 + (this.field_22759 - 9 - 11) / 2);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static class_2960 loadPackIcon(class_1060 textureManager, class_3288 pack, String icon, class_2960 fallback) {
            try (class_3262 packResources = pack.method_14458();){
                class_2960 resourceLocation;
                class_7367 ioSupplier = packResources.method_14410(new String[]{icon});
                if (ioSupplier == null) {
                    class_2960 class_29603 = fallback;
                    return class_29603;
                }
                String string = pack.method_14463();
                class_2960 resourceLocation3 = FactoryAPI.createLocation((String)"minecraft", (String)(icon + "/" + class_156.method_30309((String)string, class_2960::method_29184) + "/" + String.valueOf(Hashing.sha1().hashUnencodedChars((CharSequence)string)) + "/icon"));
                try (InputStream inputStream = (InputStream)ioSupplier.get();){
                    class_1011 nativeImage = class_1011.method_4309((InputStream)inputStream);
                    textureManager.method_4616(resourceLocation3, (class_1044)new class_1043(nativeImage));
                    resourceLocation = resourceLocation3;
                }
                class_2960 class_29602 = resourceLocation;
                return class_29602;
            }
            catch (Exception exception) {
                Legacy4J.LOGGER.warn("Failed to load icon from pack {}", (Object)pack.method_14463(), (Object)exception);
                return fallback;
            }
        }

        public static class_2960 getPackIcon(class_3288 pack) {
            return packIcons.computeIfAbsent(pack.method_14463(), string -> Selector.loadPackIcon(class_310.method_1551().method_1531(), pack, "pack.png", DEFAULT_ICON));
        }

        public static class_2960 getPackBackground(class_3288 pack) {
            return packBackgrounds.computeIfAbsent(pack.method_14463(), string -> Selector.loadPackIcon(class_310.method_1551().method_1531(), pack, "background.png", null));
        }

        protected void method_47399(class_6382 narrationElementOutput) {
            this.method_37021(narrationElementOutput);
        }

        public PackAlbum getSelectedAlbum() {
            return this.albums.isEmpty() || this.selectedIndex > this.albums.size() ? null : (PackAlbum)this.albums.getByIndex(this.selectedIndex);
        }

        @Override
        @Nullable
        public class_2561 getAction(ControlTooltip.ActionHolder.Context context) {
            return context.actionOfContext(ControlTooltip.ActionHolder.KeyContext.class, k -> k.key() == 79 && this.method_25370() ? LegacyComponents.ALBUM_OPTIONS : (k.key() == 88 && this.method_25370() || k.key() == 0 && this.method_49606() ? this.screenComponent : ControlTooltip.getSelectAction((class_364)this, context)));
        }
    }
}

