/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.controller;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1041;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_433;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_640;
import net.minecraft.class_8015;
import net.minecraft.class_8028;
import org.lwjgl.glfw.GLFW;
import wily.factoryapi.FactoryEvent;
import wily.factoryapi.util.ListMap;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacyTipManager;
import wily.legacy.client.controller.BindingState;
import wily.legacy.client.controller.Controller;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.controller.GLFWControllerHandler;
import wily.legacy.client.controller.LegacyKeyMapping;
import wily.legacy.client.controller.SDLControllerHandler;
import wily.legacy.client.screen.LegacyMenuAccess;
import wily.legacy.entity.LegacyPlayerInfo;
import wily.legacy.mixin.base.MouseHandlerAccessor;

public class ControllerManager {
    public Controller connectedController = null;
    public boolean isCursorDisabled = false;
    public boolean resetCursor = false;
    public boolean canChangeSlidersValue = true;
    final class_310 minecraft;
    public static final ListMap<String, Controller.Handler> handlers = ListMap.builder().put((Object)"none", (Object)Controller.Handler.EMPTY).put((Object)"glfw", (Object)GLFWControllerHandler.getInstance()).put((Object)"sdl3", (Object)SDLControllerHandler.getInstance()).build();
    public boolean isControllerTheLastInput = false;
    public boolean isControllerSimulatingInput = false;
    public static final class_2561 CONTROLLER_DETECTED = class_2561.method_43471((String)"legacy.controller.detected");
    public static final class_2561 CONTROLLER_DISCONNECTED = class_2561.method_43471((String)"legacy.controller.disconnected");

    public ControllerManager(class_310 minecraft) {
        this.minecraft = minecraft;
    }

    public static Controller.Handler getHandler() {
        return (Controller.Handler)LegacyOptions.selectedControllerHandler.get();
    }

    public static void updatePlayerCamera(BindingState.Axis stick, Controller handler) {
        class_310 minecraft = class_310.method_1551();
        if (!(minecraft.field_1729.method_1613() && minecraft.method_1569() && stick.pressed && minecraft.field_1724 != null)) {
            return;
        }
        double f = Math.pow((Double)LegacyOptions.controllerSensitivity.get() * (double)0.6f + (double)0.2f, 3.0) * 7.5 * (minecraft.field_1724.method_31550() ? 0.125 : 1.0);
        minecraft.field_1724.method_5872((double)ControllerManager.getCameraCurve(stick.getSmoothX()) * f, (double)ControllerManager.getCameraCurve(stick.getSmoothY()) * f * (double)((Boolean)LegacyOptions.invertYController.get() != false ? -1 : 1));
    }

    public static float getCameraCurve(float f) {
        if (((Boolean)LegacyOptions.linearCameraMovement.get()).booleanValue()) {
            return f;
        }
        return f * f * Math.signum(f);
    }

    public void setup() {
        GLFW.glfwSetInputMode((long)this.minecraft.method_22683().method_4490(), (int)208897, (int)212994);
        CompletableFuture.runAsync(() -> new Timer().scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                ControllerManager.this.minecraft.execute(ControllerManager.getHandler()::init);
                if (ControllerManager.this.minecraft.method_22108() && ControllerManager.getHandler().update()) {
                    ((Setup)Setup.EVENT.invoker).accept(ControllerManager.this);
                    if (!ControllerManager.getHandler().isValidController((Integer)LegacyOptions.selectedController.get())) {
                        if (ControllerManager.this.connectedController != null) {
                            ControllerManager.this.connectedController.disconnect(ControllerManager.this);
                        }
                        return;
                    }
                    if (ControllerManager.this.connectedController == null && (ControllerManager.this.connectedController = ControllerManager.getHandler().getController((Integer)LegacyOptions.selectedController.get())) != null) {
                        ControllerManager.this.connectedController.connect(ControllerManager.this);
                    }
                    ControllerManager.this.minecraft.execute(() -> {
                        if (ControllerManager.this.connectedController != null) {
                            ControllerManager.getHandler().setup(ControllerManager.this);
                        }
                    });
                }
            }
        }, 0L, 1L)).exceptionally(t -> {
            Legacy4J.LOGGER.warn(t.getMessage());
            return null;
        });
    }

    public void setPointerPos(double x, double y) {
        this.setPointerPos(x, y, this.isControllerTheLastInput && (Boolean)LegacyOptions.controllerVirtualCursor.get() != false);
    }

    public void setPointerPos(double x, double y, boolean onlyVirtual) {
        class_1041 window = this.minecraft.method_22683();
        this.minecraft.field_1729.field_1795 = Math.max(0.0, Math.min(x, (double)window.method_4480()));
        this.minecraft.field_1729.field_1794 = Math.max(0.0, Math.min(y, (double)window.method_4507()));
        if (!onlyVirtual) {
            GLFW.glfwSetCursorPos((long)class_310.method_1551().method_22683().method_4490(), (double)this.minecraft.field_1729.field_1795, (double)this.minecraft.field_1729.field_1794);
        }
    }

    public synchronized void updateBindings() {
        this.updateBindings(this.minecraft.method_1569() ? this.connectedController : Controller.EMPTY);
    }

    public synchronized void updateBindings(Controller controller) {
        if (this.minecraft.field_1755 != null) {
            Controller.Event.of(this.minecraft.field_1755).controllerTick(controller);
        }
        if (LegacyTipManager.getActualTip() != null) {
            LegacyTipManager.getActualTip().controllerTick(controller);
        }
        for (ControllerBinding<?> binding : ControllerBinding.map.values()) {
            class_640 class_6402;
            if (controller == null) break;
            Object state = binding.state();
            ((BindingState)state).update(controller);
            if (LegacyTipManager.getActualTip() != null) {
                LegacyTipManager.getActualTip().bindingStateTick((BindingState)state);
            }
            if (((BindingState)state).pressed) {
                this.isControllerTheLastInput = true;
                this.minecraft.method_61964().method_61939();
            }
            if (this.getCursorMode() == 0 && ((BindingState)state).pressed && !this.isCursorDisabled) {
                this.disableCursor();
            }
            if (this.minecraft.field_1724 != null && this.minecraft.method_1562() != null && controller.hasLED() && (class_6402 = this.minecraft.method_1562().method_2871(this.minecraft.field_1724.method_5667())) instanceof LegacyPlayerInfo) {
                LegacyPlayerInfo i = (LegacyPlayerInfo)class_6402;
                float[] color = Legacy4JClient.getVisualPlayerColor(i);
                controller.setLED((byte)(color[0] * 255.0f), (byte)(color[1] * 255.0f), (byte)(color[2] * 255.0f));
            }
            if (((BindingState)state).is(ControllerBinding.START) && ((BindingState)state).justPressed) {
                if (this.minecraft.field_1755 == null) {
                    this.minecraft.method_20539(false);
                } else if (this.minecraft.field_1755 instanceof class_465 || this.minecraft.field_1755 instanceof class_433) {
                    this.minecraft.field_1755.method_25419();
                }
            }
            if (this.minecraft.field_1755 != null) {
                if (((BindingState)state).pressed && ((BindingState)state).canClick()) {
                    this.minecraft.method_48185(class_8015.field_43097);
                    this.minecraft.field_1755.method_37070();
                }
                Controller.Event.of(this.minecraft.field_1755).bindingStateTick((BindingState)state);
                if (this.minecraft.field_1755 != null) {
                    ControllerBinding cursorBinding = LegacyKeyMapping.of(Legacy4JClient.keyToggleCursor).getBinding();
                    if (cursorBinding != null && ((BindingState)state).is(cursorBinding) && ((BindingState)state).canClick()) {
                        this.toggleCursor();
                    }
                    if (this.isCursorDisabled) {
                        this.simulateKeyAction(s -> {
                            Controller.Event e;
                            class_437 patt0$temp;
                            return state.is(ControllerBinding.DOWN_BUTTON) && ((patt0$temp = this.minecraft.field_1755) instanceof Controller.Event && !(e = (Controller.Event)patt0$temp).onceClickBindings() || state.onceClick(true));
                        }, 257, (BindingState)state);
                    }
                    this.simulateKeyAction(s -> s.is(ControllerBinding.RIGHT_BUTTON) && state.onceClick(true), 256, (BindingState)state);
                    this.simulateKeyAction(s -> s.is(ControllerBinding.LEFT_BUTTON), 88, (BindingState)state);
                    this.simulateKeyAction(s -> s.is(ControllerBinding.UP_BUTTON), 79, (BindingState)state);
                    this.simulateKeyAction(s -> s.is(ControllerBinding.RIGHT_TRIGGER), 87, (BindingState)state);
                    this.simulateKeyAction(s -> s.is(ControllerBinding.LEFT_TRIGGER), 266, (BindingState)state);
                    this.simulateKeyAction(s -> s.is(ControllerBinding.RIGHT_TRIGGER), 267, (BindingState)state);
                    this.simulateKeyAction(s -> s.is(ControllerBinding.RIGHT_BUMPER), 93, (BindingState)state);
                    this.simulateKeyAction(s -> s.is(ControllerBinding.LEFT_BUMPER), 91, (BindingState)state);
                    this.simulateKeyAction(s -> s.is(ControllerBinding.TOUCHPAD_BUTTON), 84, (BindingState)state);
                    this.simulateKeyAction(s -> s.is(ControllerBinding.CAPTURE), 291, (BindingState)state);
                    if (((BindingState)state).is(ControllerBinding.RIGHT_STICK) && state instanceof BindingState.Axis) {
                        BindingState.Axis stick = (BindingState.Axis)state;
                        if (Math.abs(stick.y) > Math.abs(stick.x) && ((BindingState)state).pressed && ((BindingState)state).canClick()) {
                            this.minecraft.field_1755.method_25401(this.getPointerX(), this.getPointerY(), 0.0, (double)Math.signum(-stick.y));
                        }
                    }
                    Predicate<Predicate> isStickAnd = s -> {
                        BindingState.Axis stick;
                        return state.is(ControllerBinding.LEFT_STICK) && state instanceof BindingState.Axis && s.test(stick = (BindingState.Axis)state);
                    };
                    if (this.isCursorDisabled) {
                        if (isStickAnd.test(s -> s.y < 0.0f && -s.y > Math.abs(s.x)) || ((BindingState)state).is(ControllerBinding.DPAD_UP)) {
                            this.simulateKeyAction(265, (BindingState)state);
                        }
                        if (isStickAnd.test(s -> s.y > 0.0f && s.y > Math.abs(s.x)) || ((BindingState)state).is(ControllerBinding.DPAD_DOWN)) {
                            this.simulateKeyAction(264, (BindingState)state);
                        }
                        if (isStickAnd.test(s -> s.x > 0.0f && s.x > Math.abs(s.y)) || ((BindingState)state).is(ControllerBinding.DPAD_RIGHT)) {
                            this.simulateKeyAction(262, (BindingState)state);
                        }
                        if (isStickAnd.test(s -> s.x < 0.0f && -s.x > Math.abs(s.y)) || ((BindingState)state).is(ControllerBinding.DPAD_LEFT)) {
                            this.simulateKeyAction(263, (BindingState)state);
                        }
                    }
                }
            }
            if (this.minecraft.field_1755 != null && !this.isCursorDisabled) {
                LegacyMenuAccess m;
                if (((BindingState)state).is(ControllerBinding.LEFT_STICK) && state instanceof BindingState.Axis) {
                    BindingState.Axis stick = (BindingState.Axis)state;
                    if (((BindingState)state).pressed) {
                        this.setPointerPos(this.minecraft.field_1729.method_1603() + (double)stick.x * ((double)this.minecraft.method_22683().method_4480() / (double)this.minecraft.method_22683().method_4486()) * (Double)LegacyOptions.interfaceSensitivity.get() / 2.0, this.minecraft.field_1729.method_1604() + (double)stick.y * ((double)this.minecraft.method_22683().method_4507() / (double)this.minecraft.method_22683().method_4502()) * (Double)LegacyOptions.interfaceSensitivity.get() / 2.0);
                    }
                }
                if (((BindingState)state).is(ControllerBinding.LEFT_TRIGGER) && (class_6402 = this.minecraft.field_1755) instanceof LegacyMenuAccess && (m = (LegacyMenuAccess)class_6402).method_17577().method_34255().method_7947() > 1) {
                    if (((BindingState)state).justPressed) {
                        this.minecraft.field_1755.method_25402(this.getPointerX(), this.getPointerY(), 0);
                    } else if (((BindingState)state).released) {
                        this.minecraft.field_1755.method_25406(this.getPointerX(), this.getPointerY(), 0);
                    }
                    if (((BindingState)state).pressed) {
                        this.minecraft.field_1755.method_25403(this.getPointerX(), this.getPointerY(), 0, 0.0, 0.0);
                    }
                }
                if (((BindingState)state).is(ControllerBinding.DOWN_BUTTON) || ((BindingState)state).is(ControllerBinding.UP_BUTTON) || ((BindingState)state).is(ControllerBinding.LEFT_BUTTON)) {
                    this.isControllerSimulatingInput = true;
                    if (((BindingState)state).pressed && ((BindingState)state).onceClick(true)) {
                        ((MouseHandlerAccessor)this.minecraft.field_1729).pressMouse(this.minecraft.method_22683().method_4490(), ((BindingState)state).is(ControllerBinding.LEFT_BUTTON) ? 1 : 0, 1, 0);
                    } else if (((BindingState)state).released) {
                        ((MouseHandlerAccessor)this.minecraft.field_1729).pressMouse(this.minecraft.method_22683().method_4490(), ((BindingState)state).is(ControllerBinding.LEFT_BUTTON) ? 1 : 0, 0, 0);
                    }
                    this.isControllerSimulatingInput = false;
                }
            }
            if ((class_6402 = this.minecraft.field_1755) instanceof LegacyMenuAccess) {
                LegacyMenuAccess a = (LegacyMenuAccess)class_6402;
                if (!this.isCursorDisabled) {
                    if (((BindingState)state).pressed && ((BindingState)state).canClick()) {
                        if (((BindingState)state).is(ControllerBinding.DPAD_UP)) {
                            a.movePointerToSlotIn(class_8028.field_41826);
                        } else if (((BindingState)state).is(ControllerBinding.DPAD_DOWN)) {
                            a.movePointerToSlotIn(class_8028.field_41827);
                        } else if (((BindingState)state).is(ControllerBinding.DPAD_RIGHT)) {
                            a.movePointerToSlotIn(class_8028.field_41829);
                        } else if (((BindingState)state).is(ControllerBinding.DPAD_LEFT)) {
                            a.movePointerToSlotIn(class_8028.field_41828);
                        }
                    } else if (((BindingState)state).is(ControllerBinding.LEFT_STICK) && ((BindingState)state).released) {
                        a.movePointerToSlot(a.findSlotAt(this.getPointerX(), this.getPointerY()));
                    }
                }
            }
            for (class_304 keyMapping : this.minecraft.field_1690.field_1839) {
                class_437 screen;
                if (!((BindingState)state).matches(keyMapping) || this.minecraft.field_1755 != null && (!((screen = this.minecraft.field_1755) instanceof class_433) || ((class_433)screen).method_53558())) continue;
                if (((BindingState)state).is(ControllerBinding.START) && ((BindingState)state).pressed) {
                    keyMapping.method_23481(false);
                    continue;
                }
                if (((BindingState)state).canClick()) {
                    ++keyMapping.field_1661;
                }
                if (((BindingState)state).pressed && ((BindingState)state).canDownKeyMapping(keyMapping)) {
                    keyMapping.method_23481(true);
                } else if (((BindingState)state).canReleaseKeyMapping(keyMapping)) {
                    keyMapping.method_23481(false);
                }
                if (!((BindingState)state).pressed) continue;
                if (keyMapping == this.minecraft.field_1690.field_1824 || keyMapping == this.minecraft.field_1690.field_1904) {
                    ((BindingState)state).block();
                    continue;
                }
                if (keyMapping != this.minecraft.field_1690.field_1886) continue;
                ((BindingState)state).onceClick(-((BindingState)state).getDefaultDelay() * (this.minecraft.field_1724.method_31549().field_7480 ? 3 : 5));
            }
        }
    }

    public void simulateKeyAction(Predicate<BindingState> canSimulate, int key, BindingState state) {
        boolean clicked;
        boolean bl = clicked = state.pressed && state.canClick();
        if (canSimulate.test(state)) {
            this.simulateKeyAction(key, state, clicked);
        }
    }

    public void simulateKeyAction(int key, BindingState state) {
        this.simulateKeyAction(key, state, state.pressed && state.canClick());
    }

    public void simulateKeyAction(int key, BindingState state, boolean canPress) {
        if (canPress) {
            this.simulateKeyAction(key, true);
        } else if (state.released) {
            this.simulateKeyAction(key, false);
        }
    }

    public void simulateKeyAction(int key, boolean press) {
        this.isControllerSimulatingInput = true;
        this.minecraft.field_1774.method_1466(this.minecraft.method_22683().method_4490(), key, 0, press ? 1 : 0, 0);
        this.isControllerSimulatingInput = false;
    }

    public double getPointerX() {
        return this.minecraft.field_1729.method_1603() * (double)this.minecraft.method_22683().method_4486() / (double)this.minecraft.method_22683().method_4480();
    }

    public double getPointerY() {
        return this.minecraft.field_1729.method_1604() * (double)this.minecraft.method_22683().method_4502() / (double)this.minecraft.method_22683().method_4507();
    }

    public BindingState getButtonState(ControllerBinding button) {
        return button.state();
    }

    public void disableCursor() {
        Controller.Event e;
        class_437 class_4372;
        if (this.getCursorMode() == 1 || this.minecraft.field_1755 == null || (class_4372 = this.minecraft.field_1755) instanceof Controller.Event && !(e = (Controller.Event)class_4372).disableCursorOnInit()) {
            return;
        }
        GLFW.glfwSetInputMode((long)this.minecraft.method_22683().method_4490(), (int)208897, (int)212994);
        this.isCursorDisabled = true;
    }

    public void resetCursor() {
        if (!this.resetCursor || this.isCursorDisabled) {
            return;
        }
        class_437 class_4372 = this.minecraft.field_1755;
        if (class_4372 instanceof LegacyMenuAccess) {
            LegacyMenuAccess a = (LegacyMenuAccess)class_4372;
            for (class_1735 slot : a.method_17577().field_7761) {
                if (slot.method_34266() != 0 || this.minecraft.field_1724 != null && slot.field_7871 != this.minecraft.field_1724.method_31548()) continue;
                a.movePointerToSlot(slot);
                break;
            }
        }
        this.resetCursor = false;
    }

    public void enableAndResetCursor() {
        this.enableCursor();
        this.resetCursor = true;
    }

    public void enableCursor() {
        this.isCursorDisabled = false;
    }

    public void toggleCursor() {
        if (this.getCursorMode() < 2) {
            this.setCursorMode(this.getCursorMode() + 1);
        } else {
            this.setCursorMode(0);
        }
        if (this.getCursorMode() == 1) {
            this.enableCursor();
        } else if (this.getCursorMode() == 2) {
            this.disableCursor();
            if (this.minecraft.field_1755 != null) {
                this.minecraft.field_1755.method_48640();
            }
        }
    }

    public int getCursorMode() {
        return (Integer)LegacyOptions.cursorMode.get();
    }

    public void setCursorMode(int cursorMode) {
        LegacyOptions.cursorMode.set((Object)cursorMode);
        LegacyOptions.cursorMode.save();
    }

    static interface Setup
    extends Consumer<ControllerManager> {
        public static final FactoryEvent<Setup> EVENT = new FactoryEvent(e -> m -> e.invokeAll(l -> l.accept(m)));
    }
}

