/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_6382;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.client.AdvancedTextWidget;
import wily.factoryapi.base.client.SimpleLayoutRenderable;
import wily.legacy.Legacy4J;
import wily.legacy.client.CommonColor;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.controller.BindingState;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.controller.LegacyKeyMapping;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PanelVListScreen;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public class LegacyKeyMappingScreen
extends PanelVListScreen {
    protected AdvancedTextWidget mappingTooltipLines;
    protected LegacyKeyMapping selectedMapping;
    protected ArbitrarySupplier<class_2561> mappingTooltip;

    public LegacyKeyMappingScreen(class_437 parent) {
        this(parent, (class_2561)class_2561.method_43471((String)"controls.keybinds.title"));
    }

    public LegacyKeyMappingScreen(class_437 parent, class_2561 title) {
        this(parent, s -> Panel.centered(s, LegacySprites.PANEL, 255, 293), title);
    }

    public LegacyKeyMappingScreen(class_437 parent, Function<class_437, Panel> panelFunction, class_2561 title) {
        super(parent, panelFunction, title);
        this.mappingTooltipLines = new AdvancedTextWidget(this.accessor).withShadow(false);
        this.selectedMapping = null;
        this.mappingTooltip = ArbitrarySupplier.empty();
        this.renderableVList.layoutSpacing(l -> 1);
        this.addButtons();
    }

    public void addButtons() {
        Object[] keyMappings = (class_304[])ArrayUtils.clone((Object[])class_310.method_1551().field_1690.field_1839);
        Arrays.sort(keyMappings);
        String lastCategory = null;
        this.renderableVList.addRenderable((class_4068)class_4185.method_46430((class_2561)class_2561.method_43471((String)"legacy.menu.reset_defaults"), arg_0 -> this.lambda$addButtons$3((class_304[])keyMappings, arg_0)).method_46437(240, 20).method_46431());
        this.renderableVList.addOptions(LegacyOptions.of(class_310.method_1551().field_1690.method_42449()), LegacyOptions.of(class_310.method_1551().field_1690.method_42450()));
        for (Object keyMapping : keyMappings) {
            String category = keyMapping.method_1423();
            if (!Objects.equals(lastCategory, category)) {
                this.renderableVList.addRenderables(new class_4068[]{SimpleLayoutRenderable.create((int)240, (int)13, l -> (graphics, i, j, f) -> {}), SimpleLayoutRenderable.create((int)240, (int)13, l -> (graphics, i, j, f) -> graphics.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)category), l.x + 1, l.y + 4, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false))});
            }
            lastCategory = keyMapping.method_1423();
            this.renderableVList.addRenderable((class_4068)new MappingButton(0, 0, 240, 20, LegacyKeyMapping.of((class_304)keyMapping), (class_304)keyMapping){
                final /* synthetic */ class_304 val$keyMapping;
                {
                    this.val$keyMapping = class_3042;
                    super(i, j, k, l, mapping);
                }

                @Override
                public ControlTooltip.ComponentIcon getIcon() {
                    return ControlTooltip.getKeyIcon(this.mapping.getKey().method_1444());
                }

                @Override
                public boolean isNone() {
                    return this.mapping.getKey() == class_3675.field_16237;
                }

                public void method_25306() {
                    if (class_437.method_25442() || ControllerBinding.LEFT_STICK_BUTTON.state().pressed) {
                        LegacyKeyMappingScreen.setAndUpdateKey(this.val$keyMapping, this.val$keyMapping.method_1429());
                        LegacyKeyMappingScreen.this.setAndUpdateMappingTooltip((ArbitrarySupplier<class_2561>)ArbitrarySupplier.empty());
                    } else {
                        LegacyKeyMappingScreen.this.setSelectedMapping(this.mapping);
                        LegacyKeyMappingScreen.this.setAndUpdateMappingTooltip((ArbitrarySupplier<class_2561>)((ArbitrarySupplier)LegacyKeyMappingScreen.this::getCancelTooltip));
                    }
                }
            });
        }
    }

    public boolean method_25402(double d, double e, int i) {
        if (this.selectedMapping != null && this.allowsKey()) {
            LegacyKeyMappingScreen.setAndUpdateKey(this.selectedMapping.self(), class_3675.class_307.field_1672.method_1447(i));
            this.setAndUpdateMappingTooltip((ArbitrarySupplier<class_2561>)ArbitrarySupplier.empty());
            this.resolveConflictingMappings();
            this.setSelectedMapping(null);
            return true;
        }
        return super.method_25402(d, e, i);
    }

    public static void setAndUpdateKey(class_304 key, class_3675.class_306 input) {
        key.method_1422(input);
        class_310.method_1551().field_1690.method_1640();
        class_304.method_1426();
    }

    @Override
    public boolean method_25404(int i, int j, int k) {
        if (this.selectedMapping != null && this.allowsKey()) {
            LegacyKeyMappingScreen.setAndUpdateKey(this.selectedMapping.self(), i == 256 ? class_3675.field_16237 : class_3675.method_15985((int)i, (int)j));
            this.setAndUpdateMappingTooltip((ArbitrarySupplier<class_2561>)ArbitrarySupplier.empty());
            this.resolveConflictingMappings();
            this.setSelectedMapping(null);
            return true;
        }
        return super.method_25404(i, j, k);
    }

    public boolean allowsKey() {
        return true;
    }

    public void method_25395(@Nullable class_364 guiEventListener) {
        super.method_25395(guiEventListener);
        this.setAndUpdateMappingTooltip((ArbitrarySupplier<class_2561>)ArbitrarySupplier.empty());
    }

    @Override
    public void renderDefaultBackground(class_332 guiGraphics, int i, int j, float f) {
        ScreenUtil.renderDefaultBackground(this.accessor, guiGraphics, false);
    }

    public class_2561 getCancelTooltip() {
        return class_2561.method_43469((String)"legacy.options.keyMappingTooltip", (Object[])new Object[]{((ControlTooltip.ComponentIcon)ControlTooltip.CANCEL_BINDING.get()).getComponent()});
    }

    public class_2561 getConflictingTooltip() {
        return LegacyComponents.CONFLICTING_KEYS;
    }

    protected void setSelectedMapping(LegacyKeyMapping keyMapping) {
        this.selectedMapping = keyMapping;
    }

    protected boolean areConflicting(LegacyKeyMapping keyMapping, LegacyKeyMapping comparison) {
        return keyMapping.getKey() == comparison.getKey();
    }

    protected void setNone(LegacyKeyMapping keyMapping) {
        LegacyKeyMappingScreen.setAndUpdateKey(keyMapping.self(), class_3675.field_16237);
    }

    protected void resolveConflictingMappings() {
        for (class_4068 renderable : this.getRenderableVList().renderables) {
            if (!(renderable instanceof MappingButton)) continue;
            MappingButton b = (MappingButton)renderable;
            if (this.selectedMapping == b.mapping || b.isNone() || !this.areConflicting(this.selectedMapping, b.mapping)) continue;
            this.getRenderableVList().focusRenderable((class_4068)b);
            this.setNone(b.mapping);
            this.setAndUpdateMappingTooltip((ArbitrarySupplier<class_2561>)((ArbitrarySupplier)this::getConflictingTooltip));
            break;
        }
    }

    protected void setAndUpdateMappingTooltip(ArbitrarySupplier<class_2561> tooltip) {
        this.mappingTooltip = tooltip;
        this.updateMappingTooltip();
    }

    protected void updateMappingTooltip() {
        this.mappingTooltipLines.withLines(Collections.emptyList());
        this.mappingTooltip.ifPresent(c -> this.mappingTooltipLines.withLines(c, 120));
    }

    @Override
    protected void method_25426() {
        this.updateMappingTooltip();
        this.method_37060((guiGraphics, i, j, f) -> {
            class_364 patt0$temp = this.method_25399();
            if (patt0$temp instanceof MappingButton) {
                MappingButton b = (MappingButton)patt0$temp;
                if (!this.mappingTooltipLines.getLines().isEmpty()) {
                    int tooltipHeight = this.mappingTooltipLines.method_25364() + 18;
                    int tooltipX = this.panel.method_46426() + this.panel.method_25368() - 2;
                    int tooltipY = Math.max(this.panel.method_46427() + 2, Math.min(b.method_46427() + (b.method_25364() - tooltipHeight) / 2, this.panel.method_46427() + this.panel.method_25364() - tooltipHeight - 2));
                    ScreenUtil.renderPointerPanel(guiGraphics, tooltipX, tooltipY, 129, tooltipHeight);
                    this.mappingTooltipLines.method_48229(tooltipX + 4, tooltipY + 9);
                    this.mappingTooltipLines.method_25394(guiGraphics, i, j, f);
                }
            }
        });
        super.method_25426();
        this.method_37060((guiGraphics, i, j, f) -> guiGraphics.method_51433(this.field_22793, FactoryAPIPlatform.getModInfo((String)"minecraft").getVersion() + " " + Legacy4J.VERSION.get(), this.panel.method_46426() + this.panel.method_25368() + 81, this.panel.method_46427() + this.panel.method_25364() - 7, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false));
    }

    @Override
    public void renderableVListInit() {
        this.getRenderableVList().init(this.panel.x + 7, this.panel.y + 6, this.panel.width - 14, this.panel.height - 20);
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        super.addControlTooltips(renderer);
        renderer.replace(0, i -> i, c -> this.selectedMapping == null ? c : null);
        renderer.replace(1, i -> i, c -> this.selectedMapping == null ? c : null);
        renderer.replace(2, i -> i, c -> this.selectedMapping == null ? c : null);
        renderer.replace(3, i -> i, c -> this.selectedMapping == null ? c : null);
        renderer.add(() -> ControlTooltip.CANCEL_BINDING.get(), () -> this.selectedMapping == null ? null : LegacyComponents.CANCEL);
    }

    @Override
    public void bindingStateTick(BindingState state) {
        if (this.selectedMapping != null) {
            state.block();
            if (state.is(ControllerBinding.BACK) && state.pressed) {
                LegacyKeyMappingScreen.setAndUpdateKey(this.selectedMapping.self(), class_3675.field_16237);
                this.setAndUpdateMappingTooltip((ArbitrarySupplier<class_2561>)ArbitrarySupplier.empty());
                this.setSelectedMapping(null);
            }
        }
    }

    private /* synthetic */ void lambda$addButtons$3(class_304[] keyMappings, class_4185 button) {
        this.field_22787.method_1507((class_437)new ConfirmationScreen((class_437)this, (class_2561)class_2561.method_43471((String)"legacy.menu.reset_keyBinds"), (class_2561)class_2561.method_43471((String)"legacy.menu.reset_keyBinds_message"), b -> {
            for (class_304 keyMapping : keyMappings) {
                keyMapping.method_1422(keyMapping.method_1429());
            }
            class_304.method_1426();
            class_310.method_1551().field_1690.method_1640();
            this.field_22787.method_1507((class_437)this);
        }));
    }

    public abstract class MappingButton
    extends class_4264 {
        public final LegacyKeyMapping mapping;

        public MappingButton(int i, int j, int k, int l, LegacyKeyMapping mapping) {
            super(i, j, k, l, mapping.getDisplayName());
            this.mapping = mapping;
        }

        public abstract ControlTooltip.ComponentIcon getIcon();

        public abstract boolean isNone();

        protected void method_48579(class_332 guiGraphics, int i, int j, float f) {
            class_2561 c;
            if (!this.method_25370() && this.isPressed()) {
                LegacyKeyMappingScreen.this.setSelectedMapping(null);
            }
            super.method_48579(guiGraphics, i, j, f);
            Object object = this.isPressed() ? LegacyComponents.SELECTION : (c = this.isNone() ? LegacyComponents.NONE : null);
            if (c != null) {
                class_327 class_3272 = LegacyKeyMappingScreen.this.field_22793;
                int n = this.method_46426() + this.field_22758 - 20 - class_310.method_1551().field_1772.method_27525((class_5348)c) / 2;
                int n2 = this.method_46427();
                Objects.requireNonNull(LegacyKeyMappingScreen.this.field_22793);
                guiGraphics.method_27535(class_3272, c, n, n2 + (this.field_22759 - 9) / 2 + 1, 0xFFFFFF);
                return;
            }
            ControlTooltip.ComponentIcon icon = this.getIcon();
            RenderSystem.enableBlend();
            int n = this.method_46426() + this.field_22758 - 20 - icon.render(guiGraphics, 0, 0, false, true) / 2;
            int n3 = this.method_46427();
            Objects.requireNonNull(LegacyKeyMappingScreen.this.field_22793);
            icon.render(guiGraphics, n, n3 + (this.field_22759 - 9) / 2 + 1, false, false);
            RenderSystem.disableBlend();
        }

        private boolean isPressed() {
            return LegacyKeyMappingScreen.this.selectedMapping != null && this.mapping == LegacyKeyMappingScreen.this.selectedMapping;
        }

        protected void method_49604(class_332 guiGraphics, class_327 font, int i, int j) {
            ScreenUtil.renderScrollingString(guiGraphics, font, this.method_25369(), this.method_46426() + 8, this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), j, true);
        }

        protected void method_47399(class_6382 narrationElementOutput) {
            this.method_37021(narrationElementOutput);
        }
    }
}

