/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1132;
import net.minecraft.class_124;
import net.minecraft.class_1267;
import net.minecraft.class_1928;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2881;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_332;
import net.minecraft.class_34;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_7196;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8573;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.LegacyClientWorldSettings;
import wily.legacy.client.PackAlbum;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacySliderButton;
import wily.legacy.client.screen.OptionsScreen;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PanelBackgroundScreen;
import wily.legacy.client.screen.PublishScreen;
import wily.legacy.client.screen.SaveRenderableList;
import wily.legacy.client.screen.TickBox;
import wily.legacy.client.screen.WorldMoreOptionsScreen;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public class LoadSaveScreen
extends PanelBackgroundScreen {
    public static final class_2561 GAME_MODEL_LABEL = class_2561.method_43471((String)"selectWorld.gameMode");
    protected final boolean isLocked;
    public BiConsumer<class_1928, MinecraftServer> applyGameRules = (r, s) -> {};
    protected final class_32.class_5143 access;
    protected final LegacySliderButton<class_1934> gameTypeSlider;
    public boolean trustPlayers;
    public boolean allowCommands;
    public static final List<class_5321<class_1937>> RESETTABLE_DIMENSIONS = new ArrayList<class_5321>(List.of(class_1937.field_25180, class_1937.field_25181));
    public final List<class_5321<class_1937>> dimensionsToReset = new ArrayList<class_5321<class_1937>>();
    public class_1267 difficulty;
    public final class_34 summary;
    protected final PackAlbum.Selector resourceAssortSelector;
    protected final TickBox onlineTickBox;
    protected final PublishScreen publishScreen;
    public static final List<class_1934> GAME_TYPES = Arrays.stream(class_1934.values()).toList();

    public LoadSaveScreen(class_437 screen, class_34 summary, class_32.class_5143 access, boolean isLocked) {
        super((class_437 s) -> Panel.createPanel(s, p -> (s.field_22789 - (p.width + (ScreenUtil.hasTooltipBoxes(UIAccessor.of((class_437)s)) ? 160 : 0))) / 2, p -> (s.field_22790 - p.height) / 2 + 21, 245, 233), (class_2561)class_2561.method_43471((String)"legacy.menu.load_save.load"));
        this.isLocked = isLocked;
        this.parent = screen;
        this.summary = summary;
        this.access = access;
        this.difficulty = summary.method_35505().method_27340();
        this.gameTypeSlider = new LegacySliderButton<class_1934>(0, 0, 220, 16, b -> b.getDefaultMessage(GAME_MODEL_LABEL, ((class_1934)b.getObjectValue()).method_8383()), b -> class_7919.method_47407((class_2561)class_2561.method_43471((String)("selectWorld.gameMode." + ((class_1934)b.getObjectValue()).method_8381() + ".info"))), summary.method_35505().method_8574(), () -> GAME_TYPES, b -> {});
        this.gameTypeSlider.field_22763 = !summary.method_257();
        this.publishScreen = new PublishScreen((class_437)this, this.gameTypeSlider.getObjectValue());
        this.onlineTickBox = new TickBox(0, 0, 220, this.publishScreen.publish, b -> PublishScreen.PUBLISH, b -> null, button -> {
            if (button.selected) {
                this.field_22787.method_1507((class_437)this.publishScreen);
            }
            this.publishScreen.publish = false;
            button.selected = false;
        });
        this.allowCommands = LoadSaveScreen.hasCommands(summary);
        this.trustPlayers = LegacyClientWorldSettings.of(summary.method_35505()).trustPlayers();
        this.resourceAssortSelector = PackAlbum.Selector.resources(this.panel.x + 13, this.panel.y + 112, 220, 45, !ScreenUtil.hasTooltipBoxes(this.accessor), LegacyClientWorldSettings.of(summary.method_35505()).getSelectedResourceAlbum());
        PackAlbum.Selector.resources(this.panel.x + 13, this.panel.y + 112, 220, 45, !ScreenUtil.hasTooltipBoxes(this.accessor), LegacyClientWorldSettings.of(summary.method_35505()).getSelectedResourceAlbum()).field_22763 = !this.isLocked;
    }

    public LoadSaveScreen(class_437 screen, class_34 summary, class_32 source) {
        this(screen, summary, LoadSaveScreen.getSummaryAccess(source, summary), false);
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        super.addControlTooltips(renderer);
        OptionsScreen.setupSelectorControlTooltips(renderer, this);
    }

    public static boolean hasCommands(class_34 levelSummary) {
        return levelSummary.method_259();
    }

    public static class_32.class_5143 getSummaryAccess(class_32 source, class_34 summary) {
        class_32.class_5143 class_51432;
        block8: {
            class_32.class_5143 access = source.method_27002(summary.method_248());
            try {
                class_51432 = access;
                if (access == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (access != null) {
                        try {
                            access.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            access.close();
        }
        return class_51432;
    }

    @Override
    protected void method_25426() {
        this.panel.init();
        this.gameTypeSlider.method_48229(this.panel.x + 13, this.panel.y + 65);
        ((LegacySliderButton)this.method_37063(new LegacySliderButton<class_1267>((int)(this.panel.x + 13), (int)(this.panel.y + 90), (int)220, (int)16, (Function<LegacySliderButton<T>, class_2561>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$init$11(wily.legacy.client.screen.LegacySliderButton ), (Lwily/legacy/client/screen/LegacySliderButton;)Lnet/minecraft/class_2561;)(), (Function<LegacySliderButton<T>, class_7919>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$init$12(wily.legacy.client.screen.LegacySliderButton ), (Lwily/legacy/client/screen/LegacySliderButton;)Lnet/minecraft/class_7919;)((LoadSaveScreen)this), this.difficulty, (Supplier<List<T>>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$init$13(), ()Ljava/util/List;)(), (Consumer<LegacySliderButton<T>>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$init$14(wily.legacy.client.screen.LegacySliderButton ), (Lwily/legacy/client/screen/LegacySliderButton;)V)((LoadSaveScreen)this)))).field_22763 = !LegacyClientWorldSettings.of(this.summary.method_35505()).isDifficultyLocked() && !this.summary.method_257();
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"createWorld.tab.more.title"), button -> this.field_22787.method_1507((class_437)new WorldMoreOptionsScreen(this))).method_46434(this.panel.x + 13, this.panel.y + 178, 220, 20).method_46431());
        class_4185 loadButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"legacy.menu.load_save.load"), button -> this.onLoad()).method_46434(this.panel.x + 13, this.panel.y + 203, 220, 20).method_46431());
        this.method_37063((class_364)this.gameTypeSlider);
        this.onlineTickBox.selected = this.publishScreen.publish;
        this.onlineTickBox.method_48229(this.panel.x + 14, this.panel.y + 161);
        this.method_37063((class_364)this.onlineTickBox);
        this.method_48265((class_364)loadButton);
        this.resourceAssortSelector.method_46421(this.panel.x + 13);
        this.resourceAssortSelector.method_46419(this.panel.y + 112);
        this.method_37063((class_364)this.resourceAssortSelector);
    }

    public void onLoad() {
        if (this.dimensionsToReset.isEmpty()) {
            this.completeLoad();
        } else {
            this.confirmDimensionToReset(0);
        }
    }

    public void confirmDimensionToReset(final int index) {
        class_5321<class_1937> level = this.dimensionsToReset.get(index);
        final class_2561 dimensionName = LegacyComponents.getDimensionName(level);
        this.field_22787.method_1507((class_437)new ConfirmationScreen(this, (class_2561)class_2561.method_43469((String)"legacy.menu.load_save.reset", (Object[])new Object[]{dimensionName}), (class_2561)class_2561.method_43469((String)"legacy.menu.load_save.reset_message", (Object[])new Object[]{dimensionName, dimensionName}), b -> {
            if (index == this.dimensionsToReset.size() - 1) {
                this.completeLoad();
            } else {
                this.confirmDimensionToReset(index + 1);
            }
        }){

            @Override
            protected void addButtons() {
                this.renderableVList.addRenderable((class_4068)class_4185.method_46430((class_2561)class_2561.method_43469((String)"legacy.menu.load_save.reset_cancel", (Object[])new Object[]{dimensionName}), b -> {
                    LoadSaveScreen.this.dimensionsToReset.remove(index);
                    if (LoadSaveScreen.this.dimensionsToReset.isEmpty()) {
                        LoadSaveScreen.this.completeLoad();
                    } else {
                        LoadSaveScreen.this.confirmDimensionToReset(index);
                    }
                }).method_46431());
                this.okButton = class_4185.method_46430((class_2561)this.method_25440(), b -> this.okAction.accept(this)).method_46431();
                this.renderableVList.addRenderable((class_4068)this.okButton);
            }
        });
    }

    public void completeLoad() {
        this.dimensionsToReset.forEach(l -> {
            if (l == class_1937.field_25179) {
                return;
            }
            try {
                LoadSaveScreen.deleteLevelDimension(this.access, (class_5321<class_1937>)l);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        LegacyClientWorldSettings.of(this.summary.method_35505()).setSelectedResourceAlbum(this.resourceAssortSelector.getSelectedAlbum());
        LoadSaveScreen.loadWorld((class_437)this, this.field_22787, Legacy4JClient.getLevelStorageSource(), this.summary);
        Legacy4JClient.serverPlayerJoinConsumer = s -> {
            if (this.dimensionsToReset.contains(class_1937.field_25181)) {
                s.field_13995.method_3847(class_1937.field_25181).method_51837(new class_2881(this.field_22787.method_1576().method_3847(class_1937.field_25181), this.field_22787.method_1576().method_27728().method_28057().method_28028(), class_2881.class_8576.field_44946));
            }
            s.field_13995.method_3838(this.gameTypeSlider.getObjectValue());
            s.field_13995.method_3776(this.difficulty, false);
            this.applyGameRules.accept(s.field_13995.method_3767(), (MinecraftServer)this.field_22787.method_1576());
            this.publishScreen.publish((class_1132)s.field_13995);
            LegacyClientWorldSettings.of(s.field_13995.method_27728()).setAllowCommands(this.allowCommands);
            s.field_13995.method_3760().method_14576(s);
            LegacyClientWorldSettings.of(s.field_13995.method_27728()).setSelectedResourceAlbum(this.resourceAssortSelector.getSelectedAlbum());
            if (s.field_13974.method_14257() != this.gameTypeSlider.getObjectValue()) {
                s.method_7336(this.gameTypeSlider.getObjectValue());
            }
        };
    }

    public static void deleteLevelDimension(class_32.class_5143 access, class_5321<class_1937> dimension) throws IOException {
        Path path = access.method_27424(dimension);
        Legacy4J.LOGGER.info("Deleting dimension {}", dimension);
        for (int i = 1; i <= 5; ++i) {
            Legacy4J.LOGGER.info("Attempt {}...", (Object)i);
            try {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path pathx, BasicFileAttributes basicFileAttributes) throws IOException {
                        Legacy4J.LOGGER.debug("Deleting {}", (Object)pathx);
                        Files.delete(pathx);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path pathx, @Nullable IOException iOException) throws IOException {
                        if (iOException != null) {
                            throw iOException;
                        }
                        Files.delete(pathx);
                        return FileVisitResult.CONTINUE;
                    }
                });
                break;
            }
            catch (IOException var6) {
                if (i >= 5) {
                    throw var6;
                }
                Legacy4J.LOGGER.warn("Failed to delete {}", (Object)path, (Object)var6);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
    }

    public boolean method_25401(double d, double e, double f, double g) {
        if (this.resourceAssortSelector.scrollableRenderer.mouseScrolled(g)) {
            return true;
        }
        return super.method_25401(d, e, f, g);
    }

    @Override
    public void renderDefaultBackground(class_332 guiGraphics, int i, int j, float f) {
        super.renderDefaultBackground(guiGraphics, i, j, f);
        this.resourceAssortSelector.renderTooltipBox(guiGraphics, (class_8021)this.panel);
        this.panel.method_25394(guiGraphics, i, j, f);
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.5f, 0.0f, 0.0f);
        FactoryGuiGraphics.of((class_332)guiGraphics).blitSprite(LegacySprites.SQUARE_ENTITY_PANEL, this.panel.x + 12, this.panel.y + 9, 32, 32);
        guiGraphics.method_51448().method_22909();
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.5f, 0.0f);
        FactoryGuiGraphics.of((class_332)guiGraphics).blit(((class_8573)SaveRenderableList.iconCache.getUnchecked((Object)this.summary)).method_52201(), this.panel.x + 14, this.panel.y + 10, 0.0f, 0.0f, 29, 29, 29, 29);
        guiGraphics.method_51433(this.field_22793, this.summary.method_252(), this.panel.x + 48, this.panel.y + 12, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43469((String)"legacy.menu.load_save.created_in", (Object[])new Object[]{(LoadSaveScreen.hasCommands(this.summary) ? class_1934.field_9220 : class_1934.field_9215).method_32763()}), this.panel.x + 48, this.panel.y + 29, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        guiGraphics.method_51448().method_22909();
        if (!this.isLocked) {
            guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43469((String)"commands.seed.success", (Object[])new Object[]{LegacyClientWorldSettings.of(this.summary.method_35505()).getDisplaySeed()}), this.panel.x + 13, this.panel.y + 49, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        }
    }

    public void method_25394(class_332 guiGraphics, int i, int j, float f) {
        super.method_25394(guiGraphics, i, j, f);
        if (ScreenUtil.isMouseOver(i, j, (double)this.panel.x + 14.5, this.panel.y + 10, 29, 29)) {
            guiGraphics.method_51438(this.field_22793, (class_2561)class_2561.method_43469((String)"selectWorld.targetFolder", (Object[])new Object[]{class_2561.method_43470((String)this.summary.method_248()).method_27692(class_124.field_1056)}), i, j);
        }
    }

    public static void loadWorld(class_437 screen, class_310 minecraft, class_32 source, String levelId) {
        try (class_32.class_5143 access = source.method_27002(levelId);){
            LoadSaveScreen.loadWorld(screen, minecraft, source, access.method_29584(access.method_54545()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void loadWorld(class_437 screen, class_310 minecraft, class_32 source, class_34 summary) {
        SaveRenderableList.resetIconCache();
        PackAlbum.Selector.applyResourceChanges(minecraft, PackAlbum.getSelectedIds(minecraft.method_1520()), LegacyClientWorldSettings.of(summary.method_35505()).getSelectedResourceAlbum().packs(), () -> new class_7196(minecraft, source).method_57784(summary.method_248(), () -> minecraft.method_1507(screen)));
    }

    private /* synthetic */ void lambda$init$14(LegacySliderButton b) {
        this.difficulty = (class_1267)b.getObjectValue();
    }

    private static /* synthetic */ List lambda$init$13() {
        return Arrays.asList(class_1267.values());
    }

    private /* synthetic */ class_7919 lambda$init$12(LegacySliderButton b) {
        return class_7919.method_47407((class_2561)this.difficulty.method_48556());
    }

    private static /* synthetic */ class_2561 lambda$init$11(LegacySliderButton b) {
        return b.getDefaultMessage((class_2561)class_2561.method_43471((String)"options.difficulty"), ((class_1267)b.getObjectValue()).method_5463());
    }
}

