/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_437;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.SimpleLayoutRenderable;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public class Panel
extends SimpleLayoutRenderable {
    protected final UIAccessor accessor;
    public class_2960 panelSprite = LegacySprites.SMALL_PANEL;
    public String name;

    public Panel(class_437 screen) {
        this(UIAccessor.of((class_437)screen));
    }

    public Panel(UIAccessor accessor) {
        this.accessor = accessor;
    }

    public static Panel createPanel(class_437 screen, Function<Panel, Integer> leftPosGetter, Function<Panel, Integer> topPosGetter, int width, int height) {
        return Panel.createPanel(screen, leftPosGetter, topPosGetter, () -> width, () -> height);
    }

    public static Panel createPanel(class_437 screen, Function<Panel, Integer> leftPosGetter, Function<Panel, Integer> topPosGetter, Supplier<Integer> widthGetter, Supplier<Integer> heightGetter) {
        return Panel.createPanel(screen, p -> p.appearance((Integer)widthGetter.get(), (Integer)heightGetter.get()), p -> p.pos((Integer)leftPosGetter.apply((Panel)((Object)p)), (Integer)topPosGetter.apply((Panel)((Object)p))));
    }

    public static Panel createPanel(class_437 screen, Consumer<Panel> initAppearance) {
        return Panel.createPanel(screen, initAppearance, p -> p.centered(screen));
    }

    public static Panel createPanel(class_437 screen, final Consumer<Panel> initAppearance, final Consumer<Panel> initPos) {
        return new Panel(UIAccessor.of((class_437)screen)){

            @Override
            public void init(String name) {
                super.init(name);
                initAppearance.accept(this);
                initPos.accept(this);
            }
        };
    }

    public int centeredLeftPos(class_437 screen) {
        return (screen.field_22789 - this.width) / 2;
    }

    public int centeredTopPos(class_437 screen) {
        return (screen.field_22790 - this.height) / 2;
    }

    public static Panel centered(class_437 screen, Supplier<Integer> width, Supplier<Integer> height) {
        return Panel.centered(screen, width, height, 0, 0);
    }

    public static Panel centered(class_437 screen, int width, int height) {
        return Panel.centered(screen, width, height, 0, 0);
    }

    public static Panel centered(class_437 screen, int width, int height, int xOffset, int yOffset) {
        return Panel.centered(screen, () -> width, () -> height, xOffset, yOffset);
    }

    public static Panel centered(class_437 screen, int width, int height, Supplier<Integer> xOffset, Supplier<Integer> yOffset) {
        return Panel.centered(screen, () -> width, () -> height, xOffset, yOffset);
    }

    public static Panel centered(class_437 screen, Supplier<Integer> widthGetter, Supplier<Integer> heightGetter, int xOffset, int yOffset) {
        return Panel.centered(screen, widthGetter, heightGetter, () -> xOffset, () -> yOffset);
    }

    public static Panel centered(class_437 screen, Supplier<Integer> imageWidth, Supplier<Integer> imageHeight, Supplier<Integer> xOffset, Supplier<Integer> yOffset) {
        return Panel.createPanel(screen, (Panel p) -> p.centeredLeftPos(screen) + (Integer)xOffset.get(), (Panel p) -> p.centeredTopPos(screen) + (Integer)yOffset.get(), imageWidth, imageHeight);
    }

    public static Panel centered(class_437 screen, class_2960 panelSprite, int imageWidth, int imageHeight, int xOffset, int yOffset) {
        return Panel.createPanel(screen, p -> p.appearance(panelSprite, imageWidth, imageHeight), p -> p.pos(p.centeredLeftPos(screen) + xOffset, p.centeredTopPos(screen) + yOffset));
    }

    public static Panel centered(class_437 screen, class_2960 panelSprite, int imageWidth, int imageHeight) {
        return Panel.createPanel(screen, p -> p.appearance(panelSprite, imageWidth, imageHeight), p -> p.pos(p.centeredLeftPos(screen), p.centeredTopPos(screen)));
    }

    public static Panel tooltipBoxOf(final Panel panel, final int boxWidth) {
        Panel p = new Panel(panel.accessor){

            @Override
            public void init(String name) {
                super.init(name);
                panel.x -= (boxWidth - 2) / 2;
                this.appearance(LegacySprites.POINTER_PANEL, boxWidth, panel.height - 10);
                this.pos(panel.x + panel.width - 2, panel.y + 5);
            }

            @Override
            public void init() {
                this.init("tooltipBox");
            }

            @Override
            public void method_25394(class_332 guiGraphics, int i, int j, float f) {
                ScreenUtil.renderPointerPanel(guiGraphics, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
            }
        };
        p.init();
        return p;
    }

    public void appearance(int width, int height) {
        this.appearance(LegacySprites.SMALL_PANEL, width, height);
    }

    public void appearance(class_2960 sprite, int width, int height) {
        this.panelSprite = (class_2960)this.accessor.getElementValue(this.name + ".sprite", (Object)sprite, class_2960.class);
        this.size((Integer)this.accessor.putStaticElement(this.name + ".width", (Object)this.accessor.getInteger(this.name + ".width", width)), (Integer)this.accessor.putStaticElement(this.name + ".height", (Object)this.accessor.getInteger(this.name + ".height", height)));
    }

    public void pos(int x, int y) {
        this.method_48229((Integer)this.accessor.putStaticElement(this.name + ".x", (Object)this.accessor.getInteger(this.name + ".x", x)), (Integer)this.accessor.putStaticElement(this.name + ".y", (Object)this.accessor.getInteger(this.name + ".y", y)));
    }

    public void centered(class_437 screen) {
        this.pos(this.centeredLeftPos(screen), this.centeredTopPos(screen));
    }

    public void init(String name) {
        this.name = name;
    }

    public void init() {
        this.init("panel");
    }

    public void method_25394(class_332 guiGraphics, int i, int j, float f) {
        FactoryGuiGraphics.of((class_332)guiGraphics).blitSprite(this.panelSprite, this.x, this.y, this.width, this.height);
    }
}

