/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.util;

import com.google.common.base.Charsets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.datafixers.util.Pair;
import com.sun.net.httpserver.HttpServer;
import io.netty.channel.ConnectTimeoutException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_320;
import net.minecraft.class_332;
import net.minecraft.class_3518;
import net.minecraft.class_368;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7532;
import net.minecraft.class_8685;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.MinecraftAccessor;
import wily.legacy.Legacy4J;
import wily.legacy.client.LegacyTip;
import wily.legacy.client.screen.ChooseUserScreen;
import wily.legacy.client.screen.LegacyLoadingScreen;

public interface MCAccount {
    public static final String MC_ACCESS_TOKEN = "mcAccessToken";
    public static final String MSA_REFRESH_TOKEN = "msaRefreshToken";
    public static final String ENCRYPTED = "encrypted";
    public static final String TRANSFORMATION = "AES/CBC/PKCS5Padding";
    public static final class_2561 LOGIN_IN = class_2561.method_43471((String)"legacy.menu.choose_user.login_in");
    public static final class_2561 ACQUIRING_MSAUTH_TOKEN = class_2561.method_43471((String)"legacy.menu.choose_user.stage.acquiringMSAuthCode");
    public static final class_2561 ACQUIRING_MSACCESS_TOKEN = class_2561.method_43471((String)"legacy.menu.choose_user.stage.acquiringMSAccessToken");
    public static final class_2561 ACQUIRING_XBOX_ACCESS_TOKEN = class_2561.method_43471((String)"legacy.menu.choose_user.stage.acquiringXboxAccessToken");
    public static final class_2561 ACQUIRING_XBOX_XSTS_TOKEN = class_2561.method_43471((String)"legacy.menu.choose_user.stage.acquiringXboxXstsToken");
    public static final class_2561 ACQUIRING_MC_ACCESS_TOKEN = class_2561.method_43471((String)"legacy.menu.choose_user.stage.acquiringMCAccessToken");
    public static final class_2561 FINALIZING = class_2561.method_43471((String)"legacy.menu.choose_user.stage.finalizing");
    public static final Path ACCOUNTS_PATH = class_310.method_1551().field_1697.toPath().resolve(".accounts.json");
    public static final List<MCAccount> list = new ArrayList<MCAccount>();
    public static final RequestConfig REQUEST_CONFIG = RequestConfig.custom().setConnectionRequestTimeout(30000).setConnectTimeout(30000).setSocketTimeout(30000).build();
    public static final String CLIENT_ID = "2f63b52c-2aeb-4f21-a753-12adfd4ef9fc";
    public static final String AUTHORIZE_URL = "https://login.microsoftonline.com/consumers/oauth2/v2.0/authorize";
    public static final String TOKEN_URL = "https://login.microsoftonline.com/consumers/oauth2/v2.0/token";
    public static final String XBOX_AUTH_URL = "https://user.auth.xboxlive.com/user/authenticate";
    public static final String XBOX_XSTS_URL = "https://xsts.auth.xboxlive.com/xsts/authorize";
    public static final String MC_AUTH_URL = "https://api.minecraftservices.com/authentication/login_with_xbox";
    public static final String MC_PROFILE_URL = "https://api.minecraftservices.com/minecraft/profile";
    public static final Stocker<Long> lastSessionCheckTime = Stocker.of((Object)0L);
    public static final Stocker<Boolean> lastSessionCheck = Stocker.of(null);

    public GameProfile getProfile();

    default public boolean isEncrypted() {
        return false;
    }

    default public Optional<String> getToken(@Nullable String password, String tokenEntry) {
        return Optional.empty();
    }

    default public Optional<String> getMCAccessToken(@Nullable String password) {
        return this.getToken(password, MC_ACCESS_TOKEN);
    }

    default public Optional<String> getMSARefreshToken(@Nullable String password) {
        return this.getToken(password, MSA_REFRESH_TOKEN);
    }

    default public void serialize(JsonObject object) {
        MCAccount.serializeProfile(this.getProfile(), object);
    }

    default public void login(ChooseUserScreen screen, @Nullable String password) {
        this.login(() -> {
            screen.reloadAccountButtons();
            class_310.method_1551().method_1507((class_437)screen);
        }, password);
    }

    default public void login(Runnable onClose, @Nullable String password) {
        MCAccount.setUser(new class_320(this.getProfile().getName(), this.getProfile().getId(), "invalidtoken", Optional.empty(), Optional.empty(), class_320.class_321.field_1990));
        onClose.run();
    }

    public static void loadAll() {
        list.clear();
        if (!Files.exists(ACCOUNTS_PATH, new LinkOption[0])) {
            return;
        }
        try (BufferedReader r = Files.newBufferedReader(ACCOUNTS_PATH, Charsets.UTF_8);){
            class_3518.method_37165((Reader)r).forEach(e -> list.add(MCAccount.deserialize(e.getAsJsonObject())));
        }
        catch (IOException e2) {
            Legacy4J.LOGGER.warn("Failed to load the saved accounts", (Throwable)e2);
        }
    }

    public static void saveAll() {
        if (list.isEmpty()) {
            return;
        }
        try (JsonWriter w = new JsonWriter((Writer)Files.newBufferedWriter(ACCOUNTS_PATH, Charsets.UTF_8, new OpenOption[0]));){
            w.setSerializeNulls(false);
            w.setIndent("  ");
            JsonArray array = new JsonArray();
            list.forEach(a -> {
                JsonObject obj = new JsonObject();
                a.serialize(obj);
                array.add((JsonElement)obj);
            });
            class_3518.method_43677((JsonWriter)w, (JsonElement)array, null);
            if (class_156.method_668().equals((Object)class_156.class_158.field_1133)) {
                Files.setAttribute(ACCOUNTS_PATH, "dos:hidden", Boolean.TRUE, LinkOption.NOFOLLOW_LINKS);
            }
        }
        catch (IOException e) {
            Legacy4J.LOGGER.warn("Failed to write the saved accounts", (Throwable)e);
        }
    }

    public static String encryptToken(String password, String token) {
        if (password == null) {
            return token;
        }
        try {
            byte[] salt = new byte[16];
            SecureRandom random = new SecureRandom();
            random.nextBytes(salt);
            byte[] iv = new byte[16];
            random.nextBytes(iv);
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            cipher.init(1, (Key)MCAccount.getKeyFromPassword(password, salt), new IvParameterSpec(iv));
            byte[] encrypted = cipher.doFinal(token.getBytes());
            byte[] encryptedWithSaltAndIv = new byte[salt.length + iv.length + encrypted.length];
            System.arraycopy(salt, 0, encryptedWithSaltAndIv, 0, salt.length);
            System.arraycopy(iv, 0, encryptedWithSaltAndIv, salt.length, iv.length);
            System.arraycopy(encrypted, 0, encryptedWithSaltAndIv, salt.length + iv.length, encrypted.length);
            return Base64.getEncoder().encodeToString(encryptedWithSaltAndIv);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            return null;
        }
    }

    public static MCAccount deserialize(JsonObject object) {
        return MCAccount.create(MCAccount.deserializeProfile(object), class_3518.method_15258((JsonObject)object, (String)ENCRYPTED, (boolean)false), class_3518.method_15253((JsonObject)object, (String)MC_ACCESS_TOKEN, null), class_3518.method_15253((JsonObject)object, (String)MSA_REFRESH_TOKEN, null));
    }

    public static void serializeProfile(GameProfile profile, JsonObject object) {
        object.addProperty("id", profile.getId().toString());
        object.addProperty("name", profile.getName());
    }

    public static GameProfile deserializeProfile(JsonObject object) {
        return new GameProfile(UUID.fromString(object.get("id").getAsString()), object.get("name").getAsString());
    }

    public static SecretKeySpec getKeyFromPassword(String password, byte[] salt) {
        try {
            return new SecretKeySpec(SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256").generateSecret(new PBEKeySpec(password.toCharArray(), salt, 65536, 256)).getEncoded(), "AES");
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    public static MCAccount create(final GameProfile profile, final boolean encrypted, final String mcAccessToken, final String msaRefreshToken) {
        if (mcAccessToken == null || msaRefreshToken == null) {
            return () -> profile;
        }
        final CompletableFuture<GameProfile> result = CompletableFuture.supplyAsync(() -> class_310.method_1551().method_1495().fetchProfile(profile.getId(), true).profile(), (Executor)class_156.method_55473());
        return new MCAccount(){

            @Override
            public GameProfile getProfile() {
                return result.getNow(profile);
            }

            @Override
            public boolean isEncrypted() {
                return encrypted;
            }

            @Override
            public void login(Runnable onClose, @Nullable String password) {
                if (password == null && this.isEncrypted()) {
                    return;
                }
                this.getMCAccessToken(password).ifPresent(s -> {
                    ExecutorService executor = Executors.newSingleThreadExecutor();
                    LegacyLoadingScreen screen = MCAccount.prepareLoginInScreen(onClose, executor);
                    class_310.method_1551().method_1507((class_437)screen);
                    ((CompletableFuture)MCAccount.login(s, executor).thenAccept(u -> {
                        class_310.method_1551().execute(onClose);
                        MCAccount.setUser(u);
                    })).exceptionally(t -> {
                        this.getMSARefreshToken(password).ifPresent(re -> {
                            Stocker refresh = Stocker.of((Object)re);
                            MCAccount.login(screen, re, password, (Stocker<String>)refresh, executor).thenAccept(user -> {
                                MCAccount.setUser(user);
                                list.set(list.indexOf(this), MCAccount.create(this.getProfile(), this.isEncrypted(), MCAccount.encryptToken(password, user.method_1674()), MCAccount.encryptToken(password, (String)refresh.get())));
                                class_310.method_1551().execute(onClose);
                            });
                        });
                        return null;
                    });
                });
            }

            @Override
            public void serialize(JsonObject object) {
                MCAccount.super.serialize(object);
                object.addProperty(MCAccount.ENCRYPTED, Boolean.valueOf(this.isEncrypted()));
                this.getMCAccessToken(null).ifPresent(t -> object.addProperty(MCAccount.MC_ACCESS_TOKEN, t));
                this.getMSARefreshToken(null).ifPresent(t -> object.addProperty(MCAccount.MSA_REFRESH_TOKEN, t));
            }

            @Override
            public Optional<String> getToken(@Nullable String password, String tokenEntry) {
                Optional<String> token = Optional.ofNullable(tokenEntry.equals(MCAccount.MC_ACCESS_TOKEN) ? mcAccessToken : (tokenEntry.equals(MCAccount.MSA_REFRESH_TOKEN) ? msaRefreshToken : null));
                if (token.isEmpty() || password == null) {
                    return token;
                }
                try {
                    byte[] decodedData = Base64.getDecoder().decode(token.get());
                    byte[] salt = new byte[16];
                    byte[] iv = new byte[16];
                    byte[] encrypted2 = new byte[decodedData.length - salt.length - iv.length];
                    System.arraycopy(decodedData, 0, salt, 0, salt.length);
                    System.arraycopy(decodedData, salt.length, iv, 0, iv.length);
                    System.arraycopy(decodedData, salt.length + iv.length, encrypted2, 0, encrypted2.length);
                    Cipher c = Cipher.getInstance(MCAccount.TRANSFORMATION);
                    c.init(2, (Key)MCAccount.getKeyFromPassword(password, salt), new IvParameterSpec(iv));
                    return Optional.of(new String(c.doFinal(encrypted2)));
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                    FactoryAPIClient.getToasts().method_1999((class_368)new LegacyTip((class_2561)class_2561.method_43469((String)"legacy.menu.choose_user.failed", (Object[])new Object[]{class_2561.method_43471((String)"legacy.menu.choose_user.failed.incorrect_password").method_27692(class_124.field_1061)}), 140, 46).centered());
                    return Optional.empty();
                }
            }
        };
    }

    public static CompletableFuture<String> acquireMSAuthCode(Function<Boolean, @NotNull String> browserMessage, Executor executor) {
        return MCAccount.acquireMSAuthCode(arg_0 -> ((class_156.class_158)class_156.method_668()).method_673(arg_0), browserMessage, executor);
    }

    public static CompletableFuture<String> acquireMSAuthCode(Function<Boolean, @NotNull String> browserMessage, Executor executor, @Nullable MicrosoftPrompt prompt) {
        return MCAccount.acquireMSAuthCode(arg_0 -> ((class_156.class_158)class_156.method_668()).method_673(arg_0), browserMessage, executor, prompt);
    }

    public static CompletableFuture<String> acquireMSAuthCode(Consumer<URI> browserAction, Function<Boolean, @NotNull String> browserMessage, Executor executor) {
        return MCAccount.acquireMSAuthCode(browserAction, browserMessage, executor, null);
    }

    public static CompletableFuture<String> acquireMSAuthCode(Consumer<URI> browserAction, Function<Boolean, @NotNull String> browserMessage, Executor executor, @Nullable MicrosoftPrompt prompt) {
        return CompletableFuture.supplyAsync(() -> {
            Legacy4J.LOGGER.info("Acquiring Microsoft auth code...");
            String state = RandomStringUtils.randomAlphanumeric((int)8);
            HttpServer server = HttpServer.create(new InetSocketAddress(25585), 0);
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference<@Nullable Object> authCode = new AtomicReference<Object>(null);
            AtomicReference<@Nullable Object> errorMsg = new AtomicReference<Object>(null);
            server.createContext("/callback", exchange -> {
                Map<String, String> query = URLEncodedUtils.parse((URI)exchange.getRequestURI(), (Charset)StandardCharsets.UTF_8).stream().collect(Collectors.toMap(NameValuePair::getName, NameValuePair::getValue));
                if (!state.equals(query.get("state"))) {
                    errorMsg.set(String.format("State mismatch! Expected '%s' but got '%s'.", state, query.get("state")));
                } else if (query.containsKey("code")) {
                    authCode.set(query.get("code"));
                } else if (query.containsKey("error")) {
                    errorMsg.set(String.format("%s: %s", query.get("error"), query.get("error_description")));
                }
                byte @Nullable [] message = ((String)browserMessage.apply(errorMsg.get() == null)).getBytes();
                exchange.sendResponseHeaders(200, message.length);
                OutputStream res = exchange.getResponseBody();
                res.write(message);
                res.close();
                latch.countDown();
            });
            URIBuilder uriBuilder = new URIBuilder(AUTHORIZE_URL).addParameter("client_id", CLIENT_ID).addParameter("response_type", "code").addParameter("redirect_uri", String.format("http://localhost:%d/callback", server.getAddress().getPort())).addParameter("scope", "XboxLive.signin offline_access").addParameter("state", state);
            if (prompt != null) {
                uriBuilder.addParameter("prompt", prompt.toString());
            }
            URI uri = uriBuilder.build();
            Legacy4J.LOGGER.info("Launching Microsoft login in browser: {}", (Object)uri.toString());
            browserAction.accept(uri);
            try {
                Legacy4J.LOGGER.info("Begin listening on http://localhost:{}/callback for a successful Microsoft login...", (Object)server.getAddress().getPort());
                server.start();
                latch.await();
                String string = Optional.ofNullable(authCode.get()).filter(code -> !code.isBlank()).map(code -> {
                    Legacy4J.LOGGER.info("Acquired Microsoft auth code! ({})", (Object)StringUtils.abbreviateMiddle((String)code, (String)"...", (int)32));
                    return code;
                }).orElseThrow(() -> new Exception(Optional.ofNullable((String)errorMsg.get()).orElse("There was no auth code or error description present.")));
                server.stop(2);
                return string;
            }
            catch (Throwable throwable) {
                try {
                    server.stop(2);
                    throw throwable;
                }
                catch (InterruptedException e) {
                    Legacy4J.LOGGER.warn("Microsoft auth code acquisition was cancelled!");
                    throw new CancellationException("Interrupted");
                }
                catch (Exception e) {
                    Legacy4J.LOGGER.error("Unable to acquire Microsoft auth code!", (Throwable)e);
                    throw new CompletionException(e);
                }
            }
        }, executor);
    }

    public static CompletableFuture<Pair<String, String>> acquireMSAccessToken(String code, Executor executor) {
        return MCAccount.acquireMSAccessToken(code, false, executor);
    }

    public static CompletableFuture<Pair<String, String>> acquireMSAccessToken(String code, boolean isRefreshToken, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            Pair pair;
            block9: {
                Legacy4J.LOGGER.info("Exchanging Microsoft auth code for an access token...");
                CloseableHttpClient client = HttpClients.createMinimal();
                try {
                    HttpPost request = new HttpPost(URI.create(TOKEN_URL));
                    request.setConfig(REQUEST_CONFIG);
                    request.setHeader("Content-Type", "application/x-www-form-urlencoded");
                    request.setEntity((HttpEntity)new UrlEncodedFormEntity(List.of(new BasicNameValuePair("client_id", CLIENT_ID), new BasicNameValuePair("grant_type", isRefreshToken ? "refresh_token" : "authorization_code"), new BasicNameValuePair(isRefreshToken ? "refresh_token" : "code", code), new BasicNameValuePair("redirect_uri", String.format("http://localhost:%d/callback", 25585))), "UTF-8"));
                    Legacy4J.LOGGER.info("[{}] {} (timeout={}s)", (Object)request.getMethod(), (Object)request.getURI().toString(), (Object)(request.getConfig().getConnectTimeout() / 1000));
                    CloseableHttpResponse res = client.execute((HttpUriRequest)request);
                    JsonObject json = class_3518.method_15285((String)EntityUtils.toString((HttpEntity)res.getEntity()));
                    pair = Pair.of((Object)Optional.ofNullable(json.get("access_token")).map(JsonElement::getAsString).filter(token -> !token.isBlank()).map(token -> {
                        Legacy4J.LOGGER.info("Acquired Microsoft access token! ({})", (Object)StringUtils.abbreviateMiddle((String)token, (String)"...", (int)32));
                        return token;
                    }).orElseThrow(() -> new Exception(json.has("error") ? String.format("%s: %s", json.get("error").getAsString(), json.get("error_description").getAsString()) : "There was no access token or error description present.")), (Object)json.get("refresh_token").getAsString());
                    if (client == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InterruptedException e) {
                        Legacy4J.LOGGER.warn("Microsoft access token acquisition was cancelled!");
                        throw new CancellationException("Interrupted");
                    }
                    catch (Exception e) {
                        Legacy4J.LOGGER.error("Unable to acquire Microsoft access token!", (Throwable)e);
                        throw new CompletionException(e);
                    }
                }
                client.close();
            }
            return pair;
        }, executor);
    }

    public static CompletableFuture<String> acquireXboxAccessToken(String accessToken, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            String string;
            block9: {
                Legacy4J.LOGGER.info("Exchanging Microsoft access token for an Xbox Live access token...");
                CloseableHttpClient client = HttpClients.createMinimal();
                try {
                    HttpPost request = new HttpPost(URI.create(XBOX_AUTH_URL));
                    request.setConfig(REQUEST_CONFIG);
                    request.setHeader("Content-Type", "application/json");
                    request.setEntity((HttpEntity)new StringEntity(String.format("{\n  \"Properties\": {\n    \"AuthMethod\": \"RPS\",\n    \"SiteName\": \"user.auth.xboxlive.com\",\n    \"RpsTicket\": \"d=%s\"\n  },\n  \"RelyingParty\": \"http://auth.xboxlive.com\",\n  \"TokenType\": \"JWT\"\n}", accessToken)));
                    Legacy4J.LOGGER.info("[{}] {} (timeout={}s)", (Object)request.getMethod(), (Object)request.getURI().toString(), (Object)(request.getConfig().getConnectTimeout() / 1000));
                    CloseableHttpResponse res = client.execute((HttpUriRequest)request);
                    JsonObject json = res.getStatusLine().getStatusCode() == 200 ? class_3518.method_15285((String)EntityUtils.toString((HttpEntity)res.getEntity())) : new JsonObject();
                    string = Optional.ofNullable(json.get("Token")).map(JsonElement::getAsString).filter(token -> !token.isBlank()).map(token -> {
                        Legacy4J.LOGGER.info("Acquired Xbox Live access token! ({})", (Object)StringUtils.abbreviateMiddle((String)token, (String)"...", (int)32));
                        return token;
                    }).orElseThrow(() -> new Exception(json.has("XErr") ? String.format("%s: %s", json.get("XErr").getAsString(), json.get("Message").getAsString()) : "There was no access token or error description present."));
                    if (client == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InterruptedException e) {
                        Legacy4J.LOGGER.warn("Xbox Live access token acquisition was cancelled!");
                        throw new CancellationException("Interrupted");
                    }
                    catch (Exception e) {
                        Legacy4J.LOGGER.error("Unable to acquire Xbox Live access token!", (Throwable)e);
                        throw new CompletionException(e);
                    }
                }
                client.close();
            }
            return string;
        }, executor);
    }

    public static CompletableFuture<Map<String, String>> acquireXboxXstsToken(String accessToken, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            Map map;
            block9: {
                Legacy4J.LOGGER.info("Exchanging Xbox Live token for an Xbox Live XSTS token...");
                CloseableHttpClient client = HttpClients.createMinimal();
                try {
                    HttpPost request = new HttpPost(URI.create(XBOX_XSTS_URL));
                    request.setConfig(REQUEST_CONFIG);
                    request.setHeader("Content-Type", "application/json");
                    request.setEntity((HttpEntity)new StringEntity(String.format("{\n  \"Properties\": {\n    \"SandboxId\": \"RETAIL\",\n    \"UserTokens\": [\"%s\"]\n  },\n  \"RelyingParty\": \"rp://api.minecraftservices.com/\",\n  \"TokenType\": \"JWT\"\n}", accessToken)));
                    Legacy4J.LOGGER.info("[{}] {} (timeout={}s)", (Object)request.getMethod(), (Object)request.getURI().toString(), (Object)(request.getConfig().getConnectTimeout() / 1000));
                    CloseableHttpResponse res = client.execute((HttpUriRequest)request);
                    JsonObject json = res.getStatusLine().getStatusCode() == 200 ? class_3518.method_15285((String)EntityUtils.toString((HttpEntity)res.getEntity())) : new JsonObject();
                    map = Optional.ofNullable(json.get("Token")).map(JsonElement::getAsString).filter(token -> !token.isBlank()).map(token -> {
                        String uhs = json.get("DisplayClaims").getAsJsonObject().get("xui").getAsJsonArray().get(0).getAsJsonObject().get("uhs").getAsString();
                        Legacy4J.LOGGER.info("Acquired Xbox Live XSTS token! (token={}, uhs={})", (Object)StringUtils.abbreviateMiddle((String)token, (String)"...", (int)32), (Object)uhs);
                        return Map.of("Token", token, "uhs", uhs);
                    }).orElseThrow(() -> new Exception(json.has("XErr") ? String.format("%s: %s", json.get("XErr").getAsString(), json.get("Message").getAsString()) : "There was no access token or error description present."));
                    if (client == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InterruptedException e) {
                        Legacy4J.LOGGER.warn("Xbox Live XSTS token acquisition was cancelled!");
                        throw new CancellationException("Interrupted");
                    }
                    catch (Exception e) {
                        Legacy4J.LOGGER.error("Unable to acquire Xbox Live XSTS token!", (Throwable)e);
                        throw new CompletionException(e);
                    }
                }
                client.close();
            }
            return map;
        }, executor);
    }

    public static CompletableFuture<String> acquireMCAccessToken(String xstsToken, String userHash, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            String string;
            block9: {
                Legacy4J.LOGGER.info("Exchanging Xbox Live XSTS token for a Minecraft access token...");
                CloseableHttpClient client = HttpClients.createMinimal();
                try {
                    HttpPost request = new HttpPost(URI.create(MC_AUTH_URL));
                    request.setConfig(REQUEST_CONFIG);
                    request.setHeader("Content-Type", "application/json");
                    request.setEntity((HttpEntity)new StringEntity(String.format("{\"identityToken\": \"XBL3.0 x=%s;%s\"}", userHash, xstsToken)));
                    Legacy4J.LOGGER.info("[{}] {} (timeout={}s)", (Object)request.getMethod(), (Object)request.getURI().toString(), (Object)(request.getConfig().getConnectTimeout() / 1000));
                    CloseableHttpResponse res = client.execute((HttpUriRequest)request);
                    JsonObject json = class_3518.method_15285((String)EntityUtils.toString((HttpEntity)res.getEntity()));
                    string = Optional.ofNullable(json.get("access_token")).map(JsonElement::getAsString).filter(token -> !token.isBlank()).map(token -> {
                        Legacy4J.LOGGER.info("Acquired Minecraft access token! ({})", (Object)StringUtils.abbreviateMiddle((String)token, (String)"...", (int)32));
                        return token;
                    }).orElseThrow(() -> new Exception(json.has("error") ? String.format("%s: %s", json.get("error").getAsString(), json.get("errorMessage").getAsString()) : "There was no access token or error description present."));
                    if (client == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InterruptedException e) {
                        Legacy4J.LOGGER.warn("Minecraft access token acquisition was cancelled!");
                        throw new CancellationException("Interrupted");
                    }
                    catch (Exception e) {
                        Legacy4J.LOGGER.error("Unable to acquire Minecraft access token!", (Throwable)e);
                        throw new CompletionException(e);
                    }
                }
                client.close();
            }
            return string;
        }, executor);
    }

    public static LegacyLoadingScreen prepareLoginInScreen(final Runnable onClose, final ExecutorService executor) {
        return new LegacyLoadingScreen(LOGIN_IN, (class_2561)class_2561.method_43473()){

            public void method_25419() {
                boolean bl;
                onClose.run();
                executor.shutdown();
                try {
                    bl = executor.awaitTermination(3L, TimeUnit.SECONDS);
                }
                catch (InterruptedException var3) {
                    bl = false;
                }
                if (!bl) {
                    executor.shutdownNow();
                }
            }

            @Override
            public boolean method_25422() {
                return true;
            }
        };
    }

    public static CompletableFuture<class_320> login(LegacyLoadingScreen screen, String code, String password, Stocker<String> refresh, Executor executor) {
        CompletionStage login = ((CompletableFuture)((CompletableFuture)((CompletableFuture)MCAccount.updateStage(MCAccount.acquireMSAccessToken(code, refresh.get() != null, executor), screen, ACQUIRING_MSACCESS_TOKEN, 20).thenComposeAsync(s -> {
            refresh.set((Object)MCAccount.encryptToken(password, (String)s.getSecond()));
            return MCAccount.updateStage(MCAccount.acquireXboxAccessToken((String)s.getFirst(), executor), screen, ACQUIRING_XBOX_ACCESS_TOKEN, 40);
        })).thenComposeAsync(s -> MCAccount.updateStage(MCAccount.acquireXboxXstsToken(s, executor), screen, ACQUIRING_XBOX_XSTS_TOKEN, 60))).thenComposeAsync(s -> MCAccount.updateStage(MCAccount.acquireMCAccessToken((String)s.get("Token"), (String)s.get("uhs"), executor), screen, ACQUIRING_MC_ACCESS_TOKEN, 80))).thenComposeAsync(s -> MCAccount.updateStage(MCAccount.login(s, executor), screen, FINALIZING, 100));
        ((CompletableFuture)login).exceptionally(throwable -> {
            FactoryAPIClient.getToasts().method_1999((class_368)new LegacyTip((class_2561)class_2561.method_43469((String)"legacy.menu.choose_user.failed", (Object[])new Object[]{class_2561.method_43471((String)("legacy.menu.choose_user.failed." + (throwable instanceof ConnectTimeoutException ? "timeout" : (throwable != null && throwable.getCause().getMessage().equals("NOT_FOUND: Not Found") ? "notPurchased" : "unauthorized")))).method_27692(class_124.field_1061)}), 140, 46).centered());
            if (throwable != null) {
                Legacy4J.LOGGER.error(throwable.getMessage());
            }
            class_310.method_1551().method_19537(() -> ((LegacyLoadingScreen)screen).method_25419());
            return null;
        });
        return login;
    }

    public static class_320 loginFail(LegacyLoadingScreen screen, Throwable throwable) {
        FactoryAPIClient.getToasts().method_1999((class_368)new LegacyTip((class_2561)class_2561.method_43469((String)"legacy.menu.choose_user.failed", (Object[])new Object[]{class_2561.method_43471((String)("legacy.menu.choose_user.failed." + (throwable instanceof ConnectTimeoutException ? "timeout" : (throwable != null && throwable.getCause().getMessage().equals("NOT_FOUND: Not Found") ? "notPurchased" : "unauthorized")))).method_27692(class_124.field_1061)}), 140, 46).centered());
        if (throwable != null) {
            Legacy4J.LOGGER.error(throwable.getMessage());
        }
        class_310.method_1551().method_19537(() -> ((LegacyLoadingScreen)screen).method_25419());
        return null;
    }

    public static CompletableFuture<MCAccount> create(Runnable onClose, String password) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        LegacyLoadingScreen screen = MCAccount.prepareLoginInScreen(onClose, executor);
        class_310.method_1551().method_1507((class_437)screen);
        Stocker refresh = Stocker.of(null);
        return ((CompletableFuture)MCAccount.updateStage(MCAccount.acquireMSAuthCode(bol -> class_1074.method_4662((String)(bol != false ? "legacy.menu.choose_user.login_successful" : "legacy.menu.choose_user.failed_login"), (Object[])new Object[0]), executor), screen, ACQUIRING_MSAUTH_TOKEN, 0).thenComposeAsync(s -> MCAccount.login(screen, s, password, (Stocker<String>)refresh, executor))).thenApplyAsync(user -> MCAccount.create(new GameProfile(user.method_44717(), user.method_1676()), password != null, MCAccount.encryptToken(password, user.method_1674()), (String)refresh.get()), (Executor)executor);
    }

    public static CompletableFuture<class_320> login(String mcToken, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            class_320 class_3202;
            block9: {
                Legacy4J.LOGGER.info("Fetching Minecraft profile...");
                CloseableHttpClient client = HttpClients.createMinimal();
                try {
                    HttpGet request = new HttpGet(URI.create(MC_PROFILE_URL));
                    request.setConfig(REQUEST_CONFIG);
                    request.setHeader("Authorization", "Bearer " + mcToken);
                    Legacy4J.LOGGER.info("[{}] {} (timeout={}s)", (Object)request.getMethod(), (Object)request.getURI().toString(), (Object)(request.getConfig().getConnectTimeout() / 1000));
                    CloseableHttpResponse res = client.execute((HttpUriRequest)request);
                    JsonObject json = class_3518.method_15285((String)EntityUtils.toString((HttpEntity)res.getEntity()));
                    class_3202 = Optional.ofNullable(json.get("id")).map(JsonElement::getAsString).filter(uuid -> !uuid.isBlank()).map(uuid -> UUID.fromString(uuid.replaceFirst("([0-9a-fA-F]{8})([0-9a-fA-F]{4})([0-9a-fA-F]{4})([0-9a-fA-F]{4})([0-9a-fA-F]+)", "$1-$2-$3-$4-$5"))).map(uuid -> {
                        Legacy4J.LOGGER.info("Fetched Minecraft profile! (name={}, uuid={})", (Object)json.get("name").getAsString(), uuid);
                        return new class_320(json.get("name").getAsString(), uuid, mcToken, Optional.empty(), Optional.empty(), class_320.class_321.field_34962);
                    }).orElseThrow(() -> new Exception(json.has("error") ? String.format("%s: %s", json.get("error").getAsString(), json.get("errorMessage").getAsString()) : "There was no profile or error description present."));
                    if (client == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InterruptedException e) {
                        Legacy4J.LOGGER.warn("Minecraft profile fetching was cancelled!");
                        throw new CancellationException("Interrupted");
                    }
                    catch (Exception e) {
                        Legacy4J.LOGGER.error("Unable to fetch Minecraft profile!", (Throwable)e);
                        throw new CompletionException(e);
                    }
                }
                client.close();
            }
            return class_3202;
        }, executor);
    }

    public static void setUser(class_320 user) {
        if (MinecraftAccessor.getInstance().setUser(user)) {
            class_5250 success = class_2561.method_43469((String)"legacy.menu.choose_user.success", (Object[])new Object[]{user.method_1676()});
            FactoryAPIClient.getToasts().method_1999((class_368)new LegacyTip((class_2561)success, class_310.method_1551().field_1772.method_27525((class_5348)success) + 110, 46){

                @Override
                public void renderTip(class_332 guiGraphics, int i, int j, float f, float l) {
                    super.renderTip(guiGraphics, i, j, f, l);
                    GameProfile profile = class_310.method_1551().method_53462();
                    class_7532.method_52722((class_332)guiGraphics, (class_8685)class_310.method_1551().method_1582().method_52862(profile), (int)7, (int)((this.method_29050() - 32) / 2), (int)32);
                }
            }.centered().disappearTime(2400L).canRemove(() -> user != class_310.method_1551().method_1548()));
            lastSessionCheck.set(null);
        }
    }

    public static boolean isOfflineUser() {
        if (lastSessionCheck.get() != null && class_156.method_658() - (Long)lastSessionCheckTime.get() <= 180000L) {
            return (Boolean)lastSessionCheck.get();
        }
        lastSessionCheckTime.set((Object)class_156.method_658());
        lastSessionCheck.set((Object)true);
        CompletableFuture.runAsync(() -> {
            try {
                String server = UUID.randomUUID().toString();
                class_310.method_1551().method_1495().joinServer(class_310.method_1551().method_1548().method_44717(), class_310.method_1551().method_1548().method_1674(), server);
                lastSessionCheck.set((Object)(class_310.method_1551().method_1495().hasJoinedServer(class_310.method_1551().method_1548().method_1676(), server, null) == null ? 1 : 0));
            }
            catch (AuthenticationException e) {
                lastSessionCheck.set((Object)true);
            }
        });
        return false;
    }

    public static <T> CompletableFuture<T> updateStage(CompletableFuture<T> future, LegacyLoadingScreen screen, class_2561 stage, int percentage) {
        screen.setLoadingStage(stage);
        screen.setProgress(percentage);
        return future;
    }

    public static enum MicrosoftPrompt {
        DEFAULT(""),
        SELECT_ACCOUNT("select_account"),
        LOGIN("login"),
        NONE("none"),
        CONSENT("consent");

        private final String prompt;

        private MicrosoftPrompt(String prompt) {
            this.prompt = prompt;
        }

        public String toString() {
            return this.prompt;
        }
    }
}

