/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.google.common.base.Charsets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonWriter;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.slf4j.Logger;
import wily.factoryapi.FactoryAPI;

public class KnownListing<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Path path;
    public final List<ResourceLocation> list = new ArrayList<ResourceLocation>();
    private final Registry<T> registry;
    private final String listingFile;

    public KnownListing(Registry<T> registry, Path path) {
        this.registry = registry;
        this.listingFile = "known_" + this.registry.key().location().getPath() + ".json";
        this.path = path.resolve(this.listingFile);
        if (Files.exists(this.path, new LinkOption[0])) {
            try (BufferedReader bufferedReader = Files.newBufferedReader(this.path, Charsets.UTF_8);){
                JsonArray array = GsonHelper.parseArray((Reader)bufferedReader);
                array.forEach(e -> {
                    JsonPrimitive p;
                    if (e instanceof JsonPrimitive && (p = (JsonPrimitive)e).isString()) {
                        this.list.add(FactoryAPI.createLocation((String)p.getAsString()));
                    }
                });
            }
            catch (Exception exception) {
                LOGGER.error("Failed to read {}, known " + this.registry.key().location().getPath() + " will be reset", (Object)this.listingFile, (Object)exception);
            }
        }
    }

    public boolean contains(T obj) {
        return this.list.contains(this.registry.getKey(obj));
    }

    public void add(T obj) {
        if (!this.contains(obj)) {
            this.list.add(this.registry.getKey(obj));
        }
    }

    public void save() {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(this.path, Charsets.UTF_8, new OpenOption[0]);){
            JsonArray a = new JsonArray();
            this.list.forEach(l -> a.add(l.toString()));
            GsonHelper.writeValue((JsonWriter)new JsonWriter((Writer)bufferedWriter), (JsonElement)a, String::compareTo);
        }
        catch (IOException iOException) {
            LOGGER.error("Failed to write {}, new known " + this.registry.key().location().getPath() + " won't be present", (Object)this.listingFile, (Object)iOException);
        }
    }
}

