/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.util.DynamicUtil;
import wily.factoryapi.util.ListMap;
import wily.legacy.Legacy4J;
import wily.legacy.client.LegacyTabInfo;
import wily.legacy.client.RecipeInfo;
import wily.legacy.client.screen.LegacyTabButton;
import wily.legacy.util.JsonUtil;

public class LegacyCraftingTabListing
implements LegacyTabInfo {
    public static final Codec<LegacyCraftingTabListing> CODEC = RecordCodecBuilder.create(i -> i.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(LegacyCraftingTabListing::id), (App)DynamicUtil.getComponentCodec().optionalFieldOf("name", null).forGetter(LegacyCraftingTabListing::name), (App)LegacyTabButton.ICON_HOLDER_CODEC.optionalFieldOf("icon", null).forGetter(LegacyCraftingTabListing::iconHolder), (App)RecipeInfo.Filter.LISTING_CODEC.fieldOf("listing").forGetter(LegacyCraftingTabListing::craftings)).apply((Applicative)i, LegacyCraftingTabListing::new));
    public static final ListMap<ResourceLocation, LegacyCraftingTabListing> map = new ListMap();
    private static final String CRAFTING_TAB_LISTING = "crafting_tab_listing.json";
    private final ResourceLocation id;
    public Component name;
    public LegacyTabButton.IconHolder<?> iconHolder;
    private final Map<String, List<RecipeInfo.Filter>> craftings;

    @Deprecated
    public LegacyCraftingTabListing(ResourceLocation id, Component name, LegacyTabButton.IconHolder<?> iconHolder) {
        this(id, name, iconHolder, new LinkedHashMap<String, List<RecipeInfo.Filter>>());
    }

    public LegacyCraftingTabListing(ResourceLocation id, Component name, LegacyTabButton.IconHolder<?> iconHolder, Map<String, List<RecipeInfo.Filter>> craftings) {
        this.id = id;
        this.name = name;
        this.iconHolder = iconHolder;
        this.craftings = craftings;
    }

    @Override
    public boolean isValid() {
        return LegacyTabInfo.super.isValid() && !this.craftings.isEmpty();
    }

    @Override
    public ResourceLocation id() {
        return this.id;
    }

    @Override
    public Component name() {
        return this.name;
    }

    @Override
    public LegacyTabButton.IconHolder<?> iconHolder() {
        return this.iconHolder;
    }

    public final Map<String, List<RecipeInfo.Filter>> craftings() {
        return this.craftings;
    }

    public void addFrom(LegacyCraftingTabListing otherListing) {
        if (otherListing.name != null) {
            this.name = otherListing.name;
        }
        if (otherListing.iconHolder != null) {
            this.iconHolder = otherListing.iconHolder;
        }
        otherListing.craftings.forEach((s, f) -> {
            if (this.craftings.containsKey(s)) {
                this.craftings.get(s).addAll((Collection<RecipeInfo.Filter>)f);
            } else {
                this.craftings.put((String)s, (List<RecipeInfo.Filter>)f);
            }
        });
    }

    public static class Manager
    implements ResourceManagerReloadListener {
        public void onResourceManagerReload(ResourceManager manager) {
            map.clear();
            JsonUtil.getOrderedNamespaces(manager).forEach(name -> manager.getResource(FactoryAPI.createLocation((String)name, (String)LegacyCraftingTabListing.CRAFTING_TAB_LISTING)).ifPresent(r -> {
                try (BufferedReader bufferedReader = r.openAsReader();){
                    JsonElement element = JsonParser.parseReader((Reader)bufferedReader);
                    if (element instanceof JsonArray) {
                        JsonArray a = (JsonArray)element;
                        a.forEach(e -> CODEC.parse((DynamicOps)JsonOps.INSTANCE, e).result().ifPresent(listing -> {
                            if (map.containsKey((Object)listing.id)) {
                                ((LegacyCraftingTabListing)map.get((Object)listing.id)).addFrom((LegacyCraftingTabListing)listing);
                            } else if (listing.isValid()) {
                                map.put((Object)listing.id, listing);
                            }
                        }));
                    }
                }
                catch (IOException exception) {
                    Legacy4J.LOGGER.warn(exception.getMessage());
                }
            }));
        }

        public String getName() {
            return "legacy:crafting_tab_listing";
        }
    }
}

