/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.controller;

import com.mojang.blaze3d.platform.Window;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.InputType;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.Slot;
import org.lwjgl.glfw.GLFW;
import wily.factoryapi.FactoryEvent;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.util.ListMap;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacyTipManager;
import wily.legacy.client.controller.BindingState;
import wily.legacy.client.controller.Controller;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.controller.GLFWControllerHandler;
import wily.legacy.client.controller.LegacyKeyMapping;
import wily.legacy.client.controller.SDLControllerHandler;
import wily.legacy.client.screen.LegacyMenuAccess;
import wily.legacy.entity.LegacyPlayerInfo;
import wily.legacy.mixin.base.MouseHandlerAccessor;

public class ControllerManager {
    public Controller connectedController = null;
    public boolean isCursorDisabled = false;
    public boolean resetCursor = false;
    public boolean canChangeSlidersValue = true;
    protected Minecraft minecraft;
    public static final ListMap<String, Controller.Handler> handlers = ListMap.builder().put((Object)"none", (Object)Controller.Handler.EMPTY).put((Object)"glfw", (Object)GLFWControllerHandler.getInstance()).put((Object)"sdl3", (Object)SDLControllerHandler.getInstance()).build();
    protected boolean isControllerTheLastInput = false;
    public boolean isControllerSimulatingInput = false;
    public static final Component CONTROLLER_DETECTED = Component.translatable((String)"legacy.controller.detected");
    public static final Component CONTROLLER_DISCONNECTED = Component.translatable((String)"legacy.controller.disconnected");

    public static Controller.Handler getHandler() {
        return (Controller.Handler)LegacyOptions.selectedControllerHandler.get();
    }

    public static void updatePlayerCamera(BindingState.Axis stick, Controller controller) {
        Minecraft minecraft = Minecraft.getInstance();
        if (!(minecraft.mouseHandler.isMouseGrabbed() && minecraft.isWindowActive() && stick.pressed && minecraft.player != null)) {
            return;
        }
        double f = Math.pow((Double)LegacyOptions.controllerSensitivity.get() * (double)0.6f + (double)0.2f, 3.0) * 7.5 * (minecraft.player.isScoping() ? 0.125 : 1.0);
        minecraft.player.turn((double)ControllerManager.getCameraCurve(stick.getSmoothX()) * f, (double)ControllerManager.getCameraCurve(stick.getSmoothY()) * f * (double)((Boolean)LegacyOptions.invertYController.get() != false ? -1 : 1));
    }

    public static float getCameraCurve(float f) {
        if (((Boolean)LegacyOptions.linearCameraMovement.get()).booleanValue()) {
            return f;
        }
        return f * f * Math.signum(f);
    }

    public void setup(final Minecraft minecraft) {
        this.minecraft = minecraft;
        this.updateCursorInputMode();
        CompletableFuture.runAsync(() -> new Timer().scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                minecraft.execute(ControllerManager.getHandler()::init);
                if (minecraft.isRunning() && ControllerManager.getHandler().update()) {
                    ((Setup)Setup.EVENT.invoker).accept(ControllerManager.this);
                    if (!ControllerManager.getHandler().isValidController((Integer)LegacyOptions.selectedController.get())) {
                        if (ControllerManager.this.connectedController != null) {
                            ControllerManager.this.connectedController.disconnect(ControllerManager.this);
                        }
                        return;
                    }
                    if (ControllerManager.this.connectedController == null && (ControllerManager.this.connectedController = ControllerManager.getHandler().getController((Integer)LegacyOptions.selectedController.get())) != null) {
                        ControllerManager.this.connectedController.connect(ControllerManager.this);
                    }
                    minecraft.execute(() -> {
                        if (ControllerManager.this.connectedController != null) {
                            ControllerManager.getHandler().setup(ControllerManager.this);
                        }
                    });
                }
            }
        }, 0L, 1L)).exceptionally(t -> {
            Legacy4J.LOGGER.warn(t.getMessage());
            return null;
        });
    }

    public void setPointerPos(double x, double y) {
        this.setPointerPos(x, y, this.isControllerTheLastInput() && (Boolean)LegacyOptions.controllerVirtualCursor.get() != false);
    }

    public void setPointerPos(double x, double y, boolean onlyVirtual) {
        Window window = this.minecraft.getWindow();
        this.minecraft.mouseHandler.xpos = Math.max(0.0, Math.min(x, (double)window.getScreenWidth()));
        this.minecraft.mouseHandler.ypos = Math.max(0.0, Math.min(y, (double)window.getScreenHeight()));
        if (!onlyVirtual) {
            GLFW.glfwSetCursorPos((long)Minecraft.getInstance().getWindow().getWindow(), (double)this.minecraft.mouseHandler.xpos, (double)this.minecraft.mouseHandler.ypos);
        }
    }

    public synchronized void updateBindings() {
        this.updateBindings(this.minecraft.isWindowActive() ? this.connectedController : Controller.EMPTY);
    }

    public synchronized void updateBindings(Controller controller) {
        if (this.minecraft.screen != null) {
            Controller.Event.of(this.minecraft.screen).controllerTick(controller);
        }
        if (LegacyTipManager.getActualTip() != null) {
            LegacyTipManager.getActualTip().controllerTick(controller);
        }
        for (ControllerBinding<?> binding : ControllerBinding.map.values()) {
            PlayerInfo playerInfo;
            if (controller == null) break;
            Object state = binding.state();
            ((BindingState)state).update(controller);
            if (LegacyTipManager.getActualTip() != null) {
                LegacyTipManager.getActualTip().bindingStateTick((BindingState)state);
            }
            if (((BindingState)state).pressed) {
                this.setControllerTheLastInput(true);
                this.minecraft.getFramerateLimitTracker().onInputReceived();
            }
            if (this.getCursorMode().isAuto() && ((BindingState)state).pressed && !this.isCursorDisabled) {
                this.disableCursor();
            }
            if (this.minecraft.player != null && this.minecraft.getConnection() != null && controller.hasLED() && (playerInfo = this.minecraft.getConnection().getPlayerInfo(this.minecraft.player.getUUID())) instanceof LegacyPlayerInfo) {
                LegacyPlayerInfo i = (LegacyPlayerInfo)playerInfo;
                float[] color = Legacy4JClient.getVisualPlayerColor(i);
                controller.setLED((byte)(color[0] * 255.0f), (byte)(color[1] * 255.0f), (byte)(color[2] * 255.0f));
            }
            if (((BindingState)state).is(ControllerBinding.START) && ((BindingState)state).justPressed) {
                if (this.minecraft.screen == null) {
                    this.minecraft.pauseGame(false);
                } else if (this.minecraft.screen instanceof AbstractContainerScreen || this.minecraft.screen instanceof PauseScreen) {
                    this.minecraft.screen.onClose();
                }
            }
            if (this.minecraft.screen != null) {
                if (((BindingState)state).pressed && ((BindingState)state).canClick()) {
                    this.minecraft.setLastInputType(InputType.KEYBOARD_ARROW);
                    this.minecraft.screen.afterKeyboardAction();
                }
                Controller.Event.of(this.minecraft.screen).bindingStateTick((BindingState)state);
                if (this.minecraft.screen != null) {
                    ControllerBinding cursorBinding = LegacyKeyMapping.of(Legacy4JClient.keyToggleCursor).getBinding();
                    if (cursorBinding != null && ((BindingState)state).is(cursorBinding) && ((BindingState)state).canClick()) {
                        this.toggleCursor();
                    }
                    if (this.isCursorDisabled) {
                        this.simulateKeyAction(s -> {
                            Controller.Event e;
                            Screen patt0$temp;
                            return state.is(ControllerBinding.DOWN_BUTTON) && ((patt0$temp = this.minecraft.screen) instanceof Controller.Event && !(e = (Controller.Event)patt0$temp).onceClickBindings() || state.onceClick(true));
                        }, 257, (BindingState)state);
                    }
                    this.simulateKeyAction(s -> s.is(ControllerBinding.RIGHT_BUTTON) && state.onceClick(true), 256, (BindingState)state);
                    this.simulateKeyAction(s -> s.is(ControllerBinding.LEFT_BUTTON), 88, (BindingState)state);
                    this.simulateKeyAction(s -> s.is(ControllerBinding.UP_BUTTON), 79, (BindingState)state);
                    this.simulateKeyAction(s -> s.is(ControllerBinding.RIGHT_TRIGGER), 87, (BindingState)state);
                    this.simulateKeyAction(s -> s.is(ControllerBinding.LEFT_TRIGGER), 266, (BindingState)state);
                    this.simulateKeyAction(s -> s.is(ControllerBinding.RIGHT_TRIGGER), 267, (BindingState)state);
                    this.simulateKeyAction(s -> s.is(ControllerBinding.RIGHT_BUMPER), 93, (BindingState)state);
                    this.simulateKeyAction(s -> s.is(ControllerBinding.LEFT_BUMPER), 91, (BindingState)state);
                    this.simulateKeyAction(s -> s.is(ControllerBinding.TOUCHPAD_BUTTON), 84, (BindingState)state);
                    this.simulateKeyAction(s -> s.is(ControllerBinding.CAPTURE), 291, (BindingState)state);
                    if (((BindingState)state).is(ControllerBinding.RIGHT_STICK) && state instanceof BindingState.Axis) {
                        BindingState.Axis stick = (BindingState.Axis)state;
                        if (Math.abs(stick.y) > Math.abs(stick.x) && ((BindingState)state).pressed && ((BindingState)state).canClick()) {
                            this.minecraft.screen.mouseScrolled(this.getPointerX(), this.getPointerY(), 0.0, (double)Math.signum(-stick.y));
                        }
                    }
                    Predicate<Predicate> isStickAnd = s -> {
                        BindingState.Axis stick;
                        return state.is(ControllerBinding.LEFT_STICK) && state instanceof BindingState.Axis && s.test(stick = (BindingState.Axis)state);
                    };
                    if (this.isCursorDisabled) {
                        if (isStickAnd.test(s -> s.y < 0.0f && -s.y > Math.abs(s.x)) || ((BindingState)state).is(ControllerBinding.DPAD_UP)) {
                            this.simulateKeyAction(265, (BindingState)state);
                        }
                        if (isStickAnd.test(s -> s.y > 0.0f && s.y > Math.abs(s.x)) || ((BindingState)state).is(ControllerBinding.DPAD_DOWN)) {
                            this.simulateKeyAction(264, (BindingState)state);
                        }
                        if (isStickAnd.test(s -> s.x > 0.0f && s.x > Math.abs(s.y)) || ((BindingState)state).is(ControllerBinding.DPAD_RIGHT)) {
                            this.simulateKeyAction(262, (BindingState)state);
                        }
                        if (isStickAnd.test(s -> s.x < 0.0f && -s.x > Math.abs(s.y)) || ((BindingState)state).is(ControllerBinding.DPAD_LEFT)) {
                            this.simulateKeyAction(263, (BindingState)state);
                        }
                    }
                }
            }
            if (this.minecraft.screen != null && !this.isCursorDisabled) {
                LegacyMenuAccess m;
                if (((BindingState)state).is(ControllerBinding.LEFT_STICK) && state instanceof BindingState.Axis) {
                    BindingState.Axis stick = (BindingState.Axis)state;
                    if (((BindingState)state).pressed) {
                        this.setPointerPos(this.minecraft.mouseHandler.xpos() + (double)stick.x * ((double)this.minecraft.getWindow().getScreenWidth() / (double)this.minecraft.getWindow().getGuiScaledWidth()) * (Double)LegacyOptions.interfaceSensitivity.get() / 2.0, this.minecraft.mouseHandler.ypos() + (double)stick.y * ((double)this.minecraft.getWindow().getScreenHeight() / (double)this.minecraft.getWindow().getGuiScaledHeight()) * (Double)LegacyOptions.interfaceSensitivity.get() / 2.0);
                    }
                }
                if (((BindingState)state).is(ControllerBinding.LEFT_TRIGGER) && (playerInfo = this.minecraft.screen) instanceof LegacyMenuAccess && (m = (LegacyMenuAccess)playerInfo).getMenu().getCarried().getCount() > 1) {
                    if (((BindingState)state).justPressed) {
                        this.minecraft.screen.mouseClicked(this.getPointerX(), this.getPointerY(), 0);
                    } else if (((BindingState)state).released) {
                        this.minecraft.screen.mouseReleased(this.getPointerX(), this.getPointerY(), 0);
                    }
                    if (((BindingState)state).pressed) {
                        this.minecraft.screen.mouseDragged(this.getPointerX(), this.getPointerY(), 0, 0.0, 0.0);
                    }
                }
                if (((BindingState)state).is(ControllerBinding.DOWN_BUTTON) || ((BindingState)state).is(ControllerBinding.UP_BUTTON) || ((BindingState)state).is(ControllerBinding.LEFT_BUTTON)) {
                    this.isControllerSimulatingInput = true;
                    if (((BindingState)state).pressed && ((BindingState)state).onceClick(true)) {
                        ((MouseHandlerAccessor)this.minecraft.mouseHandler).pressMouse(this.minecraft.getWindow().getWindow(), ((BindingState)state).is(ControllerBinding.LEFT_BUTTON) ? 1 : 0, 1, 0);
                    } else if (((BindingState)state).released) {
                        ((MouseHandlerAccessor)this.minecraft.mouseHandler).pressMouse(this.minecraft.getWindow().getWindow(), ((BindingState)state).is(ControllerBinding.LEFT_BUTTON) ? 1 : 0, 0, 0);
                    }
                    this.isControllerSimulatingInput = false;
                }
            }
            if ((playerInfo = this.minecraft.screen) instanceof LegacyMenuAccess) {
                LegacyMenuAccess a = (LegacyMenuAccess)playerInfo;
                if (!this.isCursorDisabled) {
                    if (((BindingState)state).pressed && ((BindingState)state).canClick()) {
                        if (((BindingState)state).is(ControllerBinding.DPAD_UP)) {
                            a.movePointerToSlotIn(ScreenDirection.UP);
                        } else if (((BindingState)state).is(ControllerBinding.DPAD_DOWN)) {
                            a.movePointerToSlotIn(ScreenDirection.DOWN);
                        } else if (((BindingState)state).is(ControllerBinding.DPAD_RIGHT)) {
                            a.movePointerToSlotIn(ScreenDirection.RIGHT);
                        } else if (((BindingState)state).is(ControllerBinding.DPAD_LEFT)) {
                            a.movePointerToSlotIn(ScreenDirection.LEFT);
                        }
                    } else if (((BindingState)state).is(ControllerBinding.LEFT_STICK) && ((BindingState)state).released) {
                        a.movePointerToSlot(a.findSlotAt(this.getPointerX(), this.getPointerY()));
                    }
                }
            }
            for (KeyMapping keyMapping : this.minecraft.options.keyMappings) {
                Screen screen;
                if (!((BindingState)state).matches(keyMapping) || this.minecraft.screen != null && (!((screen = this.minecraft.screen) instanceof PauseScreen) || ((PauseScreen)screen).showsPauseMenu())) continue;
                if (((BindingState)state).is(ControllerBinding.START) && ((BindingState)state).pressed) {
                    keyMapping.setDown(false);
                    continue;
                }
                if (((BindingState)state).canClick()) {
                    ++keyMapping.clickCount;
                }
                if (((BindingState)state).pressed && ((BindingState)state).canDownKeyMapping(keyMapping)) {
                    keyMapping.setDown(true);
                } else if (((BindingState)state).canReleaseKeyMapping(keyMapping)) {
                    keyMapping.setDown(false);
                }
                if (!((BindingState)state).pressed) continue;
                if (keyMapping == this.minecraft.options.keyTogglePerspective || keyMapping == this.minecraft.options.keyUse) {
                    ((BindingState)state).block();
                    continue;
                }
                if (keyMapping != this.minecraft.options.keyAttack) continue;
                ((BindingState)state).onceClick(-((BindingState)state).getDefaultDelay() * (this.minecraft.player.getAbilities().invulnerable ? 3 : 5));
            }
        }
    }

    public void simulateKeyAction(Predicate<BindingState> canSimulate, int key, BindingState state) {
        boolean clicked;
        boolean bl = clicked = state.pressed && state.canClick();
        if (canSimulate.test(state)) {
            this.simulateKeyAction(key, state, clicked);
        }
    }

    public void simulateKeyAction(int key, BindingState state) {
        this.simulateKeyAction(key, state, state.pressed && state.canClick());
    }

    public void simulateKeyAction(int key, BindingState state, boolean canPress) {
        if (canPress) {
            this.simulateKeyAction(key, true);
        } else if (state.released) {
            this.simulateKeyAction(key, false);
        }
    }

    public void simulateKeyAction(int key, boolean press) {
        this.isControllerSimulatingInput = true;
        this.minecraft.keyboardHandler.keyPress(this.minecraft.getWindow().getWindow(), key, 0, press ? 1 : 0, 0);
        this.isControllerSimulatingInput = false;
    }

    public double getPointerX() {
        return this.minecraft.mouseHandler.xpos() * (double)this.minecraft.getWindow().getGuiScaledWidth() / (double)this.minecraft.getWindow().getScreenWidth();
    }

    public double getPointerY() {
        return this.minecraft.mouseHandler.ypos() * (double)this.minecraft.getWindow().getGuiScaledHeight() / (double)this.minecraft.getWindow().getScreenHeight();
    }

    public <T extends BindingState> T getButtonState(ControllerBinding<T> button) {
        return button.state();
    }

    public boolean allowCursorAtFirstInventorySlot() {
        return this.isControllerTheLastInput() && (Boolean)LegacyOptions.controllerCursorAtFirstInventorySlot.get() != false || !this.isControllerTheLastInput() && (Boolean)LegacyOptions.cursorAtFirstInventorySlot.get() != false;
    }

    public void disableCursor() {
        Controller.Event e;
        Screen screen;
        if (this.getCursorMode().isAlways() || this.minecraft.screen == null || (screen = this.minecraft.screen) instanceof Controller.Event && !(e = (Controller.Event)screen).disableCursorOnInit()) {
            return;
        }
        this.setCursorInputMode(true);
        this.isCursorDisabled = true;
    }

    public void resetCursor() {
        Object object;
        if (!this.resetCursor || this.isCursorDisabled) {
            return;
        }
        if (this.allowCursorAtFirstInventorySlot() && (object = this.minecraft.screen) instanceof LegacyMenuAccess) {
            LegacyMenuAccess a = (LegacyMenuAccess)object;
            for (Slot slot : a.getMenu().slots) {
                if (slot.getContainerSlot() != 0 || this.minecraft.player != null && slot.container != this.minecraft.player.getInventory()) continue;
                a.movePointerToSlot(slot);
                break;
            }
        }
        this.resetCursor = false;
    }

    public void enableCursorAndScheduleReset() {
        this.enableCursor();
        this.resetCursor = true;
    }

    public void enableCursor() {
        this.isCursorDisabled = false;
        this.updateCursorInputMode();
    }

    public void toggleCursor() {
        this.setCursorMode(LegacyOptions.CursorMode.values()[Stocker.cyclic((int)0, (int)(this.getCursorMode().ordinal() + 1), (int)LegacyOptions.CursorMode.values().length)]);
        this.updateCursorMode();
    }

    public void updateCursorMode() {
        switch (this.getCursorMode()) {
            case ALWAYS: {
                this.enableCursor();
                break;
            }
            case NEVER: {
                this.disableCursor();
                if (this.minecraft.screen == null) break;
                this.minecraft.screen.repositionElements();
            }
        }
    }

    public LegacyOptions.CursorMode getCursorMode() {
        return (LegacyOptions.CursorMode)((Object)LegacyOptions.cursorMode.get());
    }

    public void setCursorMode(LegacyOptions.CursorMode cursorMode) {
        LegacyOptions.cursorMode.set((Object)cursorMode);
        LegacyOptions.cursorMode.save();
    }

    public boolean isControllerTheLastInput() {
        return this.isControllerTheLastInput;
    }

    public void setCursorInputMode(boolean hidden) {
        GLFW.glfwSetInputMode((long)Minecraft.getInstance().getWindow().getWindow(), (int)208897, (int)(hidden ? 212994 : 212993));
    }

    public void updateCursorInputMode() {
        if (!this.minecraft.mouseHandler.isMouseGrabbed()) {
            this.setCursorInputMode(!LegacyOptions.hasSystemCursor());
        }
    }

    public void setControllerTheLastInput(boolean controllerTheLastInput) {
        if (this.isControllerTheLastInput != controllerTheLastInput) {
            this.isControllerTheLastInput = controllerTheLastInput;
            this.updateCursorInputMode();
        }
    }

    static interface Setup
    extends Consumer<ControllerManager> {
        public static final FactoryEvent<Setup> EVENT = new FactoryEvent(e -> m -> e.invokeAll(l -> l.accept(m)));
    }
}

