/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ThrownTridentRenderer;
import net.minecraft.client.renderer.entity.state.ThrownTridentRenderState;
import net.minecraft.world.entity.projectile.ThrownTrident;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LoyaltyLinesRenderState;

@Mixin(value={ThrownTridentRenderer.class})
public abstract class ThrownTridentRendererMixin
extends EntityRenderer<ThrownTrident, ThrownTridentRenderState> {
    protected ThrownTridentRendererMixin(EntityRendererProvider.Context context) {
        super(context);
    }

    @Inject(method={"render(Lnet/minecraft/client/renderer/entity/state/ThrownTridentRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="RETURN")})
    public void render(ThrownTridentRenderState renderState, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, CallbackInfo ci) {
        if (((Boolean)LegacyOptions.loyaltyLines.get()).booleanValue()) {
            this.renderLoyaltyLines(LoyaltyLinesRenderState.of(renderState), poseStack, multiBufferSource, 240);
        }
    }

    @Unique
    private void renderLoyaltyLines(LoyaltyLinesRenderState renderState, PoseStack poseStack, MultiBufferSource multiBufferSource, int light) {
        if (renderState.canRender) {
            Matrix4f matrix4f = poseStack.last().pose();
            double d1 = Math.cos(renderState.horizontalMovementFactor);
            double d2 = Math.sin(renderState.horizontalMovementFactor);
            double d6 = d1 - d2;
            double d7 = d2 + d1;
            double d14 = Math.sqrt(renderState.x * renderState.x + renderState.y * renderState.y + renderState.z * renderState.z);
            double d15 = (double)renderState.uniqueAge * -0.1;
            double d16 = Math.min(0.5, d14 / 30.0);
            int k = 7 - (int)renderState.uniqueAge % 7;
            this.renderLoyalityLine(renderState, matrix4f, multiBufferSource.getBuffer(RenderType.leash()), k, d6, d7, d15, d16, 0.02, light);
            this.renderLoyalityLine(renderState, matrix4f, multiBufferSource.getBuffer(RenderType.leash()), k, d6, d7, d15, d16, 0.01, light);
        }
    }

    @Unique
    private void renderLoyalityLine(LoyaltyLinesRenderState renderState, Matrix4f matrix4f, VertexConsumer consumer, int k, double d6, double d7, double d15, double d16, double lineYD, int light) {
        for (int l = 0; l <= 37; ++l) {
            float d18 = (float)l / 37.0f;
            float f = 1.0f - (float)((l + k) % 7) / 7.0f;
            double d19 = (double)d18 * 2.0 - 1.0;
            d19 = (float)((1.0 - d19 * d19) * d16);
            double d20 = renderState.x * (double)d18 + Math.sin((double)d18 * Math.PI * 8.0 + d15) * d6 * d19;
            double d21 = renderState.y * (double)d18 + Math.cos((double)d18 * Math.PI * 8.0 + d15) * lineYD + (0.1 + d19);
            double d22 = renderState.z * (double)d18 + Math.sin((double)d18 * Math.PI * 8.0 + d15) * d7 * d19;
            float f1 = 0.2f * f + 0.34f;
            float f2 = 0.07f * f + 0.18f;
            float f3 = 0.14f * f + 0.52f;
            consumer.addVertex(matrix4f, (float)d20, (float)d21, (float)d22).setColor(f1, f2, f3, 1.0f).setLight(light);
            consumer.addVertex(matrix4f, (float)(d20 + (double)0.1f * d19), (float)(d21 + (double)0.1f * d19), (float)d22).setColor(f1, f2, f3, 1.0f).setLight(light);
            if (l > renderState.clientSideReturnTridentTickCount * 2) break;
        }
    }
}

