/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.book;

import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.legacy.client.ControlType;
import wily.legacy.client.controller.BindingState;
import wily.legacy.client.controller.Controller;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.BookPanel;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.util.LegacyComponents;

@Mixin(value={BookViewScreen.class})
public abstract class BookViewScreenMixin
extends Screen
implements Controller.Event,
ControlTooltip.Event {
    @Shadow
    private PageButton forwardButton;
    @Shadow
    private PageButton backButton;
    @Shadow
    private Component pageMsg;
    @Shadow
    private int currentPage;
    @Shadow
    private int cachedPage;
    @Shadow
    private List<FormattedCharSequence> cachedPageComponents;
    @Shadow
    private BookViewScreen.BookAccess bookAccess;
    @Unique
    private BookPanel panel = new BookPanel(this);

    @Shadow
    protected abstract void updateButtonVisibility();

    @Shadow
    protected abstract void pageBack();

    @Shadow
    protected abstract void pageForward();

    @Shadow
    protected abstract int getNumPages();

    @Shadow
    @Nullable
    public abstract Style getClickedComponentStyleAt(double var1, double var3);

    public void added() {
        super.added();
        ControlTooltip.Renderer.of(this).add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(263) : ControllerBinding.LEFT_BUMPER.getIcon(), () -> this.currentPage != 0 ? LegacyComponents.PREVIOUS_PAGE : null).add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(262) : ControllerBinding.RIGHT_BUMPER.getIcon(), () -> this.currentPage < this.getNumPages() - 1 ? LegacyComponents.NEXT_PAGE : null);
    }

    protected BookViewScreenMixin(Component component) {
        super(component);
    }

    @Inject(method={"init"}, at={@At(value="HEAD")}, cancellable=true)
    public void init(CallbackInfo ci) {
        ci.cancel();
        this.panel.init();
        this.addRenderableWidget(this.panel);
        this.forwardButton = (PageButton)this.addRenderableWidget((GuiEventListener)this.panel.createLegacyPageButton(this.panel.x + this.panel.width - 62, this.panel.y + this.panel.height - 34, true, button -> this.pageForward(), true));
        this.backButton = (PageButton)this.addRenderableWidget((GuiEventListener)this.panel.createLegacyPageButton(this.panel.x + 26, this.panel.y + this.panel.height - 34, false, button -> this.pageBack(), true));
        this.setFocused(this.panel);
        this.updateButtonVisibility();
    }

    @Inject(method={"renderBackground"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderBackground(CallbackInfo ci) {
        ci.cancel();
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    public void render(GuiGraphics guiGraphics, int i, int j, float f, CallbackInfo ci) {
        ci.cancel();
        super.render(guiGraphics, i, j, f);
        if (this.cachedPage != this.currentPage) {
            FormattedText formattedText = this.bookAccess.getPage(this.currentPage);
            this.cachedPageComponents = this.font.split(formattedText, 159);
            this.pageMsg = Component.translatable((String)"book.pageIndicator", (Object[])new Object[]{this.currentPage + 1, Math.max(this.getNumPages(), 1)});
        }
        this.cachedPage = this.currentPage;
        guiGraphics.drawString(this.font, this.pageMsg, this.panel.x + this.panel.width - 24 - this.font.width((FormattedText)this.pageMsg), this.panel.y + 22, 0, false);
        Objects.requireNonNull(this.font);
        int n = Math.min(176 / 9, this.cachedPageComponents.size());
        for (int o = 0; o < n; ++o) {
            FormattedCharSequence formattedCharSequence = this.cachedPageComponents.get(o);
            int n2 = this.panel.x + 20;
            int n3 = this.panel.y + 37;
            Objects.requireNonNull(this.font);
            guiGraphics.drawString(this.font, formattedCharSequence, n2, n3 + o * 9, 0, false);
        }
        Style style = this.getClickedComponentStyleAt(i, j);
        if (style != null) {
            guiGraphics.renderComponentHoverEffect(this.font, style, i, j);
        }
    }

    @Override
    public void bindingStateTick(BindingState state) {
        if ((state.is(ControllerBinding.RIGHT_BUMPER) || state.is(ControllerBinding.LEFT_BUMPER)) && state.canClick()) {
            (state.is(ControllerBinding.RIGHT_BUMPER) ? this.forwardButton : this.backButton).keyPressed(257, 0, 0);
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    public void keyPressed(int i, int j, int k, CallbackInfoReturnable<Boolean> cir) {
        if (ControlType.getActiveType().isKbm() && (i == 262 || i == 263)) {
            (i == 262 ? this.forwardButton : this.backButton).keyPressed(257, 0, 0);
            cir.setReturnValue((Object)true);
            return;
        }
        cir.setReturnValue((Object)super.keyPressed(i, j, k));
    }

    @Inject(method={"getClickedComponentStyleAt"}, at={@At(value="HEAD")}, cancellable=true)
    public void getClickedComponentStyleAt(double d, double e, CallbackInfoReturnable<Style> cir) {
        if (this.cachedPageComponents.isEmpty()) {
            cir.setReturnValue(null);
            return;
        }
        int i = (int)Math.floor(d - (double)this.panel.x - 20.0);
        int j = (int)Math.floor(e - (double)this.panel.y - 37.0);
        if (i < 0 || j < 0) {
            cir.setReturnValue(null);
            return;
        }
        Objects.requireNonNull(this.font);
        int k = Math.min(176 / 9, this.cachedPageComponents.size());
        if (i <= 159) {
            Objects.requireNonNull(this.minecraft.font);
            if (j < 9 * k + k) {
                Objects.requireNonNull(this.minecraft.font);
                int l = j / 9;
                if (l < this.cachedPageComponents.size()) {
                    FormattedCharSequence formattedCharSequence = this.cachedPageComponents.get(l);
                    cir.setReturnValue((Object)this.minecraft.font.getSplitter().componentStyleAtWidth(formattedCharSequence, i));
                    return;
                }
            }
        }
        cir.setReturnValue(null);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

