/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.cartography;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CartographyTableScreen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundRenameItemPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CartographyTableMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.util.FactoryItemUtil;
import wily.legacy.client.CommonColor;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.inventory.RenameItemMenu;
import wily.legacy.util.LegacySprites;

@Mixin(value={CartographyTableScreen.class})
public abstract class CartographyTableScreenMixin
extends AbstractContainerScreen<CartographyTableMenu> {
    private static final Component MAP_NAME = Component.translatable((String)"legacy.container.mapName");
    private static final Component RENAME_MAP = Component.translatable((String)"legacy.container.renameMap");
    private static final Component ZOOM = Component.translatable((String)"legacy.container.zoomMap");
    private static final Component COPY = Component.translatable((String)"legacy.container.copyMap");
    private static final Component LOCK = Component.translatable((String)"legacy.container.lockMap");
    private EditBox name;
    private final ContainerListener listener = new ContainerListener(){

        public void slotChanged(AbstractContainerMenu abstractContainerMenu, int i, ItemStack itemStack) {
            if (i == 0) {
                CartographyTableScreenMixin.this.name.setValue(itemStack.isEmpty() ? "" : itemStack.getHoverName().getString());
                CartographyTableScreenMixin.this.name.setEditable(!itemStack.isEmpty());
            }
        }

        public void dataChanged(AbstractContainerMenu abstractContainerMenu, int i, int j) {
        }
    };

    public CartographyTableScreenMixin(CartographyTableMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
    }

    public void init() {
        this.imageWidth = 207;
        this.imageHeight = 254;
        this.inventoryLabelX = 10;
        this.inventoryLabelY = 144;
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.getTitle())) / 2;
        this.titleLabelY = 10;
        super.init();
        for (int i = 0; i < ((CartographyTableMenu)this.menu).slots.size(); ++i) {
            Slot s2 = (Slot)((CartographyTableMenu)this.menu).slots.get(i);
            if (i == 0) {
                LegacySlotDisplay.override(s2, 10, 62, new LegacySlotDisplay(this){

                    @Override
                    public int getWidth() {
                        return 23;
                    }
                });
                continue;
            }
            if (i == 1) {
                LegacySlotDisplay.override(s2, 10, 105, new LegacySlotDisplay(this){

                    @Override
                    public int getWidth() {
                        return 23;
                    }
                });
                continue;
            }
            if (i == 2) {
                LegacySlotDisplay.override(s2, 166, 82, new LegacySlotDisplay(this){

                    @Override
                    public int getWidth() {
                        return 27;
                    }
                });
                continue;
            }
            if (i < ((CartographyTableMenu)this.menu).slots.size() - 9) {
                LegacySlotDisplay.override(s2, 10 + (s2.getContainerSlot() - 9) % 9 * 21, 156 + (s2.getContainerSlot() - 9) / 9 * 21);
                continue;
            }
            LegacySlotDisplay.override(s2, 10 + s2.getContainerSlot() * 21, 225);
        }
        ((CartographyTableMenu)this.menu).addSlotListener(this.listener);
        this.name = new EditBox(this.font, this.leftPos + 10, this.topPos + 38, 120, 18, (Component)Component.empty());
        this.name.setCanLoseFocus(false);
        this.name.setTextColor(-1);
        this.name.setTextColorUneditable(-1);
        this.name.setMaxLength(50);
        this.name.setResponder(s -> {
            Slot slot = ((CartographyTableMenu)this.menu).getSlot(0);
            if (!slot.hasItem()) {
                return;
            }
            if (!FactoryItemUtil.hasCustomName((ItemStack)slot.getItem()) && s.equals(slot.getItem().getHoverName().getString())) {
                s = "";
            }
            ((RenameItemMenu)this.menu).setResultItemName((String)s);
            this.minecraft.player.connection.send((Packet)new ServerboundRenameItemPacket(s));
        });
        this.name.setValue("");
        this.addWidget((GuiEventListener)this.name);
        this.name.setEditable(((CartographyTableMenu)this.menu).getSlot(0).hasItem());
    }

    public Component getCartographyAction() {
        ItemStack input = ((CartographyTableMenu)this.menu).getSlot(0).getItem();
        ItemStack input2 = ((CartographyTableMenu)this.menu).getSlot(1).getItem();
        if (input.is(Items.FILLED_MAP)) {
            if (input2.is(Items.PAPER)) {
                return ZOOM;
            }
            if (input2.is(Items.MAP)) {
                return COPY;
            }
            if (input2.is(Items.GLASS_PANE)) {
                return LOCK;
            }
            return RENAME_MAP;
        }
        return null;
    }

    public boolean keyPressed(int i, int j, int k) {
        if (i != 256 && (this.name.keyPressed(i, j, k) || this.name.canConsumeInput())) {
            return true;
        }
        return super.keyPressed(i, j, k);
    }

    public void renderLabels(GuiGraphics guiGraphics, int i, int j) {
        super.renderLabels(guiGraphics, i, j);
        guiGraphics.drawString(this.font, MAP_NAME, 10, 27, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        Component cartographyAction = this.getCartographyAction();
        if (cartographyAction != null) {
            guiGraphics.drawString(this.font, cartographyAction, (this.imageWidth - this.font.width((FormattedText)cartographyAction)) / 2, 130, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBg(guiGraphics, f, i, j);
    }

    public void repositionElements() {
        String string = this.name.getValue();
        super.repositionElements();
        this.name.setValue(string);
    }

    @Inject(method={"renderBg"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderBg(GuiGraphics guiGraphics, float f, int i, int j, CallbackInfo ci) {
        ci.cancel();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite((ResourceLocation)UIAccessor.of((Screen)this).getElementValue("imageSprite", (Object)LegacySprites.SMALL_PANEL, ResourceLocation.class), this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        this.name.render(guiGraphics, i, j, f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.COMBINER_PLUS, this.leftPos + 14, this.topPos + 88, 13, 13);
        ItemStack input2 = ((CartographyTableMenu)this.menu).getSlot(1).getItem();
        boolean bl = input2.is(Items.MAP);
        boolean bl2 = input2.is(Items.PAPER);
        boolean bl3 = input2.is(Items.GLASS_PANE);
        ItemStack input = ((CartographyTableMenu)this.menu).getSlot(0).getItem();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.ARROW, this.leftPos + 36, this.topPos + 87, 22, 15);
        if (input.is(Items.FILLED_MAP)) {
            MapItemSavedData mapItemSavedData = MapItem.getSavedData((MapId)((MapId)input.get(DataComponents.MAP_ID)), (Level)this.minecraft.level);
            if (mapItemSavedData != null && (mapItemSavedData.locked && (bl2 || bl3) || bl2 && mapItemSavedData.scale >= 4)) {
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.ERROR_CROSS, this.leftPos + 40, this.topPos + 87, 15, 15);
            }
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(bl ? LegacySprites.CARTOGRAPHY_TABLE_COPY : (bl2 ? LegacySprites.CARTOGRAPHY_TABLE_ZOOM : (bl3 ? LegacySprites.CARTOGRAPHY_TABLE_LOCKED : LegacySprites.CARTOGRAPHY_TABLE_MAP)), this.leftPos + 70, this.topPos + 61, 66, 66);
        } else {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.CARTOGRAPHY_TABLE, this.leftPos + 70, this.topPos + 61, 66, 66);
        }
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.ARROW, this.leftPos + 139, this.topPos + 87, 22, 15);
    }
}

