/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.container;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.client.gui.screens.inventory.DispenserScreen;
import net.minecraft.client.gui.screens.inventory.HopperScreen;
import net.minecraft.client.gui.screens.inventory.ShulkerBoxScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.DispenserMenu;
import net.minecraft.world.inventory.HopperMenu;
import net.minecraft.world.inventory.Slot;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.util.LegacySprites;

@Mixin(value={ContainerScreen.class, ShulkerBoxScreen.class, HopperScreen.class, DispenserScreen.class})
public abstract class ContainerScreenMixin
extends AbstractContainerScreen {
    public ContainerScreenMixin(AbstractContainerMenu abstractContainerMenu, Inventory inventory, Component component) {
        super(abstractContainerMenu, inventory, component);
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBg(guiGraphics, f, i, j);
    }

    public void init() {
        int rows;
        AbstractContainerMenu abstractContainerMenu = this.menu;
        if (abstractContainerMenu instanceof ChestMenu) {
            ChestMenu m = (ChestMenu)abstractContainerMenu;
            v0 = m.getRowCount();
        } else {
            v0 = rows = this.menu instanceof HopperMenu ? 1 : 3;
        }
        int columns = this.menu instanceof HopperMenu ? 5 : (this.menu instanceof DispenserMenu ? 3 : 9);
        int yDiff = (rows - 3) * 21;
        boolean centeredTitle = this.menu instanceof HopperMenu || this.menu instanceof DispenserMenu;
        this.imageWidth = 215;
        this.imageHeight = 207 + yDiff;
        this.titleLabelX = centeredTitle ? (this.imageWidth - this.font.width((FormattedText)this.title)) / 2 : 14;
        this.titleLabelY = 11;
        this.inventoryLabelX = 14;
        this.inventoryLabelY = 94 + yDiff;
        int slotsAmount = rows * columns;
        for (int i = 0; i < this.menu.slots.size(); ++i) {
            Slot s = (Slot)this.menu.slots.get(i);
            if (i < slotsAmount) {
                LegacySlotDisplay.override(s, (this.imageWidth - columns * 21) / 2 + s.getContainerSlot() % columns * 21, 26 + s.getContainerSlot() / columns * 21);
                continue;
            }
            if (i < this.menu.slots.size() - 9) {
                LegacySlotDisplay.override(s, 14 + (s.getContainerSlot() - 9) % 9 * 21, 107 + (s.getContainerSlot() - 9) / 9 * 21 + yDiff);
                continue;
            }
            LegacySlotDisplay.override(s, 14 + s.getContainerSlot() * 21, 177 + yDiff);
        }
        super.init();
    }

    @Inject(method={"renderBg"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderBg(GuiGraphics guiGraphics, float f, int i, int j, CallbackInfo ci) {
        ci.cancel();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite((ResourceLocation)UIAccessor.of((Screen)this).getElementValue("imageSprite", (Object)LegacySprites.SMALL_PANEL, ResourceLocation.class), this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
    }
}

