/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.inventory;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.screen.CreativeModeScreen;
import wily.legacy.client.screen.LegacyMenuAccess;
import wily.legacy.client.screen.ReplaceableScreen;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

@Mixin(value={InventoryScreen.class})
public abstract class InventoryScreenMixin
extends AbstractContainerScreen<InventoryMenu>
implements ReplaceableScreen,
LegacyMenuAccess<InventoryMenu> {
    private static final Vec3 EQUIP_SLOT_OFFSET = new Vec3(50.0, 0.0, 0.0);
    private static final ResourceLocation[] EQUIPMENT_SLOT_SPRITES = new ResourceLocation[]{LegacySprites.HEAD_SLOT, LegacySprites.CHEST_SLOT, LegacySprites.LEGS_SLOT, LegacySprites.FEET_SLOT};
    private boolean canReplace = true;

    public InventoryScreenMixin(InventoryMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
    }

    @ModifyExpressionValue(method={"containerTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;hasInfiniteItems()Z")})
    public boolean containerTick(boolean original) {
        return false;
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBg(guiGraphics, f, i, j);
    }

    @Inject(method={"init"}, at={@At(value="HEAD")}, cancellable=true)
    public void init(CallbackInfo ci) {
        ci.cancel();
        this.imageWidth = 215;
        this.imageHeight = 217;
        this.inventoryLabelX = 14;
        this.inventoryLabelY = 103;
        super.init();
        for (int i = 0; i < ((InventoryMenu)this.menu).slots.size(); ++i) {
            final Slot s = (Slot)((InventoryMenu)this.menu).slots.get(i);
            if (i == 0) {
                LegacySlotDisplay.override(s, 180, 40, new LegacySlotDisplay(this){

                    @Override
                    public boolean isVisible() {
                        return ScreenUtil.hasClassicCrafting();
                    }
                });
                continue;
            }
            if (i < 5) {
                LegacySlotDisplay.override(s, 111 + s.getContainerSlot() % 2 * 21, 30 + s.getContainerSlot() / 2 * 21, new LegacySlotDisplay(this){

                    @Override
                    public boolean isVisible() {
                        return ScreenUtil.hasClassicCrafting();
                    }
                });
                continue;
            }
            if (i < 9) {
                final int index = 39 - s.getContainerSlot();
                LegacySlotDisplay.override(s, 14, 14 + index * 21, new LegacySlotDisplay(){

                    @Override
                    public ResourceLocation getIconSprite() {
                        return s.getItem().isEmpty() ? EQUIPMENT_SLOT_SPRITES[index] : null;
                    }

                    @Override
                    public Vec3 getOffset() {
                        return ScreenUtil.hasClassicCrafting() ? Vec3.ZERO : EQUIP_SLOT_OFFSET;
                    }
                });
                continue;
            }
            if (i < ((InventoryMenu)this.menu).slots.size() - 10) {
                LegacySlotDisplay.override(s, 14 + (s.getContainerSlot() - 9) % 9 * 21, 116 + (s.getContainerSlot() - 9) / 9 * 21);
                continue;
            }
            if (i < ((InventoryMenu)this.menu).slots.size() - 1) {
                LegacySlotDisplay.override(s, 14 + s.getContainerSlot() * 21, 186);
                continue;
            }
            LegacySlotDisplay.override(s, 111, 77, new LegacySlotDisplay(){

                @Override
                public Vec3 getOffset() {
                    return ScreenUtil.hasClassicCrafting() ? Vec3.ZERO : EQUIP_SLOT_OFFSET;
                }

                @Override
                public ResourceLocation getIconSprite() {
                    return s.getItem().isEmpty() ? LegacySprites.SHIELD_SLOT : null;
                }
            });
        }
    }

    @Inject(method={"getRecipeBookButtonPosition"}, at={@At(value="HEAD")}, cancellable=true)
    protected void getRecipeBookButtonPosition(CallbackInfoReturnable<ScreenPosition> cir) {
        cir.setReturnValue((Object)new ScreenPosition(this.leftPos + 180, this.topPos + 71));
    }

    @Inject(method={"renderBg"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderBg(GuiGraphics graphics, float f, int i, int j, CallbackInfo ci) {
        ci.cancel();
        FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(LegacySprites.SMALL_PANEL, this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(LegacySprites.ENTITY_PANEL, this.leftPos + 40 + (ScreenUtil.hasClassicCrafting() ? 0 : 50), this.topPos + 13, 63, 84);
        Pose pose = this.minecraft.player.getPose();
        this.minecraft.player.setPose(Pose.STANDING);
        ScreenUtil.renderEntityInInventoryFollowsMouse(graphics, this.leftPos + 40 + (ScreenUtil.hasClassicCrafting() ? 0 : 50), this.topPos + 13, this.leftPos + 103 + (ScreenUtil.hasClassicCrafting() ? 0 : 50), this.topPos + 97, 35, 0.0625f, i, j, (LivingEntity)this.minecraft.player);
        this.minecraft.player.setPose(pose);
        if (ScreenUtil.hasClassicCrafting()) {
            graphics.drawString(this.font, this.title, this.leftPos + 111, this.topPos + 16, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
            FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(LegacySprites.SMALL_ARROW, this.leftPos + 158, this.topPos + 43, 16, 13);
        }
    }

    @Inject(method={"renderLabels"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderLabels(GuiGraphics guiGraphics, int i, int j, CallbackInfo ci) {
        ci.cancel();
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
    }

    @Override
    public boolean canReplace() {
        return Legacy4JClient.playerHasInfiniteMaterials() && this.canReplace;
    }

    @Override
    public void setCanReplace(boolean canReplace) {
        this.canReplace = canReplace;
    }

    @Override
    public Screen getReplacement() {
        return CreativeModeScreen.getActualCreativeScreenInstance(this.minecraft);
    }

    @Override
    public int getTipXDiff() {
        return -186;
    }

    @Override
    public boolean allowItemPopping() {
        return true;
    }
}

