/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy;

import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.FactoryEvent;
import wily.factoryapi.base.config.FactoryConfig;
import wily.factoryapi.base.config.FactoryMixinToggle;
import wily.factoryapi.base.network.CommonNetwork;
import wily.factoryapi.util.ColorUtil;
import wily.legacy.Legacy4JClient;
import wily.legacy.block.entity.WaterCauldronBlockEntity;
import wily.legacy.config.LegacyCommonOptions;
import wily.legacy.config.LegacyMixinToggles;
import wily.legacy.config.LegacyWorldOptions;
import wily.legacy.entity.LegacyPlayerInfo;
import wily.legacy.init.LegacyGameRules;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.network.ClientAdvancementsPayload;
import wily.legacy.network.ClientAnimalInLoveSyncPayload;
import wily.legacy.network.ClientEffectActivationPayload;
import wily.legacy.network.ClientMerchantTradingPayload;
import wily.legacy.network.PlayerInfoSync;
import wily.legacy.network.ServerMenuCraftPayload;
import wily.legacy.network.ServerOpenClientMenuPayload;
import wily.legacy.network.ServerPlayerMissHitPayload;
import wily.legacy.network.TipCommand;
import wily.legacy.network.TopMessage;
import wily.legacy.util.ArmorStandPose;
import wily.legacy.util.ItemAccessor;

@Mod(value="legacy")
public class Legacy4J {
    public static final String MOD_ID = "legacy";
    public static final Supplier<String> VERSION = () -> FactoryAPIPlatform.getModInfo((String)MOD_ID).getVersion();
    public static final Logger LOGGER = LogManager.getLogger((String)"legacy");
    public static final FactoryConfig.StorageHandler MIXIN_CONFIGS_STORAGE = FactoryConfig.StorageHandler.fromMixin((FactoryMixinToggle.Storage)LegacyMixinToggles.COMMON_STORAGE, (boolean)true);
    private static Collection<CommonNetwork.Payload> playerInitialPayloads = Collections.emptySet();

    public Legacy4J() {
        Legacy4J.init();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            Legacy4JClient.init();
        }
    }

    public static List<Integer> getParsedVersion(String version) {
        String[] versions;
        ArrayList<Integer> parsedVersion = new ArrayList<Integer>();
        for (String s : versions = version.split("[.\\-]")) {
            int value;
            try {
                value = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                value = 0;
            }
            parsedVersion.add(value);
        }
        return parsedVersion;
    }

    public static boolean isNewerVersion(String actualVersion, String previous) {
        return Legacy4J.isNewerVersion(actualVersion, previous, 2);
    }

    public static boolean isNewerVersion(String actualVersion, String previous, int limitCount) {
        List<Integer> v = Legacy4J.getParsedVersion(actualVersion);
        List<Integer> v1 = Legacy4J.getParsedVersion(previous);
        int size = limitCount <= 0 ? v.size() : Math.min(limitCount, v.size());
        for (int i = 0; i < size; ++i) {
            if (v.get(i) <= (v1.size() <= i ? 0 : v1.get(i))) continue;
            return true;
        }
        return false;
    }

    public static void init() {
        FactoryConfig.registerCommonStorage((ResourceLocation)Legacy4J.createModLocation("common"), (FactoryConfig.StorageHandler)LegacyCommonOptions.COMMON_STORAGE);
        FactoryConfig.registerCommonStorage((ResourceLocation)Legacy4J.createModLocation("mixin_common"), (FactoryConfig.StorageHandler)MIXIN_CONFIGS_STORAGE);
        LegacyRegistries.register();
        LegacyGameRules.init();
        FactoryEvent.registerPayload(r -> {
            r.register(false, ClientAdvancementsPayload.ID);
            r.register(false, ClientAnimalInLoveSyncPayload.ID);
            r.register(false, ClientEffectActivationPayload.ID);
            r.register(true, ClientMerchantTradingPayload.ID_C2S);
            r.register(false, ClientMerchantTradingPayload.ID_S2C);
            r.register(true, PlayerInfoSync.ID);
            r.register(true, PlayerInfoSync.All.ID_C2S);
            r.register(false, PlayerInfoSync.All.ID_S2C);
            r.register(true, ServerMenuCraftPayload.ID);
            r.register(true, ServerOpenClientMenuPayload.ID);
            r.register(true, ServerPlayerMissHitPayload.ID);
            r.register(false, TipCommand.Payload.ID);
            r.register(false, TipCommand.EntityPayload.ID);
            r.register(false, TopMessage.Payload.ID);
        });
        ArmorStandPose.init();
        ItemAccessor.of(Items.CAKE).setMaxStackSize(64);
        ItemAccessor.of(Items.MUSIC_DISC_CAT).setRecordLengthInTicks(330);
        FactoryEvent.registerCommands((dispatcher, context, selection) -> TipCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher, context, selection));
        FactoryEvent.setup(Legacy4J::setup);
        FactoryEvent.tagsLoaded(Legacy4J::tagsLoaded);
        FactoryEvent.serverStarted(Legacy4J::onServerStart);
        FactoryEvent.PlayerEvent.JOIN_EVENT.register(Legacy4J::onServerPlayerJoin);
        FactoryEvent.PlayerEvent.RELOAD_RESOURCES_EVENT.register(Legacy4J::onResourcesReload);
    }

    public static ResourceLocation createModLocation(String path) {
        return FactoryAPI.createLocation((String)MOD_ID, (String)path);
    }

    public static InteractionResult defaultPassInteraction() {
        return InteractionResult.PASS;
    }

    public static InteractionResult successInteraction() {
        return InteractionResult.SUCCESS;
    }

    public static InteractionResult consumeInteraction() {
        return InteractionResult.CONSUME;
    }

    public static void setup() {
        LegacyCommonOptions.COMMON_STORAGE.load();
        if (!((Boolean)LegacyMixinToggles.legacyCauldrons.get()).booleanValue()) {
            return;
        }
        Map emptyCauldron = CauldronInteraction.EMPTY.map();
        Map waterCauldron = CauldronInteraction.WATER.map();
        CauldronInteraction emptyCauldronPotion = (blockState, level, blockPos, player, interactionHand, itemStack) -> {
            Holder p = BuiltInRegistries.POTION.wrapAsHolder((Object)PotionUtils.getPotion((ItemStack)itemStack));
            if (p.value() == Potions.EMPTY) {
                return Legacy4J.defaultPassInteraction();
            }
            level.setBlockAndUpdate(blockPos, Blocks.WATER_CAULDRON.defaultBlockState());
            level.getBlockEntity(blockPos, (BlockEntityType)LegacyRegistries.WATER_CAULDRON_BLOCK_ENTITY.get()).ifPresent(be -> {
                be.potion = p;
                be.lastPotionItemUsed = itemStack.getItemHolder();
                be.setChanged();
            });
            if (!level.isClientSide) {
                Item item = itemStack.getItem();
                player.setItemInHand(interactionHand, ItemUtils.createFilledResult((ItemStack)itemStack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.GLASS_BOTTLE)));
                player.awardStat(Stats.USE_CAULDRON);
                player.awardStat(Stats.ITEM_USED.get((Object)item));
                level.playSound(null, blockPos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.gameEvent(null, GameEvent.FLUID_PLACE, blockPos);
                return Legacy4J.consumeInteraction();
            }
            return Legacy4J.successInteraction();
        };
        emptyCauldron.put(Items.POTION, emptyCauldronPotion);
        emptyCauldron.put(Items.SPLASH_POTION, emptyCauldronPotion);
        emptyCauldron.put(Items.LINGERING_POTION, emptyCauldronPotion);
        waterCauldron.put(Items.GLASS_BOTTLE, (blockState, level, blockPos, player, interactionHand, itemStack) -> {
            Optional opt = level.getBlockEntity(blockPos, (BlockEntityType)LegacyRegistries.WATER_CAULDRON_BLOCK_ENTITY.get());
            if (opt.isEmpty() || opt.map(be -> be.waterColor).orElse(null) != null) {
                return Legacy4J.defaultPassInteraction();
            }
            if (!level.isClientSide) {
                Item item = itemStack.getItem();
                player.setItemInHand(interactionHand, ItemUtils.createFilledResult((ItemStack)itemStack, (Player)player, (ItemStack)Legacy4J.setItemStackPotion(new ItemStack(((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).lastPotionItemUsed), ((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).potion)));
                player.awardStat(Stats.USE_CAULDRON);
                player.awardStat(Stats.ITEM_USED.get((Object)item));
                LayeredCauldronBlock.lowerFillLevel((BlockState)blockState, (Level)level, (BlockPos)blockPos);
                level.playSound(null, blockPos, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.gameEvent(null, GameEvent.FLUID_PICKUP, blockPos);
                return Legacy4J.consumeInteraction();
            }
            return Legacy4J.successInteraction();
        });
        CauldronInteraction waterCauldronPotion = (blockState, level, blockPos, player, interactionHand, itemStack) -> {
            Optional opt = level.getBlockEntity(blockPos, (BlockEntityType)LegacyRegistries.WATER_CAULDRON_BLOCK_ENTITY.get());
            Holder p = BuiltInRegistries.POTION.wrapAsHolder((Object)PotionUtils.getPotion((ItemStack)itemStack));
            if (p.value() == Potions.EMPTY || (Integer)blockState.getValue((Property)LayeredCauldronBlock.LEVEL) == 3 && (opt.isEmpty() || ((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).potion.equals((Object)p))) {
                return Legacy4J.defaultPassInteraction();
            }
            if (opt.isPresent() && !((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).potion.equals((Object)p)) {
                level.setBlockAndUpdate(blockPos, Blocks.CAULDRON.defaultBlockState());
                if (!((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).potion.equals((Object)p)) {
                    level.playSound(null, blockPos, SoundEvents.GENERIC_EXPLODE, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            } else {
                if (opt.isEmpty() || ((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).waterColor == null) {
                    level.setBlockAndUpdate(blockPos, (BlockState)blockState.cycle((Property)LayeredCauldronBlock.LEVEL));
                } else {
                    ((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).waterColor = null;
                    level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(1)));
                    ((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).setChanged();
                }
                ((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).lastPotionItemUsed = itemStack.getItemHolder();
                level.playSound(null, blockPos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (!level.isClientSide) {
                player.setItemInHand(interactionHand, ItemUtils.createFilledResult((ItemStack)itemStack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.GLASS_BOTTLE)));
                player.awardStat(Stats.USE_CAULDRON);
                player.awardStat(Stats.ITEM_USED.get((Object)itemStack.getItem()));
                level.gameEvent(null, GameEvent.FLUID_PLACE, blockPos);
                return Legacy4J.consumeInteraction();
            }
            return Legacy4J.successInteraction();
        };
        waterCauldron.put(Items.POTION, waterCauldronPotion);
        waterCauldron.put(Items.SPLASH_POTION, waterCauldronPotion);
        waterCauldron.put(Items.LINGERING_POTION, waterCauldronPotion);
        waterCauldron.put(Items.ARROW, (blockState, level, blockPos, player, interactionHand, itemStack) -> {
            WaterCauldronBlockEntity be;
            BlockEntity patt0$temp = level.getBlockEntity(blockPos);
            if (!(patt0$temp instanceof WaterCauldronBlockEntity) || (be = (WaterCauldronBlockEntity)patt0$temp).hasWater()) {
                return Legacy4J.defaultPassInteraction();
            }
            if (!level.isClientSide) {
                int l = (Integer)blockState.getValue((Property)LayeredCauldronBlock.LEVEL);
                int arrowCount = Math.min(itemStack.getCount(), l < 3 ? l * 16 : 64);
                if (!player.getAbilities().instabuild) {
                    itemStack.shrink(arrowCount);
                }
                ItemStack tippedArrow = Legacy4J.setItemStackPotion(new ItemStack((ItemLike)Items.TIPPED_ARROW, arrowCount), be.potion);
                player.getInventory().placeItemBackInInventory(tippedArrow);
                player.awardStat(Stats.USE_CAULDRON);
                player.awardStat(Stats.ITEM_USED.get((Object)itemStack.getItem()));
                int i = (int)Math.min(3.0, Math.ceil((double)arrowCount / 16.0));
                BlockState blockState2 = l - i == 0 ? Blocks.CAULDRON.defaultBlockState() : (BlockState)blockState.setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(i));
                level.setBlockAndUpdate(blockPos, blockState2);
                level.gameEvent(GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of((BlockState)blockState2));
                return Legacy4J.consumeInteraction();
            }
            return Legacy4J.successInteraction();
        });
        for (DyeColor color : DyeColor.values()) {
            waterCauldron.put(DyeItem.byColor((DyeColor)color), (blockState, level, blockPos, player, interactionHand, itemStack) -> {
                Optional opt = level.getBlockEntity(blockPos, (BlockEntityType)LegacyRegistries.WATER_CAULDRON_BLOCK_ENTITY.get());
                if (!(itemStack.getItem() instanceof DyeItem) || opt.isEmpty() || !((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).hasWater()) {
                    return Legacy4J.defaultPassInteraction();
                }
                int dyeColor = Legacy4J.getDyeColor(color);
                ((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).waterColor = ((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).waterColor == null ? Integer.valueOf(dyeColor) : Integer.valueOf(Legacy4J.mixColors(List.of(((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).waterColor, Integer.valueOf(dyeColor)).iterator()));
                ((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).setChanged();
                return level.isClientSide ? Legacy4J.successInteraction() : Legacy4J.consumeInteraction();
            });
        }
        DispenserBlock.registerBehavior((ItemLike)Blocks.TNT, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            protected ItemStack execute(BlockSource blockSource, ItemStack itemStack) {
                this.setSuccess(blockSource.level().getGameRules().getBoolean(LegacyGameRules.TNT_EXPLODES));
                if (this.isSuccess()) {
                    BlockPos blockPos = blockSource.pos().relative((Direction)blockSource.state().getValue((Property)DispenserBlock.FACING));
                    TntBlock.explode((Level)blockSource.level(), (BlockPos)blockPos);
                    blockSource.level().gameEvent(null, GameEvent.ENTITY_PLACE, blockSource.pos());
                    itemStack.shrink(1);
                }
                return itemStack;
            }

            protected void playAnimation(BlockSource blockSource, Direction direction) {
                if (this.isSuccess()) {
                    super.playAnimation(blockSource, direction);
                }
            }
        });
        DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior(){

            public ItemStack execute(BlockSource blockSource, ItemStack itemStack) {
                Direction direction = (Direction)blockSource.state().getValue((Property)DispenserBlock.FACING);
                EntityType entityType = ((SpawnEggItem)itemStack.getItem()).getType(null);
                try {
                    if (entityType.spawn(blockSource.level(), itemStack, null, blockSource.pos().relative(direction), MobSpawnType.DISPENSER, direction != Direction.UP, false) != null) {
                        itemStack.shrink(1);
                        blockSource.level().gameEvent(null, GameEvent.ENTITY_PLACE, blockSource.pos());
                    }
                }
                catch (Exception var6) {
                    LOGGER.error("Error while dispensing spawn egg from dispenser at {}", (Object)blockSource.pos(), (Object)var6);
                    return ItemStack.EMPTY;
                }
                return itemStack;
            }
        };
        for (SpawnEggItem spawnEggItem : SpawnEggItem.eggs()) {
            DispenserBlock.registerBehavior((ItemLike)spawnEggItem, (DispenseItemBehavior)defaultDispenseItemBehavior);
        }
        Legacy4J.registerDyedWaterCauldronInteraction(waterCauldron);
    }

    public static boolean isChunkPosVisibleInSquare(int centerX, int centerZ, int viewDistance, int x, int z, boolean offset) {
        int n = Math.max(0, Math.abs(x - centerX) - 1);
        int o = Math.max(0, Math.abs(z - centerZ) - 1);
        long p = Math.max(0, Math.max(n, o) - (offset ? 1 : 0));
        long q = Math.min(n, o);
        return Math.max(p, q) < (long)viewDistance;
    }

    public static ItemStack setItemStackPotion(ItemStack stack, Holder<Potion> potion) {
        return PotionUtils.setPotion((ItemStack)stack, (Potion)((Potion)potion.value()));
    }

    public static void addPotionTooltip(Holder<Potion> potion, List<Component> tooltipList, float f, float tickRate) {
        PotionUtils.addPotionTooltip((List)((Potion)potion.value()).getEffects(), tooltipList, (float)f, (float)tickRate);
    }

    public static int getDyeColor(DyeColor dyeColor) {
        return ColorUtil.colorFromFloat((float[])dyeColor.getTextureDiffuseColors());
    }

    public static float getItemDamageModifier(ItemStack stack) {
        if (FactoryConfig.hasCommonConfigEnabled(LegacyCommonOptions.legacyCombat)) {
            if (stack.is(ItemTags.SWORDS)) {
                return 1.0f;
            }
            if (stack.getItem() instanceof ShovelItem) {
                return -0.5f;
            }
            if (stack.is(ItemTags.PICKAXES)) {
                return 1.0f;
            }
            if (stack.getItem() instanceof AxeItem) {
                if (stack.is(Items.STONE_AXE)) {
                    return -4.0f;
                }
                if (stack.is(Items.DIAMOND_AXE) || stack.is(Items.NETHERITE_AXE)) {
                    return -2.0f;
                }
                return -3.0f;
            }
        }
        return 0.0f;
    }

    public static void tagsLoaded() {
    }

    public static void registerDyedWaterCauldronInteraction(Map<Item, CauldronInteraction> waterCauldron) {
        if (!((Boolean)LegacyMixinToggles.legacyCauldrons.get()).booleanValue()) {
            return;
        }
        BuiltInRegistries.ITEM.asHolderIdMap().forEach(i -> {
            if (!Legacy4J.isDyeableItem((Holder<Item>)i)) {
                return;
            }
            waterCauldron.put((Item)i.value(), (blockState, level, blockPos, player, interactionHand, itemStack) -> {
                Optional opt = level.getBlockEntity(blockPos, (BlockEntityType)LegacyRegistries.WATER_CAULDRON_BLOCK_ENTITY.get());
                if (opt.isPresent() && !((WaterCauldronBlockEntity)((Object)((Object)((Object)opt.get())))).hasWater() || ((DyeableLeatherItem)itemStack.getItem()).hasCustomColor(itemStack) && (opt.isEmpty() || ((WaterCauldronBlockEntity)((Object)((Object)((Object)opt.get())))).waterColor == null)) {
                    return Legacy4J.defaultPassInteraction();
                }
                if (!level.isClientSide) {
                    player.awardStat(Stats.USE_CAULDRON);
                    player.awardStat(Stats.ITEM_USED.get((Object)itemStack.getItem()));
                    if (opt.isEmpty() || ((WaterCauldronBlockEntity)((Object)((Object)((Object)opt.get())))).waterColor == null) {
                        ((DyeableLeatherItem)itemStack.getItem()).clearColor(itemStack);
                    } else {
                        Legacy4J.dyeItem(itemStack, ((WaterCauldronBlockEntity)((Object)((Object)((Object)opt.get())))).waterColor);
                    }
                    LayeredCauldronBlock.lowerFillLevel((BlockState)blockState, (Level)level, (BlockPos)blockPos);
                }
                return Legacy4J.successInteraction();
            });
        });
    }

    public static Vec3 getRelativeMovement(LivingEntity entity, float f, Vec3 vec3, int relRot) {
        double d = (vec3 = Legacy4J.getNormal(vec3, Math.toRadians(relRot))).lengthSqr();
        if (d < 1.0E-7) {
            return Vec3.ZERO;
        }
        Vec3 vec32 = (d > 1.0 ? vec3.normalize() : vec3).scale((double)f);
        double angle = Math.toRadians(relRot == 0 ? (double)entity.getYRot() : (double)(Math.round(entity.getYRot() / (float)relRot) * relRot));
        double sin = Math.sin(angle);
        double cos = Math.cos(angle);
        return new Vec3(vec32.x * cos - vec32.z * sin, vec32.y, vec32.z * cos + vec32.x * sin);
    }

    public static Vec3 getNormal(Vec3 vec3, double relRot) {
        if (relRot == 0.0) {
            return vec3;
        }
        double angleRad = Math.atan2(vec3.z, vec3.x);
        double quantizedAngle = (double)Math.round(angleRad / relRot) * relRot;
        double length = vec3.length();
        return new Vec3(length * Math.cos(quantizedAngle), vec3.y, length * Math.sin(quantizedAngle));
    }

    public static boolean canRepair(ItemStack repairItem, ItemStack ingredient) {
        return repairItem.is(ingredient.getItem()) && repairItem.getCount() == 1 && ingredient.getCount() == 1 && repairItem.getItem().canBeDepleted() && !ingredient.isEnchanted();
    }

    public static boolean isDyeableItem(Holder<Item> item) {
        return item.value() instanceof DyeableLeatherItem;
    }

    public static ItemStack dyeItem(ItemStack itemStack, int color) {
        ArrayList<Integer> colors = new ArrayList<Integer>();
        DyeableLeatherItem dyeableLeatherItem = null;
        Item item = itemStack.getItem();
        if (item instanceof DyeableLeatherItem) {
            dyeableLeatherItem = (DyeableLeatherItem)item;
            if (dyeableLeatherItem.hasCustomColor(itemStack)) {
                colors.add(dyeableLeatherItem.getColor(itemStack));
            }
            colors.add(color);
        }
        if (dyeableLeatherItem != null) {
            dyeableLeatherItem.setColor(itemStack, Legacy4J.mixColors(colors.iterator()));
        }
        return itemStack;
    }

    public static int mixColors(Iterator<Integer> colors) {
        float h;
        int[] is = new int[3];
        int i = 0;
        int j = 0;
        Iterator<Integer> it = colors;
        while (it.hasNext()) {
            Integer color = it.next();
            float f = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            h = (float)(color & 0xFF) / 255.0f;
            i += (int)(Math.max(f, Math.max(g, h)) * 255.0f);
            is[0] = is[0] + (int)(f * 255.0f);
            is[1] = is[1] + (int)(g * 255.0f);
            is[2] = is[2] + (int)(h * 255.0f);
            ++j;
        }
        int k = is[0] / j;
        int o = is[1] / j;
        int p = is[2] / j;
        h = (float)i / (float)j;
        float q = Math.max(k, Math.max(o, p));
        k = (int)((float)k * h / q);
        o = (int)((float)o * h / q);
        p = (int)((float)p * h / q);
        int n = k;
        n = (n << 8) + o;
        n = (n << 8) + p;
        return n;
    }

    public static boolean itemHasValidPatterns(ItemStack stack) {
        int count = Legacy4J.getItemPatternsCount(stack);
        return count > 0 && count <= 6;
    }

    public static int getItemPatternsCount(ItemStack stack) {
        CompoundTag beTag = stack.getTagElement("BlockEntityTag");
        return beTag == null ? 0 : (beTag.contains("Patterns") ? beTag.getList("Patterns", 10).size() : -1);
    }

    public static boolean anyArmorSlotMatch(Inventory inventory, Predicate<ItemStack> predicate) {
        return inventory.armor.stream().anyMatch(predicate);
    }

    public static void onServerPlayerJoin(ServerPlayer p) {
        if (p.getServer() == null) {
            return;
        }
        int pos = 0;
        boolean b = true;
        block0: while (b) {
            b = false;
            for (ServerPlayer player : p.server.getPlayerList().getPlayers()) {
                if (player == p || ((LegacyPlayerInfo)player).getIdentifierIndex() != pos) continue;
                ++pos;
                b = true;
                continue block0;
            }
        }
        ((LegacyPlayerInfo)p).setIdentifierIndex(pos);
        CommonNetwork.sendToPlayers((Collection)p.getServer().getPlayerList().getPlayers().stream().filter(sp -> sp != p).collect(Collectors.toSet()), (CommonNetwork.Payload)new PlayerInfoSync.All(Map.of(p.getUUID(), (LegacyPlayerInfo)p), Collections.emptyMap(), p.server.getDefaultGameType(), PlayerInfoSync.All.ID_S2C));
        CommonNetwork.sendToPlayer((ServerPlayer)p, (CommonNetwork.Payload)PlayerInfoSync.All.fromPlayerList(p.getServer()), (boolean)true);
        playerInitialPayloads.forEach(payload -> CommonNetwork.sendToPlayer((ServerPlayer)p, (CommonNetwork.Payload)payload, (boolean)true));
        if (!p.server.isDedicatedServer()) {
            Legacy4JClient.serverPlayerJoin(p);
        }
    }

    public static void onServerStart(MinecraftServer server) {
        playerInitialPayloads = Legacy4J.createPlayerInitialPayloads(server);
        LegacyWorldOptions.WORLD_STORAGE.withServerFile(server, "legacy_data.json").load();
    }

    public static void onResourcesReload(PlayerList playerList) {
        Legacy4J.onServerStart(playerList.getServer());
        playerInitialPayloads.forEach(payload -> CommonNetwork.sendToPlayers((Collection)playerList.getPlayers(), (CommonNetwork.Payload)payload));
    }

    public static Collection<CommonNetwork.Payload> createPlayerInitialPayloads(MinecraftServer server) {
        HashSet<CommonNetwork.Payload> payloads = new HashSet<CommonNetwork.Payload>();
        payloads.add(new ClientAdvancementsPayload(List.copyOf(server.getAdvancements().getAllAdvancements())));
        return payloads;
    }

    public static void copySaveToDirectory(InputStream stream, File directory) {
        if (directory.exists()) {
            FileUtils.deleteQuietly((File)directory);
        }
        try (ZipInputStream inputStream = new ZipInputStream(stream);){
            ZipEntry zipEntry;
            byte[] buffer = new byte[1024];
            while ((zipEntry = inputStream.getNextEntry()) != null) {
                int len;
                File newFile = new File(directory, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    if (newFile.isDirectory() || newFile.mkdirs()) continue;
                    throw new IOException("Failed to create directory " + String.valueOf(newFile));
                }
                File parent = newFile.getParentFile();
                if (!parent.isDirectory() && !parent.mkdirs()) {
                    throw new IOException("Failed to create directory " + String.valueOf(parent));
                }
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = inputStream.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

