/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.block.Block;
import wily.legacy.Legacy4J;
import wily.legacy.util.JsonUtil;
import wily.legacy.util.LegacyTipBuilder;

public record LegacyTipOverride(BiPredicate<Item, CompoundTag> matchItemOverride, Predicate<Block> matchBlockOverride, Predicate<EntityType<?>> matchEntityOverride, LegacyTipBuilder tip) {
    public static final List<LegacyTipOverride> list = new ArrayList<LegacyTipOverride>();
    private static final String TIP_OVERRIDES = "tip_overrides";
    public static final Component SPAWN_EGG_TIP = Component.translatable((String)"item.minecraft.spawn_egg.tip");
    public static BiFunction<Item, CompoundTag, LegacyTipBuilder> itemOverrideCache;
    public static Function<EntityType<?>, LegacyTipBuilder> entityOverrideCache;

    public static LegacyTipBuilder getOverride(ItemStack stack) {
        return itemOverrideCache.apply(stack.getItem(), stack.getTag());
    }

    public static LegacyTipBuilder getOverride(EntityType<?> entity) {
        return entityOverrideCache.apply(entity);
    }

    public static class Manager
    implements ResourceManagerReloadListener {
        public void onResourceManagerReload(ResourceManager manager) {
            list.clear();
            itemOverrideCache = Util.memoize((item, data) -> {
                for (LegacyTipOverride legacyTipOverride : list) {
                    BlockItem b;
                    if ((!(item instanceof BlockItem) || !legacyTipOverride.matchBlockOverride.test((b = (BlockItem)item).getBlock())) && !legacyTipOverride.matchItemOverride.test((Item)item, (CompoundTag)data)) continue;
                    return legacyTipOverride.tip;
                }
                return new LegacyTipBuilder();
            });
            entityOverrideCache = Util.memoize(entity -> {
                for (LegacyTipOverride legacyTipOverride : list) {
                    if (!legacyTipOverride.matchEntityOverride.test((EntityType<?>)entity)) continue;
                    return legacyTipOverride.tip;
                }
                return new LegacyTipBuilder();
            });
            list.add(new LegacyTipOverride((i, d) -> i instanceof SpawnEggItem, b -> false, e -> false, new LegacyTipBuilder().tip(SPAWN_EGG_TIP)));
            manager.listResources(LegacyTipOverride.TIP_OVERRIDES, string -> string.getPath().endsWith(".json")).forEach((location, resource) -> {
                try {
                    BufferedReader bufferedReader = resource.openAsReader();
                    JsonObject obj = GsonHelper.parse((Reader)bufferedReader);
                    JsonElement ioElement = obj.get("overrides");
                    if (ioElement instanceof JsonArray) {
                        JsonArray array = (JsonArray)ioElement;
                        array.forEach(e -> {
                            if (e instanceof JsonObject) {
                                JsonObject o = (JsonObject)e;
                                list.add(this.overrideFromJson(o));
                            }
                        });
                    } else if (ioElement instanceof JsonObject) {
                        JsonObject o = (JsonObject)ioElement;
                        list.add(this.overrideFromJson(o));
                    }
                    bufferedReader.close();
                }
                catch (IOException exception) {
                    Legacy4J.LOGGER.warn(exception.getMessage());
                }
            });
        }

        protected LegacyTipOverride overrideFromJson(JsonObject o) {
            return new LegacyTipOverride(JsonUtil.registryMatchesItem(o), JsonUtil.registryMatches(BuiltInRegistries.BLOCK, o), JsonUtil.registryMatches(BuiltInRegistries.ENTITY_TYPE, o), LegacyTipBuilder.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)o.get("tip")).result().orElse(new LegacyTipBuilder()));
        }

        public String getName() {
            return "legacy:tip_override";
        }
    }
}

