/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import wily.legacy.client.CommonColor;
import wily.legacy.util.LegacySprites;

public record PlayerIdentifier(int index, ResourceLocation optionsMapSprite, int color, byte mapDecorationIndex, byte offMapDecorationIndex, byte offLimitsMapDecorationIndex) {
    public static final Codec<PlayerIdentifier> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.fieldOf("index").forGetter(PlayerIdentifier::index), (App)ResourceLocation.CODEC.fieldOf("optionsMapSprite").orElse((Object)LegacySprites.MAP_PLAYER).forGetter(PlayerIdentifier::optionsMapSprite), (App)CommonColor.INT_COLOR_CODEC.fieldOf("color").orElse((Object)0xFFFFFF).forGetter(PlayerIdentifier::color), (App)Codec.BYTE.fieldOf("mapDecorationIndex").orElse((Object)MapDecoration.Type.PLAYER.getIcon()).forGetter(PlayerIdentifier::mapDecorationIndex), (App)Codec.BYTE.fieldOf("offMapDecorationIndex").orElse((Object)MapDecoration.Type.PLAYER_OFF_MAP.getIcon()).forGetter(PlayerIdentifier::offMapDecorationIndex), (App)Codec.BYTE.fieldOf("offLimitsMapDecorationSprite").orElse((Object)MapDecoration.Type.PLAYER_OFF_MAP.getIcon()).forGetter(PlayerIdentifier::offLimitsMapDecorationIndex)).apply((Applicative)i, PlayerIdentifier::new));
    public static final PlayerIdentifier DEFAULT = new PlayerIdentifier(0, LegacySprites.MAP_PLAYER, 0xFFFFFF, MapDecoration.Type.PLAYER.getIcon(), MapDecoration.Type.PLAYER_OFF_MAP.getIcon(), MapDecoration.Type.PLAYER_OFF_LIMITS.getIcon());
    public static final Int2ObjectMap<PlayerIdentifier> list = new Int2ObjectArrayMap();

    public byte indexByMapDecorationType(MapDecoration.Type type) {
        return switch (type) {
            case MapDecoration.Type.PLAYER -> this.mapDecorationIndex;
            case MapDecoration.Type.PLAYER_OFF_MAP -> this.offMapDecorationIndex;
            case MapDecoration.Type.PLAYER_OFF_LIMITS -> this.offLimitsMapDecorationIndex;
            default -> type.getIcon();
        };
    }

    public static PlayerIdentifier of(int index) {
        return (PlayerIdentifier)list.getOrDefault(index % list.size(), (Object)DEFAULT);
    }
}

