/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeInventoryListener;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.inventory.Hotbar;
import net.minecraft.client.searchtree.SearchRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.util.FactoryItemUtil;
import wily.factoryapi.util.PagedList;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.ControlType;
import wily.legacy.client.LegacyCreativeTabListing;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.controller.BindingState;
import wily.legacy.client.controller.Controller;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyMenuAccess;
import wily.legacy.client.screen.LegacyScroller;
import wily.legacy.client.screen.LegacyTabButton;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.TabList;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;

public class CreativeModeScreen
extends EffectRenderingInventoryScreen<CreativeModeMenu>
implements Controller.Event,
ControlTooltip.Event {
    protected Stocker.Sizeable page = new Stocker.Sizeable(Integer.valueOf(0));
    protected final TabList tabList = new TabList(UIAccessor.of((Screen)this), (List<LegacyTabButton>)new PagedList(this.page, 8));
    protected final Panel panel;
    public static final Container creativeModeGrid = new SimpleContainer(50);
    private CreativeInventoryListener listener;
    protected boolean hasClickedOutside;
    public final List<Stocker.Sizeable> tabsScrolledList = new ArrayList<Stocker.Sizeable>();
    protected final LegacyScroller scroller = LegacyScroller.create(135, () -> this.tabsScrolledList.get((Integer)this.page.get() * 8 + this.tabList.selectedTab));
    protected final List<List<ItemStack>> displayListing = new ArrayList<List<ItemStack>>();
    protected final Stocker.Sizeable arrangement = new Stocker.Sizeable(Integer.valueOf(0), 2);
    protected final EditBox searchBox;
    boolean canRemoveSearch;

    public CreativeModeScreen(Player player) {
        super((AbstractContainerMenu)new CreativeModeMenu(player), player.getInventory(), (Component)Component.empty());
        this.searchBox = new EditBox(Minecraft.getInstance().font, 0, 0, 200, 20, LegacyComponents.SEARCH_ITEMS);
        this.canRemoveSearch = false;
        this.searchBox.setResponder(s -> {
            this.fillCreativeGrid();
            this.tabsScrolledList.get((Integer)this.page.get() * 8 + this.tabList.selectedTab).set(Integer.valueOf(0));
        });
        this.searchBox.setMaxLength(50);
        LegacyCreativeTabListing.rebuildVanillaCreativeTabsItems(Minecraft.getInstance());
        for (LegacyCreativeTabListing tab : LegacyCreativeTabListing.map.values()) {
            this.displayListing.add(tab.displayItems().stream().map(Supplier::get).filter(i -> !i.isEmpty() && i.isItemEnabled(Minecraft.getInstance().getConnection().enabledFeatures())).toList());
            this.tabList.addTabButton(39, LegacyTabButton.Type.LEFT, tab.icon(), tab.name(), b -> this.pressCommonTab());
        }
        BuiltInRegistries.CREATIVE_MODE_TAB.stream().filter(CreativeModeScreen::canDisplayVanillaCreativeTab).forEach(c -> {
            List<ItemStack> displayItems;
            if (c.getType() == CreativeModeTab.Type.HOTBAR) {
                displayItems = new ArrayList();
                for (int i = 0; i < 9; ++i) {
                    Hotbar hotbar = Minecraft.getInstance().getHotbarManager().get(i);
                    if (hotbar.isEmpty()) {
                        for (int j = 0; j < 10; ++j) {
                            if (j == i) {
                                ItemStack itemStack = new ItemStack((ItemLike)Items.PAPER);
                                Component component = Minecraft.getInstance().options.keyHotbarSlots[i].getTranslatedKeyMessage();
                                Component component2 = Minecraft.getInstance().options.keySaveHotbarActivator.getTranslatedKeyMessage();
                                itemStack.getOrCreateTagElement("CustomCreativeLock");
                                itemStack.setHoverName((Component)Component.translatable((String)"inventory.hotbarInfo", (Object[])new Object[]{component2, component}));
                                displayItems.add(itemStack);
                                continue;
                            }
                            displayItems.add(ItemStack.EMPTY);
                        }
                        continue;
                    }
                    displayItems.addAll((Collection<ItemStack>)hotbar);
                    displayItems.add(ItemStack.EMPTY);
                }
            } else {
                displayItems = List.copyOf(c.getDisplayItems());
            }
            this.displayListing.add(displayItems);
            this.tabList.addTabButton(39, LegacyTabButton.Type.LEFT, LegacyTabButton.iconOf(c.getIconItem()), c.getDisplayName(), b -> this.pressCommonTab());
        });
        if (((Boolean)LegacyOptions.searchCreativeTab.get()).booleanValue()) {
            this.displayListing.add(List.copyOf(CreativeModeTabs.searchTab().getDisplayItems()));
            this.tabList.addTabButton(39, LegacyTabButton.Type.LEFT, LegacyTabButton.iconOf(LegacySprites.SEARCH), LegacyComponents.SEARCH_ITEMS, b -> {
                this.canRemoveSearch = (Integer)this.arrangement.get() != 2 && !this.canRemoveSearch;
                this.arrangement.set(Integer.valueOf(2));
                this.repositionElements();
            });
        }
        player.containerMenu = this.menu;
        this.panel = Panel.createPanel((Screen)this, p -> p.appearance(LegacySprites.CREATIVE_PANEL, 321, 212), p -> p.pos(p.centeredLeftPos((Screen)this), Math.max(33, (this.height - 179) / 2)));
        this.displayListing.forEach(t -> this.tabsScrolledList.add(new Stocker.Sizeable(Integer.valueOf(0))));
    }

    public void pressCommonTab() {
        if (this.canRemoveSearch) {
            this.canRemoveSearch = false;
            this.arrangement.set(Integer.valueOf(0));
            this.repositionElements();
        } else {
            this.fillCreativeGrid();
        }
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        ControlTooltip.Event.super.addControlTooltips(renderer);
        renderer.replace(2, i -> ControlType.getActiveType().isKbm() && this.canClearQuickSelect() ? ControlTooltip.getKeyIcon(88) : i, a -> this.canClearQuickSelect() ? LegacyComponents.CLEAR_QUICK_SELECT : a).replace(3, i -> i, a -> this.hoveredSlot != null && this.hoveredSlot.hasItem() && this.hoveredSlot.container != creativeModeGrid ? LegacyComponents.CLEAR : a).add(() -> this.page.max > 0 ? (ControlType.getActiveType().isKbm() ? ControlTooltip.ComponentIcon.compoundOf(ControlTooltip.getKeyIcon(340), ControlTooltip.PLUS_ICON, ControlTooltip.getKeyIcon(263), ControlTooltip.SPACE_ICON, ControlTooltip.getKeyIcon(262)) : ControllerBinding.RIGHT_STICK.getIcon()) : null, () -> LegacyComponents.PAGE);
    }

    public boolean canClearQuickSelect() {
        return this.hoveredSlot == null || this.hoveredSlot.container == this.minecraft.player.getInventory() && !this.hoveredSlot.hasItem();
    }

    public static AbstractContainerScreen<?> getActualCreativeScreenInstance(Minecraft minecraft) {
        return (Boolean)LegacyOptions.legacyCreativeTab.get() != false ? new CreativeModeScreen((Player)minecraft.player) : new CreativeModeInventoryScreen((Player)minecraft.player, minecraft.player.connection.enabledFeatures(), ((Boolean)minecraft.options.operatorItemsTab().get()).booleanValue());
    }

    public void removed() {
        super.removed();
        if (this.minecraft.player != null) {
            this.minecraft.player.inventoryMenu.removeSlotListener((ContainerListener)this.listener);
        }
    }

    public static boolean canDisplayVanillaCreativeTab(CreativeModeTab c) {
        ResourceLocation location = BuiltInRegistries.CREATIVE_MODE_TAB.getKey((Object)c);
        return !(!c.shouldDisplay() || c.getType() != CreativeModeTab.Type.CATEGORY && c.getType() != CreativeModeTab.Type.HOTBAR || location == null || (Boolean)LegacyOptions.vanillaTabs.get() == false && location.getNamespace().equals("minecraft") && !location.equals((Object)CreativeModeTabs.OP_BLOCKS.location()));
    }

    protected void init() {
        super.init();
        if (!Legacy4JClient.playerHasInfiniteMaterials()) {
            this.minecraft.setScreen((Screen)new InventoryScreen((Player)this.minecraft.player));
            return;
        }
        this.addRenderableWidget(this.tabList);
        this.addRenderableOnly((Renderable)this.panel);
        this.panel.init();
        this.imageWidth = this.panel.width;
        this.imageHeight = this.panel.height;
        this.leftPos = this.panel.x;
        this.topPos = this.panel.y;
        this.addRenderableOnly((Renderable)this.scroller);
        this.scroller.setPosition(this.panel.x + 296, this.panel.y + 27);
        this.scroller.offset(new Vec3(0.5, 0.5, 0.0));
        if ((Integer)this.arrangement.get() == 2) {
            this.searchBox.setPosition(this.panel.getX() + (this.panel.getWidth() - this.searchBox.getWidth()) / 2 - 6, this.panel.getY() + 7);
            this.addRenderableWidget((GuiEventListener)this.searchBox);
        }
        this.minecraft.player.inventoryMenu.removeSlotListener((ContainerListener)this.listener);
        this.listener = new CreativeInventoryListener(this.minecraft);
        this.minecraft.player.inventoryMenu.addSlotListener((ContainerListener)this.listener);
        this.tabList.init(this.panel.x, this.panel.y - 33, this.panel.width, (t, i) -> {
            int index = this.tabList.tabButtons.indexOf(t);
            t.type = LegacyTabButton.Type.bySize(index, 7);
            t.offset = b -> {
                if (!t.selected) {
                    return new Vec3(0.0, 1.5, 0.0);
                }
                return Vec3.ZERO;
            };
            t.setWidth(41);
            t.setX(t.getX() - this.tabList.tabButtons.indexOf(t));
        });
        this.fillCreativeGrid();
    }

    public void fillCreativeGrid() {
        if (this.displayListing.isEmpty()) {
            return;
        }
        List<ItemStack> list = this.displayListing.get((Integer)this.page.get() * 8 + this.tabList.selectedTab);
        if ((Integer)this.arrangement.get() != 0 && ((Integer)this.arrangement.get() == 1 || !this.searchBox.getValue().isEmpty() && this.minecraft.getConnection() != null)) {
            list = (Integer)this.arrangement.get() == 1 ? list.stream().sorted(Comparator.comparing(i -> i.getDisplayName().getString())).toList() : CreativeModeScreen.getItemsSearchResult(this.minecraft, this.searchBox.getValue());
        }
        for (int i2 = 0; i2 < creativeModeGrid.getContainerSize(); ++i2) {
            int index = (Integer)this.tabsScrolledList.get((Integer)this.page.get() * 8 + this.tabList.selectedTab).get() * 50 + i2;
            creativeModeGrid.setItem(i2, list.size() > index ? list.get(index) : ItemStack.EMPTY);
        }
        this.tabsScrolledList.get((int)(((Integer)this.page.get()).intValue() * 8 + this.tabList.selectedTab)).max = Math.max(0, (list.size() - 1) / creativeModeGrid.getContainerSize());
    }

    public static List<ItemStack> getItemsSearchResult(Minecraft minecraft, String value) {
        return value.startsWith("#") ? minecraft.getSearchTree(SearchRegistry.CREATIVE_TAGS).search(value.substring(1).toLowerCase(Locale.ROOT)) : minecraft.getSearchTree(SearchRegistry.CREATIVE_NAMES).search(value.toLowerCase(Locale.ROOT));
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBg(guiGraphics, f, i, j);
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        super.render(guiGraphics, i, j, f);
        this.renderTooltip(guiGraphics, i, j);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int i, int j) {
        if ((Integer)this.arrangement.get() == 2) {
            return;
        }
        Component tabTitle = this.tabList.tabButtons.get(this.tabList.selectedTab).getMessage();
        guiGraphics.drawString(this.font, tabTitle, (this.imageWidth - this.font.width((FormattedText)tabTitle)) / 2, 12, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
    }

    protected void renderBg(GuiGraphics guiGraphics, float f, int i, int j) {
    }

    public boolean mouseReleased(double d, double e, int i) {
        this.scroller.mouseReleased(d, e, i);
        return super.mouseReleased(d, e, i);
    }

    public boolean mouseScrolled(double d, double e, double f, double g) {
        if (super.mouseScrolled(d, e, f, g)) {
            return true;
        }
        if (this.scroller.mouseScrolled(g)) {
            this.fillCreativeGrid();
            return true;
        }
        return false;
    }

    public boolean mouseClicked(double d, double e, int i) {
        if (this.searchBox.isFocused() && !this.searchBox.isMouseOver(d, e)) {
            this.setFocused(null);
        }
        if (this.canClearQuickSelect() && i == 1) {
            return false;
        }
        if (this.scroller.mouseClicked(d, e, i)) {
            this.fillCreativeGrid();
        }
        return super.mouseClicked(d, e, i);
    }

    public boolean mouseDragged(double d, double e, int i, double f, double g) {
        if (this.scroller.mouseDragged(e)) {
            this.fillCreativeGrid();
        }
        return super.mouseDragged(d, e, i, f, g);
    }

    public boolean keyPressed(int i, int j, int k) {
        if (this.tabList.controlTab(i)) {
            return true;
        }
        if (i != 256 && this.searchBox.isFocused()) {
            return this.searchBox.keyPressed(i, j, k);
        }
        if (CreativeModeScreen.hasShiftDown() && this.tabList.controlPage(this.page, i == 263, i == 262)) {
            this.repositionElements();
        }
        if (i == 88 && this.canClearQuickSelect()) {
            for (int n = 36; n < 45; ++n) {
                this.minecraft.gameMode.handleCreativeModeItemAdd(ItemStack.EMPTY, n);
            }
            return true;
        }
        return super.keyPressed(i, j, k);
    }

    protected void slotClicked(@Nullable Slot slot, int i, int j, ClickType clickType) {
        boolean bl = clickType == ClickType.QUICK_MOVE;
        ClickType clickType2 = clickType = i == -999 && clickType == ClickType.PICKUP ? ClickType.THROW : clickType;
        if (slot != null || clickType == ClickType.QUICK_CRAFT) {
            if (slot != null && !slot.mayPickup((Player)this.minecraft.player)) {
                return;
            }
            if (clickType != ClickType.QUICK_CRAFT && slot.container == creativeModeGrid) {
                ItemStack itemStack = ((CreativeModeMenu)this.menu).getCarried();
                ItemStack itemStack2 = slot.getItem();
                if (clickType == ClickType.SWAP) {
                    if (!itemStack2.isEmpty()) {
                        this.minecraft.player.getInventory().setItem(j, itemStack2.copyWithCount(itemStack2.getMaxStackSize()));
                        this.minecraft.player.inventoryMenu.broadcastChanges();
                    }
                    return;
                }
                if (clickType == ClickType.CLONE) {
                    if (((CreativeModeMenu)this.menu).getCarried().isEmpty() && slot.hasItem()) {
                        ItemStack itemStack3 = slot.getItem();
                        ((CreativeModeMenu)this.menu).setCarried(itemStack3.copyWithCount(itemStack3.getMaxStackSize()));
                    }
                    return;
                }
                if (clickType == ClickType.THROW) {
                    if (!itemStack2.isEmpty()) {
                        ItemStack itemStack3 = itemStack2.copyWithCount(j == 0 ? 1 : itemStack2.getMaxStackSize());
                        this.minecraft.player.drop(itemStack3, true);
                        this.minecraft.gameMode.handleCreativeModeItemDrop(itemStack3);
                    }
                    return;
                }
                if (!itemStack.isEmpty() && !itemStack2.isEmpty() && FactoryItemUtil.equalItems((ItemStack)itemStack, (ItemStack)itemStack2)) {
                    if (j == 0) {
                        if (bl) {
                            itemStack.setCount(itemStack.getMaxStackSize());
                        } else if (itemStack.getCount() < itemStack.getMaxStackSize()) {
                            itemStack.grow(1);
                        }
                    } else {
                        itemStack.shrink(1);
                    }
                } else if (itemStack2.isEmpty() || !itemStack.isEmpty()) {
                    if (j == 0) {
                        ((CreativeModeMenu)this.menu).setCarried(ItemStack.EMPTY);
                    } else if (!((CreativeModeMenu)this.menu).getCarried().isEmpty()) {
                        ((CreativeModeMenu)this.menu).getCarried().shrink(1);
                    }
                } else {
                    ItemStack stack = itemStack2.copyWithCount(bl ? itemStack2.getMaxStackSize() : itemStack2.getCount());
                    if (!((CreativeModeMenu)this.menu).moveItemStackTo(stack, 50, 59, false) && !stack.isEmpty()) {
                        ((CreativeModeMenu)this.menu).setCarried(stack);
                        ((LegacyMenuAccess)((Object)this)).movePointerToSlot((Slot)((CreativeModeMenu)this.menu).slots.get(58));
                    }
                    ((CreativeModeMenu)this.menu).inventoryMenu.broadcastChanges();
                }
            } else {
                ItemStack itemStack = slot == null ? ItemStack.EMPTY : ((CreativeModeMenu)this.menu).getSlot(slot.index).getItem();
                ((CreativeModeMenu)this.menu).clicked(slot == null ? i : slot.index, j, clickType, (Player)this.minecraft.player);
                if (AbstractContainerMenu.getQuickcraftHeader((int)j) == 2) {
                    for (int m = 0; m < 9; ++m) {
                        this.minecraft.gameMode.handleCreativeModeItemAdd(((CreativeModeMenu)this.menu).getSlot(50 + m).getItem(), 36 + m);
                    }
                } else if (slot != null) {
                    ItemStack itemStack2 = ((CreativeModeMenu)this.menu).getSlot(slot.index).getItem();
                    this.minecraft.gameMode.handleCreativeModeItemAdd(itemStack2, slot.index - ((CreativeModeMenu)this.menu).slots.size() + 9 + 36);
                    int l = 50 + j;
                    if (clickType == ClickType.SWAP) {
                        this.minecraft.gameMode.handleCreativeModeItemAdd(itemStack, l - ((CreativeModeMenu)this.menu).slots.size() + 9 + 36);
                    } else if (clickType == ClickType.THROW && !itemStack.isEmpty()) {
                        ItemStack itemStack4 = itemStack.copyWithCount(j == 0 ? 1 : itemStack.getMaxStackSize());
                        this.minecraft.player.drop(itemStack4, true);
                        this.minecraft.gameMode.handleCreativeModeItemDrop(itemStack4);
                    }
                    this.minecraft.player.inventoryMenu.broadcastChanges();
                }
            }
        } else if (!((CreativeModeMenu)this.menu).getCarried().isEmpty() && this.hasClickedOutside) {
            if (j == 0) {
                this.minecraft.player.drop(((CreativeModeMenu)this.menu).getCarried(), true);
                this.minecraft.gameMode.handleCreativeModeItemDrop(((CreativeModeMenu)this.menu).getCarried());
                ((CreativeModeMenu)this.menu).setCarried(ItemStack.EMPTY);
            }
            if (j == 1) {
                ItemStack itemStack = ((CreativeModeMenu)this.menu).getCarried().split(1);
                this.minecraft.player.drop(itemStack, true);
                this.minecraft.gameMode.handleCreativeModeItemDrop(itemStack);
            }
        }
    }

    protected boolean hasClickedOutside(double d, double e, int i, int j, int k) {
        this.hasClickedOutside = super.hasClickedOutside(d, e, i, j, k) && !this.tabList.isMouseOver(d, e);
        return this.hasClickedOutside;
    }

    @Override
    public void bindingStateTick(BindingState state) {
        if (state.is(ControllerBinding.RIGHT_STICK) && state instanceof BindingState.Axis) {
            BindingState.Axis s = (BindingState.Axis)state;
            if (s.pressed && s.canClick() && this.tabList.controlPage(this.page, s.x < 0.0f && -s.x > Math.abs(s.y), s.x > 0.0f && s.x > Math.abs(s.y))) {
                this.repositionElements();
            }
        }
    }

    public static class CreativeModeMenu
    extends AbstractContainerMenu {
        private final AbstractContainerMenu inventoryMenu;

        public CreativeModeMenu(Player player) {
            super(null, 0);
            this.inventoryMenu = player.inventoryMenu;
            for (int h = 0; h < 5; ++h) {
                for (int x = 0; x < 10; ++x) {
                    this.addSlot(LegacySlotDisplay.override(new Slot(creativeModeGrid, h * 10 + x, 21 + x * 27, 29 + h * 27){

                        public boolean mayPickup(Player player) {
                            return super.mayPickup(player) && !this.getItem().isEmpty() ? this.getItem().isItemEnabled(player.level().enabledFeatures()) && this.getItem().getTagElement("CustomCreativeLock") == null : this.getItem().isEmpty();
                        }
                    }, new LegacySlotDisplay(){

                        @Override
                        public int getWidth() {
                            return 27;
                        }
                    }));
                }
            }
            for (int x = 0; x < 9; ++x) {
                this.addSlot(LegacySlotDisplay.override(new Slot((Container)player.getInventory(), x, 35 + x * 27, 176), new LegacySlotDisplay(){

                    @Override
                    public int getWidth() {
                        return 27;
                    }
                }));
            }
        }

        public ItemStack quickMoveStack(Player player, int i) {
            Slot slot;
            if (i >= this.slots.size() - 9 && i < this.slots.size() && (slot = (Slot)this.slots.get(i)) != null && slot.hasItem()) {
                slot.setByPlayer(ItemStack.EMPTY);
            }
            return ItemStack.EMPTY;
        }

        public boolean stillValid(Player player) {
            return true;
        }

        public boolean canTakeItemForPickAll(ItemStack itemStack, Slot slot) {
            return slot.container != creativeModeGrid;
        }

        public boolean canDragTo(Slot slot) {
            return slot.container != creativeModeGrid;
        }

        public ItemStack getCarried() {
            return this.inventoryMenu.getCarried();
        }

        public void setCarried(ItemStack itemStack) {
            this.inventoryMenu.setCarried(itemStack);
        }
    }
}

