/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.SimpleLayoutRenderable;
import wily.factoryapi.base.network.CommonNetwork;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.ControlType;
import wily.legacy.client.PlayerIdentifier;
import wily.legacy.client.controller.BindingState;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.controller.LegacyKeyMapping;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyConfigWidgets;
import wily.legacy.client.screen.LegacySliderButton;
import wily.legacy.client.screen.LoadSaveScreen;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PanelVListScreen;
import wily.legacy.client.screen.PublishScreen;
import wily.legacy.client.screen.TickBox;
import wily.legacy.client.screen.compat.WorldHostFriendsScreen;
import wily.legacy.config.LegacyCommonOptions;
import wily.legacy.entity.LegacyPlayerInfo;
import wily.legacy.init.LegacyGameRules;
import wily.legacy.network.PlayerInfoSync;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public class HostOptionsScreen
extends PanelVListScreen {
    public static final Component HOST_OPTIONS = Component.translatable((String)"legacy.menu.host_options");
    public static final Component PLAYERS_INVITE = Component.translatable((String)"legacy.menu.players_invite");
    protected final Component title;
    protected float oldAlpha = HostOptionsScreen.getDefaultOpacity();
    protected float alpha = HostOptionsScreen.getDefaultOpacity();
    protected boolean shouldFade = false;
    public static final List<GameRules.Key<GameRules.BooleanValue>> WORLD_RULES = new ArrayList<GameRules.Key<GameRules.BooleanValue>>(List.of(GameRules.RULE_DOFIRETICK, LegacyGameRules.getTntExplodes(), GameRules.RULE_DAYLIGHT, GameRules.RULE_KEEPINVENTORY, GameRules.RULE_DOMOBSPAWNING, GameRules.RULE_MOBGRIEFING, LegacyGameRules.GLOBAL_MAP_PLAYER_ICON, LegacyGameRules.LEGACY_SWIMMING));
    public static final List<GameRules.Key<GameRules.BooleanValue>> OTHER_RULES = new ArrayList<GameRules.Key>(List.of(GameRules.RULE_WEATHER_CYCLE, GameRules.RULE_DOMOBLOOT, GameRules.RULE_DOBLOCKDROPS, GameRules.RULE_NATURAL_REGENERATION, GameRules.RULE_DO_IMMEDIATE_RESPAWN));

    public HostOptionsScreen(Component title) {
        super((Screen s) -> Panel.centered(s, LegacySprites.PANEL, 250, 190, 0, 20), HOST_OPTIONS);
        this.title = title;
        this.addPlayerButtons();
        this.renderableVList.layoutSpacing(l -> 0);
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        super.addControlTooltips(renderer);
        renderer.add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(88) : ControllerBinding.LEFT_BUTTON.getIcon(), () -> this.minecraft.hasSingleplayerServer() ? (!this.minecraft.getSingleplayerServer().isPublished() ? PublishScreen.PUBLISH : (PublishScreen.hasWorldHost() ? WorldHostFriendsScreen.FRIENDS : null)) : null);
        renderer.add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(79) : ControllerBinding.UP_BUTTON.getIcon(), () -> this.minecraft.getChatStatus().isChatAllowed(this.minecraft.isLocalServer()) ? LegacyKeyMapping.of(Minecraft.getInstance().options.keyChat).getDisplayName() : null);
    }

    public HostOptionsScreen() {
        this(PLAYERS_INVITE);
    }

    public void reloadPlayerButtons() {
        int i = this.renderableVList.renderables.indexOf(this.getFocused());
        this.renderableVList.renderables.clear();
        this.addPlayerButtons();
        this.rebuildWidgets();
        if (i >= 0 && i < this.renderableVList.renderables.size()) {
            this.setFocused((GuiEventListener)this.renderableVList.renderables.get(i));
        }
    }

    @Override
    public void bindingStateTick(BindingState state) {
        if (state.is(LegacyKeyMapping.of(Legacy4JClient.keyHostOptions).getBinding()) && state.onceClick(true)) {
            this.onClose();
        }
    }

    @Override
    public boolean keyPressed(final int i, int j, int k) {
        if (Legacy4JClient.keyHostOptions.matches(i, j)) {
            this.onClose();
            return true;
        }
        if (i == 79) {
            this.minecraft.setScreen((Screen)new ChatScreen(""){
                boolean released;
                {
                    super(string);
                    this.released = false;
                }

                public boolean charTyped(char c, int i2) {
                    if (!this.released) {
                        return false;
                    }
                    return super.charTyped(c, i2);
                }

                public boolean keyReleased(int i2, int j, int k) {
                    if (i2 == i) {
                        this.released = true;
                    }
                    return super.keyReleased(i2, j, k);
                }
            });
            return true;
        }
        if (i == 88 && this.minecraft.hasSingleplayerServer()) {
            if (!this.minecraft.getSingleplayerServer().isPublished()) {
                this.minecraft.setScreen((Screen)new PublishScreen(this, this.minecraft.getSingleplayerServer().getDefaultGameType(), s -> s.publish(this.minecraft.getSingleplayerServer())){
                    boolean released;
                    {
                        super(parent, gameType, okAction);
                        this.released = false;
                    }

                    public boolean charTyped(char c, int i2) {
                        if (!this.released) {
                            return false;
                        }
                        return super.charTyped(c, i2);
                    }

                    public boolean keyReleased(int i2, int j, int k) {
                        if (i2 == i) {
                            this.released = true;
                        }
                        return super.keyReleased(i2, j, k);
                    }
                });
            } else if (PublishScreen.hasWorldHost()) {
                this.minecraft.setScreen((Screen)new WorldHostFriendsScreen(this));
            }
            return true;
        }
        return super.keyPressed(i, j, k);
    }

    public static void drawPlayerIcon(LegacyPlayerInfo info, GuiGraphics guiGraphics, int x, int y) {
        float[] color = Legacy4JClient.getVisualPlayerColor(info);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setColor(color[0], color[1], color[2], 1.0f);
        FactoryScreenUtil.enableBlend();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(PlayerIdentifier.of(info.getIdentifierIndex()).optionsMapSprite(), x, y, 20, 20);
        FactoryScreenUtil.disableBlend();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).clearColor();
    }

    protected void addPlayerButtons() {
        this.addPlayerButtons(true, (playerInfo, b) -> {
            if (!this.minecraft.player.hasPermissions(2)) {
                return;
            }
            final HashMap COMMAND_MAP = new HashMap();
            boolean initialVisibility = !((LegacyPlayerInfo)playerInfo).isVisible();
            PanelVListScreen screen = new PanelVListScreen(this, s -> Panel.centered(s, LegacySprites.PANEL, 280, playerInfo.getGameMode().isSurvival() ? 120 : 88), HOST_OPTIONS, (PlayerInfo)playerInfo){
                final /* synthetic */ PlayerInfo val$playerInfo;
                {
                    this.val$playerInfo = playerInfo;
                    super(parent, panelConstructor, component);
                }

                @Override
                public void renderableVListInit() {
                    this.getRenderableVList().init(this.panel.x + 8, this.panel.y + 27, this.panel.width - 16, this.panel.height - 16);
                }

                @Override
                protected void panelInit() {
                    this.panel.init();
                }

                @Override
                public void onClose() {
                    COMMAND_MAP.values().forEach(Runnable::run);
                    super.onClose();
                }

                public boolean isPauseScreen() {
                    return false;
                }

                @Override
                public void renderDefaultBackground(GuiGraphics guiGraphics, int i, int j, float f) {
                    this.panel.render(guiGraphics, i, j, f);
                    HostOptionsScreen.drawPlayerIcon((LegacyPlayerInfo)this.val$playerInfo, guiGraphics, this.panel.x + 7, this.panel.y + 5);
                    guiGraphics.drawString(this.font, this.val$playerInfo.getProfile().getName(), this.panel.x + 31, this.panel.y + 12, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
                }
            };
            List<GameType> gameTypes = Arrays.stream(GameType.values()).toList();
            screen.renderableVList.addRenderable((Renderable)new TickBox(0, 0, initialVisibility, b1 -> Component.translatable((String)"legacy.menu.host_options.player.invisible"), b1 -> null, b1 -> {
                if (initialVisibility != b1.selected) {
                    COMMAND_MAP.put(b1, () -> {
                        if (b1.selected) {
                            this.minecraft.player.connection.sendCommand("effect give %s minecraft:invisibility infinite 255 true".formatted(playerInfo.getProfile().getName()));
                            this.minecraft.player.connection.sendCommand("effect give %s minecraft:resistance infinite 255 true".formatted(playerInfo.getProfile().getName()));
                        } else {
                            this.minecraft.player.connection.sendCommand("effect clear %s minecraft:invisibility".formatted(playerInfo.getProfile().getName()));
                            this.minecraft.player.connection.sendCommand("effect clear %s minecraft:resistance".formatted(playerInfo.getProfile().getName()));
                        }
                    });
                }
            }));
            if (playerInfo.getGameMode().isSurvival()) {
                screen.renderableVList.addRenderable((Renderable)new TickBox(0, 0, ((LegacyPlayerInfo)playerInfo).mayFlySurvival(), b1 -> Component.translatable((String)"legacy.menu.host_options.player.mayFly"), b1 -> null, b1 -> CommonNetwork.sendToServer((CommonNetwork.Payload)PlayerInfoSync.mayFlySurvival(b1.selected, playerInfo.getProfile()))));
                screen.renderableVList.addRenderable((Renderable)new TickBox(0, 0, ((LegacyPlayerInfo)playerInfo).isExhaustionDisabled(), b1 -> Component.translatable((String)"legacy.menu.host_options.player.disableExhaustion"), b1 -> null, b1 -> CommonNetwork.sendToServer((CommonNetwork.Payload)PlayerInfoSync.disableExhaustion(b1.selected, playerInfo.getProfile()))));
            }
            screen.renderableVList.addRenderable((Renderable)new LegacySliderButton<GameType>(0, 0, 230, 16, b1 -> b1.getDefaultMessage(LoadSaveScreen.GAME_MODEL_LABEL, ((GameType)b1.getObjectValue()).getShortDisplayName()), b1 -> Tooltip.create((Component)Component.translatable((String)("selectWorld.gameMode." + playerInfo.getGameMode().getName() + ".info"))), playerInfo.getGameMode(), () -> gameTypes, b1 -> COMMAND_MAP.put(b1, () -> this.minecraft.getConnection().sendCommand("gamemode %s %s".formatted(((GameType)b1.getObjectValue()).getName(), playerInfo.getProfile().getName())))));
            screen.renderableVList.addRenderable((Renderable)Button.builder((Component)Component.translatable((String)"legacy.menu.host_options.set_player_spawn"), b1 -> COMMAND_MAP.put(b1, () -> this.minecraft.player.connection.sendCommand("spawnpoint %s ~ ~ ~".formatted(playerInfo.getProfile().getName())))).bounds(0, 0, 215, 20).build());
            this.minecraft.setScreen((Screen)screen);
        });
    }

    protected void addPlayerButtons(boolean includeLocal, final BiConsumer<PlayerInfo, AbstractButton> onPress) {
        for (PlayerInfo playerInfo : HostOptionsScreen.getActualPlayerInfos()) {
            if (!includeLocal && Objects.equals(playerInfo.getProfile().getName(), Minecraft.getInstance().player.getGameProfile().getName())) continue;
            this.renderableVList.addRenderable((Renderable)new PlayerButton(0, 0, 230, 30, playerInfo){

                public void onPress() {
                    onPress.accept(this.playerInfo, this);
                }
            });
        }
    }

    public static List<PlayerInfo> getActualPlayerInfos() {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player != null && !minecraft.player.connection.getOnlinePlayers().isEmpty()) {
            return minecraft.player.connection.getOnlinePlayers().stream().sorted(Comparator.comparingInt(p -> minecraft.hasSingleplayerServer() && minecraft.getSingleplayerServer().isSingleplayerOwner(p.getProfile()) ? 0 : ((LegacyPlayerInfo)p).getIdentifierIndex())).toList();
        }
        return Collections.emptyList();
    }

    @Override
    protected void init() {
        CommonNetwork.sendToServer((CommonNetwork.Payload)PlayerInfoSync.askAll((Player)this.minecraft.player));
        super.init();
        this.addHostOptionsButton();
    }

    @Override
    protected void panelInit() {
        this.panel.init();
    }

    @Override
    public void renderableVListInit() {
        this.getRenderableVList().init(this.panel.x + 10, this.panel.y + 22, this.panel.width - 20, this.panel.height - 26);
    }

    protected void addHostOptionsButton() {
        if (!this.minecraft.player.hasPermissions(2) && !this.minecraft.hasSingleplayerServer()) {
            return;
        }
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)HOST_OPTIONS, this::pressHostOptionsButton).bounds(this.panel.x, this.panel.y - 36, 250, 20).build());
    }

    protected void pressHostOptionsButton(Button b) {
        final HashMap nonOpGamerules = new HashMap();
        final HashMap COMMAND_MAP = new HashMap();
        PanelVListScreen screen = new PanelVListScreen(this, s -> Panel.centered(s, LegacySprites.PANEL, 265, this.minecraft.player.hasPermissions(2) ? 200 : 130), HOST_OPTIONS){

            @Override
            public void renderableVListInit() {
                this.getRenderableVList().init(this.panel.x + 8, this.panel.y + 8, this.panel.width - 16, this.panel.height - 16);
            }

            @Override
            protected void panelInit() {
                this.panel.init();
            }

            @Override
            public void onClose() {
                super.onClose();
                COMMAND_MAP.values().forEach(Runnable::run);
                if (!nonOpGamerules.isEmpty()) {
                    CommonNetwork.sendToServer((CommonNetwork.Payload)new PlayerInfoSync.All(nonOpGamerules, PlayerInfoSync.All.ID_C2S));
                }
            }

            public boolean isPauseScreen() {
                return false;
            }

            @Override
            public void renderDefaultBackground(GuiGraphics guiGraphics, int i, int j, float f) {
                this.panel.render(guiGraphics, i, j, f);
            }
        };
        if (!this.minecraft.player.hasPermissions(2)) {
            for (GameRules.Key<GameRules.BooleanValue> key : PlayerInfoSync.All.NON_OP_GAMERULES) {
                screen.renderableVList.addRenderable((Renderable)new TickBox(0, 0, ((GameRules.BooleanValue)Legacy4JClient.gameRules.getRule(key)).get(), b1 -> Component.translatable((String)key.getDescriptionId()), b1 -> null, b1 -> nonOpGamerules.put(key.getId(), b1.selected)));
            }
            LegacyCommonOptions.COMMON_STORAGE.configMap.values().forEach(c -> screen.getRenderableVList().addRenderable((Renderable)LegacyConfigWidgets.createWidget(c, b1 -> c.sync())));
            Legacy4J.MIXIN_CONFIGS_STORAGE.configMap.values().forEach(c -> screen.getRenderableVList().addRenderable((Renderable)LegacyConfigWidgets.createWidget(c, b1 -> c.sync())));
            this.minecraft.setScreen((Screen)screen);
            return;
        }
        List<String> weathers = List.of("clear", "rain", "thunder");
        int initialWeather = this.minecraft.level.isThundering() ? 2 : (this.minecraft.level.isRaining() ? 1 : 0);
        screen.renderableVList.layoutSpacing(l -> 2);
        for (GameRules.Key<GameRules.BooleanValue> key : WORLD_RULES) {
            screen.renderableVList.addRenderable((Renderable)new TickBox(0, 0, ((GameRules.BooleanValue)Legacy4JClient.gameRules.getRule(key)).get(), b1 -> Component.translatable((String)key.getDescriptionId()), b1 -> null, b1 -> COMMAND_MAP.put(b1, () -> this.minecraft.player.connection.sendCommand("gamerule %s %s".formatted(key.getId(), b1.selected)))));
        }
        screen.renderableVList.addRenderable((Renderable)Button.builder((Component)Component.translatable((String)"legacy.menu.host_options.set_day"), b1 -> this.minecraft.player.connection.sendCommand("time set day")).bounds(0, 0, 215, 20).build());
        screen.renderableVList.addRenderable((Renderable)Button.builder((Component)Component.translatable((String)"legacy.menu.host_options.set_night"), b1 -> this.minecraft.player.connection.sendCommand("time set 14000")).bounds(0, 0, 215, 20).build());
        screen.renderableVList.addRenderable((Renderable)new LegacySliderButton<Difficulty>(0, 0, 230, 16, b1 -> b1.getDefaultMessage((Component)Component.translatable((String)"options.difficulty"), ((Difficulty)b1.getObjectValue()).getDisplayName()), b1 -> Tooltip.create((Component)this.minecraft.level.getDifficulty().getInfo()), this.minecraft.level.getDifficulty(), () -> Arrays.asList(Difficulty.values()), b1 -> COMMAND_MAP.put(b1, () -> this.minecraft.getConnection().sendCommand("difficulty " + ((Difficulty)b1.getObjectValue()).getKey()))));
        Supplier<GameType> gameType = () -> Legacy4JClient.defaultServerGameType == null ? this.minecraft.gameMode.getPlayerMode() : Legacy4JClient.defaultServerGameType;
        List<GameType> gameTypes = Arrays.stream(GameType.values()).toList();
        screen.renderableVList.addRenderable((Renderable)new LegacySliderButton<GameType>(0, 0, 230, 16, b1 -> b1.getDefaultMessage(LoadSaveScreen.GAME_MODEL_LABEL, ((GameType)b1.getObjectValue()).getShortDisplayName()), b1 -> Tooltip.create((Component)Component.translatable((String)("selectWorld.gameMode." + ((GameType)gameType.get()).getName() + ".info"))), gameType.get(), () -> gameTypes, b1 -> COMMAND_MAP.put(b1, () -> this.minecraft.getConnection().sendCommand("defaultgamemode " + ((GameType)b1.getObjectValue()).getName()))));
        screen.renderableVList.addRenderable((Renderable)Button.builder((Component)Component.translatable((String)"legacy.menu.host_options.set_world_spawn"), b1 -> COMMAND_MAP.put(b1, () -> this.minecraft.player.connection.sendCommand("setworldspawn"))).bounds(0, 0, 215, 20).build());
        screen.renderableVList.addRenderables(new Renderable[]{SimpleLayoutRenderable.create((int)240, (int)12, l -> (graphics, i, j, f) -> {}), SimpleLayoutRenderable.create((int)240, (int)12, l -> (graphics, i, j, f) -> graphics.drawString(this.font, (Component)Component.translatable((String)"soundCategory.weather"), l.x + 1, l.y + 4, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false))});
        screen.renderableVList.addRenderable((Renderable)new LegacySliderButton<String>(0, 0, 230, 16, b1 -> Component.translatable((String)("legacy.weather_state." + (String)b1.getObjectValue())), b1 -> null, weathers.get(initialWeather), () -> weathers, b1 -> {
            if (!Objects.equals(b1.getObjectValue(), weathers.get(initialWeather))) {
                COMMAND_MAP.put(b1, () -> this.minecraft.getConnection().sendCommand("weather " + (String)b1.getObjectValue()));
            }
        }));
        for (GameRules.Key<GameRules.BooleanValue> key : OTHER_RULES) {
            screen.renderableVList.addRenderable((Renderable)new TickBox(0, 0, ((GameRules.BooleanValue)Legacy4JClient.gameRules.getRule(key)).get(), b1 -> Component.translatable((String)key.getDescriptionId()), b1 -> null, b1 -> COMMAND_MAP.put(b1, () -> this.minecraft.player.connection.sendCommand("gamerule %s %s".formatted(key.getId(), b1.selected)))));
        }
        LegacyCommonOptions.COMMON_STORAGE.configMap.values().forEach(c -> screen.getRenderableVList().addRenderable((Renderable)LegacyConfigWidgets.createWidget(c, b1 -> c.sync())));
        Legacy4J.MIXIN_CONFIGS_STORAGE.configMap.values().forEach(c -> screen.getRenderableVList().addRenderable((Renderable)LegacyConfigWidgets.createWidget(c, b1 -> c.sync())));
        this.minecraft.setScreen((Screen)screen);
        if (this.minecraft.hasSingleplayerServer() && !this.minecraft.getSingleplayerServer().isPublished()) {
            return;
        }
        BiFunction<Boolean, Component, AbstractButton> teleportButton = (bol, title) -> Button.builder((Component)title, b1 -> this.minecraft.setScreen((Screen)new HostOptionsScreen((Component)title, (Boolean)bol){
            final /* synthetic */ Boolean val$bol;
            {
                this.val$bol = bl;
                super(title);
            }

            @Override
            protected void addHostOptionsButton() {
            }

            @Override
            protected void addPlayerButtons() {
                this.addPlayerButtons(false, (profile, b1) -> {
                    if (this.val$bol.booleanValue()) {
                        this.minecraft.player.connection.sendCommand("tp %s".formatted(profile.getProfile().getName()));
                    } else {
                        this.minecraft.player.connection.sendCommand("tp %s ~ ~ ~".formatted(profile.getProfile().getName()));
                    }
                });
            }

            @Override
            public boolean isPauseScreen() {
                return false;
            }
        })).bounds(0, 0, 215, 20).build();
        screen.renderableVList.addRenderable((Renderable)teleportButton.apply(true, (Component)Component.translatable((String)"legacy.menu.host_options.teleport_player")));
        screen.renderableVList.addRenderable((Renderable)teleportButton.apply(false, (Component)Component.translatable((String)"legacy.menu.host_options.teleport_me")));
    }

    public boolean isPauseScreen() {
        return false;
    }

    @Override
    public void renderDefaultBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.oldAlpha = this.alpha;
        this.alpha = Mth.lerp((float)(f * 0.1f), (float)this.oldAlpha, (float)(this.shouldFade ? 1.0f : HostOptionsScreen.getDefaultOpacity()));
        this.shouldFade = false;
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setColor(1.0f, 1.0f, 1.0f, this.alpha);
        FactoryScreenUtil.enableBlend();
        this.panel.render(guiGraphics, i, j, f);
        FactoryScreenUtil.disableBlend();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.drawString(this.font, this.title, this.panel.x + 11, this.panel.y + 8, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
    }

    protected static float getDefaultOpacity() {
        return 0.5f;
    }

    protected abstract class PlayerButton
    extends AbstractButton {
        public final PlayerInfo playerInfo;

        public PlayerButton(int x, int y, int width, int height, PlayerInfo playerInfo) {
            super(x, y, width, height, (Component)Component.literal((String)playerInfo.getProfile().getName()));
            this.playerInfo = playerInfo;
        }

        protected void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
            if (this.isHoveredOrFocused()) {
                HostOptionsScreen.this.shouldFade = true;
            }
            super.renderWidget(guiGraphics, i, j, f);
            HostOptionsScreen.drawPlayerIcon((LegacyPlayerInfo)this.playerInfo, guiGraphics, this.getX() + 6, this.getY() + 5);
        }

        protected void renderScrollingString(GuiGraphics guiGraphics, Font font, int i, int j) {
            ScreenUtil.renderScrollingString(guiGraphics, font, this.getMessage(), this.getX() + 68, this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), j, true);
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
            this.defaultButtonNarrationText(narrationElementOutput);
        }
    }
}

