/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;
import wily.factoryapi.base.Stocker;
import wily.legacy.client.ControlType;
import wily.legacy.client.LegacyTipManager;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyIconHolder;
import wily.legacy.client.screen.LegacyMenuAccess;
import wily.legacy.client.screen.LegacyScroller;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PanelBackgroundScreen;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.ScreenUtil;

public class ItemViewerScreen
extends PanelBackgroundScreen
implements LegacyMenuAccess<AbstractContainerMenu> {
    public static final Container layerSelectionGrid = new SimpleContainer(50);
    public final List<ItemStack> layerItems = new ArrayList<ItemStack>();
    protected final Stocker.Sizeable scrolledList = new Stocker.Sizeable(Integer.valueOf(0));
    protected final AbstractContainerMenu menu;
    protected Slot hoveredSlot = null;
    protected final LegacyScroller scroller = LegacyScroller.create(135, () -> this.scrolledList);

    public ItemViewerScreen(Screen parent, Function<Screen, Panel> panelConstructor, Component component) {
        super(parent, panelConstructor, component);
        this.menu = new AbstractContainerMenu(null, -1){

            public ItemStack quickMoveStack(Player player, int i) {
                return null;
            }

            public boolean stillValid(Player player) {
                return false;
            }
        };
        for (int i = 0; i < layerSelectionGrid.getContainerSize(); ++i) {
            this.menu.slots.add((Object)LegacySlotDisplay.override(new Slot(layerSelectionGrid, i, 23 + i % 10 * 27, 24 + i / 10 * 27), new LegacySlotDisplay(){

                @Override
                public int getWidth() {
                    return 27;
                }

                @Override
                public int getHeight() {
                    return 27;
                }
            }));
        }
        this.addLayerItems();
        this.scrolledList.max = Math.max(0, (this.layerItems.size() - 1) / layerSelectionGrid.getContainerSize());
    }

    protected void addLayerItems() {
        BuiltInRegistries.ITEM.forEach(i -> {
            if (i != Items.AIR) {
                this.layerItems.add(i.getDefaultInstance());
            }
        });
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        ControlTooltip.setupDefaultScreen(renderer, this).add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(87) : ControllerBinding.RIGHT_TRIGGER.getIcon(), () -> this.getHoveredSlot() != null && this.getHoveredSlot().hasItem() && LegacyTipManager.hasTip(this.getHoveredSlot().getItem()) ? LegacyComponents.WHATS_THIS : null);
    }

    @Override
    protected void init() {
        this.panel.init();
        this.scroller.setPosition(this.panel.x + 299, this.panel.y + 23);
        this.scroller.offset(new Vec3(0.5, 0.0, 0.0));
        this.fillLayerGrid();
    }

    public void fillLayerGrid() {
        for (int i = 0; i < layerSelectionGrid.getContainerSize(); ++i) {
            int index = (Integer)this.scrolledList.get() * 50 + i;
            layerSelectionGrid.setItem(i, this.layerItems.size() > index ? this.layerItems.get(index) : ItemStack.EMPTY);
        }
    }

    public boolean mouseScrolled(double d, double e, double f, double g) {
        if (this.scroller.mouseScrolled(g)) {
            this.fillLayerGrid();
        }
        return super.mouseScrolled(d, e, f, g);
    }

    public boolean mouseClicked(double d, double e, int i) {
        if (this.scroller.mouseClicked(d, e, i)) {
            this.fillLayerGrid();
        }
        if (this.hoveredSlot != null) {
            this.slotClicked(this.hoveredSlot);
        }
        return super.mouseClicked(d, e, i);
    }

    public boolean mouseReleased(double d, double e, int i) {
        this.scroller.mouseReleased(d, e, i);
        return super.mouseReleased(d, e, i);
    }

    public boolean keyPressed(int i, int j, int k) {
        if (i == 87 && this.hoveredSlot != null && this.hoveredSlot.hasItem() && LegacyTipManager.setTip(LegacyTipManager.getTip(this.hoveredSlot.getItem().copy()))) {
            ScreenUtil.playSimpleUISound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 1.0f);
            return true;
        }
        return super.keyPressed(i, j, k);
    }

    protected void slotClicked(Slot slot) {
    }

    public boolean mouseDragged(double d, double e, int i, double f, double g) {
        if (this.scroller.mouseDragged(e)) {
            this.fillLayerGrid();
        }
        return super.mouseDragged(d, e, i, f, g);
    }

    public void setHoveredSlot(Slot hoveredSlot) {
        this.hoveredSlot = hoveredSlot;
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        super.render(guiGraphics, i, j, f);
        this.setHoveredSlot(null);
        this.menu.slots.forEach(s -> {
            LegacyIconHolder holder = ScreenUtil.iconHolderRenderer.slotBoundsWithItem(this.panel.x, this.panel.y, (Slot)s);
            holder.render(guiGraphics, i, j, f);
            if (holder.isHovered) {
                if (s.isHighlightable()) {
                    holder.renderHighlight(guiGraphics);
                }
                this.setHoveredSlot((Slot)s);
            }
        });
        if (this.hoveredSlot != null && !this.hoveredSlot.getItem().isEmpty()) {
            guiGraphics.renderTooltip(this.font, this.hoveredSlot.getItem(), i, j);
        }
    }

    @Override
    public void renderDefaultBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        ScreenUtil.renderDefaultBackground(this.accessor, guiGraphics, false);
        this.panel.render(guiGraphics, i, j, f);
        this.renderScroll(guiGraphics, i, j, f);
    }

    protected void renderScroll(GuiGraphics guiGraphics, int i, int j, float f) {
        this.scroller.render(guiGraphics, i, j, f);
    }

    public AbstractContainerMenu getMenu() {
        return this.menu;
    }

    @Override
    public ScreenRectangle getMenuRectangle() {
        return new ScreenRectangle(this.panel.x, this.panel.y, this.panel.width, this.panel.height);
    }

    @Override
    public boolean isOutsideClick(int i) {
        return false;
    }

    @Override
    public Slot getHoveredSlot() {
        return this.hoveredSlot;
    }

    @Override
    public int getTipXDiff() {
        return 0;
    }
}

