/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BedItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.DecoratedPotPatterns;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.FactoryIngredient;
import wily.factoryapi.base.StackIngredient;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.base.client.UIDefinition;
import wily.factoryapi.base.network.CommonNetwork;
import wily.factoryapi.base.network.CommonRecipeManager;
import wily.factoryapi.util.ModInfo;
import wily.factoryapi.util.PagedList;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.ControlType;
import wily.legacy.client.LegacyCraftingTabListing;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacyTipManager;
import wily.legacy.client.RecipeInfo;
import wily.legacy.client.controller.BindingState;
import wily.legacy.client.controller.Controller;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.CustomRecipeIconHolder;
import wily.legacy.client.screen.LegacyIconHolder;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.client.screen.LegacyTabButton;
import wily.legacy.client.screen.ModsScreen;
import wily.legacy.client.screen.RecipeIconHolder;
import wily.legacy.client.screen.ScrollableRenderer;
import wily.legacy.client.screen.TabList;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.inventory.ImpossibleIngredient;
import wily.legacy.inventory.LegacyCraftingMenu;
import wily.legacy.inventory.RecipeMenu;
import wily.legacy.mixin.base.FireworkRocketRecipeAccessor;
import wily.legacy.mixin.base.FireworkStarRecipeAccessor;
import wily.legacy.network.ServerMenuCraftPayload;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public class LegacyCraftingScreen
extends AbstractContainerScreen<LegacyCraftingMenu>
implements Controller.Event,
ControlTooltip.Event,
TabList.Access {
    private final Inventory inventory;
    protected final List<ItemStack> compactItemStackList = new ArrayList<ItemStack>();
    private final boolean is2x2;
    private final int gridDimension;
    private boolean onlyCraftableRecipes = false;
    protected Stocker.Sizeable infoType = new Stocker.Sizeable(Integer.valueOf(0), 2);
    protected final List<Optional<Ingredient>> ingredientsGrid;
    protected final CraftingContainer container;
    protected ItemStack resultStack = ItemStack.EMPTY;
    protected final UIAccessor accessor = UIAccessor.of((Screen)this);
    protected final List<RecipeIconHolder<CraftingRecipe>> craftingButtons = new PagedList(new Stocker.Sizeable(Integer.valueOf(0), 0), () -> this.accessor.getInteger("maxCraftingButtonsCount", 12));
    protected final List<CustomRecipeIconHolder> dyeItemButtons = new ArrayList<CustomRecipeIconHolder>();
    protected final List<CustomRecipeIconHolder> dyeArmorButtons = new ArrayList<CustomRecipeIconHolder>();
    protected final List<CustomRecipeIconHolder> bannerButtons = new ArrayList<CustomRecipeIconHolder>();
    protected final List<CustomRecipeIconHolder> decorateShieldButtons = new ArrayList<CustomRecipeIconHolder>();
    protected final List<CustomRecipeIconHolder> decoratedPotButtons = new ArrayList<CustomRecipeIconHolder>();
    protected final List<CustomRecipeIconHolder> fireworkStarButtons = new ArrayList<CustomRecipeIconHolder>();
    protected final List<CustomRecipeIconHolder> fireworkStarFadeButtons = new ArrayList<CustomRecipeIconHolder>();
    protected final List<CustomRecipeIconHolder> fireworkButtons = new ArrayList<CustomRecipeIconHolder>();
    protected final List<List<List<RecipeInfo<CraftingRecipe>>>> recipesByTab = new ArrayList<List<List<RecipeInfo<CraftingRecipe>>>>();
    protected List<List<RecipeInfo<CraftingRecipe>>> filteredRecipesByGroup = Collections.emptyList();
    protected final Stocker.Sizeable page = new Stocker.Sizeable(Integer.valueOf(0));
    protected final Stocker.Sizeable craftingButtonsOffset = new Stocker.Sizeable(Integer.valueOf(0));
    protected final TabList craftingTabList = new TabList(this.accessor, (List<LegacyTabButton>)new PagedList(this.page, this::getMaxTabCount));
    protected final TabList bannerTabList = new TabList(this.accessor);
    protected final TabList fireworkTabList = new TabList(this.accessor);
    protected final TabList dyeTabList = new TabList(this.accessor);
    protected final TabList typeTabList = new TabList(this.accessor).add(0, 0, 42, 42, LegacyTabButton.Type.MIDDLE, LegacyTabButton.iconOf(Items.CRAFTING_TABLE), CommonComponents.EMPTY, null, b -> this.resetElements()).add(0, 0, 42, 42, LegacyTabButton.Type.MIDDLE, LegacyTabButton.iconOf(Items.WHITE_BANNER), CommonComponents.EMPTY, null, b -> this.resetElements()).add(0, 0, 42, 42, LegacyTabButton.Type.MIDDLE, LegacyTabButton.iconOf(Items.FIREWORK_ROCKET), CommonComponents.EMPTY, null, b -> this.resetElements()).add(0, 0, 42, 42, LegacyTabButton.Type.MIDDLE, LegacyTabButton.iconOf(Items.CYAN_DYE), CommonComponents.EMPTY, null, b -> this.resetElements());
    protected final LegacyScrollRenderer scrollRenderer = new LegacyScrollRenderer();
    protected final ScrollableRenderer scrollableRenderer = new ScrollableRenderer();
    private final boolean[] warningSlots;
    protected final ContainerListener listener = new ContainerListener(){

        public void slotChanged(AbstractContainerMenu abstractContainerMenu, int i, ItemStack itemStack) {
            LegacyIconHolder legacyIconHolder;
            if (LegacyCraftingScreen.this.onlyCraftableRecipes && LegacyCraftingScreen.this.typeTabList.selectedTab == 0) {
                LegacyCraftingScreen.this.filteredRecipesByGroup = LegacyCraftingScreen.this.recipesByTab.get(LegacyCraftingScreen.this.craftingTabList.selectedTab).stream().map(l -> l.stream().filter(r -> RecipeMenu.canCraft(r.getOptionalIngredients(), LegacyCraftingScreen.this.inventory, abstractContainerMenu.getCarried())).toList()).filter(l -> !l.isEmpty()).toList();
                LegacyCraftingScreen.this.craftingButtons.get(LegacyCraftingScreen.this.selectedCraftingButton).updateRecipeDisplay();
            } else if (LegacyCraftingScreen.this.getCraftingButtons().size() > LegacyCraftingScreen.this.selectedCraftingButton && (legacyIconHolder = LegacyCraftingScreen.this.getCraftingButtons().get(LegacyCraftingScreen.this.selectedCraftingButton)) instanceof CustomCraftingIconHolder) {
                CustomCraftingIconHolder h = (CustomCraftingIconHolder)legacyIconHolder;
                h.updateRecipe();
            }
        }

        public void dataChanged(AbstractContainerMenu abstractContainerMenu, int i, int j) {
        }
    };
    protected int selectedCraftingButton;
    public static final Item[] VANILLA_CATEGORY_ICONS = new Item[]{Items.BRICKS, Items.REDSTONE, Items.GOLDEN_SWORD, Items.LAVA_BUCKET};

    public static LegacyCraftingScreen craftingScreen(LegacyCraftingMenu abstractContainerMenu, Inventory inventory, Component component) {
        return new LegacyCraftingScreen(abstractContainerMenu, inventory, component, false);
    }

    public static LegacyCraftingScreen playerCraftingScreen(LegacyCraftingMenu abstractContainerMenu, Inventory inventory, Component component) {
        return new LegacyCraftingScreen(abstractContainerMenu, inventory, component, true);
    }

    public LegacyCraftingScreen(LegacyCraftingMenu abstractContainerMenu, Inventory inventory, Component component, boolean is2x2) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
        this.inventory = inventory;
        this.is2x2 = is2x2;
        this.gridDimension = is2x2 ? 2 : 3;
        this.ingredientsGrid = new ArrayList(Collections.nCopies(this.gridDimension * this.gridDimension, Optional.empty()));
        this.container = new TransientCraftingContainer((AbstractContainerMenu)abstractContainerMenu, this.gridDimension, this.gridDimension);
        this.warningSlots = new boolean[this.gridDimension * this.gridDimension];
        if (Minecraft.getInstance().level == null) {
            return;
        }
        List<RecipeInfo> allRecipes = CommonRecipeManager.byType((RecipeType)RecipeType.CRAFTING).stream().map(h -> {
            List<Optional<Ingredient>> list;
            ResourceLocation resourceLocation = h.id();
            CraftingRecipe craftingRecipe = (CraftingRecipe)h.value();
            Recipe patt0$temp = h.value();
            if (patt0$temp instanceof ShapedRecipe) {
                ShapedRecipe rcp = (ShapedRecipe)patt0$temp;
                list = LegacyCraftingMenu.updateShapedIngredients(new ArrayList<Optional<Ingredient>>(this.ingredientsGrid), LegacyCraftingMenu.getRecipeOptionalIngredients(rcp), this.gridDimension, rcp.getWidth(), rcp.getHeight());
            } else {
                Recipe patt1$temp = h.value();
                if (patt1$temp instanceof ShapelessRecipe) {
                    ShapelessRecipe r = (ShapelessRecipe)patt1$temp;
                    list = LegacyCraftingMenu.getRecipeOptionalIngredients(r);
                } else {
                    list = Collections.emptyList();
                }
            }
            return RecipeInfo.create(resourceLocation, craftingRecipe, list, ((CraftingRecipe)h.value()).isSpecial() ? ItemStack.EMPTY : ((CraftingRecipe)h.value()).assemble((Container)this.container, Minecraft.getInstance().level.registryAccess()));
        }).filter(h -> h.getOptionalIngredients().size() <= this.ingredientsGrid.size()).toList();
        for (LegacyCraftingTabListing listing : LegacyCraftingTabListing.map.values()) {
            ArrayList groups = new ArrayList();
            listing.craftings().values().forEach(l -> {
                if (l.isEmpty()) {
                    return;
                }
                ArrayList<RecipeInfo> group = new ArrayList<RecipeInfo>();
                l.forEach(v -> v.addRecipes(allRecipes, group::add));
                group.removeIf(i -> i.isInvalid() || i.getOptionalIngredients().size() > this.ingredientsGrid.size());
                if (!group.isEmpty()) {
                    groups.add(group);
                }
            });
            if (groups.isEmpty()) continue;
            this.recipesByTab.add(groups);
            this.craftingTabList.addTabButton(43, LegacyTabButton.Type.MIDDLE, listing.icon(), listing.name(), t -> this.resetElements());
        }
        Collector<RecipeInfo, ?, Map<String, List<RecipeInfo>>> recipesByGroupsCollector = Collectors.groupingBy(h -> ((CraftingRecipe)h.get()).getGroup().isEmpty() ? h.getId().toString() : ((CraftingRecipe)h.get()).getGroup());
        if (((Boolean)LegacyOptions.vanillaTabs.get()).booleanValue()) {
            allRecipes.stream().collect(Collectors.groupingBy(h -> ((CraftingRecipe)h.get()).category(), () -> new TreeMap(Comparator.comparingInt(Enum::ordinal)), recipesByGroupsCollector)).forEach((category, m) -> {
                if (m.isEmpty()) {
                    return;
                }
                ArrayList groups = new ArrayList();
                m.values().forEach(l -> {
                    l.removeIf(i -> i.isInvalid() || i.getOptionalIngredients().size() > this.ingredientsGrid.size());
                    if (!l.isEmpty()) {
                        groups.add(l);
                    }
                });
                if (groups.isEmpty()) {
                    return;
                }
                this.recipesByTab.add(groups);
                this.craftingTabList.addTabButton(43, LegacyTabButton.Type.MIDDLE, LegacyTabButton.iconOf(VANILLA_CATEGORY_ICONS[category.ordinal()]), this.getTitle(), t -> this.resetElements());
            });
        }
        if (((Boolean)LegacyOptions.modCraftingTabs.get()).booleanValue()) {
            allRecipes.stream().collect(Collectors.groupingBy(h -> h.getId().getNamespace(), () -> new TreeMap(Comparator.naturalOrder()), recipesByGroupsCollector)).forEach((namespace, m) -> {
                ModInfo modInfo = FactoryAPIPlatform.getModInfo((String)namespace);
                if (modInfo == null || namespace.equals("minecraft") || namespace.equals("legacy") || m.isEmpty()) {
                    return;
                }
                ArrayList groups = new ArrayList();
                m.values().forEach(l -> {
                    l.removeIf(i -> i.isInvalid() || i.getOptionalIngredients().size() > this.ingredientsGrid.size());
                    if (!l.isEmpty()) {
                        groups.add(l);
                    }
                });
                if (groups.isEmpty()) {
                    return;
                }
                this.recipesByTab.add(groups);
                this.craftingTabList.addTabButton(43, LegacyTabButton.Type.MIDDLE, LegacyTabButton.iconOf(ModsScreen.modLogosCache.apply(modInfo)), (Component)Component.literal((String)modInfo.getName()), t -> this.resetElements());
            });
        }
        this.resetElements(false);
        this.addCraftingButtons();
        this.accessor.getStaticDefinitions().add(UIDefinition.createBeforeInit(a -> this.accessor.putStaticElement("is2x2", (Object)is2x2)));
        ItemStack redStar = Items.FIREWORK_STAR.getDefaultInstance();
        CompoundTag redStarTag = redStar.getOrCreateTag();
        CompoundTag explosionTag = new CompoundTag();
        redStarTag.put("Explosion", (Tag)explosionTag);
        explosionTag.putIntArray("Colors", List.of(Integer.valueOf(DyeColor.RED.getFireworkColor())));
        this.bannerTabList.add(0, 0, 0, 43, LegacyTabButton.Type.MIDDLE, LegacyTabButton.iconOf(Items.WHITE_BANNER), CommonComponents.EMPTY, null, b -> this.resetElements());
        this.bannerTabList.add(0, 0, 0, 43, LegacyTabButton.Type.MIDDLE, LegacyTabButton.iconOf(Items.SHIELD), CommonComponents.EMPTY, null, b -> this.resetElements());
        this.fireworkTabList.add(0, 0, 0, 43, LegacyTabButton.Type.MIDDLE, LegacyTabButton.iconOf(Items.FIREWORK_STAR), CommonComponents.EMPTY, null, b -> this.resetElements());
        this.fireworkTabList.add(0, 0, 0, 43, LegacyTabButton.Type.MIDDLE, LegacyTabButton.iconOf(redStar), CommonComponents.EMPTY, null, b -> this.resetElements());
        this.fireworkTabList.add(0, 0, 0, 43, LegacyTabButton.Type.MIDDLE, LegacyTabButton.iconOf(Items.FIREWORK_ROCKET), CommonComponents.EMPTY, null, b -> this.resetElements());
        this.dyeTabList.add(0, 0, 0, 43, LegacyTabButton.Type.MIDDLE, LegacyTabButton.iconOf(Legacy4J.dyeItem(Items.LEATHER_CHESTPLATE.getDefaultInstance(), Legacy4J.getDyeColor(DyeColor.GREEN))), CommonComponents.EMPTY, null, b -> this.resetElements());
        this.dyeTabList.add(0, 0, 0, 43, LegacyTabButton.Type.MIDDLE, this.typeTabList.tabButtons.get((int)3).icon, CommonComponents.EMPTY, null, b -> this.resetElements());
        if (!is2x2) {
            this.dyeTabList.add(0, 0, 0, 43, LegacyTabButton.Type.MIDDLE, LegacyTabButton.iconOf(Items.DECORATED_POT), CommonComponents.EMPTY, null, b -> this.resetElements());
        }
        Consumer<CustomCraftingIconHolder> fireworkStarUpdateRecipe = h -> {
            LegacyCraftingScreen.clearIngredients(this.ingredientsGrid);
            if (this.fireworkStarButtons.isEmpty()) {
                return;
            }
            LegacyCraftingMenu.updateShapedIngredients(this.ingredientsGrid, List.of(Optional.empty(), Optional.of(FactoryIngredient.of((ItemStack[])new ItemStack[]{this.fireworkStarButtons.get((int)0).itemIcon}).toIngredient()), Optional.empty(), Optional.of(FireworkStarRecipeAccessor.getGunpowderIngredient())), this.gridDimension, 2, 2);
            this.fireworkStarButtons.forEach(CustomRecipeIconHolder::applyAddedIngredients);
            this.resultStack = this.fireworkStarButtons.get(0).hasItem() ? h.assembleCraftingResult((Level)this.minecraft.level, this.container) : Items.FIREWORK_STAR.getDefaultInstance();
            this.canCraft(this.ingredientsGrid, true);
        };
        Consumer<CustomCraftingIconHolder> fireworkStarFadeUpdateRecipe = h -> {
            LegacyCraftingScreen.clearIngredients(this.ingredientsGrid);
            if (this.fireworkStarFadeButtons.isEmpty()) {
                return;
            }
            ItemStack item = this.fireworkStarFadeButtons.get((int)0).itemIcon.isEmpty() ? Items.FIREWORK_STAR.getDefaultInstance() : this.fireworkStarFadeButtons.get((int)0).itemIcon.copyWithCount(1);
            LegacyCraftingMenu.updateShapedIngredients(this.ingredientsGrid, List.of(Optional.empty(), Optional.of(FactoryIngredient.of((ItemStack[])new ItemStack[]{this.fireworkStarFadeButtons.get((int)1).itemIcon}).toIngredient()), Optional.empty(), Optional.of(StackIngredient.of((boolean)true, (ItemStack)item))), this.gridDimension, 2, 2);
            this.fireworkStarFadeButtons.get(1).applyAddedIngredients();
            this.resultStack = this.fireworkStarFadeButtons.get((int)0).itemIcon.isEmpty() ? item : h.assembleCraftingResult((Level)Minecraft.getInstance().level, this.container);
            this.canCraft(this.ingredientsGrid, true);
        };
        Consumer<CustomCraftingIconHolder> fireworkRocketUpdateRecipe = h -> {
            LegacyCraftingScreen.clearIngredients(this.ingredientsGrid);
            if (this.fireworkButtons.isEmpty()) {
                return;
            }
            LegacyCraftingMenu.updateShapedIngredients(this.ingredientsGrid, List.of(Optional.empty(), Optional.of(FactoryIngredient.of((ItemStack[])new ItemStack[]{this.fireworkButtons.get((int)0).itemIcon}).toIngredient()), Optional.empty(), Optional.of(FireworkRocketRecipeAccessor.getPaperIngredient())), this.gridDimension, 2, 2);
            this.fireworkButtons.forEach(CustomRecipeIconHolder::applyAddedIngredients);
            this.resultStack = this.fireworkButtons.get(0).hasItem() ? h.assembleCraftingResult((Level)Minecraft.getInstance().level, this.container) : new ItemStack((ItemLike)Items.FIREWORK_ROCKET, 3);
            this.canCraft(this.ingredientsGrid, true);
        };
        Consumer<CustomCraftingIconHolder> dyeArmorUpdateRecipe = h -> {
            LegacyCraftingScreen.clearIngredients(this.ingredientsGrid);
            if (this.dyeArmorButtons.isEmpty()) {
                return;
            }
            ItemStack armor = this.dyeArmorButtons.get((int)0).itemIcon.isEmpty() ? Items.LEATHER_HELMET.getDefaultInstance() : this.dyeArmorButtons.get((int)0).itemIcon.copyWithCount(1);
            LegacyCraftingMenu.updateShapedIngredients(this.ingredientsGrid, List.of(Optional.empty(), Optional.of(Ingredient.of((ItemLike[])new ItemLike[]{this.dyeArmorButtons.get((int)1).itemIcon.getItem()})), Optional.empty(), Optional.of(StackIngredient.of((boolean)true, (ItemStack)armor))), this.gridDimension, 2, 2);
            this.dyeArmorButtons.forEach(CustomRecipeIconHolder::applyAddedIngredients);
            this.resultStack = this.dyeArmorButtons.get((int)0).itemIcon.isEmpty() || !this.dyeArmorButtons.get(1).hasItem() ? armor : h.assembleCraftingResult((Level)Minecraft.getInstance().level, this.container);
            this.canCraft(this.ingredientsGrid, true);
        };
        Consumer<CustomCraftingIconHolder> dyeItemUpdateRecipe = h -> {
            LegacyCraftingScreen.clearIngredients(this.ingredientsGrid);
            if (this.dyeItemButtons.isEmpty()) {
                return;
            }
            ItemStack item = this.dyeItemButtons.get((int)0).itemIcon.isEmpty() ? Items.WHITE_BED.getDefaultInstance() : this.dyeItemButtons.get((int)0).itemIcon.copyWithCount(1);
            Optional<Ingredient> dyeIngredient = Optional.of(Ingredient.of((ItemLike[])new ItemLike[]{this.dyeItemButtons.get((int)1).itemIcon.getItem()}));
            LegacyCraftingMenu.updateShapedIngredients(this.ingredientsGrid, List.of(Optional.empty(), dyeIngredient, Optional.empty(), Optional.of(StackIngredient.of((boolean)true, (ItemStack)item))), this.gridDimension, 2, 2);
            ItemStack itemStack = this.resultStack = this.dyeItemButtons.get((int)0).itemIcon.isEmpty() ? item : h.assembleCraftingResult((Level)Minecraft.getInstance().level, this.container);
            if (this.resultStack.isEmpty()) {
                this.resultStack = item;
                this.ingredientsGrid.set(this.ingredientsGrid.indexOf(dyeIngredient), Optional.of(new ImpossibleIngredient(this.dyeItemButtons.get((int)1).itemIcon)));
            }
            this.canCraft(this.ingredientsGrid, true);
        };
        List<ItemStack> dyes = Arrays.stream(DyeColor.values()).map(c -> DyeItem.byColor((DyeColor)c).getDefaultInstance()).toList();
        this.fireworkStarButtons.add(this.craftingButtonByList(LegacyComponents.COLOR_TAB, dyes, fireworkStarUpdateRecipe).enableAddIngredients());
        this.fireworkStarButtons.add(this.craftingButtonByList(LegacyComponents.SHAPE_TAB, FireworkStarRecipeAccessor.getShapeByItem().keySet().stream().map(ItemStack::new).toList(), fireworkStarUpdateRecipe).enableAddIngredients(h -> this.ingredientsGrid.stream().noneMatch(i -> i.isPresent() && Arrays.stream(FactoryIngredient.of((Ingredient)((Ingredient)i.get())).getStacks()).anyMatch(item -> FireworkStarRecipeAccessor.getShapeByItem().containsKey(item.getItem())))));
        this.fireworkStarButtons.add(this.craftingButtonByList(LegacyComponents.EFFECT_TAB, Stream.concat(Arrays.stream(FactoryIngredient.of((Ingredient)FireworkStarRecipeAccessor.getTwinkleIngredient()).getStacks()), Arrays.stream(FactoryIngredient.of((Ingredient)FireworkStarRecipeAccessor.getTrailIngredient()).getStacks())).toList(), fireworkStarUpdateRecipe).enableAddIngredients(h -> this.ingredientsGrid.stream().noneMatch(i -> i.isPresent() && ((Ingredient)i.get()).test(h.itemIcon))));
        this.fireworkStarFadeButtons.add(this.craftingButtonByPredicate(LegacyComponents.SELECT_STAR_TAB, i -> i.is(Items.FIREWORK_STAR), fireworkStarFadeUpdateRecipe));
        this.fireworkStarFadeButtons.add(this.craftingButtonByList(LegacyComponents.ADD_FADE_TAB, dyes, fireworkStarFadeUpdateRecipe).enableAddIngredients());
        this.fireworkButtons.add(this.craftingButtonByList(LegacyComponents.ADD_POWER_TAB, Arrays.stream(FactoryIngredient.of((Ingredient)FireworkRocketRecipeAccessor.getGunpowderIngredient()).getStacks()).toList(), fireworkRocketUpdateRecipe).enableAddIngredients(h -> this.ingredientsGrid.stream().filter(i -> i.isPresent() && ((Ingredient)i.get()).equals((Object)FireworkRocketRecipeAccessor.getGunpowderIngredient())).count() < 3L));
        this.fireworkButtons.add(this.craftingButtonByPredicate(LegacyComponents.SELECT_STAR_TAB, i -> i.is(Items.FIREWORK_STAR) && i.hasTag() && i.getTag().contains("Explosion"), fireworkRocketUpdateRecipe).enableAddIngredients());
        this.dyeArmorButtons.add(this.craftingButtonByPredicate((Component)Component.translatable((String)"legacy.container.tab.armour"), i -> i.getItem() instanceof DyeableLeatherItem, dyeArmorUpdateRecipe));
        this.dyeArmorButtons.add(this.craftingButtonByList(LegacyComponents.COLOR_TAB, dyes, dyeArmorUpdateRecipe).enableAddIngredients());
        this.dyeItemButtons.add(this.craftingButtonByPredicate((Component)Component.translatable((String)"entity.minecraft.item"), i -> {
            BlockItem b;
            Item patt0$temp;
            return i.getItem() instanceof BedItem || (patt0$temp = i.getItem()) instanceof BlockItem && (b = (BlockItem)patt0$temp).getBlock() instanceof ShulkerBoxBlock;
        }, dyeItemUpdateRecipe));
        this.dyeItemButtons.add(this.craftingButtonByList(LegacyComponents.COLOR_TAB, dyes, dyeItemUpdateRecipe));
        if (!is2x2) {
            this.bannerButtons.add(this.craftingButtonByRecipes(LegacyComponents.CREATE_BANNER_TAB, Arrays.stream(DyeColor.values()).flatMap(c -> allRecipes.stream().filter(new RecipeInfo.Filter.ItemId(BuiltInRegistries.ITEM.getKey((Object)BannerBlock.byColor((DyeColor)c).asItem())))).toList()));
        }
        this.bannerButtons.add(this.craftingButtonByPredicate(LegacyComponents.COPY_BANNER, i -> i.getItem() instanceof BannerItem && Legacy4J.itemHasValidPatterns(i), h -> {
            LegacyCraftingScreen.clearIngredients(this.ingredientsGrid);
            if (this.bannerButtons.isEmpty() || h.itemIcon.isEmpty()) {
                return;
            }
            LegacyCraftingMenu.updateShapedIngredients(this.ingredientsGrid, List.of(Optional.empty(), Optional.empty(), Optional.of(StackIngredient.of((boolean)true, (ItemStack)h.itemIcon.getItem().getDefaultInstance())), Optional.of(StackIngredient.of((boolean)true, (ItemStack)h.itemIcon.copyWithCount(1)))), this.gridDimension, 2, 2);
            this.resultStack = h.itemIcon.copyWithCount(1);
            this.canCraft(this.ingredientsGrid, true);
        }));
        Consumer<CustomCraftingIconHolder> decorateShieldUpdateRecipe = h -> {
            LegacyCraftingScreen.clearIngredients(this.ingredientsGrid);
            if (this.decorateShieldButtons.isEmpty()) {
                return;
            }
            ItemStack inputStack = this.decorateShieldButtons.get((int)0).itemIcon.isEmpty() ? Items.SHIELD.getDefaultInstance() : this.decorateShieldButtons.get((int)0).itemIcon.copyWithCount(1);
            LegacyCraftingMenu.updateShapedIngredients(this.ingredientsGrid, List.of(Optional.empty(), Optional.empty(), Optional.of(StackIngredient.of((boolean)true, (ItemStack)inputStack.copy())), Optional.of(StackIngredient.of((boolean)true, (ItemStack)(this.decorateShieldButtons.get((int)1).itemIcon.isEmpty() ? Items.WHITE_BANNER.getDefaultInstance() : this.decorateShieldButtons.get((int)1).itemIcon.copyWithCount(1))))), this.gridDimension, 2, 2);
            this.resultStack = this.decorateShieldButtons.get((int)0).itemIcon.isEmpty() ? inputStack : h.assembleCraftingResult((Level)this.minecraft.level, this.container);
            this.canCraft(this.ingredientsGrid, true);
        };
        this.decorateShieldButtons.add(this.craftingButtonByPredicate(LegacyComponents.SELECT_SHIELD, i -> i.getItem() instanceof ShieldItem && Legacy4J.getItemPatternsCount(i) == 0, decorateShieldUpdateRecipe));
        this.decorateShieldButtons.add(this.craftingButtonByPredicate(LegacyComponents.SELECT_BANNER_TAB, i -> i.getItem() instanceof BannerItem, decorateShieldUpdateRecipe));
        this.decoratedPotButtons.add(this.craftingButtonByList(LegacyComponents.ADD_SHERD, DecoratedPotPatterns.ITEM_TO_POT_TEXTURE.keySet().stream().map(Item::getDefaultInstance).toList(), h -> {
            LegacyCraftingScreen.clearIngredients(this.ingredientsGrid);
            if (is2x2) {
                return;
            }
            Function<Integer, Item> sherdByIndex = i -> h.addedIngredientsItems.size() > i ? ((ItemStack)h.addedIngredientsItems.get((int)i)).getItem() : Items.BRICK;
            LegacyCraftingMenu.updateShapedIngredients(this.ingredientsGrid, List.of(Optional.empty(), Optional.of(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)sherdByIndex.apply(0)})), Optional.empty(), Optional.of(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)sherdByIndex.apply(1)})), Optional.empty(), Optional.of(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)sherdByIndex.apply(2)})), Optional.empty(), Optional.of(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)sherdByIndex.apply(3)}))), this.gridDimension, 3, 3);
            this.resultStack = h.assembleCraftingResult((Level)this.minecraft.level, this.container);
            this.canCraft(this.ingredientsGrid, true);
        }).enableAddIngredients(h -> h.addedIngredientsItems.size() < 4));
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        ControlTooltip.setupDefaultButtons(renderer, (Screen)this);
        ControlTooltip.Event.super.addControlTooltips(renderer);
        renderer.add(() -> ControlTooltip.EXTRA.get(), () -> {
            Component component;
            if (this.typeTabList.selectedTab == 0) {
                component = LegacyComponents.INFO;
                return component;
            } else {
                GuiEventListener patt0$temp = this.getFocused();
                if (!(patt0$temp instanceof CustomCraftingIconHolder)) return null;
                CustomCraftingIconHolder h = (CustomCraftingIconHolder)patt0$temp;
                if (h.addedIngredientsItems == null) return null;
                if (h.addedIngredientsItems.isEmpty()) return null;
                component = LegacyComponents.REMOVE;
            }
            return component;
        }).add(() -> ControlTooltip.OPTION.get(), () -> this.typeTabList.selectedTab == 0 ? (this.onlyCraftableRecipes ? LegacyComponents.ALL_RECIPES : LegacyComponents.SHOW_CRAFTABLE_RECIPES) : ControlTooltip.getKeyMessage(79, (Screen)this)).add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.COMPOUND_ICON_FUNCTION.apply(new ControlTooltip.Icon[]{ControlTooltip.getKeyIcon(340), ControlTooltip.PLUS_ICON, ControlTooltip.getKeyIcon(91), ControlTooltip.SPACE_ICON, ControlTooltip.getKeyIcon(93)}) : ControlTooltip.COMPOUND_ICON_FUNCTION.apply(new ControlTooltip.Icon[]{ControllerBinding.LEFT_TRIGGER.getIcon(), ControlTooltip.SPACE_ICON, ControllerBinding.RIGHT_TRIGGER.getIcon()}), () -> this.hasTypeTabList() ? LegacyComponents.TYPE : null).addCompound(() -> new ControlTooltip.Icon[]{ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(91) : ControllerBinding.LEFT_BUMPER.getIcon(), ControlTooltip.SPACE_ICON, ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(93) : ControllerBinding.RIGHT_BUMPER.getIcon()}, () -> LegacyComponents.GROUP).add(() -> this.page.max > 0 && this.typeTabList.selectedTab == 0 ? (ControlType.getActiveType().isKbm() ? ControlTooltip.COMPOUND_ICON_FUNCTION.apply(new ControlTooltip.Icon[]{ControlTooltip.getKeyIcon(340), ControlTooltip.PLUS_ICON, ControlTooltip.getKeyIcon(263), ControlTooltip.SPACE_ICON, ControlTooltip.getKeyIcon(262)}) : ControllerBinding.RIGHT_STICK.getIcon()) : null, () -> LegacyComponents.PAGE);
    }

    public void resetElements() {
        this.resetElements(true);
    }

    public void resetElements(boolean reposition) {
        this.listener.slotChanged(this.menu, -1, ItemStack.EMPTY);
        this.selectedCraftingButton = 0;
        this.infoType.set(Integer.valueOf(0));
        this.craftingButtonsOffset.set(Integer.valueOf(0));
        if (reposition) {
            this.repositionElements();
        }
    }

    protected CustomCraftingIconHolder craftingButtonByRecipes(final Component displayName, final List<RecipeInfo<CraftingRecipe>> recipes) {
        final List<ItemStack> results = recipes.stream().map(RecipeInfo::getResultItem).toList();
        return new CustomCraftingIconHolder(results.get(0)){

            @Override
            public Component getDisplayName() {
                return displayName;
            }

            @Override
            public ItemStack nextItem() {
                return this.nextItem(results);
            }

            @Override
            public ItemStack previousItem() {
                return this.previousItem(results);
            }

            @Override
            public int findInventoryMatchSlot() {
                return -1;
            }

            @Override
            public void updateRecipe() {
                LegacyCraftingScreen.this.scrollableRenderer.scrolled.set(Integer.valueOf(0));
                LegacyCraftingScreen.this.ingredientsGrid.clear();
                LegacyCraftingScreen.this.ingredientsGrid.addAll(((RecipeInfo)recipes.get(results.indexOf(this.itemIcon))).getOptionalIngredients());
                LegacyCraftingScreen.this.resultStack = this.itemIcon.copyWithCount(1);
                LegacyCraftingScreen.this.canCraft(LegacyCraftingScreen.this.ingredientsGrid, true);
            }

            @Override
            protected boolean hasItem(ItemStack stack) {
                return LegacyCraftingScreen.this.canCraft(((RecipeInfo)recipes.get(results.indexOf(stack))).getOptionalIngredients(), false);
            }

            @Override
            public void craft() {
                ScreenUtil.playSimpleUISound(SoundEvents.ITEM_PICKUP, 1.0f);
                CommonNetwork.sendToServer((CommonNetwork.Payload)new ServerMenuCraftPayload((RecipeInfo)recipes.get(results.indexOf(this.itemIcon)), Screen.hasShiftDown() || ControllerBinding.LEFT_STICK_BUTTON.state().pressed));
            }
        };
    }

    protected CustomCraftingIconHolder craftingButtonByList(final Component displayName, final List<ItemStack> itemStacks, final Consumer<CustomCraftingIconHolder> updateRecipe) {
        return new CustomCraftingIconHolder(itemStacks.get(0)){

            @Override
            public Component getDisplayName() {
                return displayName;
            }

            @Override
            public ItemStack nextItem() {
                return this.nextItem(itemStacks);
            }

            @Override
            public ItemStack previousItem() {
                return this.previousItem(itemStacks);
            }

            @Override
            public int findInventoryMatchSlot() {
                for (int i = 0; i < ((LegacyCraftingMenu)((LegacyCraftingScreen)LegacyCraftingScreen.this).menu).slots.size(); ++i) {
                    if (!((Slot)((LegacyCraftingMenu)((LegacyCraftingScreen)LegacyCraftingScreen.this).menu).slots.get(i)).getItem().is(this.itemIcon.getItem())) continue;
                    return i;
                }
                return 0;
            }

            @Override
            public void updateRecipe() {
                LegacyCraftingScreen.this.scrollableRenderer.scrolled.set(Integer.valueOf(0));
                updateRecipe.accept(this);
            }
        };
    }

    protected CustomCraftingIconHolder craftingButtonByPredicate(final Component displayName, final Predicate<ItemStack> isValid, final Consumer<CustomCraftingIconHolder> updateRecipe) {
        return new CustomCraftingIconHolder(){

            @Override
            public Component getDisplayName() {
                return displayName;
            }

            @Override
            public ItemStack nextItem() {
                return this.nextItem(LegacyCraftingScreen.this.inventory, isValid);
            }

            @Override
            public ItemStack previousItem() {
                return this.previousItem(LegacyCraftingScreen.this.inventory, isValid);
            }

            @Override
            public boolean applyNextItemIfAbsent() {
                return true;
            }

            @Override
            public int findInventoryMatchSlot() {
                for (int i = 0; i < ((LegacyCraftingMenu)((LegacyCraftingScreen)LegacyCraftingScreen.this).menu).slots.size(); ++i) {
                    if (((Slot)((LegacyCraftingMenu)((LegacyCraftingScreen)LegacyCraftingScreen.this).menu).slots.get(i)).getItem() != this.itemIcon) continue;
                    return i;
                }
                this.itemIcon = this.nextItem;
                return this.itemIcon.isEmpty() ? 0 : this.findInventoryMatchSlot();
            }

            @Override
            void updateRecipe() {
                updateRecipe.accept(this);
            }
        };
    }

    public void setFocused(@Nullable GuiEventListener guiEventListener) {
        if (guiEventListener instanceof TabList) {
            return;
        }
        super.setFocused(guiEventListener);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int i, int j) {
        LegacyIconHolder legacyIconHolder;
        Component component;
        if (this.getTabList() == this.craftingTabList) {
            component = this.getTabList().tabButtons.get(this.getTabList().selectedTab).getMessage();
        } else {
            GuiEventListener guiEventListener = this.getFocused();
            if (guiEventListener instanceof CustomCraftingIconHolder) {
                CustomCraftingIconHolder h = (CustomCraftingIconHolder)guiEventListener;
                component = h.getDisplayName();
            } else {
                component = CommonComponents.EMPTY;
            }
        }
        Component title = component;
        guiGraphics.drawString(this.font, title, ((this.typeTabList.selectedTab == 0 ? this.imageWidth : this.imageWidth / 2) - this.font.width((FormattedText)title)) / 2, 17, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        int inventoryPanelX = this.accessor.getInteger("inventoryPanelX", 176);
        int inventoryPanelWidth = this.accessor.getInteger("inventoryPanelWidth", 163);
        if ((Integer)this.infoType.get() <= 0) {
            guiGraphics.drawString(this.font, this.playerInventoryTitle, inventoryPanelX + (inventoryPanelWidth - this.font.width((FormattedText)this.playerInventoryTitle)) / 2, this.accessor.getInteger("bottomPanelTitleY", 114), ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        } else if (this.selectedCraftingButton < this.getCraftingButtons().size() && (legacyIconHolder = this.getCraftingButtons().get(this.selectedCraftingButton)) instanceof RecipeIconHolder) {
            RecipeIconHolder h = (RecipeIconHolder)legacyIconHolder;
            if ((Integer)this.infoType.get() == 1 && LegacyTipManager.hasTip(h.getFocusedResult())) {
                List l = this.font.split((FormattedText)LegacyTipManager.getTipComponent(h.getFocusedResult()), inventoryPanelWidth - 11);
                this.scrollableRenderer.scrolled.max = Math.max(0, l.size() - 7);
                this.scrollableRenderer.render(guiGraphics, inventoryPanelX + 5, 105, inventoryPanelWidth - 11, 84, () -> {
                    for (int i1 = 0; i1 < l.size(); ++i1) {
                        guiGraphics.drawString(this.font, (FormattedCharSequence)l.get(i1), inventoryPanelX + 5, 108 + i1 * 12, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
                    }
                });
            } else if ((Integer)this.infoType.get() == 2) {
                guiGraphics.drawString(this.font, LegacyComponents.INGREDIENTS, inventoryPanelX + (inventoryPanelWidth - this.font.width((FormattedText)LegacyComponents.INGREDIENTS)) / 2, 108, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
                if (h.getFocusedRecipe() != null) {
                    this.compactItemStackList.clear();
                    RecipeMenu.handleCompactItemStackList(this.compactItemStackList, () -> h.getFocusedRecipe().getOptionalIngredients().stream().map(RecipeIconHolder::getActualItem).iterator());
                    this.scrollableRenderer.scrolled.max = Math.max(0, this.compactItemStackList.size() - 4);
                    this.scrollableRenderer.render(guiGraphics, inventoryPanelX + 2, 122, 152, 60, () -> {
                        for (int i1 = 0; i1 < this.compactItemStackList.size(); ++i1) {
                            ItemStack ing = this.compactItemStackList.get(i1);
                            ScreenUtil.iconHolderRenderer.itemHolder(inventoryPanelX + 4, 124 + 15 * i1, 14, 14, ing, false, Vec3.ZERO).render(guiGraphics, i, j, 0.0f);
                            guiGraphics.pose().pushPose();
                            guiGraphics.pose().translate((float)(inventoryPanelX + 22), (float)(128 + 15 * i1), 0.0f);
                            Legacy4JClient.applyFontOverrideIf(ScreenUtil.is720p(), LegacyIconHolder.MOJANGLES_11_FONT, b -> {
                                if (!b.booleanValue()) {
                                    guiGraphics.pose().scale(0.6666667f, 0.6666667f, 0.6666667f);
                                }
                                guiGraphics.drawString(this.font, ing.getHoverName(), 0, 0, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
                            });
                            guiGraphics.pose().popPose();
                        }
                    });
                }
            }
        }
        guiGraphics.pose().translate((float)(-this.leftPos), (float)(-this.topPos), 0.0f);
        this.getCraftingButtons().forEach(b -> b.render(guiGraphics, i, j, 0.0f));
        if (this.selectedCraftingButton < this.getCraftingButtons().size()) {
            this.getCraftingButtons().get(this.selectedCraftingButton).renderSelection(guiGraphics, i, j, 0.0f);
        }
        guiGraphics.pose().translate((float)this.leftPos, (float)this.topPos, 0.0f);
    }

    @Override
    public void bindingStateTick(BindingState state) {
        if (state.pressed && state.canClick()) {
            if ((state.is(ControllerBinding.LEFT_TRIGGER) || state.is(ControllerBinding.RIGHT_TRIGGER)) && this.hasTypeTabList()) {
                this.typeTabList.controlTab(state.is(ControllerBinding.LEFT_TRIGGER), state.is(ControllerBinding.RIGHT_TRIGGER));
            }
            if (state.is(ControllerBinding.RIGHT_STICK) && state instanceof BindingState.Axis) {
                BindingState.Axis s = (BindingState.Axis)state;
                this.controlPage(s.x < 0.0f && -s.x > Math.abs(s.y), s.x > 0.0f && s.x > Math.abs(s.y));
            }
        }
    }

    protected void init() {
        this.resultStack = ItemStack.EMPTY;
        this.imageWidth = 348;
        this.imageHeight = 215;
        super.init();
        if (this.hasTypeTabList()) {
            this.leftPos += 21;
        }
        this.topPos += 18;
        ((LegacyCraftingMenu)this.menu).addSlotListener(this.listener);
        ((LegacyCraftingMenu)this.menu).inventoryActive = (Integer)this.infoType.get() <= 0;
        ((LegacyCraftingMenu)this.menu).inventoryOffset = (Vec3)this.accessor.getElementValue("inventoryOffset", (Object)LegacyCraftingMenu.DEFAULT_INVENTORY_OFFSET, Vec3.class);
        if (this.hasTypeTabList()) {
            this.addWidget(this.typeTabList);
        }
        if (this.selectedCraftingButton < this.getCraftingButtons().size()) {
            this.setFocused(this.getCraftingButtons().get(this.selectedCraftingButton));
        }
        if (this.typeTabList.selectedTab == 0 || !this.hasTypeTabList()) {
            this.craftingButtonsOffset.max = Math.max(0, this.recipesByTab.get((Integer)this.page.get() * this.getMaxTabCount() + this.craftingTabList.selectedTab).size() - 12);
            this.craftingButtons.forEach(b -> {
                b.setPos(this.leftPos + this.accessor.getInteger("craftingButtonsX", 13) + this.craftingButtons.indexOf(b) * 27, this.topPos + 38);
                this.addWidget((GuiEventListener)b);
            });
        } else {
            int size = this.getCraftingButtons().size();
            this.getCraftingButtons().forEach(b -> {
                b.setPos(this.leftPos + (size == 1 ? 77 : (size == 2 ? 52 : (size == 3 ? 21 : 8))) + this.getCraftingButtons().indexOf(b) * (size == 2 ? 62 : (size == 3 ? 55 : 45)), this.topPos + 39);
                if (size == 3) {
                    b.offset = new Vec3(0.5 + (double)this.getCraftingButtons().indexOf(b) * 0.5, 0.0, 0.0);
                }
                b.init();
                this.addWidget((GuiEventListener)b);
            });
        }
        this.addWidget(this.getTabList());
        this.getTabList().init(this.leftPos, this.topPos - 37, this.imageWidth, (t, i) -> {
            int index = this.getTabList().tabButtons.indexOf(t);
            t.type = LegacyTabButton.Type.bySize(index, this.getMaxTabCount() - 1);
            t.setWidth(51);
            t.offset = t1 -> new Vec3(this.accessor.getDouble("tabListXOffset", -1.5) * (double)this.getTabList().tabButtons.indexOf(t), t1.selected ? 0.0 : this.accessor.getDouble("tabListSelectedYOffset", 4.5), 0.0);
        });
        if (this.hasTypeTabList()) {
            this.typeTabList.init((b, i) -> {
                b.spriteRender = LegacyTabButton.ToggleableTabSprites.VERTICAL;
                b.setX(this.leftPos - b.getWidth() + 6);
                b.setY(this.topPos + i + 4);
                b.offset = t1 -> new Vec3(t1.selected ? 0.0 : 3.5, 0.5, 0.0);
            }, true);
        }
    }

    @Override
    public TabList getTabList() {
        return switch (this.typeTabList.selectedTab) {
            case 1 -> this.bannerTabList;
            case 2 -> this.fireworkTabList;
            case 3 -> this.dyeTabList;
            default -> this.craftingTabList;
        };
    }

    public boolean hasTypeTabList() {
        return this.accessor.getBoolean("hasTypeTabList", Boolean.valueOf(true));
    }

    protected boolean canCraft(List<Optional<Ingredient>> ingredients, boolean isFocused) {
        this.compactItemStackList.clear();
        RecipeMenu.handleCompactInventoryList(this.compactItemStackList, this.inventory, ((LegacyCraftingMenu)this.menu).getCarried());
        return LegacyCraftingScreen.canCraft(this.compactItemStackList, isFocused ? this.ingredientsGrid : ingredients, isFocused ? this.warningSlots : null);
    }

    public static boolean canCraft(List<ItemStack> compactItemStackList, List<Optional<Ingredient>> ings, boolean[] warningSlots) {
        boolean canCraft = true;
        boolean isAllEmpty = true;
        block0: for (int i1 = 0; i1 < ings.size(); ++i1) {
            Optional<Ingredient> ing = ings.get(i1);
            if (ing.isEmpty()) continue;
            isAllEmpty = false;
            block1: for (int c = 0; c < FactoryIngredient.of((Ingredient)ing.get()).getCount(); ++c) {
                for (ItemStack itemStack : compactItemStackList) {
                    if (itemStack.isEmpty() || !ing.get().test(itemStack.copyWithCount(1))) continue;
                    itemStack.shrink(1);
                    if (warningSlots == null) continue block1;
                    warningSlots[i1] = false;
                    continue block1;
                }
                canCraft = false;
                if (warningSlots == null) break block0;
                warningSlots[i1] = true;
            }
        }
        return canCraft && !isAllEmpty;
    }

    protected int getMaxTabCount() {
        return this.accessor.getInteger("maxTabCount", 7);
    }

    protected void addCraftingButtons() {
        for (int i = 0; i < 12; ++i) {
            final int index = i;
            RecipeIconHolder<CraftingRecipe> h = new RecipeIconHolder<CraftingRecipe>(this.leftPos + 13 + i * 27, this.topPos + 38){

                @Override
                public void render(GuiGraphics graphics, int i, int j, float f) {
                    if (this.isFocused()) {
                        LegacyCraftingScreen.this.selectedCraftingButton = index;
                    }
                    super.render(graphics, i, j, f);
                }

                @Override
                protected boolean canCraft(RecipeInfo<CraftingRecipe> rcp) {
                    if (rcp == null || LegacyCraftingScreen.this.onlyCraftableRecipes) {
                        return true;
                    }
                    return LegacyCraftingScreen.this.canCraft(rcp.getOptionalIngredients(), this.isFocused() && this.getFocusedRecipe() == rcp);
                }

                @Override
                protected List<RecipeInfo<CraftingRecipe>> getRecipes() {
                    List<List<RecipeInfo<CraftingRecipe>>> list = LegacyCraftingScreen.this.onlyCraftableRecipes ? LegacyCraftingScreen.this.filteredRecipesByGroup : LegacyCraftingScreen.this.recipesByTab.get((Integer)LegacyCraftingScreen.this.page.get() * LegacyCraftingScreen.this.getMaxTabCount() + LegacyCraftingScreen.this.craftingTabList.selectedTab);
                    return list.size() <= (Integer)LegacyCraftingScreen.this.craftingButtonsOffset.get() + index ? Collections.emptyList() : list.get((Integer)LegacyCraftingScreen.this.craftingButtonsOffset.get() + index);
                }

                @Override
                protected void toggleCraftableRecipes() {
                    LegacyCraftingScreen.this.onlyCraftableRecipes = !LegacyCraftingScreen.this.onlyCraftableRecipes;
                    LegacyCraftingScreen.this.listener.slotChanged(LegacyCraftingScreen.this.menu, 0, ItemStack.EMPTY);
                }

                @Override
                public boolean keyPressed(int i, int j, int k) {
                    if (this.controlCyclicNavigation(i, index, LegacyCraftingScreen.this.craftingButtons, LegacyCraftingScreen.this.craftingButtonsOffset, LegacyCraftingScreen.this.scrollRenderer, (Screen)LegacyCraftingScreen.this)) {
                        return true;
                    }
                    if (i == 88 && (LegacyCraftingScreen.this.typeTabList.selectedTab == 0 || LegacyCraftingScreen.this.hasTypeTabList())) {
                        LegacyCraftingScreen.this.infoType.add(1, true);
                        ((LegacyCraftingMenu)((LegacyCraftingScreen)LegacyCraftingScreen.this).menu).inventoryActive = (Integer)LegacyCraftingScreen.this.infoType.get() <= 0;
                        ScreenUtil.playSimpleUISound((SoundEvent)LegacyRegistries.FOCUS.get(), true);
                        return true;
                    }
                    return super.keyPressed(i, j, k);
                }

                @Override
                protected void updateRecipeDisplay(RecipeInfo<CraftingRecipe> rcp) {
                    LegacyCraftingScreen.this.scrollableRenderer.scrolled.set(Integer.valueOf(0));
                    LegacyCraftingScreen.this.resultStack = this.getFocusedResult();
                    LegacyCraftingScreen.clearIngredients(LegacyCraftingScreen.this.ingredientsGrid);
                    if (rcp == null) {
                        return;
                    }
                    for (int i = 0; i < rcp.getOptionalIngredients().size(); ++i) {
                        LegacyCraftingScreen.this.ingredientsGrid.set(i, rcp.getOptionalIngredients().get(i));
                    }
                }

                @Override
                public void craft() {
                    ScreenUtil.playSimpleUISound(SoundEvents.ITEM_PICKUP, 1.0f);
                    super.craft();
                }
            };
            this.craftingButtons.add(h);
            h.offset = LegacyCraftingMenu.DEFAULT_INVENTORY_OFFSET;
        }
    }

    public static void clearIngredients(List<Optional<Ingredient>> ingredientsGrid) {
        for (int i = 0; i < ingredientsGrid.size(); ++i) {
            if (!ingredientsGrid.get(i).isPresent()) continue;
            ingredientsGrid.set(i, Optional.empty());
        }
    }

    public boolean mouseScrolled(double d, double e, double f, double g) {
        if (super.mouseScrolled(d, e, f, g)) {
            return true;
        }
        if (this.scrollableRenderer.mouseScrolled(g)) {
            return true;
        }
        int scroll = (int)Math.signum(g);
        if (((Integer)this.craftingButtonsOffset.get() > 0 && scroll < 0 || scroll > 0 && this.craftingButtonsOffset.max > 0) && this.craftingButtonsOffset.add(scroll, false) != 0) {
            this.repositionElements();
            return true;
        }
        return false;
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBg(guiGraphics, f, i, j);
    }

    protected void renderBg(GuiGraphics guiGraphics, float f, int i, int j) {
        if (this.hasTypeTabList()) {
            this.typeTabList.render(guiGraphics, i, j, f);
        }
        this.getTabList().render(guiGraphics, i, j, f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite((ResourceLocation)this.accessor.getElementValue("imageSprite", (Object)LegacySprites.SMALL_PANEL, ResourceLocation.class), this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        int panelWidth = this.accessor.getInteger("craftingGridPanelWidth", 163);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.leftPos + 9, this.topPos + 103, panelWidth, 105);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.leftPos + this.accessor.getInteger("inventoryPanelX", 176), this.topPos + this.accessor.getInteger("inventoryPanelY", 103), this.accessor.getInteger("inventoryPanelWidth", 163), 105);
        if (this.typeTabList.selectedTab != 0 && this.hasTypeTabList()) {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.leftPos + 176, this.topPos + 8, 163, 93);
        }
        int contentsWidth = (this.is2x2 ? 2 : 3) * 23 + 69;
        int xDiff = this.leftPos + 9 + (panelWidth - contentsWidth) / 2;
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SMALL_ARROW, xDiff + (this.is2x2 ? 2 : 3) * 23 + 8, this.topPos + 161, 16, 13);
        if (this.typeTabList.selectedTab == 0 || !this.hasTypeTabList()) {
            if ((Integer)this.craftingButtonsOffset.get() > 0) {
                this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.LEFT, this.leftPos + 5, this.topPos + 45);
            }
            if (this.craftingButtonsOffset.max > 0 && (Integer)this.craftingButtonsOffset.get() < this.craftingButtonsOffset.max) {
                this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.RIGHT, this.leftPos + this.imageWidth - 11, this.topPos + 45);
            }
        }
    }

    @Override
    public boolean disableCursorOnInit() {
        return true;
    }

    @Override
    public boolean onceClickBindings(BindingState state) {
        return !state.is(ControllerBinding.DOWN_BUTTON);
    }

    public boolean keyPressed(int i, int j, int k) {
        if (this.hasTypeTabList() && LegacyCraftingScreen.hasShiftDown() && this.typeTabList.controlTab(i)) {
            return true;
        }
        this.getTabList().controlTab(i);
        if (LegacyCraftingScreen.hasShiftDown() && this.controlPage(i == 263, i == 262)) {
            return true;
        }
        return super.keyPressed(i, j, k);
    }

    protected boolean controlPage(boolean left, boolean right) {
        if ((left || right) && this.page.max > 0 && this.typeTabList.selectedTab == 0) {
            int lastPage = (Integer)this.page.get();
            this.page.add(left ? -1 : 1);
            if (lastPage != (Integer)this.page.get()) {
                this.craftingTabList.resetSelectedTab();
                this.rebuildWidgets();
                return true;
            }
        }
        return false;
    }

    public List<? extends LegacyIconHolder> getCraftingButtons() {
        return switch (this.typeTabList.selectedTab) {
            case 1 -> {
                if (this.bannerTabList.selectedTab == 0) {
                    yield this.bannerButtons;
                }
                yield this.decorateShieldButtons;
            }
            case 2 -> {
                if (this.fireworkTabList.selectedTab == 0) {
                    yield this.fireworkStarButtons;
                }
                if (this.fireworkTabList.selectedTab == 1) {
                    yield this.fireworkStarFadeButtons;
                }
                yield this.fireworkButtons;
            }
            case 3 -> {
                if (this.dyeTabList.selectedTab == 0) {
                    yield this.dyeArmorButtons;
                }
                if (this.dyeTabList.selectedTab == 1) {
                    yield this.dyeItemButtons;
                }
                yield this.decoratedPotButtons;
            }
            default -> this.craftingButtons;
        };
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        int index;
        this.renderBackground(guiGraphics, i, j, f);
        super.render(guiGraphics, i, j, f);
        int panelWidth = this.accessor.getInteger("craftingGridPanelWidth", 163);
        int contentsWidth = (this.is2x2 ? 2 : 3) * 23 + 69;
        int xDiff = this.leftPos + 9 + (panelWidth - contentsWidth) / 2;
        boolean anyWarning = false;
        for (index = 0; index < this.ingredientsGrid.size(); ++index) {
            LegacyIconHolder holder = ScreenUtil.iconHolderRenderer.itemHolder(xDiff + index % this.gridDimension * 23, this.topPos + (this.is2x2 ? 145 : 133) + index / this.gridDimension * 23, 23, 23, RecipeIconHolder.getActualItem(this.ingredientsGrid.get(index)), (!this.onlyCraftableRecipes || this.typeTabList.selectedTab != 0) && !RecipeIconHolder.getActualItem(this.ingredientsGrid.get(index)).isEmpty() && this.warningSlots[index], new Vec3(0.5, this.is2x2 ? 0.0 : 0.5, 0.0));
            if (holder.isWarning()) {
                anyWarning = true;
            }
            holder.render(guiGraphics, i, j, f);
        }
        ScreenUtil.iconHolderRenderer.itemHolder(xDiff + contentsWidth - 36, this.topPos + 151, 36, 36, this.resultStack, anyWarning, new Vec3(0.5, 0.0, 0.0)).render(guiGraphics, i, j, f);
        if (!this.resultStack.isEmpty()) {
            Component component;
            Component component2;
            LegacyIconHolder legacyIconHolder = this.getCraftingButtons().get(this.selectedCraftingButton);
            if (legacyIconHolder instanceof RecipeIconHolder) {
                RecipeIconHolder h2 = (RecipeIconHolder)legacyIconHolder;
                component2 = h2.getFocusedRecipe().getName();
            } else {
                component2 = this.resultStack.getHoverName();
            }
            Component resultName = component2;
            LegacyIconHolder legacyIconHolder2 = this.getCraftingButtons().get(this.selectedCraftingButton);
            if (legacyIconHolder2 instanceof RecipeIconHolder) {
                RecipeIconHolder h3 = (RecipeIconHolder)legacyIconHolder2;
                component = h3.getFocusedRecipe().getDescription();
            } else {
                component = null;
            }
            Component description = component;
            int titleY = this.accessor.getInteger("bottomPanelTitleY", 114) - (description == null ? 0 : 6);
            ScreenUtil.renderScrollingString(guiGraphics, this.font, resultName, this.leftPos + 11 + Math.max(panelWidth - this.font.width((FormattedText)resultName), 0) / 2, this.topPos + titleY, this.leftPos + 7 + panelWidth, this.topPos + titleY + 11, (int)((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()), false);
            if (description != null) {
                ScreenUtil.renderScrollingString(guiGraphics, this.font, (Component)description.copy().setStyle(Style.EMPTY), this.leftPos + 11 + Math.max(panelWidth - this.font.width((FormattedText)description), 0) / 2, this.topPos + titleY + 12, this.leftPos + 7 + panelWidth, this.topPos + titleY + 23, (int)((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()), false);
            }
            if (this.typeTabList.selectedTab != 0) {
                List<Component> list = ScreenUtil.getTooltip(this.resultStack);
                this.scrollableRenderer.scrolled.max = Math.max(0, list.size() - 6);
                this.scrollableRenderer.render(guiGraphics, this.leftPos + 180, this.topPos + 15, 152, 72, () -> {
                    for (int i1 = 0; i1 < list.size(); ++i1) {
                        guiGraphics.drawString(this.font, (Component)((Component)list.get(i1)).copy().setStyle(Style.EMPTY), this.leftPos + 180, this.topPos + 15 + i1 * 12, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
                    }
                });
            }
            if (ScreenUtil.isMouseOver(i, j, xDiff + contentsWidth - 36, this.topPos + 151, 36, 36)) {
                guiGraphics.renderTooltip(this.font, this.resultStack, i, j);
            }
        }
        for (index = 0; index < this.ingredientsGrid.size(); ++index) {
            if (RecipeIconHolder.getActualItem(this.ingredientsGrid.get(index)).isEmpty() || !ScreenUtil.isMouseOver(i, j, xDiff + index % this.gridDimension * 23, this.topPos + (this.is2x2 ? 145 : 133) + index / this.gridDimension * 23, 23, 23)) continue;
            guiGraphics.renderTooltip(this.font, RecipeIconHolder.getActualItem(this.ingredientsGrid.get(index)), i, j);
        }
        this.getCraftingButtons().forEach(h -> h.renderTooltip(this.minecraft, guiGraphics, i, j));
        this.renderTooltip(guiGraphics, i, j);
    }

    protected abstract class CustomCraftingIconHolder
    extends CustomRecipeIconHolder {
        public CustomCraftingIconHolder(ItemStack itemStack) {
            super(itemStack);
        }

        public CustomCraftingIconHolder() {
        }

        @Override
        LegacyScrollRenderer getScrollRenderer() {
            return LegacyCraftingScreen.this.scrollRenderer;
        }

        @Override
        public boolean canCraft() {
            return LegacyCraftingScreen.this.canCraft(this.getIngredientsGrid(), false);
        }

        @Override
        public List<Optional<Ingredient>> getIngredientsGrid() {
            return LegacyCraftingScreen.this.ingredientsGrid;
        }

        @Override
        public void render(GuiGraphics graphics, int i, int j, float f) {
            if (this.isFocused()) {
                LegacyCraftingScreen.this.selectedCraftingButton = LegacyCraftingScreen.this.getCraftingButtons().indexOf(this);
            }
            super.render(graphics, i, j, f);
        }

        @Override
        public void craft() {
            ScreenUtil.playSimpleUISound(SoundEvents.ITEM_PICKUP, 1.0f);
            super.craft();
        }
    }
}

