/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.StackIngredient;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.base.network.CommonNetwork;
import wily.factoryapi.util.PagedList;
import wily.legacy.Legacy4J;
import wily.legacy.client.CommonColor;
import wily.legacy.client.ControlType;
import wily.legacy.client.LoomTabListing;
import wily.legacy.client.RecipeInfo;
import wily.legacy.client.controller.BindingState;
import wily.legacy.client.controller.Controller;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.CustomRecipeIconHolder;
import wily.legacy.client.screen.LegacyCraftingScreen;
import wily.legacy.client.screen.LegacyIconHolder;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.client.screen.LegacyTabButton;
import wily.legacy.client.screen.RecipeIconHolder;
import wily.legacy.client.screen.ScrollableRenderer;
import wily.legacy.client.screen.TabList;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.inventory.LegacyCraftingMenu;
import wily.legacy.inventory.RecipeMenu;
import wily.legacy.network.ServerMenuCraftPayload;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public class LegacyLoomScreen
extends AbstractContainerScreen<LegacyCraftingMenu>
implements Controller.Event,
ControlTooltip.Event,
TabList.Access {
    private final Inventory inventory;
    protected final List<ItemStack> compactInventoryList = new ArrayList<ItemStack>();
    protected final List<Optional<Ingredient>> ingredientsGrid = new ArrayList(Collections.nCopies(9, Optional.empty()));
    protected final List<Optional<Ingredient>> selectedIngredients = new ArrayList<Optional<Ingredient>>();
    protected ItemStack resultStack = ItemStack.EMPTY;
    protected ItemStack selectedStack = ItemStack.EMPTY;
    protected ItemStack previewStack = ItemStack.EMPTY;
    protected final UIAccessor accessor = UIAccessor.of((Screen)this);
    protected final ScrollableRenderer scrollableRenderer = new ScrollableRenderer();
    protected final List<LoomTabListing> loomTabListings = List.copyOf(LoomTabListing.map.values());
    protected final List<RecipeIconHolder<BannerRecipe>> craftingButtons = new ArrayList<RecipeIconHolder<BannerRecipe>>();
    protected final List<CustomRecipeIconHolder> selectBannerButton = Collections.singletonList(new CustomRecipeIconHolder(){

        @Override
        @Nullable
        public Component getAction(ControlTooltip.ActionHolder.Context context) {
            return context.actionOfContext(ControlTooltip.ActionHolder.KeyContext.class, c -> c.key() == 79 && this.isFocused() && this.hasItem() ? LegacyComponents.SELECT : null);
        }

        @Override
        public Component getDisplayName() {
            return LegacyComponents.SELECT_BANNER_TAB;
        }

        @Override
        public ItemStack nextItem() {
            return this.nextItem(LegacyLoomScreen.this.inventory, i -> i.getItem() instanceof BannerItem && Legacy4J.getItemPatternsCount(i) < 6);
        }

        @Override
        public ItemStack previousItem() {
            return this.previousItem(LegacyLoomScreen.this.inventory, i -> i.getItem() instanceof BannerItem && Legacy4J.getItemPatternsCount(i) < 6);
        }

        @Override
        public boolean applyNextItemIfAbsent() {
            return true;
        }

        @Override
        public boolean canCraft() {
            return true;
        }

        @Override
        public void craft() {
        }

        @Override
        public List<Optional<Ingredient>> getIngredientsGrid() {
            return LegacyLoomScreen.this.ingredientsGrid;
        }

        @Override
        int findInventoryMatchSlot() {
            for (int i = 0; i < ((LegacyCraftingMenu)((LegacyLoomScreen)LegacyLoomScreen.this).menu).slots.size(); ++i) {
                if (((Slot)((LegacyCraftingMenu)((LegacyLoomScreen)LegacyLoomScreen.this).menu).slots.get(i)).getItem() != this.itemIcon) continue;
                return i;
            }
            this.itemIcon = this.nextItem;
            return this.itemIcon.isEmpty() ? 0 : this.findInventoryMatchSlot();
        }

        @Override
        public void render(GuiGraphics graphics, int i, int j, float f) {
            if (this.isFocused()) {
                LegacyLoomScreen.this.selectedCraftingButton = LegacyLoomScreen.this.getCraftingButtons().indexOf(this);
            }
            super.render(graphics, i, j, f);
        }

        @Override
        public boolean keyPressed(int i, int j, int k) {
            if (i == 79 && !this.itemIcon.isEmpty() && this.hasItem()) {
                this.updateRecipe();
                LegacyLoomScreen.this.selectedStack = this.itemIcon.copyWithCount(1);
                LegacyLoomScreen.this.craftingTabList.tabButtons.get(1).onPress();
                return true;
            }
            return super.keyPressed(i, j, k);
        }

        @Override
        void updateRecipe() {
            LegacyCraftingScreen.clearIngredients(LegacyLoomScreen.this.ingredientsGrid);
            LegacyLoomScreen.this.resultStack = this.itemIcon.copyWithCount(1);
            LegacyLoomScreen.this.ingredientsGrid.set(4, LegacyLoomScreen.this.resultStack.isEmpty() ? Optional.empty() : Optional.of(StackIngredient.of((boolean)true, (ItemStack)LegacyLoomScreen.this.resultStack, (int)1)));
            LegacyLoomScreen.this.scrollableRenderer.scrolled.set(Integer.valueOf(0));
        }

        @Override
        LegacyScrollRenderer getScrollRenderer() {
            return LegacyLoomScreen.this.scrollRenderer;
        }
    });
    protected List<RecipeInfo<BannerRecipe>> selectedPatterns = new ArrayList<RecipeInfo<BannerRecipe>>();
    protected List<List<RecipeInfo<BannerRecipe>>> recipesByGroup = new ArrayList<List<RecipeInfo<BannerRecipe>>>();
    protected final Stocker.Sizeable page = new Stocker.Sizeable(Integer.valueOf(0));
    protected final Stocker.Sizeable craftingButtonsOffset = new Stocker.Sizeable(Integer.valueOf(0));
    protected final TabList craftingTabList = new TabList(this.accessor, (List<LegacyTabButton>)new PagedList(this.page, 7));
    protected final LegacyScrollRenderer scrollRenderer = new LegacyScrollRenderer();
    private final boolean[] warningSlots = new boolean[9];
    protected final ContainerListener listener = new ContainerListener(){

        public void slotChanged(AbstractContainerMenu abstractContainerMenu, int i, ItemStack itemStack) {
            LegacyIconHolder legacyIconHolder;
            LegacyLoomScreen.this.recipesByGroup.clear();
            LegacyLoomScreen.this.selectedIngredients.clear();
            if (LegacyLoomScreen.this.craftingTabList.selectedTab != 0 && !LegacyLoomScreen.this.selectedStack.isEmpty()) {
                LegacyLoomScreen.this.previewStack = LegacyLoomScreen.this.selectedStack.copy();
                LegacyLoomScreen.this.selectedIngredients.add(Optional.of(StackIngredient.of((boolean)true, (ItemStack)LegacyLoomScreen.this.selectedStack, (int)1)));
                if (!LegacyLoomScreen.this.selectedPatterns.isEmpty()) {
                    CompoundTag beTag = LegacyLoomScreen.this.previewStack.getOrCreateTagElement("BlockEntityTag");
                    ListTag patternsTag = beTag.getList("Patterns", 10);
                    if (!beTag.contains("Patterns", 9)) {
                        beTag.put("Patterns", (Tag)patternsTag);
                    }
                    LegacyLoomScreen.this.selectedPatterns.forEach(rcp -> {
                        CompoundTag patternTag = new CompoundTag();
                        patternsTag.add((Object)patternTag);
                        patternTag.putString("Pattern", ((BannerPattern)BuiltInRegistries.BANNER_PATTERN.get(((BannerRecipe)rcp.get()).pattern())).getHashname());
                        patternTag.putInt("Color", ((BannerRecipe)rcp.get()).color.getId());
                        for (int i1 = 1; i1 < rcp.getOptionalIngredients().size(); ++i1) {
                            Optional<Ingredient> ing = rcp.getOptionalIngredients().get(i1);
                            if (ing.isEmpty()) continue;
                            LegacyLoomScreen.this.selectedIngredients.add(ing);
                        }
                    });
                }
                Optional<StackIngredient> previewIng = Optional.of(StackIngredient.of((boolean)true, (ItemStack)LegacyLoomScreen.this.previewStack, (int)1));
                LegacyLoomScreen.this.loomTabListings.get(LegacyLoomScreen.this.craftingTabList.selectedTab - 1).patterns().stream().filter(p -> Minecraft.getInstance().getConnection().registryAccess().lookupOrThrow(Registries.BANNER_PATTERN).listElementIds().anyMatch(p::equals)).forEach(p -> LegacyLoomScreen.this.recipesByGroup.add(Arrays.stream(DyeColor.values()).map(color -> {
                    ItemStack result = LegacyLoomScreen.this.previewStack.copy();
                    CompoundTag beTag = result.getOrCreateTagElement("BlockEntityTag");
                    ListTag patternsTag = beTag.getList("Patterns", 10);
                    if (!beTag.contains("Patterns", 9)) {
                        beTag.put("Patterns", (Tag)patternsTag);
                    }
                    CompoundTag addPattern = new CompoundTag();
                    patternsTag.add((Object)addPattern);
                    addPattern.putString("Pattern", ((BannerPattern)BuiltInRegistries.BANNER_PATTERN.get(p)).getHashname());
                    addPattern.putInt("Color", color.getId());
                    Optional<Ingredient> dye = Optional.of(Ingredient.of((ItemLike[])new ItemLike[]{DyeItem.byColor((DyeColor)color)}));
                    ArrayList<Optional<Ingredient>> previewIngs = new ArrayList<Optional<Ingredient>>(LegacyLoomScreen.this.selectedIngredients);
                    previewIngs.add(dye);
                    List<Optional<Ingredient>> ings = List.of(previewIng, dye);
                    ArrayList<Optional<Ingredient>> displayIngs = new ArrayList<Optional<Ingredient>>(ings);
                    Optional<Ingredient> extraIng = LegacyCraftingMenu.getBannerPatternExtraIngredient((RegistryAccess)Minecraft.getInstance().getConnection().registryAccess(), (ResourceKey<BannerPattern>)p);
                    if (extraIng.isPresent()) {
                        displayIngs.add(1, extraIng);
                        previewIngs.add(extraIng);
                    }
                    displayIngs.set(0, LegacyLoomScreen.this.selectedIngredients.get(0));
                    return RecipeInfo.create(p.location().withPrefix(color.getName() + "_"), new BannerRecipe((List<Optional<Ingredient>>)previewIngs, LegacyCraftingMenu.updateShapedIngredients(new ArrayList<Optional<Ingredient>>(Collections.nCopies(9, Optional.empty())), displayIngs, 3, 2, 2), (ResourceKey<BannerPattern>)p, (DyeColor)color), ings, result);
                }).collect(Collectors.collectingAndThen(Collectors.toList(), l -> {
                    Collections.reverse(l);
                    return l;
                }))));
                LegacyLoomScreen.this.craftingButtons.get(LegacyLoomScreen.this.selectedCraftingButton).updateRecipeDisplay();
            } else if (LegacyLoomScreen.this.getCraftingButtons().size() > LegacyLoomScreen.this.selectedCraftingButton && (legacyIconHolder = LegacyLoomScreen.this.getCraftingButtons().get(LegacyLoomScreen.this.selectedCraftingButton)) instanceof LegacyCraftingScreen.CustomCraftingIconHolder) {
                LegacyCraftingScreen.CustomCraftingIconHolder h = (LegacyCraftingScreen.CustomCraftingIconHolder)legacyIconHolder;
                h.updateRecipe();
            }
        }

        public void dataChanged(AbstractContainerMenu abstractContainerMenu, int i, int j) {
        }
    };
    protected int selectedCraftingButton;
    protected boolean inited;

    public LegacyLoomScreen(LegacyCraftingMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
        this.inventory = inventory;
        this.craftingTabList.addTabButton(43, LegacyTabButton.Type.LEFT, LegacyTabButton.iconOf(Items.WHITE_BANNER), (Component)Component.empty(), t -> this.resetElements());
        for (LoomTabListing listing : this.loomTabListings) {
            this.craftingTabList.addTabButton(43, LegacyTabButton.Type.LEFT, listing.icon(), listing.name(), t -> this.resetElements());
        }
        this.craftingTabList.resetSelectedTab();
        this.inited = true;
        this.addCraftingButtons();
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        ControlTooltip.setupDefaultButtons(renderer, (Screen)this);
        ControlTooltip.Event.super.addControlTooltips(renderer);
        renderer.add(() -> ControlTooltip.OPTION.get(), () -> ControlTooltip.getKeyMessage(79, (Screen)this)).add(() -> ControlTooltip.EXTRA.get(), () -> {
            RecipeIconHolder r;
            GuiEventListener patt0$temp = this.getFocused();
            return patt0$temp instanceof RecipeIconHolder && (r = (RecipeIconHolder)patt0$temp).getFocusedRecipe() != null && this.selectedPatterns.contains(r.getFocusedRecipe()) ? LegacyComponents.REMOVE : null;
        }).addCompound(() -> {
            ControlTooltip.Icon[] iconArray;
            if (this.getTabList().selectedTab == 0) {
                iconArray = new ControlTooltip.Icon[]{};
            } else {
                ControlTooltip.Icon[] iconArray2 = new ControlTooltip.Icon[3];
                iconArray2[0] = ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(91) : ControllerBinding.LEFT_BUMPER.getIcon();
                iconArray2[1] = ControlTooltip.SPACE_ICON;
                iconArray = iconArray2;
                iconArray2[2] = ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(93) : ControllerBinding.RIGHT_BUMPER.getIcon();
            }
            return iconArray;
        }, () -> LegacyComponents.GROUP).add(() -> this.page.max > 0 ? (ControlType.getActiveType().isKbm() ? ControlTooltip.COMPOUND_ICON_FUNCTION.apply(new ControlTooltip.Icon[]{ControlTooltip.getKeyIcon(340), ControlTooltip.PLUS_ICON, ControlTooltip.getKeyIcon(263), ControlTooltip.SPACE_ICON, ControlTooltip.getKeyIcon(262)}) : ControllerBinding.RIGHT_STICK.getIcon()) : null, () -> LegacyComponents.PAGE);
    }

    public void resetElements() {
        this.listener.slotChanged(this.menu, -1, ItemStack.EMPTY);
        this.selectedCraftingButton = 0;
        this.craftingButtonsOffset.set(Integer.valueOf(0));
        if (this.inited) {
            this.repositionElements();
        }
    }

    public void setFocused(@Nullable GuiEventListener guiEventListener) {
        if (guiEventListener instanceof TabList) {
            return;
        }
        super.setFocused(guiEventListener);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int i, int j) {
        MutableComponent mutableComponent;
        if (this.craftingTabList.selectedTab != 0) {
            mutableComponent = this.craftingTabList.tabButtons.get(this.craftingTabList.selectedTab).getMessage();
        } else {
            GuiEventListener guiEventListener = this.getFocused();
            if (guiEventListener instanceof CustomRecipeIconHolder) {
                CustomRecipeIconHolder h = (CustomRecipeIconHolder)guiEventListener;
                mutableComponent = h.getDisplayName();
            } else {
                mutableComponent = Component.empty();
            }
        }
        MutableComponent title = mutableComponent;
        guiGraphics.drawString(this.font, (Component)title, ((this.craftingTabList.selectedTab != 0 ? this.imageWidth : this.imageWidth / 2) - this.font.width((FormattedText)title)) / 2, 17, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        if (((LegacyCraftingMenu)this.menu).inventoryActive) {
            guiGraphics.drawString(this.font, this.playerInventoryTitle, (515 - this.font.width((FormattedText)this.playerInventoryTitle)) / 2, 114, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        } else {
            guiGraphics.drawString(this.font, LegacyComponents.PREVIEW, (515 - this.font.width((FormattedText)LegacyComponents.PREVIEW)) / 2, 114, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        }
        guiGraphics.pose().translate((float)(-this.leftPos), (float)(-this.topPos), 0.0f);
        this.getCraftingButtons().forEach(b -> b.render(guiGraphics, i, j, 0.0f));
        if (this.selectedCraftingButton < this.getCraftingButtons().size()) {
            this.getCraftingButtons().get(this.selectedCraftingButton).renderSelection(guiGraphics, i, j, 0.0f);
        }
        guiGraphics.pose().translate((float)this.leftPos, (float)this.topPos, 0.0f);
    }

    @Override
    public void bindingStateTick(BindingState state) {
        if (state.pressed && state.canClick() && state.is(ControllerBinding.RIGHT_STICK) && state instanceof BindingState.Axis) {
            BindingState.Axis s = (BindingState.Axis)state;
            this.controlPage(s.x < 0.0f && -s.x > Math.abs(s.y), s.x > 0.0f && s.x > Math.abs(s.y));
        }
    }

    @Override
    public TabList getTabList() {
        return this.craftingTabList;
    }

    @Override
    public boolean disableCursorOnInit() {
        return true;
    }

    @Override
    public boolean onceClickBindings(BindingState state) {
        return !state.is(ControllerBinding.DOWN_BUTTON);
    }

    protected void init() {
        this.resultStack = ItemStack.EMPTY;
        this.imageWidth = 348;
        this.imageHeight = 215;
        super.init();
        this.topPos += 18;
        ((LegacyCraftingMenu)this.menu).addSlotListener(this.listener);
        this.craftingTabList.selectedTab = this.selectedStack.isEmpty() ? 0 : Math.max(this.craftingTabList.selectedTab, 1);
        ((LegacyCraftingMenu)this.menu).inventoryActive = this.selectedStack.isEmpty();
        if (this.selectedCraftingButton < this.getCraftingButtons().size()) {
            this.setFocused(this.getCraftingButtons().get(this.selectedCraftingButton));
        }
        if (this.craftingTabList.selectedTab != 0) {
            this.craftingButtonsOffset.max = Math.max(0, this.loomTabListings.get((Integer)this.page.get() * 7 + this.craftingTabList.selectedTab - 1).patterns().size() - 12);
            this.craftingButtons.forEach(b -> {
                b.setPos(this.leftPos + 13 + this.craftingButtons.indexOf(b) * 27, this.topPos + 38);
                this.addWidget((GuiEventListener)b);
            });
        } else {
            this.getCraftingButtons().forEach(b -> {
                b.setPos(this.leftPos + 77 + this.getCraftingButtons().indexOf(b) * 55, this.topPos + 39);
                b.offset = new Vec3((double)this.getCraftingButtons().indexOf(b) * 0.5, 0.0, 0.0);
                b.init();
                this.addWidget((GuiEventListener)b);
            });
        }
        this.addWidget(this.craftingTabList);
        this.craftingTabList.init(this.leftPos, this.topPos - 37, this.imageWidth, (t, i) -> {
            int index = this.craftingTabList.tabButtons.indexOf(t);
            t.active = index == 0 && this.selectedStack.isEmpty() || index != 0 && !this.selectedStack.isEmpty();
            t.type = LegacyTabButton.Type.bySize(index, 6);
            t.setWidth(51);
            t.offset = t1 -> new Vec3(-1.5 * (double)this.craftingTabList.tabButtons.indexOf(t), t1.active ? (t1.selected ? 0.0 : 4.5) : 26.5, 0.0);
        });
    }

    protected boolean canCraft() {
        return this.selectedIngredients.size() > 1 && this.canCraft(this.selectedIngredients, false);
    }

    protected boolean canCraft(List<Optional<Ingredient>> ingredients, boolean isFocused) {
        this.compactInventoryList.clear();
        RecipeMenu.handleCompactInventoryList(this.compactInventoryList, Minecraft.getInstance().player.getInventory(), ((LegacyCraftingMenu)this.menu).getCarried());
        return LegacyCraftingScreen.canCraft(this.compactInventoryList, ingredients, isFocused ? this.warningSlots : null);
    }

    public boolean mouseScrolled(double d, double e, double f, double g) {
        if (super.mouseScrolled(d, e, f, g)) {
            return true;
        }
        int scroll = (int)Math.signum(g);
        if (((Integer)this.craftingButtonsOffset.get() > 0 && scroll < 0 || scroll > 0 && this.craftingButtonsOffset.max > 0) && this.craftingButtonsOffset.add(scroll, false) != 0) {
            this.repositionElements();
            return true;
        }
        return false;
    }

    protected void addCraftingButtons() {
        for (int i = 0; i < 12; ++i) {
            final int index = i;
            RecipeIconHolder<BannerRecipe> h = new RecipeIconHolder<BannerRecipe>(this.leftPos + 13 + i * 27, this.topPos + 38){

                @Override
                @Nullable
                public Component getAction(ControlTooltip.ActionHolder.Context context) {
                    return context.actionOfContext(ControlTooltip.ActionHolder.KeyContext.class, c -> c.key() == 257 && this.isFocused() && LegacyLoomScreen.this.canCraft() ? LegacyComponents.CREATE : (c.key() == 79 && this.isFocused() && this.canCraft() ? LegacyComponents.ADD : null));
                }

                @Override
                public void render(GuiGraphics graphics, int i, int j, float f) {
                    if (this.isFocused()) {
                        LegacyLoomScreen.this.selectedCraftingButton = index;
                    }
                    super.render(graphics, i, j, f);
                }

                @Override
                protected boolean canCraft(RecipeInfo<BannerRecipe> rcp) {
                    if (rcp == null) {
                        return true;
                    }
                    return Legacy4J.getItemPatternsCount(LegacyLoomScreen.this.previewStack) < 6 && LegacyLoomScreen.this.canCraft(((BannerRecipe)rcp.get()).displayIngredients(), this.isFocused() && this.getFocusedRecipe() == rcp) && LegacyLoomScreen.this.canCraft(((BannerRecipe)rcp.get()).previewIngredients, false);
                }

                @Override
                protected List<RecipeInfo<BannerRecipe>> getRecipes() {
                    return LegacyLoomScreen.this.recipesByGroup.size() <= (Integer)LegacyLoomScreen.this.craftingButtonsOffset.get() + index ? Collections.emptyList() : LegacyLoomScreen.this.recipesByGroup.get((Integer)LegacyLoomScreen.this.craftingButtonsOffset.get() + index);
                }

                @Override
                protected void toggleCraftableRecipes() {
                }

                @Override
                public boolean keyPressed(int i, int j, int k) {
                    if ((i == 79 || i == 88) && this.isValidIndex()) {
                        if (i == 79) {
                            if (this.canCraft()) {
                                LegacyLoomScreen.this.selectedPatterns.add(this.getFocusedRecipe());
                                ScreenUtil.playSimpleUISound(SoundEvents.UI_LOOM_SELECT_PATTERN, 1.0f);
                            }
                        } else {
                            LegacyLoomScreen.this.selectedPatterns.remove(this.getFocusedRecipe());
                        }
                        int cycle = this.getFocusedRecipes().indexOf(this.getFocusedRecipe()) - this.getRecipes().indexOf(this.getFocusedRecipe());
                        this.focusedRecipes = null;
                        LegacyLoomScreen.this.listener.slotChanged(LegacyLoomScreen.this.menu, -1, ItemStack.EMPTY);
                        Collections.rotate(this.getFocusedRecipes(), cycle);
                        this.updateRecipeDisplay();
                        return true;
                    }
                    if (this.controlCyclicNavigation(i, index, LegacyLoomScreen.this.craftingButtons, LegacyLoomScreen.this.craftingButtonsOffset, LegacyLoomScreen.this.scrollRenderer, (Screen)LegacyLoomScreen.this)) {
                        return true;
                    }
                    return super.keyPressed(i, j, k);
                }

                @Override
                protected void updateRecipeDisplay(RecipeInfo<BannerRecipe> rcp) {
                    LegacyLoomScreen.this.resultStack = this.getFocusedResult();
                    LegacyCraftingScreen.clearIngredients(LegacyLoomScreen.this.ingredientsGrid);
                    if (rcp == null) {
                        return;
                    }
                    for (int i = 0; i < ((BannerRecipe)rcp.get()).displayIngredients().size(); ++i) {
                        LegacyLoomScreen.this.ingredientsGrid.set(i, ((BannerRecipe)rcp.get()).displayIngredients().get(i));
                    }
                }

                @Override
                public void onPress() {
                    if (this.isFocused() && this.isValidIndex()) {
                        if (LegacyLoomScreen.this.canCraft()) {
                            ScreenUtil.playSimpleUISound(SoundEvents.UI_LOOM_TAKE_RESULT, 1.0f);
                            LegacyLoomScreen.this.selectedPatterns.forEach(b -> CommonNetwork.sendToServer((CommonNetwork.Payload)new ServerMenuCraftPayload(Optional.of(((BannerRecipe)b.get()).pattern.location()), b.getOptionalIngredients(), -1, Screen.hasShiftDown() || ControllerBinding.LEFT_STICK_BUTTON.state().pressed)));
                            LegacyLoomScreen.this.selectedPatterns.clear();
                            LegacyLoomScreen.this.selectedStack = ItemStack.EMPTY;
                            LegacyLoomScreen.this.previewStack = ItemStack.EMPTY;
                            LegacyLoomScreen.this.craftingTabList.tabButtons.get(0).onPress();
                        } else {
                            ScreenUtil.playSimpleUISound((SoundEvent)LegacyRegistries.CRAFT_FAIL.get(), 1.0f);
                        }
                    }
                }
            };
            this.craftingButtons.add(h);
            h.allowCraftableRecipesToggle = false;
            h.offset = new Vec3(0.5, 0.5, 0.0);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBg(guiGraphics, f, i, j);
    }

    protected void renderBg(GuiGraphics guiGraphics, float f, int i, int j) {
        this.craftingTabList.render(guiGraphics, i, j, f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite((ResourceLocation)this.accessor.getElementValue("imageSprite", (Object)LegacySprites.SMALL_PANEL, ResourceLocation.class), this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.leftPos + 9, this.topPos + 103, 163, 105);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.leftPos + 176, this.topPos + 103, 163, 105);
        if (!((LegacyCraftingMenu)this.menu).inventoryActive && !this.previewStack.isEmpty()) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((double)this.leftPos + 220.5, (double)this.topPos + 130.5, 0.0);
            guiGraphics.pose().scale(4.25f, 4.25f, 4.25f);
            guiGraphics.renderItem(this.previewStack, 0, 0);
            guiGraphics.pose().popPose();
        }
        if (this.craftingTabList.selectedTab == 0) {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.leftPos + 176, this.topPos + 8, 163, 93);
        }
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SMALL_ARROW, this.leftPos + 97, this.topPos + 161, 16, 13);
        if (this.craftingTabList.selectedTab != 0) {
            if ((Integer)this.craftingButtonsOffset.get() > 0) {
                this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.LEFT, this.leftPos + 5, this.topPos + 45);
            }
            if (this.craftingButtonsOffset.max > 0 && (Integer)this.craftingButtonsOffset.get() < this.craftingButtonsOffset.max) {
                this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.RIGHT, this.leftPos + 337, this.topPos + 45);
            }
        }
    }

    public boolean keyPressed(int i, int j, int k) {
        if (LegacyLoomScreen.hasShiftDown() && this.controlPage(i == 263, i == 262)) {
            return true;
        }
        if (this.craftingTabList.controlTab(i)) {
            return true;
        }
        return super.keyPressed(i, j, k);
    }

    protected boolean controlPage(boolean left, boolean right) {
        if ((left || right) && this.page.max > 0 && this.craftingTabList.selectedTab != 0) {
            int lastPage = (Integer)this.page.get();
            this.page.add(left ? -1 : 1);
            if (lastPage != (Integer)this.page.get()) {
                this.craftingTabList.resetSelectedTab();
                this.rebuildWidgets();
                return true;
            }
        }
        return false;
    }

    public List<? extends LegacyIconHolder> getCraftingButtons() {
        return this.craftingTabList.selectedTab == 0 ? this.selectBannerButton : this.craftingButtons;
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        RecipeIconHolder r;
        this.renderBackground(guiGraphics, i, j, f);
        super.render(guiGraphics, i, j, f);
        for (int index = 0; index < this.ingredientsGrid.size(); ++index) {
            ScreenUtil.iconHolderRenderer.itemHolder(this.leftPos + 21 + index % 3 * 23, this.topPos + 133 + index / 3 * 23, 23, 23, RecipeIconHolder.getActualItem(this.ingredientsGrid.get(index)), !RecipeIconHolder.getActualItem(this.ingredientsGrid.get(index)).isEmpty() && this.warningSlots[index], new Vec3(0.5, 0.5, 0.0)).render(guiGraphics, i, j, f);
        }
        GuiEventListener guiEventListener = this.getFocused();
        ScreenUtil.iconHolderRenderer.itemHolder(this.leftPos + 124, this.topPos + 151, 36, 36, this.resultStack, guiEventListener instanceof RecipeIconHolder && (r = (RecipeIconHolder)guiEventListener).isValidIndex() && !r.canCraft(), new Vec3(0.5, 0.0, 0.0)).render(guiGraphics, i, j, f);
        if (!this.resultStack.isEmpty()) {
            Component resultName = this.resultStack.getHoverName();
            ScreenUtil.renderScrollingString(guiGraphics, this.font, resultName, this.leftPos + 11 + Math.max(163 - this.font.width((FormattedText)resultName), 0) / 2, this.topPos + 114, this.leftPos + 170, this.topPos + 125, (int)((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()), false);
            if (this.craftingTabList.selectedTab == 0) {
                List<Component> list = ScreenUtil.getTooltip(this.resultStack);
                this.scrollableRenderer.scrolled.max = Math.max(0, list.size() - 6);
                this.scrollableRenderer.render(guiGraphics, this.leftPos + 180, this.topPos + 15, 152, 72, () -> {
                    for (int i1 = 0; i1 < list.size(); ++i1) {
                        guiGraphics.drawString(this.font, (Component)((Component)list.get(i1)).copy().setStyle(Style.EMPTY), this.leftPos + 180, this.topPos + 15 + i1 * 12, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
                    }
                });
            }
            if (ScreenUtil.isMouseOver(i, j, this.leftPos + 124, this.topPos + 151, 36, 36)) {
                guiGraphics.renderTooltip(this.font, this.resultStack, i, j);
            }
        }
        for (int index = 0; index < this.ingredientsGrid.size(); ++index) {
            if (RecipeIconHolder.getActualItem(this.ingredientsGrid.get(index)).isEmpty() || !ScreenUtil.isMouseOver(i, j, this.leftPos + 21 + index % 3 * 23, this.topPos + 133 + index / 3 * 23, 23, 23)) continue;
            guiGraphics.renderTooltip(this.font, RecipeIconHolder.getActualItem(this.ingredientsGrid.get(index)), i, j);
        }
        this.getCraftingButtons().forEach(h -> h.renderTooltip(this.minecraft, guiGraphics, i, j));
        this.renderTooltip(guiGraphics, i, j);
    }

    public record BannerRecipe(List<Optional<Ingredient>> previewIngredients, List<Optional<Ingredient>> displayIngredients, ResourceKey<BannerPattern> pattern, DyeColor color) {
    }
}

