/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.Comparator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenAxis;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.controller.Controller;
import wily.legacy.client.screen.LegacyIconHolder;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.util.ScreenUtil;

public interface LegacyMenuAccess<T extends AbstractContainerMenu>
extends MenuAccess<T>,
GuiEventListener,
Controller.Event {
    default public void movePointerToSlotIn(ScreenDirection direction) {
        if (this.getMenu().slots.isEmpty() || Legacy4JClient.controllerManager.isCursorDisabled || this.findHoveredSlot() == null) {
            return;
        }
        double pointerX = Legacy4JClient.controllerManager.getPointerX();
        double pointerY = Legacy4JClient.controllerManager.getPointerY();
        int height = this.getRectangle().height();
        int width = this.getRectangle().width();
        boolean horizontal = direction.getAxis() == ScreenAxis.HORIZONTAL;
        boolean positive = direction.isPositive();
        if (this.getMenu().slots.size() == 1 && this.movePointerToSlot((Slot)this.getMenu().slots.get(0), false)) {
            return;
        }
        int part = this.getMenu().slots.stream().map(s -> Math.round((float)ScreenUtil.iconHolderRenderer.slotBounds((Slot)s).getMinSize() / 2.0f)).sorted().findFirst().orElse(9);
        double r = horizontal ? (double)height - pointerY : (double)width - pointerX;
        double l = horizontal ? pointerY : pointerX;
        int i = 0;
        while ((double)i < Math.max(r, l)) {
            if ((double)i <= r && this.movePointerToSlotIn(positive, horizontal, horizontal ? width : height, i, (int)pointerX, (int)pointerY, part)) {
                return;
            }
            if ((double)i <= l && this.movePointerToSlotIn(positive, horizontal, horizontal ? width : height, -i, (int)pointerX, (int)pointerY, part)) {
                return;
            }
            i += part;
        }
        i = 0;
        while ((double)i < Math.max(r, l)) {
            if ((double)i <= r && this.movePointerToSlotInReverse(positive, horizontal, horizontal ? width : height, i, (int)pointerX, (int)pointerY, part)) {
                return;
            }
            if ((double)i <= l && this.movePointerToSlotInReverse(positive, horizontal, horizontal ? width : height, -i, (int)pointerX, (int)pointerY, part)) {
                return;
            }
            i += part;
        }
    }

    default public boolean movePointerToSlotIn(boolean positive, boolean horizontal, int size, int pos, int pointerX, int pointerY, int part) {
        if (positive) {
            for (int j = part * 2; j < size - (horizontal ? pointerX : pointerY); j += part) {
                if (!this.movePointerToSlot(this.findSlotAt(pointerX + (horizontal ? j : pos), pointerY + (horizontal ? pos : j)), false)) continue;
                return true;
            }
        } else {
            for (int j = -part * 2; j >= -(horizontal ? pointerX : pointerY); j -= part) {
                if (!this.movePointerToSlot(this.findSlotAt(pointerX + (horizontal ? j : pos), pointerY + (horizontal ? pos : j)), false)) continue;
                return true;
            }
        }
        return false;
    }

    default public boolean movePointerToSlotInReverse(boolean positive, boolean horizontal, int size, int pos, int pointerX, int pointerY, int part) {
        if (positive) {
            for (int j = -(horizontal ? pointerX : pointerY) + part * 2; j < 0; j += part) {
                if (!this.movePointerToSlot(this.findSlotAt(pointerX + (horizontal ? j : pos), pointerY + (horizontal ? pos : j)), false)) continue;
                return true;
            }
        } else {
            for (int j = size - (horizontal ? pointerX : pointerY) - part * 2; j >= 0; j -= part) {
                if (!this.movePointerToSlot(this.findSlotAt(pointerX + (horizontal ? j : pos), pointerY + (horizontal ? pos : j)), false)) continue;
                return true;
            }
        }
        return false;
    }

    default public boolean movePointerToSlot(Slot s) {
        return this.movePointerToSlot(s, true);
    }

    default public boolean movePointerToSlot(Slot s, boolean allowHovered) {
        if (s == null || !allowHovered && s == this.findHoveredSlot() || !LegacySlotDisplay.isVisibleAndActive(s)) {
            return false;
        }
        Minecraft minecraft = Minecraft.getInstance();
        LegacyIconHolder holder = ScreenUtil.iconHolderRenderer.slotBounds(this.getMenuRectangle().left(), this.getMenuRectangle().top(), s);
        Legacy4JClient.controllerManager.setPointerPos(holder.getMiddleX() * ((double)minecraft.getWindow().getScreenWidth() / (double)minecraft.getWindow().getGuiScaledWidth()), holder.getMiddleY() * ((double)minecraft.getWindow().getScreenHeight() / (double)minecraft.getWindow().getGuiScaledHeight()));
        return true;
    }

    default public void movePointerToNextSlot() {
        if (this.getMenu().slots.isEmpty() || Legacy4JClient.controllerManager.isCursorDisabled || this.getHoveredSlot() == null) {
            return;
        }
        double pointerX = Legacy4JClient.controllerManager.getPointerX();
        double pointerY = Legacy4JClient.controllerManager.getPointerY();
        if (this.getMenu().slots.size() == 1 && this.movePointerToSlot((Slot)this.getMenu().slots.get(0))) {
            return;
        }
        this.getMenu().slots.stream().min(Comparator.comparingInt(s -> {
            LegacyIconHolder holder = ScreenUtil.iconHolderRenderer.slotBounds(this.getMenuRectangle().left(), this.getMenuRectangle().top(), (Slot)s);
            double deltaX = pointerX - holder.getMiddleX();
            double deltaY = pointerY - holder.getMiddleY();
            return (int)(deltaX * deltaX + deltaY * deltaY);
        })).ifPresent(this::movePointerToSlot);
    }

    public ScreenRectangle getMenuRectangle();

    public boolean isOutsideClick(int var1);

    public Slot getHoveredSlot();

    default public Slot findSlotAt(double d, double e) {
        for (Slot slot : this.getMenu().slots) {
            if (!ScreenUtil.isHovering(slot, this.getMenuRectangle().left(), this.getMenuRectangle().top(), d, e)) continue;
            return slot;
        }
        return null;
    }

    default public Slot findHoveredSlot() {
        return this.findSlotAt(Legacy4JClient.controllerManager.getPointerX(), Legacy4JClient.controllerManager.getPointerY());
    }

    default public int getTipXDiff() {
        return -132;
    }

    default public boolean allowItemPopping() {
        return false;
    }
}

