/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenAxis;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.resources.ResourceLocation;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.legacy.util.LegacySprites;

public class LegacyScrollRenderer {
    public static final ResourceLocation[] SCROLLS = new ResourceLocation[]{LegacySprites.SCROLL_UP, LegacySprites.SCROLL_DOWN, LegacySprites.SCROLL_LEFT, LegacySprites.SCROLL_RIGHT};
    public final long[] lastScrolled = new long[4];
    public long lastScroll = 0L;
    public ScreenDirection lastDirection;

    public void updateScroll(ScreenDirection direction) {
        this.lastDirection = direction;
        long l = Util.getMillis();
        this.lastScrolled[direction.ordinal()] = l;
        this.lastScroll = l;
    }

    public void renderScroll(GuiGraphics graphics, ScreenDirection direction, int x, int y) {
        boolean h = direction.getAxis() == ScreenAxis.HORIZONTAL;
        FactoryScreenUtil.enableBlend();
        long l = this.lastScrolled[direction.ordinal()];
        if (l > 0L) {
            float f = (float)(Util.getMillis() - l) / 320.0f;
            float fade = Math.min(1.0f, f < 0.5f ? 1.0f - f * 2.0f : (f - 0.5f) * 2.0f);
            FactoryGuiGraphics.of((GuiGraphics)graphics).setColor(1.0f, 1.0f, 1.0f, fade);
        }
        FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(SCROLLS[direction.ordinal()], x, y, h ? 6 : 13, h ? 11 : 7);
        if (l > 0L) {
            FactoryGuiGraphics.of((GuiGraphics)graphics).clearColor();
        }
        FactoryScreenUtil.disableBlend();
    }
}

