/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import wily.legacy.Legacy4JClient;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.util.ScreenUtil;

public class LegacySliderButton<T>
extends AbstractSliderButton {
    private final Function<LegacySliderButton<T>, Component> messageGetter;
    private final Function<LegacySliderButton<T>, T> valueGetter;
    private final Function<T, Double> valueSetter;
    private final Consumer<LegacySliderButton<T>> onChange;
    private final Function<LegacySliderButton<T>, Tooltip> tooltipSupplier;
    private int slidingMul = 1;
    private int lastSliderInput = -1;
    protected T objectValue;

    public LegacySliderButton(int i, int j, int k, int l, Function<LegacySliderButton<T>, Component> messageGetter, Function<LegacySliderButton<T>, Tooltip> tooltipSupplier, T initialValue, Function<LegacySliderButton<T>, T> valueGetter, Function<T, Double> valueSetter, Consumer<LegacySliderButton<T>> onChange) {
        super(i, j, k, l, (Component)Component.empty(), valueSetter.apply(initialValue).doubleValue());
        this.messageGetter = messageGetter;
        this.valueGetter = valueGetter;
        this.valueSetter = valueSetter;
        this.onChange = onChange;
        this.tooltipSupplier = tooltipSupplier;
        this.objectValue = initialValue;
        this.updateMessage();
    }

    public static <T> LegacySliderButton<T> createFromInt(int i, int j, int k, int l, Function<LegacySliderButton<T>, Component> messageGetter, Function<LegacySliderButton<T>, Tooltip> tooltipSupplier, T initialValue, Function<Integer, T> valueGetter, Function<T, Integer> valueSetter, Supplier<Integer> valuesSize, Consumer<LegacySliderButton<T>> onChange) {
        return new LegacySliderButton<Object>(i, j, k, l, messageGetter, tooltipSupplier, initialValue, b -> valueGetter.apply((int)Math.round(b.value * (double)((Integer)valuesSize.get() - 1))), t -> Math.max(0.0, (double)((Integer)valueSetter.apply(t)).intValue()) / (double)((Integer)valuesSize.get() - 1), onChange);
    }

    public LegacySliderButton(int i, int j, int k, int l, Function<LegacySliderButton<T>, Component> messageGetter, Function<LegacySliderButton<T>, Tooltip> tooltipSupplier, T initialValue, Supplier<List<T>> values, Consumer<LegacySliderButton<T>> onChange) {
        this(i, j, k, l, messageGetter, tooltipSupplier, initialValue, b -> ((List)values.get()).get((int)Math.round(b.value * (double)(((List)values.get()).size() - 1))), t -> Math.max(0.0, (double)((List)values.get()).indexOf(t)) / (double)(((List)values.get()).size() - 1), onChange);
    }

    public static LegacySliderButton<Integer> createFromIntRange(int i, int j, int k, int l, Function<LegacySliderButton<Integer>, Component> messageGetter, Function<LegacySliderButton<Integer>, Tooltip> tooltipSupplier, Integer initialValue, int min, IntSupplier max, Consumer<LegacySliderButton<Integer>> onChange) {
        return new LegacySliderButton<Integer>(i, j, k, l, messageGetter, tooltipSupplier, initialValue, b -> min + (int)Math.round(b.value * (double)(max.getAsInt() - min)), t -> Math.max(0.0, Math.min((double)(t - min) / (double)(max.getAsInt() - min), 1.0)), onChange);
    }

    public static LegacySliderButton<Integer> createFromIntRange(int i, int j, int k, int l, Function<LegacySliderButton<Integer>, Component> messageGetter, Function<LegacySliderButton<Integer>, Tooltip> tooltipSupplier, Integer initialValue, int min, int max, Consumer<LegacySliderButton<Integer>> onChange) {
        return LegacySliderButton.createFromIntRange(i, j, k, l, messageGetter, tooltipSupplier, initialValue, min, () -> max, onChange);
    }

    public Component getDefaultMessage(Component caption, Component visibleValue) {
        return CommonComponents.optionNameValue((Component)caption, (Component)visibleValue);
    }

    public T getObjectValue() {
        return this.objectValue == null ? this.valueGetter.apply(this) : this.objectValue;
    }

    public double getValue() {
        return this.value;
    }

    protected void updateMessage() {
        this.setTooltip(this.tooltipSupplier.apply(this));
    }

    public void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
        this.setMessage(this.messageGetter.apply(this));
        super.renderWidget(guiGraphics, i, j, f);
    }

    public void setFocused(boolean bl) {
        super.setFocused(bl);
        if (bl) {
            this.canChangeValue = Legacy4JClient.controllerManager.canChangeSlidersValue;
        }
    }

    public boolean keyPressed(int i, int j, int k) {
        if (!this.active) {
            return false;
        }
        if (CommonInputs.selected((int)i)) {
            this.canChangeValue = !this.canChangeValue;
            Legacy4JClient.controllerManager.canChangeSlidersValue = this.canChangeValue;
            return true;
        }
        if (this.canChangeValue) {
            boolean bl;
            boolean bl2 = bl = i == 263;
            if (bl && this.value > 0.0 || i == 262 && this.value < 1.0) {
                if (this.slidingMul > 0 && i != this.lastSliderInput) {
                    this.slidingMul = 1;
                }
                this.lastSliderInput = i;
                double part = 1.0 / (double)(this.width - 8) * (double)this.slidingMul;
                T v = this.getObjectValue();
                while (v.equals(this.getObjectValue())) {
                    this.setValue(this.value + (bl ? -part : part));
                    if (part >= 1.0) break;
                    part = Math.min(part * 2.0, 1.0);
                }
                ++this.slidingMul;
                return true;
            }
        }
        return false;
    }

    public boolean keyReleased(int i, int j, int k) {
        if (this.canChangeValue && (i == 263 || i == 262)) {
            this.slidingMul = 1;
        }
        return false;
    }

    public void setObjectValue(T objectValue) {
        this.objectValue = objectValue;
        this.value = this.valueSetter.apply(objectValue);
    }

    protected void applyValue() {
        T oldValue = this.objectValue;
        this.setObjectValue(this.valueGetter.apply(this));
        if (!oldValue.equals(this.objectValue)) {
            ScreenUtil.playSimpleUISound((SoundEvent)LegacyRegistries.SCROLL.get(), 1.0f);
            this.onChange.accept(this);
        }
    }
}

