/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.mojang.datafixers.util.Pair;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.commands.PublishCommand;
import net.minecraft.util.HttpUtil;
import net.minecraft.world.level.GameType;
import wily.factoryapi.FactoryAPI;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.LegacyClientWorldSettings;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.LegacySliderButton;
import wily.legacy.client.screen.LoadSaveScreen;

public class PublishScreen
extends ConfirmationScreen {
    public static final Component PORT_INFO_TEXT = Component.translatable((String)"lanServer.port");
    public static final Component LAN_SERVER = Component.translatable((String)"lanServer.title");
    public static final Component PUBLISH = Component.translatable((String)(PublishScreen.hasWorldHost() ? "legacy.menu.online" : "menu.shareToLan"));
    public boolean publish = false;
    protected EditBox portEdit;
    protected final LegacySliderButton<GameType> gameTypeSlider;
    private int port = HttpUtil.getAvailablePort();

    public static boolean hasWorldHost() {
        return FactoryAPI.isModLoaded((String)(FactoryAPI.getLoader().isForgeLike() ? "world_host" : "world-host"));
    }

    public PublishScreen(Screen parent, GameType gameType, Consumer<PublishScreen> okAction) {
        super(parent, 230, 145, LAN_SERVER, (Component)Component.translatable((String)"lanServer.port"), b -> {});
        this.okAction = s -> {
            this.publish = true;
            okAction.accept(this);
            s.onClose();
        };
        this.gameTypeSlider = new LegacySliderButton<GameType>(0, 0, 200, 16, b -> b.getDefaultMessage(LoadSaveScreen.GAME_MODEL_LABEL, ((GameType)b.getObjectValue()).getLongDisplayName()), b -> Tooltip.create((Component)Component.translatable((String)("selectWorld.gameMode." + ((GameType)b.getObjectValue()).getName() + ".info"))), gameType, () -> LoadSaveScreen.GAME_TYPES, b -> {});
    }

    public PublishScreen(Screen parent, GameType gameType) {
        this(parent, gameType, (PublishScreen s) -> {});
    }

    public void repositionElements() {
        String string = this.portEdit.getValue();
        super.repositionElements();
        this.portEdit.setValue(string);
    }

    @Override
    protected void init() {
        super.init();
        this.portEdit = new EditBox(this.font, this.panel.x + this.panel.width / 2 - 100, this.panel.y + 45, 200, 20, PORT_INFO_TEXT);
        this.portEdit.setHint((Component)Component.literal((String)("" + this.port)).withStyle(ChatFormatting.DARK_GRAY));
        this.portEdit.setMaxLength(128);
        this.portEdit.setResponder(string -> {
            Pair<Integer, Component> p = Legacy4JClient.tryParsePort(string);
            if (p.getFirst() != null) {
                this.port = (Integer)p.getFirst();
            }
            this.portEdit.setHint((Component)Component.literal((String)("" + this.port)).withStyle(ChatFormatting.DARK_GRAY));
            if (p.getSecond() == null) {
                this.portEdit.setTextColor(0xE0E0E0);
                this.portEdit.setTooltip(null);
                this.okButton.active = true;
            } else {
                this.portEdit.setTextColor(0xFF5555);
                this.portEdit.setTooltip(Tooltip.create((Component)((Component)p.getSecond())));
                this.okButton.active = false;
            }
        });
        this.addRenderableWidget((GuiEventListener)this.portEdit);
        this.gameTypeSlider.setPosition(this.panel.x + this.panel.width / 2 - 100, this.panel.y + 69);
        this.addRenderableWidget((GuiEventListener)this.gameTypeSlider);
    }

    public void publish(IntegratedServer server) {
        if (!this.publish) {
            return;
        }
        FactoryAPI.SECURE_EXECUTOR.executeNowIfPossible(() -> this.minecraft.gui.getChat().addMessage((Component)(server.publishServer(this.gameTypeSlider.getObjectValue(), server.getWorldData().getAllowCommands() && LegacyClientWorldSettings.of(server.getWorldData()).trustPlayers(), this.port) ? PublishCommand.getSuccessMessage((int)this.port) : Component.translatable((String)"commands.publish.failed"))), () -> Minecraft.getInstance().player != null);
    }
}

