/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.FactoryIngredient;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.network.CommonNetwork;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacyTip;
import wily.legacy.client.LegacyTipManager;
import wily.legacy.client.RecipeInfo;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyIconHolder;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.inventory.LegacyCraftingMenu;
import wily.legacy.network.ServerMenuCraftPayload;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public abstract class RecipeIconHolder<R>
extends LegacyIconHolder
implements ControlTooltip.ActionHolder {
    public static final Component NOT_ENOUGH_INGREDIENTS = Component.translatable((String)"legacy.hint.not_enough_ingredients");
    protected int selectionOffset = 0;
    boolean isHoveredTop = false;
    boolean isHoveredBottom = false;
    protected List<RecipeInfo<R>> focusedRecipes;
    protected final Minecraft minecraft = Minecraft.getInstance();
    protected boolean allowCraftableRecipesToggle = true;

    public RecipeIconHolder(int x, int y) {
        super(x, y, 27, 27);
        this.allowItemDecorations = false;
    }

    @Override
    public void render(GuiGraphics graphics, int i, int j, float f) {
        this.isHoveredTop = this.isFocused() && this.getFocusedRecipes().size() > 2 && this.isMouseOver(i, j, -1);
        this.isHoveredBottom = this.isFocused() && this.getFocusedRecipes().size() >= 2 && this.isMouseOver(i, j, 1);
        this.itemIcon = this.isValidIndex() ? this.getFocusedRecipes().get(0).getResultItem() : ItemStack.EMPTY;
        super.render(graphics, i, j, f);
    }

    @Override
    public void renderItem(GuiGraphics graphics, int i, int j, float f) {
        if (!this.isValidIndex()) {
            return;
        }
        ScreenUtil.secureTranslucentRender(graphics, !this.canCraft(this.getFocusedRecipes().get(0)), 0.5f, u -> super.renderItem(graphics, i, j, f));
    }

    protected abstract boolean canCraft(RecipeInfo<R> var1);

    public boolean canCraft() {
        return this.canCraft(this.getFocusedRecipe());
    }

    List<RecipeInfo<R>> getFocusedRecipes() {
        if (!(this.isFocused() && this.isValidIndex() && this.canScroll())) {
            this.focusedRecipes = null;
        } else if (this.focusedRecipes == null) {
            this.focusedRecipes = new ArrayList<RecipeInfo<R>>(this.getRecipes());
        }
        return this.focusedRecipes == null ? this.getRecipes() : this.focusedRecipes;
    }

    protected abstract List<RecipeInfo<R>> getRecipes();

    @Override
    public void setFocused(boolean bl) {
        if (bl) {
            this.selectionOffset = 0;
            this.updateRecipeDisplay();
        }
        super.setFocused(bl);
    }

    @Override
    public void renderTooltip(Minecraft minecraft, GuiGraphics graphics, int i, int j) {
        super.renderTooltip(minecraft, graphics, i, j);
        if (!this.isFocused()) {
            return;
        }
        if (this.getFocusedRecipes().size() <= 1) {
            return;
        }
        if (this.isHoveredTop) {
            this.renderTooltip(minecraft, graphics, this.getFocusedRecipes().get(this.getFocusedRecipes().size() - 1).getResultItem(), i, j);
        }
        if (this.isHoveredBottom) {
            this.renderTooltip(minecraft, graphics, this.getFocusedRecipes().get(1).getResultItem(), i, j);
        }
    }

    protected RecipeInfo<R> getFocusedRecipe() {
        if (this.selectionOffset > 0 && this.getFocusedRecipes().size() < 2 || this.selectionOffset < 0 && this.getFocusedRecipes().size() <= 2) {
            this.selectionOffset = 0;
        }
        return this.isValidIndex() ? this.getFocusedRecipes().get(this.getSelectionIndex()) : null;
    }

    protected ItemStack getFocusedResult() {
        return this.getFocusedRecipe() == null ? ItemStack.EMPTY : this.getFocusedRecipe().getResultItem();
    }

    public void updateRecipeDisplay() {
        this.updateRecipeDisplay(this.getFocusedRecipe());
    }

    protected abstract void toggleCraftableRecipes();

    public boolean controlCyclicNavigation(int i, int index, List<RecipeIconHolder<R>> craftingButtons, Stocker.Sizeable craftingOffset, LegacyScrollRenderer renderer, Screen screen) {
        if (i == 263 && index == 0 || i == 262 && index == craftingButtons.size() - 1) {
            int oldOffset = (Integer)craftingOffset.get();
            craftingOffset.add(i == 263 ? -1 : 1, true);
            if (oldOffset == craftingOffset.max && i == 262 || oldOffset == 0 && i == 263) {
                screen.setFocused((GuiEventListener)craftingButtons.get(i == 263 ? craftingButtons.size() - 1 : 0));
            } else {
                renderer.updateScroll(i == 263 ? ScreenDirection.LEFT : ScreenDirection.RIGHT);
                this.focusedRecipes = null;
            }
            ScreenUtil.playSimpleUISound((SoundEvent)LegacyRegistries.FOCUS.get(), true);
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(int i, int j, int k) {
        if (i == 79 && this.allowCraftableRecipesToggle) {
            this.focusedRecipes = null;
            this.selectionOffset = 0;
            this.toggleCraftableRecipes();
            this.updateRecipeDisplay();
            ScreenUtil.playSimpleUISound((SoundEvent)LegacyRegistries.FOCUS.get(), true);
            return true;
        }
        int oldSelection = this.selectionOffset;
        if ((i == 265 || i == 264) && this.isValidIndex()) {
            if (i == 265 && (this.getRecipes().size() > 2 || this.selectionOffset == 1)) {
                this.selectionOffset = Math.max(this.selectionOffset - 1, -1);
            }
            if (i == 264 && this.getRecipes().size() >= 2) {
                this.selectionOffset = Math.min(this.selectionOffset + 1, 1);
            }
            if (oldSelection != this.selectionOffset || this.canScroll()) {
                ScreenUtil.playSimpleUISound((SoundEvent)LegacyRegistries.FOCUS.get(), true);
                if (oldSelection == this.selectionOffset && this.selectionOffset != 0) {
                    Collections.rotate(this.getFocusedRecipes(), -this.selectionOffset);
                }
                this.updateRecipeDisplay(this.getFocusedRecipe());
                return true;
            }
        }
        return super.keyPressed(i, j, k);
    }

    protected abstract void updateRecipeDisplay(RecipeInfo<R> var1);

    public static ItemStack getActualItem(Optional<Ingredient> ingredient) {
        return ingredient.isEmpty() || FactoryIngredient.of((Ingredient)ingredient.get()).getStacks().length == 0 ? ItemStack.EMPTY : FactoryIngredient.of((Ingredient)ingredient.get()).getStacks()[(int)(Util.getMillis() / 800L % (long)FactoryIngredient.of((Ingredient)ingredient.get()).getStacks().length)];
    }

    @Override
    public void renderSelection(GuiGraphics graphics, int i, int j, float f) {
        if (this.isValidIndex()) {
            graphics.pose().pushPose();
            graphics.pose().translate(this.getXCorner() - 4.5f, this.getYCorner(), 0.0f);
            this.applyOffset(graphics);
            FactoryGuiGraphics.of((GuiGraphics)graphics).disableDepthTest();
            if (this.getFocusedRecipes().size() == 2) {
                FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(LegacySprites.CRAFTING_2_SLOTS_SELECTION, 0, -12, 36, 78);
            } else if (this.getFocusedRecipes().size() > 2) {
                FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(LegacySprites.CRAFTING_SELECTION, 0, -39, 36, 105);
            }
            graphics.pose().popPose();
            if (this.getFocusedRecipes().size() >= 2) {
                ScreenUtil.secureTranslucentRender(graphics, !this.canCraft(this.getFocusedRecipes().get(1)), 0.5f, u -> this.renderItem(graphics, this.getFocusedRecipes().get(1).getResultItem(), this.getX(), this.getY() + 27, false));
                if (this.getFocusedRecipes().size() >= 3) {
                    ScreenUtil.secureTranslucentRender(graphics, !this.canCraft(this.getFocusedRecipes().get(this.getFocusedRecipes().size() - 1)), 0.5f, u -> this.renderItem(graphics, this.getFocusedRecipes().get(this.getFocusedRecipes().size() - 1).getResultItem(), this.getX(), this.getY() - 27, false));
                }
            }
            FactoryGuiGraphics.of((GuiGraphics)graphics).enableDepthTest();
        }
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, (float)(this.selectionOffset * 27), 0.0f);
        super.renderSelection(graphics, i, j, f);
        graphics.pose().popPose();
    }

    protected boolean canScroll() {
        return this.getRecipes().size() >= 3;
    }

    protected boolean isValidIndex() {
        return !this.getRecipes().isEmpty();
    }

    protected int getSelectionIndex() {
        return this.selectionOffset == -1 ? this.getFocusedRecipes().size() - 1 : (this.selectionOffset == 1 ? 1 : 0);
    }

    public boolean mouseScrolled(double d, double e, double f, double g) {
        if (this.isFocused() && this.canScroll()) {
            Collections.rotate(this.getFocusedRecipes(), (int)Math.signum(g));
            this.updateRecipeDisplay();
            return true;
        }
        return false;
    }

    protected boolean isMouseOver(double d, double e, int selection) {
        return ScreenUtil.isMouseOver(d, e, this.getXCorner(), this.getYCorner() + (float)(selection * 27), this.getWidth(), this.getHeight());
    }

    @Override
    public boolean isMouseOver(double d, double e) {
        return this.isHovered || this.isHoveredTop || this.isHoveredBottom;
    }

    @Override
    public void onClick(double d, double e) {
        int oldSelection = this.selectionOffset;
        int n = this.isHoveredTop ? -1 : (this.selectionOffset = this.isHoveredBottom ? 1 : 0);
        if (oldSelection != this.selectionOffset) {
            this.updateRecipeDisplay();
        } else {
            super.onClick(d, e);
        }
    }

    public void craft() {
        CommonNetwork.sendToServer((CommonNetwork.Payload)new ServerMenuCraftPayload(this.getFocusedRecipe(), Screen.hasShiftDown() || ControllerBinding.LEFT_STICK_BUTTON.state().pressed));
    }

    @Override
    public void onPress() {
        if (this.isFocused() && this.isValidIndex()) {
            if (this.canCraft(this.getFocusedRecipe())) {
                this.craft();
                this.updateRecipeDisplay(this.getFocusedRecipe());
            } else {
                AbstractContainerMenu abstractContainerMenu = this.minecraft.player.containerMenu;
                if (abstractContainerMenu instanceof LegacyCraftingMenu) {
                    LegacyCraftingMenu m = (LegacyCraftingMenu)abstractContainerMenu;
                    if (!m.showedNotEnoughIngredientsHint && ((Boolean)LegacyOptions.hints.get()).booleanValue()) {
                        m.showedNotEnoughIngredientsHint = true;
                        LegacyTipManager.setActualTip(new LegacyTip(null, NOT_ENOUGH_INGREDIENTS));
                    }
                }
                ScreenUtil.playSimpleUISound((SoundEvent)LegacyRegistries.CRAFT_FAIL.get(), 1.0f);
            }
        }
    }

    @Override
    @Nullable
    public Component getAction(ControlTooltip.ActionHolder.Context context) {
        return context.actionOfContext(ControlTooltip.ActionHolder.KeyContext.class, c -> c.key() == 257 && this.canCraft() && this.isValidIndex() && this.isFocused() ? LegacyComponents.CREATE : null);
    }
}

