/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.inventory;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.FactoryIngredient;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.inventory.RecipeMenu;
import wily.legacy.network.ServerMenuCraftPayload;

public abstract class LegacyCraftingMenu
extends AbstractContainerMenu
implements RecipeMenu {
    public static final Component CRAFTING_TITLE = Component.translatable((String)"container.crafting");
    public static final Component STONECUTTER_TITLE = Component.translatable((String)"container.stonecutter");
    public static final Component LOOM_TITLE = Component.translatable((String)"container.loom");
    public static final Map<ResourceKey<BannerPattern>, Optional<Ingredient>> LOOM_PATTERN_EXTRA_INGREDIENT_CACHE = new ConcurrentHashMap<ResourceKey<BannerPattern>, Optional<Ingredient>>();
    public final Predicate<Player> stillValid;
    public boolean inventoryActive = true;
    public static final Vec3 DEFAULT_INVENTORY_OFFSET = new Vec3(0.5, 0.5, 0.0);
    public Vec3 inventoryOffset = DEFAULT_INVENTORY_OFFSET;
    public boolean showedNotEnoughIngredientsHint = false;

    public static LegacyCraftingMenu craftingMenu(Inventory inventory, @Nullable MenuType<?> menuType, int i, BlockPos pos, final int gridDimension) {
        return new LegacyCraftingMenu(inventory, menuType, i, p -> pos == null || LegacyCraftingMenu.isValidBlock(p, pos, Blocks.CRAFTING_TABLE)){
            RecipeHolder<CraftingRecipe> customRcp;
            final CraftingContainer container;
            {
                super(inventory, menuType, i, stillValid);
                this.container = new TransientCraftingContainer((AbstractContainerMenu)this, gridDimension, gridDimension);
            }

            @Override
            public void onCraft(Player player, ServerMenuCraftPayload packet, ItemStack result) {
                super.onCraft(player, packet, result);
                if (packet.craftId().isPresent() || this.customRcp != null) {
                    player.getServer().getRecipeManager().byKey(this.customRcp == null ? this.getRecipeKey(packet.craftId().get()) : this.customRcp.id()).ifPresent(h -> player.triggerRecipeCrafted(h, this.container.getItems()));
                }
            }

            @Override
            public ItemStack getResult(Player player, ServerMenuCraftPayload packet) {
                if (packet.craftId().isEmpty()) {
                    return player.getServer().getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (Container)this.container, player.level()).map(h -> {
                        this.customRcp = h;
                        return ((CraftingRecipe)this.customRcp.value()).assemble((Container)this.container, player.level().registryAccess());
                    }).orElse(ItemStack.EMPTY);
                }
                return player.getServer().getRecipeManager().byKey(this.getRecipeKey(packet.craftId().get())).map(h -> {
                    ItemStack itemStack;
                    Recipe patt0$temp = h.value();
                    if (patt0$temp instanceof CraftingRecipe) {
                        CraftingRecipe rcp = (CraftingRecipe)patt0$temp;
                        itemStack = rcp.assemble((Container)this.container, player.level().registryAccess());
                    } else {
                        itemStack = null;
                    }
                    return itemStack;
                }).orElse(ItemStack.EMPTY);
            }

            @Override
            public List<ItemStack> getRemainingItems(Player player, ServerMenuCraftPayload packet) {
                return player.getServer().getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (Container)this.container, player.level()).map(h -> ((CraftingRecipe)h.value()).getRemainingItems((Container)this.container)).orElse(super.getRemainingItems(player, packet));
            }

            @Override
            public List<Optional<Ingredient>> getIngredients(Player player, ServerMenuCraftPayload packet) {
                return packet.craftId().isEmpty() || !packet.customIngredients().isEmpty() ? super.getIngredients(player, packet) : player.getServer().getRecipeManager().byKey(this.getRecipeKey(packet.craftId().get())).map(r -> 1.getRecipeOptionalIngredients(r.value())).orElse(Collections.emptyList());
            }

            @Override
            public void setupActualItems(Player player, ServerMenuCraftPayload packet, ItemStack setItem, int index) {
                if (setItem == null) {
                    this.container.clearContent();
                } else {
                    this.container.setItem(index, setItem);
                }
            }
        };
    }

    public static List<Optional<Ingredient>> getRecipeOptionalIngredients(Recipe<?> recipe) {
        return LegacyCraftingMenu.convertIngredientsToOptional((List<Ingredient>)recipe.getIngredients());
    }

    static List<Optional<Ingredient>> convertIngredientsToOptional(List<Ingredient> ingredients) {
        return ingredients.stream().map(i -> i.isEmpty() ? Optional.empty() : Optional.of(i)).toList();
    }

    public static LegacyCraftingMenu playerCraftingMenu(int window, Inventory inventory) {
        return LegacyCraftingMenu.craftingMenu(inventory, (MenuType)LegacyRegistries.PLAYER_CRAFTING_PANEL_MENU.get(), window, null, 2);
    }

    public static LegacyCraftingMenu craftingMenu(int window, Inventory inventory, BlockPos pos) {
        return LegacyCraftingMenu.craftingMenu(inventory, (MenuType)LegacyRegistries.CRAFTING_PANEL_MENU.get(), window, pos, 3);
    }

    public static LegacyCraftingMenu craftingMenu(int window, Inventory inventory) {
        return LegacyCraftingMenu.craftingMenu(window, inventory, null);
    }

    public static LegacyCraftingMenu loomMenu(int window, Inventory inventory, BlockPos blockPos) {
        return new LegacyCraftingMenu(inventory, (MenuType)LegacyRegistries.LOOM_PANEL_MENU.get(), window, p -> LegacyCraftingMenu.isValidBlock(p, blockPos, Blocks.LOOM)){
            final Container container = new SimpleContainer(3);

            @Override
            public List<Optional<Ingredient>> getIngredients(Player player, ServerMenuCraftPayload packet) {
                List customIngredients = super.getIngredients(player, packet);
                if (packet.craftId().isPresent() && customIngredients.size() == 2 && Arrays.stream(FactoryIngredient.of((Ingredient)((Ingredient)((Optional)customIngredients.get(0)).get())).getStacks()).allMatch(i -> i.getItem() instanceof BannerItem) && Arrays.stream(FactoryIngredient.of((Ingredient)((Ingredient)((Optional)customIngredients.get(1)).get())).getStacks()).allMatch(i -> i.getItem() instanceof DyeItem)) {
                    return player.level().registryAccess().lookup(Registries.BANNER_PATTERN).flatMap(b -> b.get(ResourceKey.create((ResourceKey)Registries.BANNER_PATTERN, (ResourceLocation)packet.craftId().get())).map(p -> {
                        Optional<Ingredient> extraIng = 2.getBannerPatternExtraIngredient(player.level().registryAccess(), (ResourceKey<BannerPattern>)p.key());
                        if (extraIng.isEmpty()) {
                            return customIngredients;
                        }
                        return ImmutableList.builder().addAll((Iterable)customIngredients).add(extraIng).build();
                    })).orElse(Collections.emptyList());
                }
                return Collections.emptyList();
            }

            @Override
            public ItemStack getResult(Player player, ServerMenuCraftPayload packet) {
                return player.level().registryAccess().lookup(Registries.BANNER_PATTERN).flatMap(b -> b.get(ResourceKey.create((ResourceKey)Registries.BANNER_PATTERN, (ResourceLocation)packet.craftId().get())).map(p -> {
                    ItemStack banner = this.container.getItem(0);
                    CompoundTag beTag = banner.getOrCreateTagElement("BlockEntityTag");
                    ListTag patternsTag = beTag.getList("Patterns", 10);
                    beTag.put("Patterns", (Tag)patternsTag);
                    CompoundTag patternTag = new CompoundTag();
                    patternsTag.add((Object)patternTag);
                    patternTag.putString("Pattern", ((BannerPattern)p.value()).getHashname());
                    patternTag.putInt("Color", ((DyeItem)this.container.getItem(1).getItem()).getDyeColor().getId());
                    return banner;
                })).orElse(ItemStack.EMPTY);
            }

            @Override
            public List<ItemStack> getRemainingItems(Player player, ServerMenuCraftPayload packet) {
                return this.container.getItem(2).isEmpty() ? super.getRemainingItems(player, packet) : List.of(this.container.getItem(2));
            }

            @Override
            public void setupActualItems(Player player, ServerMenuCraftPayload packet, ItemStack setItem, int index) {
                if (setItem == null) {
                    this.container.clearContent();
                } else {
                    this.container.setItem(index, setItem);
                }
            }
        };
    }

    public static LegacyCraftingMenu loomMenu(int window, Inventory inventory) {
        return LegacyCraftingMenu.loomMenu(window, inventory, null);
    }

    public static LegacyCraftingMenu stoneCutterMenu(int window, Inventory inventory, final BlockPos blockPos) {
        return new LegacyCraftingMenu(inventory, (MenuType)LegacyRegistries.STONECUTTER_PANEL_MENU.get(), window, p -> LegacyCraftingMenu.isValidBlock(p, blockPos, Blocks.STONECUTTER)){
            long lastSoundTime;

            @Override
            public void onCraft(Player player, ServerMenuCraftPayload packet, ItemStack result) {
                super.onCraft(player, packet, result);
                long l = player.level().getGameTime();
                if (this.lastSoundTime != l) {
                    player.level().playSound(null, blockPos, SoundEvents.UI_STONECUTTER_TAKE_RESULT, SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.lastSoundTime = l;
                }
            }

            @Override
            public List<Optional<Ingredient>> getIngredients(Player player, ServerMenuCraftPayload packet) {
                return player.getServer().getRecipeManager().byKey(this.getRecipeKey(packet.craftId().get())).map(r -> 3.getRecipeOptionalIngredients(r.value())).orElse(Collections.emptyList());
            }

            @Override
            public ItemStack getResult(Player player, ServerMenuCraftPayload packet) {
                return player.getServer().getRecipeManager().byKey(this.getRecipeKey(packet.craftId().get())).map(h -> {
                    ItemStack itemStack;
                    Recipe patt0$temp = h.value();
                    if (patt0$temp instanceof StonecutterRecipe) {
                        StonecutterRecipe rcp = (StonecutterRecipe)patt0$temp;
                        itemStack = rcp.assemble(null, player.level().registryAccess());
                    } else {
                        itemStack = null;
                    }
                    return itemStack;
                }).orElse(ItemStack.EMPTY);
            }
        };
    }

    public static LegacyCraftingMenu stoneCutterMenu(int window, Inventory inventory) {
        return LegacyCraftingMenu.stoneCutterMenu(window, inventory, null);
    }

    public LegacyCraftingMenu(@Nullable MenuType<?> menuType, int i, Predicate<Player> stillValid) {
        super(menuType, i);
        this.stillValid = stillValid;
    }

    public LegacyCraftingMenu(Inventory inventory, @Nullable MenuType<?> menuType, int i, Predicate<Player> stillValid) {
        this(menuType, i, stillValid);
        this.addInventorySlotGrid((Container)inventory, 9, 186, 133, 3);
        this.addInventorySlotGrid((Container)inventory, 0, 186, 186, 1);
    }

    public static List<Optional<Ingredient>> updateShapedIngredients(List<Optional<Ingredient>> ingredientsGrid, List<Optional<Ingredient>> recipeIngredients, int gridDimension, int rcpWidth, int rcpHeight) {
        int i;
        int rcpDimension = Math.max(rcpWidth, rcpHeight);
        if (rcpDimension > gridDimension) {
            return Collections.emptyList();
        }
        Ingredient[] ingredients = new Ingredient[rcpDimension * rcpDimension];
        for (i = 0; i < recipeIngredients.size(); ++i) {
            ingredients[rcpWidth < rcpHeight ? i / rcpWidth * rcpHeight + i % rcpWidth : i] = recipeIngredients.get(i).orElse(null);
        }
        for (i = 0; i < ingredients.length; ++i) {
            ingredientsGrid.set(i > 1 && gridDimension > rcpDimension ? i + 1 : i, Optional.ofNullable(ingredients[i]));
        }
        return ingredientsGrid;
    }

    public static Optional<Ingredient> getBannerPatternExtraIngredient(RegistryAccess registryAccess, ResourceKey<BannerPattern> pattern) {
        return LOOM_PATTERN_EXTRA_INGREDIENT_CACHE.computeIfAbsent(pattern, key -> {
            Holder.Reference holder = registryAccess.lookupOrThrow(Registries.BANNER_PATTERN).getOrThrow(pattern);
            for (Item item : BuiltInRegistries.ITEM) {
                BannerPatternItem p;
                if (!(item instanceof BannerPatternItem) || !holder.is((p = (BannerPatternItem)item).getBannerPattern())) continue;
                return Optional.of(Ingredient.of((ItemLike[])new ItemLike[]{item}));
            }
            return Optional.empty();
        });
    }

    public ResourceLocation getRecipeKey(ResourceLocation id) {
        return id;
    }

    public void addInventorySlotGrid(Container container, int startIndex, int x, int y, int rows) {
        for (int j = 0; j < rows; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(LegacySlotDisplay.override(new Slot(container, startIndex + j * 9 + k, x + k * 16, y + j * 16){

                    public void setChanged() {
                        super.setChanged();
                        LegacyCraftingMenu.this.slotsChanged(this.container);
                    }

                    public boolean isActive() {
                        return LegacyCraftingMenu.this.inventoryActive;
                    }
                }, new LegacySlotDisplay(){

                    @Override
                    public Vec3 getOffset() {
                        return LegacyCraftingMenu.this.inventoryOffset;
                    }

                    @Override
                    public int getWidth() {
                        return 16;
                    }

                    @Override
                    public int getHeight() {
                        return 16;
                    }
                }));
            }
        }
    }

    public ItemStack quickMoveStack(Player player, int i) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i);
        if (slot.hasItem()) {
            ItemStack itemStack2 = slot.getItem();
            itemStack = itemStack2.copy();
            if (i >= 0 && i < 27 ? !this.moveItemStackTo(itemStack2, 27, 36, false) : !this.moveItemStackTo(itemStack2, 0, 27, false)) {
                return ItemStack.EMPTY;
            }
            if (itemStack2.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY, itemStack);
            } else {
                slot.setChanged();
            }
            if (itemStack2.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemStack2);
        }
        return itemStack;
    }

    public boolean stillValid(Player player) {
        return this.stillValid.test(player);
    }

    public static boolean isValidBlock(Player player, BlockPos pos, Block wantedBlock) {
        return player.level().getBlockState(pos).is(wantedBlock) && player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0;
    }

    public static MenuProvider getMenuProvider(BlockPos pos, boolean is2x2) {
        return new SimpleMenuProvider((i, inventory, player) -> is2x2 ? LegacyCraftingMenu.playerCraftingMenu(i, inventory) : LegacyCraftingMenu.craftingMenu(i, inventory, pos), CRAFTING_TITLE);
    }

    public static MenuProvider getMenuProvider(MenuConstructor constructor, Component component) {
        return new SimpleMenuProvider(constructor, component);
    }

    public static MenuProvider getLoomMenuProvider(BlockPos pos) {
        return LegacyCraftingMenu.getMenuProvider((i, inv, p) -> LegacyCraftingMenu.loomMenu(i, inv, pos), LOOM_TITLE);
    }

    public static MenuProvider getStonecutterMenuProvider(BlockPos pos) {
        return LegacyCraftingMenu.getMenuProvider((i, inv, p) -> LegacyCraftingMenu.stoneCutterMenu(i, inv, pos), STONECUTTER_TITLE);
    }

    @Override
    public void onCraft(Player player, ServerMenuCraftPayload packet, ItemStack result) {
        result.onCraftedBy(player.level(), player, result.getCount());
    }
}

