/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.util.Pair;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.LegacyTipManager;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyIconHolder;
import wily.legacy.client.screen.LegacyMenuAccess;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.util.ScreenUtil;

@Mixin(value={AbstractContainerScreen.class})
public abstract class AbstractContainerScreenMixin
extends Screen
implements LegacyMenuAccess,
ControlTooltip.Event {
    @Shadow
    protected int leftPos;
    @Shadow
    protected int topPos;
    @Shadow
    private Slot clickedSlot;
    @Shadow
    private ItemStack draggingItem;
    @Shadow
    @Final
    protected AbstractContainerMenu menu;
    @Shadow
    @Final
    protected Set<Slot> quickCraftSlots;
    @Shadow
    protected boolean isQuickCrafting;
    @Shadow
    private boolean isSplittingStack;
    @Shadow
    private int quickCraftingType;
    @Shadow
    protected int imageWidth;
    @Shadow
    protected Slot hoveredSlot;
    @Shadow
    protected int imageHeight;

    protected AbstractContainerScreenMixin(Component component) {
        super(component);
    }

    @Shadow
    protected abstract void recalculateQuickCraftRemaining();

    @Shadow
    protected abstract boolean hasClickedOutside(double var1, double var3, int var5, int var6, int var7);

    @ModifyArg(method={"renderLabels"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Lnet/minecraft/network/chat/Component;IIIZ)I"), index=4)
    private int renderLabels(int i) {
        return (Integer)CommonColor.INVENTORY_GRAY_TEXT.get();
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    private void keyPressed(int i, int j, int k, CallbackInfoReturnable<Boolean> cir) {
        if (Legacy4JClient.keyCrafting.matches(i, j)) {
            this.onClose();
            cir.setReturnValue((Object)true);
        }
        if (i == 87 && this.hoveredSlot != null && this.hoveredSlot.hasItem() && LegacyTipManager.setTip(LegacyTipManager.getTip(this.hoveredSlot.getItem().copy()))) {
            ScreenUtil.playSimpleUISound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 1.0f);
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="RETURN")})
    private void mouseClicked(double d, double e, int i, CallbackInfoReturnable<Boolean> cir) {
        if (this.getChildAt(d, e).isEmpty()) {
            ScreenUtil.playSimpleUISound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 1.0f);
        }
    }

    @Inject(method={"renderFloatingItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderFloatingItem(GuiGraphics guiGraphics, ItemStack itemStack, int i, int j, String string, CallbackInfo ci) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(Legacy4JClient.controllerManager.getPointerX() - (double)this.leftPos - 10.0, Legacy4JClient.controllerManager.getPointerY() - (double)this.topPos - 10.0, 432.0);
        guiGraphics.pose().scale(1.5f, 1.5f, 1.5f);
        guiGraphics.renderItem(itemStack, 0, 0);
        guiGraphics.renderItemDecorations(Minecraft.getInstance().font, itemStack, 0, this.draggingItem.isEmpty() ? 0 : -8, string);
        guiGraphics.pose().popPose();
        ci.cancel();
    }

    @Inject(method={"isHovering(Lnet/minecraft/world/inventory/Slot;DD)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void isHovering(Slot slot, double d, double e, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)ScreenUtil.isHovering(slot, this.leftPos, this.topPos, d, e));
    }

    @ModifyExpressionValue(method={"renderSlotHighlight(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/world/inventory/Slot;IIF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/inventory/Slot;isHighlightable()Z")})
    private boolean renderSlotHighlight(boolean original) {
        return false;
    }

    @ModifyExpressionValue(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/inventory/Slot;isActive()Z")})
    private boolean renderSlots(boolean original, @Local Slot slot) {
        return original && LegacySlotDisplay.of(slot).isVisible();
    }

    @Inject(method={"renderSlot"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderSlot(GuiGraphics graphics, Slot slot, CallbackInfo ci) {
        Pair pair;
        ci.cancel();
        LegacyIconHolder holder = ScreenUtil.iconHolderRenderer.slotBounds(slot);
        holder.render(graphics, 0, 0, 0.0f);
        if (ScreenUtil.isHovering(slot, this.leftPos, this.topPos, Legacy4JClient.controllerManager.getPointerX(), Legacy4JClient.controllerManager.getPointerY())) {
            holder.renderHighlight(graphics);
        }
        graphics.pose().pushPose();
        holder.applyOffset(graphics);
        graphics.pose().translate((float)slot.x, (float)slot.y, 0.0f);
        graphics.pose().scale(holder.getSelectableWidth() / 16.0f, holder.getSelectableHeight() / 16.0f, holder.getSelectableHeight() / 16.0f);
        ItemStack itemStack = slot.getItem();
        boolean bl = false;
        boolean bl2 = slot == this.clickedSlot && !this.draggingItem.isEmpty() && !this.isSplittingStack;
        ItemStack itemStack2 = this.menu.getCarried();
        String string = null;
        if (slot == this.clickedSlot && !this.draggingItem.isEmpty() && this.isSplittingStack && !itemStack.isEmpty()) {
            itemStack = itemStack.copyWithCount(itemStack.getCount() / 2);
        } else if (this.isQuickCrafting && this.quickCraftSlots.contains(slot) && !itemStack2.isEmpty()) {
            if (this.quickCraftSlots.size() == 1) {
                graphics.pose().popPose();
                return;
            }
            if (AbstractContainerMenu.canItemQuickReplace((Slot)slot, (ItemStack)itemStack2, (boolean)true) && this.menu.canDragTo(slot)) {
                bl = true;
                int k = Math.min(itemStack2.getMaxStackSize(), slot.getMaxStackSize(itemStack2));
                int l = slot.getItem().isEmpty() ? 0 : slot.getItem().getCount();
                int m = AbstractContainerMenu.getQuickCraftPlaceCount(this.quickCraftSlots, (int)this.quickCraftingType, (ItemStack)itemStack2) + l;
                if (m > k) {
                    m = k;
                    string = ChatFormatting.YELLOW.toString() + k;
                }
                itemStack = itemStack2.copyWithCount(m);
            } else {
                this.quickCraftSlots.remove(slot);
                this.recalculateQuickCraftRemaining();
            }
        }
        graphics.pose().translate(0.0f, 0.0f, 100.0f);
        if (itemStack.isEmpty() && (pair = slot.getNoItemIcon()) != null && holder.iconSprite == null) {
            TextureAtlasSprite textureAtlasSprite = (TextureAtlasSprite)this.minecraft.getTextureAtlas((ResourceLocation)pair.getFirst()).apply((ResourceLocation)pair.getSecond());
            FactoryGuiGraphics.of((GuiGraphics)graphics).blit(0, 0, 0, 16, 16, textureAtlasSprite);
            bl2 = true;
        }
        if (!bl2) {
            if (bl) {
                graphics.fill(0, 0, 16, 16, -2130706433);
            }
            graphics.renderItem(itemStack, 0, 0, slot.x + slot.y * this.imageWidth);
            graphics.renderItemDecorations(this.minecraft.font, itemStack, 0, 0, string);
        }
        graphics.pose().popPose();
        if (holder.isWarning()) {
            holder.renderWarning(graphics, 600.0f);
        }
    }

    @Inject(method={"renderTooltip"}, at={@At(value="HEAD")}, cancellable=true)
    protected void renderTooltip(GuiGraphics guiGraphics, int i, int j, CallbackInfo ci) {
        if (this.hoveredSlot == null || !LegacySlotDisplay.isVisibleAndActive(this.hoveredSlot)) {
            ci.cancel();
        }
    }

    @Redirect(method={"mouseClicked"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/InputConstants;isKeyDown(JI)Z"))
    public boolean mouseClicked(long l, int i) {
        return InputConstants.isKeyDown((long)l, (int)i) || Legacy4JClient.controllerManager.getButtonState(ControllerBinding.UP_BUTTON).pressed;
    }

    @Redirect(method={"mouseReleased"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;hasShiftDown()Z"))
    public boolean mouseReleased(double d, double e, int i) {
        return AbstractContainerScreenMixin.hasShiftDown() || Legacy4JClient.controllerManager.getButtonState(ControllerBinding.UP_BUTTON).released;
    }

    @Redirect(method={"mouseReleased"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/InputConstants;isKeyDown(JI)Z"))
    public boolean mouseReleased(long l, int i) {
        return InputConstants.isKeyDown((long)l, (int)i) || Legacy4JClient.controllerManager.getButtonState(ControllerBinding.UP_BUTTON).released;
    }

    @Inject(method={"onClose"}, at={@At(value="RETURN")})
    public void onClose(CallbackInfo ci) {
        if (Legacy4J.anyArmorSlotMatch(this.minecraft.player.getInventory(), i -> !i.isEmpty())) {
            ScreenUtil.updateAnimatedCharacterTime(1500L);
        }
        this.menu.slots.forEach(s -> LegacySlotDisplay.override(s, LegacySlotDisplay.VANILLA));
    }

    @Override
    public boolean isOutsideClick(int i) {
        return this.hasClickedOutside(Legacy4JClient.controllerManager.getPointerX(), Legacy4JClient.controllerManager.getPointerY(), this.leftPos, this.topPos, i);
    }

    @Override
    public Slot getHoveredSlot() {
        return this.hoveredSlot;
    }

    @Override
    public ScreenRectangle getMenuRectangle() {
        return new ScreenRectangle(this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
    }

    @Redirect(method={"renderTooltip"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isEmpty()Z"))
    public boolean renderTooltip(ItemStack instance) {
        return true;
    }
}

