/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractSignEditScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.KeyboardScreen;
import wily.legacy.client.screen.WidgetPanel;

@Mixin(value={AbstractSignEditScreen.class})
public abstract class AbstractSignEditScreenMixin
extends Screen
implements ControlTooltip.Event {
    private WidgetPanel panel = new WidgetPanel(this){

        public boolean charTyped(char c, int i) {
            if (AbstractSignEditScreenMixin.this.signField.charTyped(c)) {
                return true;
            }
            return super.charTyped(c, i);
        }

        @Override
        public void init(String name) {
            super.init(name);
            this.size(100, 100);
            this.pos(this.centeredLeftPos(AbstractSignEditScreenMixin.this), this.centeredTopPos(AbstractSignEditScreenMixin.this));
        }

        public boolean keyPressed(int i, int j, int k) {
            if (KeyboardScreen.isOpenKey(i)) {
                AbstractSignEditScreenMixin.this.minecraft.setScreen((Screen)new KeyboardScreen(AbstractSignEditScreenMixin.this.isSign() ? 60 : -100, () -> this, (Screen)AbstractSignEditScreenMixin.this));
                return true;
            }
            if (i == 265 && AbstractSignEditScreenMixin.this.line > 0) {
                --AbstractSignEditScreenMixin.this.line;
                AbstractSignEditScreenMixin.this.signField.setCursorToEnd();
                return true;
            }
            if (i != 264 && i != 257) {
                return AbstractSignEditScreenMixin.this.signField.keyPressed(i) || super.keyPressed(i, j, k);
            }
            if (AbstractSignEditScreenMixin.this.line < 3) {
                ++AbstractSignEditScreenMixin.this.line;
                AbstractSignEditScreenMixin.this.signField.setCursorToEnd();
                return true;
            }
            return super.keyPressed(i, j, k);
        }

        @Override
        @Nullable
        public Component getAction(ControlTooltip.ActionHolder.Context context) {
            return this.isFocused() ? context.actionOfContext(ControlTooltip.ActionHolder.KeyContext.class, ControlTooltip::getKeyboardAction) : null;
        }
    };
    @Shadow
    @Final
    private SignBlockEntity sign;
    @Shadow
    private int line;
    @Shadow
    private TextFieldHelper signField;

    @Shadow
    protected abstract void renderSign(GuiGraphics var1);

    protected AbstractSignEditScreenMixin(Component component) {
        super(component);
    }

    @ModifyArg(method={"init"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/Button$Builder;bounds(IIII)Lnet/minecraft/client/gui/components/Button$Builder;"), index=1)
    private int init(int i) {
        return this.height / 2 + 80;
    }

    @Inject(method={"init"}, at={@At(value="HEAD")})
    private void init(CallbackInfo ci) {
        this.addWidget(this.panel);
        this.setFocused(this.panel);
    }

    @ModifyArg(method={"offsetSign"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(FFF)V"), index=1)
    private float offsetSign(float f) {
        return (float)this.height / 2.0f - 26.5f;
    }

    @Redirect(method={"renderSignText"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(FFF)V"))
    private void renderSignText(PoseStack instance, float x, float y, float z) {
        instance.translate((double)x, this.isSign() ? (double)y - 14.5 : (double)(y + 10.0f), 10.0);
    }

    @Unique
    private boolean isSign() {
        return this.sign.getBlockState().getBlock() instanceof StandingSignBlock || this.sign.getBlockState().getBlock() instanceof WallSignBlock;
    }

    @Redirect(method={"renderSignText"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/SignBlockEntity;getTextLineHeight()I"))
    private int renderSignText(SignBlockEntity instance) {
        return instance.getTextLineHeight() + 5;
    }

    @Redirect(method={"renderSignText"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Ljava/lang/String;IIIZ)I", ordinal=1))
    private int renderSignText(GuiGraphics instance, Font arg, String string, int i, int j, int k, boolean bl) {
        return this.getFocused() == this.panel ? instance.drawString(arg, string, i, j, k, bl) : -1;
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    public void render(GuiGraphics guiGraphics, int i, int j, float f, CallbackInfo ci) {
        ci.cancel();
        super.render(guiGraphics, i, j, f);
        Lighting.setupForFlatItems();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(((float)this.width - (float)this.font.width((FormattedText)this.title) * 1.5f) / 2.0f, (float)this.height / 2.0f - 96.0f, 0.0f);
        guiGraphics.pose().scale(1.5f, 1.5f, 1.5f);
        guiGraphics.drawString(this.font, this.title, 0, 0, 0xFFFFFF);
        guiGraphics.pose().popPose();
        this.renderSign(guiGraphics);
        Lighting.setupFor3DItems();
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    public void keyPressed(int i, int j, int k, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)super.keyPressed(i, j, k));
    }

    @Inject(method={"charTyped"}, at={@At(value="HEAD")}, cancellable=true)
    public void charTyped(char c, int i, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)super.charTyped(c, i));
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
    }
}

