/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.biome.Biome;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.legacy.client.LegacyBiomeOverride;

@Mixin(value={Biome.class})
public class ClientBiomeMixin {
    @Unique
    private Biome self() {
        return (Biome)this;
    }

    @Unique
    private LegacyBiomeOverride biomeOverride() {
        ClientPacketListener l = Minecraft.getInstance().getConnection();
        return LegacyBiomeOverride.getOrDefault(l != null ? l.registryAccess().registryOrThrow(Registries.BIOME).getResourceKey((Object)this.self()) : Optional.empty());
    }

    @Inject(method={"getWaterColor"}, at={@At(value="HEAD")}, cancellable=true)
    private void getWaterColor(CallbackInfoReturnable<Integer> cir) {
        LegacyBiomeOverride o = this.biomeOverride();
        if (o.waterColor() != null) {
            cir.setReturnValue((Object)o.waterColor());
        }
    }

    @Inject(method={"getWaterFogColor"}, at={@At(value="HEAD")}, cancellable=true)
    private void getWaterFogColor(CallbackInfoReturnable<Integer> cir) {
        LegacyBiomeOverride o = this.biomeOverride();
        if (o.waterFogColor() != null || o.waterColor() != null) {
            cir.setReturnValue((Object)(o.waterFogColor() == null ? o.waterColor() : o.waterFogColor()));
        }
    }

    @Inject(method={"getFogColor"}, at={@At(value="HEAD")}, cancellable=true)
    private void getFogColor(CallbackInfoReturnable<Integer> cir) {
        LegacyBiomeOverride o = this.biomeOverride();
        if (o.fogColor() != null) {
            cir.setReturnValue((Object)o.fogColor());
        }
    }

    @Inject(method={"getSkyColor"}, at={@At(value="HEAD")}, cancellable=true)
    private void getSkyColor(CallbackInfoReturnable<Integer> cir) {
        LegacyBiomeOverride o = this.biomeOverride();
        if (o.skyColor() != null) {
            cir.setReturnValue((Object)o.skyColor());
        }
    }
}

