/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Explosion.class})
public abstract class ClientExplosionMixin {
    @Shadow
    @Final
    private Level level;
    @Shadow
    @Final
    private ObjectArrayList<BlockPos> toBlow;
    @Shadow
    @Final
    private double x;
    @Shadow
    @Final
    private double y;
    @Shadow
    @Final
    private double z;
    @Shadow
    @Final
    private float radius;

    @Shadow
    public abstract boolean interactsWithBlocks();

    @Inject(method={"finalizeExplosion"}, at={@At(value="RETURN")})
    public void finalizeExplosion(boolean bl, CallbackInfo ci) {
        if (this.level.isClientSide && this.interactsWithBlocks()) {
            double d = Math.sqrt(Minecraft.getInstance().player.distanceToSqr(this.x, this.y, this.z));
            if (d >= 21.0) {
                return;
            }
            for (BlockPos blockPos : this.toBlow) {
                if (this.level.random.nextInt(d >= 15.0 ? 40 : 10) != 0) continue;
                double d0 = (float)blockPos.getX() + this.level.random.nextFloat();
                double d1 = (float)blockPos.getY() + this.level.random.nextFloat();
                double d2 = (float)blockPos.getZ() + this.level.random.nextFloat();
                double d3 = d0 - this.x;
                double d4 = d1 - this.y;
                double d5 = d2 - this.z;
                double d6 = Math.sqrt(d3 * d3 + d4 * d4 + d5 * d5);
                d3 /= d6;
                d4 /= d6;
                d5 /= d6;
                double d7 = 0.5 / (d6 / (double)this.radius + 0.1);
                d3 *= (d7 *= (double)(this.level.random.nextFloat() * this.level.random.nextFloat() + 0.3f));
                d4 *= d7;
                d5 *= d7;
                if (d <= 18.0) {
                    this.level.addParticle((ParticleOptions)ParticleTypes.POOF, (d0 + this.x) / 2.0, (d1 + this.y) / 2.0, (d2 + this.z) / 2.0, d3, d4, d5);
                }
                this.level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, d3, d4, d5);
            }
        }
    }
}

