/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.CyclingSlotBackground;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.legacy.client.screen.LegacyIconHolder;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.util.ScreenUtil;

@Mixin(value={CyclingSlotBackground.class})
public class CyclingSlotBackgroundMixin {
    @Inject(method={"renderIcon"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderIcon(Slot slot, ResourceLocation resourceLocation, float f, GuiGraphics guiGraphics, int i, int j, CallbackInfo ci) {
        if (!(slot instanceof LegacySlotDisplay)) {
            return;
        }
        ci.cancel();
        LegacyIconHolder holder = ScreenUtil.iconHolderRenderer.slotBounds(slot);
        holder.renderScaled(guiGraphics, i + slot.x, j + slot.y, () -> {
            FactoryScreenUtil.enableBlend();
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setColor(1.0f, 1.0f, 1.0f, f);
            TextureAtlasSprite textureAtlasSprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(resourceLocation);
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(0, 0, 0, 16, 16, textureAtlasSprite);
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).clearColor();
            FactoryScreenUtil.disableBlend();
        });
    }
}

