/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.client.Camera;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.legacy.client.LegacyBiomeOverride;
import wily.legacy.client.LegacyOptions;

@Mixin(value={FogRenderer.class})
public abstract class FogRendererMixin {
    @Inject(method={"setupFog"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/FogRenderer$FogData;start:F", opcode=181, ordinal=8, shift=At.Shift.AFTER)})
    private static void setupFogStart(CallbackInfo ci, @Local FogRenderer.FogData fogData) {
        if (((Boolean)LegacyOptions.overrideTerrainFogStart.get()).booleanValue()) {
            fogData.start = LegacyOptions.getTerrainFogStart() * 16;
        }
    }

    @Inject(method={"setupFog"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/FogRenderer$FogData;end:F", opcode=181, ordinal=11, shift=At.Shift.AFTER)})
    private static void setupFogEnd(CallbackInfo ci, @Local FogRenderer.FogData fogData) {
        if (((Boolean)LegacyOptions.overrideTerrainFogStart.get()).booleanValue()) {
            fogData.end = ((Integer)LegacyOptions.terrainFogEnd.get()).floatValue() * 16.0f;
        }
    }

    @Inject(method={"setupFog"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/FogRenderer$FogData;start:F", opcode=181, ordinal=7, shift=At.Shift.AFTER)})
    private static void setupSkyFogStart(CallbackInfo ci, @Local FogRenderer.FogData fogData) {
        if (((Boolean)LegacyOptions.overrideTerrainFogStart.get()).booleanValue()) {
            fogData.start = LegacyOptions.getTerrainFogStart() * 16;
        }
    }

    @Inject(method={"setupFog"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/FogRenderer$FogData;end:F", opcode=181, ordinal=10, shift=At.Shift.AFTER)})
    private static void setupSkyFogEnd(CallbackInfo ci, @Local FogRenderer.FogData fogData) {
        if (((Boolean)LegacyOptions.overrideTerrainFogStart.get()).booleanValue()) {
            fogData.end = ((Integer)LegacyOptions.terrainFogEnd.get()).floatValue() * 16.0f;
        }
    }

    @Inject(method={"setupFog"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/FogRenderer$FogData;end:F", opcode=181, ordinal=5, shift=At.Shift.AFTER)})
    private static void setupWaterFogEnd(CallbackInfo ci, @Local(argsOnly=true) Camera camera, @Local FogRenderer.FogData fogData) {
        Entity entity = camera.getEntity();
        if (entity instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)entity;
            LegacyBiomeOverride o = LegacyBiomeOverride.getOrDefault(localPlayer.clientLevel.getBiome(BlockPos.containing((Position)camera.getPosition())).unwrapKey());
            if (o.waterFogDistance() != null) {
                fogData.end = o.waterFogDistance().floatValue();
            }
        }
    }
}

