/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.factoryapi.base.config.FactoryConfig;
import wily.legacy.config.LegacyCommonOptions;
import wily.legacy.util.ItemAccessor;

@Mixin(value={Item.class})
public class ItemMixin
implements ItemAccessor {
    @Mutable
    @Shadow
    @Final
    private int maxStackSize;

    @Override
    public void setMaxStackSize(int i) {
        this.maxStackSize = i;
    }

    @Override
    public void setRecordLengthInTicks(int i) {
    }

    @Unique
    private boolean isSword() {
        return ((Item)this).builtInRegistryHolder().is(ItemTags.SWORDS);
    }

    @Inject(method={"getUseDuration"}, at={@At(value="HEAD")}, cancellable=true)
    public void getUseDuration(CallbackInfoReturnable<Integer> cir) {
        if (this.isSword() && FactoryConfig.hasCommonConfigEnabled(LegacyCommonOptions.legacySwordBlocking)) {
            cir.setReturnValue((Object)7200);
        }
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    public void use(Level level, Player player, InteractionHand interactionHand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        if (this.isSword() && FactoryConfig.hasCommonConfigEnabled(LegacyCommonOptions.legacySwordBlocking) && (interactionHand == InteractionHand.OFF_HAND || !player.getOffhandItem().getUseAnimation().equals((Object)UseAnim.BLOCK))) {
            player.startUsingItem(interactionHand);
            cir.setReturnValue((Object)InteractionResultHolder.consume((Object)player.getItemInHand(interactionHand)));
        }
    }

    @Inject(method={"getUseAnimation"}, at={@At(value="HEAD")}, cancellable=true)
    public void getUseAnimation(ItemStack itemStack, CallbackInfoReturnable<UseAnim> cir) {
        if (this.isSword() && FactoryConfig.hasCommonConfigEnabled(LegacyCommonOptions.legacySwordBlocking)) {
            cir.setReturnValue((Object)UseAnim.BLOCK);
        }
    }
}

