/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LevelRendererAccessor;

@Mixin(value={LevelRenderer.class})
public abstract class LevelRendererMixin
implements LevelRendererAccessor {
    @Shadow
    protected abstract void createLightSky();

    @Shadow
    protected abstract void createDarkSky();

    @Override
    public void updateSkyBuffers() {
        this.createLightSky();
        this.createDarkSky();
    }

    @Inject(method={"buildSkyDisc"}, at={@At(value="HEAD")}, cancellable=true)
    private static void buildSkyDisc(BufferBuilder bufferBuilder, float f, CallbackInfoReturnable<BufferBuilder.RenderedBuffer> cir) {
        if (((Boolean)LegacyOptions.legacySkyShape.get()).booleanValue()) {
            RenderSystem.setShader(GameRenderer::getPositionShader);
            bufferBuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
            Legacy4JClient.buildLegacySkyDisc((VertexConsumer)bufferBuilder, f);
            cir.setReturnValue((Object)bufferBuilder.end());
        }
    }
}

