/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.gui.screens.Overlay;
import net.minecraft.server.packs.resources.ReloadInstance;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.MinecraftAccessor;
import wily.legacy.client.LegacyIntro;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacyResourceManager;
import wily.legacy.util.ScreenUtil;

@Mixin(value={LoadingOverlay.class})
public abstract class LoadingOverlayMixin
extends Overlay {
    @Unique
    private static boolean finishedIntro = false;
    @Unique
    private static boolean loadIntroLocation = false;
    @Shadow
    @Final
    private ReloadInstance reload;
    @Shadow
    @Final
    private Consumer<Optional<Throwable>> onFinish;
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    private long fadeOutStart;
    @Shadow
    @Final
    private boolean fadeIn;
    @Shadow
    private long fadeInStart;
    @Unique
    private long initTime;

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    public void render(GuiGraphics guiGraphics, int i, int j, float f, CallbackInfo ci) {
        if (((Boolean)LegacyOptions.legacyIntroAndReloading.get()).booleanValue()) {
            ci.cancel();
            if (!loadIntroLocation) {
                this.initTime = Util.getMillis();
                loadIntroLocation = true;
                LegacyResourceManager.loadIntroLocations(this.minecraft.getResourceManager());
            }
            float timer = LegacyIntro.getTimer(this.initTime, LegacyResourceManager.intro);
            if (!finishedIntro && LegacyIntro.canSkip(timer, LegacyResourceManager.intro) && this.reload.isDone()) {
                finishedIntro = true;
            }
            if (!finishedIntro) {
                LegacyIntro.render(guiGraphics, LegacyResourceManager.intro, timer);
            }
            if (finishedIntro) {
                float h;
                long m = Util.getMillis();
                if (this.fadeIn && this.fadeInStart == -1L) {
                    this.fadeInStart = m;
                }
                float g = this.fadeOutStart > -1L ? (float)(m - this.fadeOutStart) / 1000.0f : -1.0f;
                float f2 = h = this.fadeInStart > -1L ? (float)(m - this.fadeInStart) / 500.0f : -1.0f;
                if (MinecraftAccessor.getInstance().hasGameLoaded() && this.reload.isDone() && this.minecraft.screen != null) {
                    this.minecraft.screen.renderWithTooltip(guiGraphics, 0, 0, f);
                } else {
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(ScreenUtil.LOADING_BACKGROUND, 0, 0, 0.0f, 0.0f, guiGraphics.guiWidth(), guiGraphics.guiHeight(), guiGraphics.guiWidth(), guiGraphics.guiHeight());
                }
                if (g < 1.0f && !this.reload.isDone() && MinecraftAccessor.getInstance().hasGameLoaded()) {
                    ScreenUtil.drawGenericLoading(guiGraphics, (guiGraphics.guiWidth() - 75) / 2, (guiGraphics.guiHeight() - 75) / 2);
                }
                if (g >= 2.0f) {
                    this.minecraft.setOverlay(null);
                }
                if (this.fadeOutStart == -1L && this.reload.isDone() && (!this.fadeIn || h >= 2.0f)) {
                    try {
                        this.reload.checkExceptions();
                        this.onFinish.accept(Optional.empty());
                    }
                    catch (Throwable throwable) {
                        this.onFinish.accept(Optional.of(throwable));
                    }
                    this.fadeOutStart = Util.getMillis();
                    if (this.minecraft.screen != null) {
                        this.minecraft.screen.init(this.minecraft, guiGraphics.guiWidth(), guiGraphics.guiHeight());
                    }
                }
            }
        }
    }
}

