/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.mojang.authlib.GameProfile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.legacy.Legacy4JClient;
import wily.legacy.init.LegacyGameRules;

@Mixin(value={LocalPlayer.class})
public abstract class LocalPlayerMixin
extends AbstractClientPlayer {
    @Shadow
    private boolean crouching;
    @Shadow
    public Input input;
    @Shadow
    @Final
    protected Minecraft minecraft;
    @Shadow
    @Final
    public static Logger LOGGER;
    @Shadow
    private boolean lastOnGround;

    @Shadow
    protected abstract boolean isControlledCamera();

    @Shadow
    protected abstract boolean hasEnoughFoodToStartSprinting();

    @Shadow
    public abstract void move(MoverType var1, Vec3 var2);

    public LocalPlayerMixin(ClientLevel clientLevel, GameProfile gameProfile) {
        super(clientLevel, gameProfile);
    }

    @ModifyExpressionValue(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;onGround()Z", ordinal=2)})
    public boolean onGroundFlying(boolean original) {
        return false;
    }

    @ModifyExpressionValue(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;onGround()Z", ordinal=0)})
    public boolean onGroundCanSprint(boolean original) {
        return true;
    }

    @Redirect(method={"aiStep"}, at=@At(value="FIELD", target="Lnet/minecraft/client/player/LocalPlayer;crouching:Z", opcode=181, ordinal=0))
    public void aiStepCrouching(LocalPlayer instance, boolean value) {
        this.crouching = value && (this.onGround() || !this.isInWater()) && !this.getAbilities().flying && !this.isFallFlying();
    }

    @Inject(method={"aiStep"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/player/Abilities;flying:Z", opcode=181, ordinal=1, shift=At.Shift.AFTER)})
    public void aiStepStopCrouching(CallbackInfo ci) {
        this.minecraft.options.keyShift.setDown(false);
    }

    @ModifyExpressionValue(method={"aiStep"}, at={@At(value="FIELD", target="Lnet/minecraft/client/player/LocalPlayer;horizontalCollision:Z")})
    public boolean aiStepSprinting(boolean original) {
        return false;
    }

    @WrapWithCondition(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;setSprinting(Z)V", ordinal=3)})
    public boolean aiStepSprintingWater(LocalPlayer instance, boolean b) {
        return !Legacy4JClient.hasModOnServer() || !((GameRules.BooleanValue)Legacy4JClient.gameRules.getRule(LegacyGameRules.LEGACY_SWIMMING)).get() || !this.input.hasForwardImpulse() || !this.hasEnoughFoodToStartSprinting();
    }

    @Redirect(method={"aiStep"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V"))
    public void aiStepFlyUpDown(LocalPlayer instance, Vec3 vec3) {
        if (Legacy4JClient.hasModOnServer()) {
            this.move(MoverType.SELF, vec3.with(Direction.Axis.Y, (vec3.y - this.getDeltaMovement().y) * (double)(this.input.jumping ? (0.42f + this.getJumpBoostPower()) * 6.0f : 3.0f)));
        } else {
            this.setDeltaMovement(vec3);
        }
    }

    @ModifyExpressionValue(method={"aiStep"}, at={@At(value="FIELD", target="Lnet/minecraft/client/player/Input;shiftKeyDown:Z", ordinal=2)})
    public boolean aiStepShift(boolean original) {
        if (!this.lastOnGround && !this.isSpectator()) {
            this.checkSupportingBlock(true, null);
            this.lastOnGround = this.mainSupportingBlockPos.isPresent();
        }
        return original && (!Legacy4JClient.hasModOnServer() || !this.input.jumping && !this.lastOnGround);
    }

    @ModifyExpressionValue(method={"aiStep"}, at={@At(value="FIELD", target="Lnet/minecraft/client/player/Input;jumping:Z", ordinal=4)})
    public boolean aiStepJump(boolean original) {
        return original && (!Legacy4JClient.hasModOnServer() || !this.isSprinting() || this.getXRot() <= 0.0f || !this.lastOnGround);
    }

    public float maxUpStep() {
        return (Legacy4JClient.hasModOnServer() && this.input.jumping && this.isSprinting() && this.getAbilities().flying ? 0.5f : 0.0f) + super.maxUpStep();
    }

    @Inject(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/AbstractClientPlayer;aiStep()V")})
    public void setYElytraFlightElevation(CallbackInfo ci) {
        if (!Legacy4JClient.hasModOnServer()) {
            return;
        }
        if (this.isFallFlying() && this.getAbilities().mayfly && this.getAbilities().invulnerable && this.isControlledCamera() && this.jumping) {
            this.setDeltaMovement(this.getDeltaMovement().with(Direction.Axis.Y, this.input.jumping ? (double)(this.getAbilities().getFlyingSpeed() * 12.0f) : 0.0));
        }
    }

    @Inject(method={"aiStep"}, at={@At(value="RETURN")})
    public void setYFlightElevation(CallbackInfo ci) {
        if (!Legacy4JClient.hasModOnServer()) {
            return;
        }
        if (this.getAbilities().flying && this.isControlledCamera()) {
            if (Legacy4JClient.keyFlyDown.isDown() && !Legacy4JClient.keyFlyUp.isDown() || !Legacy4JClient.keyFlyDown.isDown() && Legacy4JClient.keyFlyUp.isDown() || Legacy4JClient.keyFlyLeft.isDown() && !Legacy4JClient.keyFlyRight.isDown() || !Legacy4JClient.keyFlyLeft.isDown() && Legacy4JClient.keyFlyRight.isDown()) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, (Legacy4JClient.keyFlyUp.isDown() ? 1.5 : (Legacy4JClient.keyFlyDown.isDown() ? -1.5 : 0.0)) * (double)this.getAbilities().getFlyingSpeed(), 0.0));
            }
            if (this.getXRot() != 0.0f && (!this.lastOnGround || this.getXRot() < 0.0f) && this.input.hasForwardImpulse() && this.isSprinting()) {
                this.move(MoverType.SELF, new Vec3(0.0, (double)(-(this.getXRot() / 90.0f) * this.input.forwardImpulse * this.getFlyingSpeed() * 2.0f), 0.0));
            }
        }
    }

    @ModifyExpressionValue(method={"handleNetherPortalClient"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;isPauseScreen()Z")})
    public boolean handleConfusionTransitionEffect(boolean original) {
        return original || Legacy4JClient.hasModOnServer();
    }

    @Inject(method={"serverAiStep"}, at={@At(value="RETURN")})
    public void applyInput(CallbackInfo ci) {
        if (!Legacy4JClient.hasModOnServer()) {
            return;
        }
        if (this.isControlledCamera() && this.getAbilities().flying) {
            if (Legacy4JClient.keyFlyLeft.isDown() && !Legacy4JClient.keyFlyRight.isDown() || !Legacy4JClient.keyFlyLeft.isDown() && Legacy4JClient.keyFlyRight.isDown()) {
                this.xxa += (float)(Legacy4JClient.keyFlyLeft.isDown() ? 12 : -12) * this.getAbilities().getFlyingSpeed();
            }
            if (this.getXRot() != 0.0f && this.input.hasForwardImpulse() && this.isSprinting()) {
                this.zza *= Math.max(0.1f, 1.0f - Math.abs(this.getXRot() / 90.0f));
            }
        }
        if (this.wantsToStopRiding() && this.isPassenger()) {
            this.minecraft.options.keyShift.setDown(false);
        }
    }
}

