/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.factoryapi.FactoryAPI;
import wily.legacy.config.LegacyWorldOptions;
import wily.legacy.init.LegacyGameRules;

@Mixin(value={MapItemSavedData.class})
public abstract class MapItemSavedDataMixin {
    @Shadow
    @Final
    private List<MapItemSavedData.HoldingPlayer> carriedBy;
    @Shadow
    @Final
    public int centerX;
    @Shadow
    @Final
    public int centerZ;
    @Shadow
    @Final
    public byte scale;
    @Shadow
    @Final
    private boolean trackingPosition;
    @Shadow
    @Final
    private boolean unlimitedTracking;
    @Shadow
    @Final
    public ResourceKey<Level> dimension;
    @Shadow
    @Final
    private Map<Player, MapItemSavedData.HoldingPlayer> carriedByPlayers;

    @Shadow
    protected abstract void addDecoration(MapDecoration.Type var1, LevelAccessor var2, String var3, double var4, double var6, double var8, Component var10);

    @Shadow
    protected abstract void removeDecoration(String var1);

    public MapItemSavedData self() {
        return (MapItemSavedData)this;
    }

    @ModifyExpressionValue(method={"tickCarriedBy"}, at={@At(value="INVOKE", target="Ljava/util/Map;containsKey(Ljava/lang/Object;)Z", ordinal=0)})
    public boolean tickCarriedByAddGlobalPlayers(boolean original, Player player) {
        ServerPlayer sp;
        if (!player.getServer().getGameRules().getBoolean(LegacyGameRules.GLOBAL_MAP_PLAYER_ICON)) {
            return original;
        }
        if (player instanceof ServerPlayer && (sp = (ServerPlayer)player).getServer() != null) {
            sp.getServer().getPlayerList().getPlayers().forEach(p -> {
                if (!this.carriedByPlayers.containsKey(p)) {
                    MapItemSavedData mapItemSavedData = this.self();
                    Objects.requireNonNull(mapItemSavedData);
                    MapItemSavedData.HoldingPlayer hp = new MapItemSavedData.HoldingPlayer(mapItemSavedData, (Player)p);
                    this.carriedBy.add(hp);
                    this.carriedByPlayers.put((Player)p, hp);
                }
                if (p.level().dimension() != this.dimension) {
                    this.removeDecoration(sp.getGameProfile().getName());
                }
            });
        }
        return true;
    }

    @ModifyExpressionValue(method={"tickCarriedBy"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Inventory;contains(Lnet/minecraft/world/item/ItemStack;)Z")})
    public boolean tickCarriedByRemoveInvalid(boolean original, Player player) {
        return player.getServer().getGameRules().getBoolean(LegacyGameRules.GLOBAL_MAP_PLAYER_ICON) || original;
    }

    @ModifyArg(method={"tickCarriedBy"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/saveddata/maps/MapItemSavedData;addDecoration(Lnet/minecraft/world/level/saveddata/maps/MapDecoration$Type;Lnet/minecraft/world/level/LevelAccessor;Ljava/lang/String;DDDLnet/minecraft/network/chat/Component;)V", ordinal=0))
    public Component tickCarriedBy(Component original, @Local MapItemSavedData.HoldingPlayer player) {
        return player.player.getName();
    }

    @Inject(method={"tickCarriedBy"}, at={@At(value="RETURN")}, cancellable=true)
    private void tickCarriedBy(Player player, ItemStack itemStack, CallbackInfo ci) {
        Iterator iterator = ((List)LegacyWorldOptions.usedEndPortalPositions.get()).iterator();
        boolean modified = false;
        while (iterator.hasNext()) {
            LegacyWorldOptions.UsedEndPortalPos next = (LegacyWorldOptions.UsedEndPortalPos)iterator.next();
            boolean valid = next.isValid(player.getServer());
            if (valid && this.dimension == Level.OVERWORLD) {
                this.addDecoration(MapDecoration.Type.TARGET_X, (LevelAccessor)player.getServer().overworld(), next.identifier(), next.pos().getX(), next.pos().getZ(), 0.0, null);
                continue;
            }
            this.removeDecoration(next.identifier());
            if (valid) continue;
            iterator.remove();
            modified = true;
        }
        if (modified) {
            LegacyWorldOptions.usedEndPortalPositions.save();
        }
    }

    @Inject(method={"createFresh"}, at={@At(value="HEAD")}, cancellable=true)
    private static void createFresh(double d, double e, byte b, boolean bl, boolean bl2, ResourceKey<Level> resourceKey, CallbackInfoReturnable<MapItemSavedData> cir) {
        if (FactoryAPI.currentServer != null && !FactoryAPI.currentServer.getGameRules().getBoolean(LegacyGameRules.LEGACY_MAP_GRID)) {
            return;
        }
        int i = 128 * (1 << b);
        cir.setReturnValue((Object)new MapItemSavedData(((int)d + i / 2 * Mth.sign((double)d)) / i * i, ((int)e + i / 2 * Mth.sign((double)e)) / i * i, b, bl, bl2, false, resourceKey));
    }

    @Inject(method={"scaled"}, at={@At(value="HEAD")}, cancellable=true)
    public void scaled(CallbackInfoReturnable<MapItemSavedData> cir) {
        if (FactoryAPI.currentServer != null && !FactoryAPI.currentServer.getGameRules().getBoolean(LegacyGameRules.LEGACY_MAP_GRID)) {
            return;
        }
        int i = 128 * (1 << this.scale);
        cir.setReturnValue((Object)MapItemSavedData.createFresh((double)(this.centerX - i / 2 * Mth.sign((double)this.centerX)), (double)(this.centerZ - i / 2 * Mth.sign((double)this.centerZ)), (byte)((byte)Mth.clamp((int)(this.scale + 1), (int)0, (int)4)), (boolean)this.trackingPosition, (boolean)this.unlimitedTracking, this.dimension));
    }
}

