/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Iterator;
import java.util.stream.StreamSupport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.MapRenderer;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.PlayerIdentifier;
import wily.legacy.entity.LegacyPlayerInfo;

@Mixin(value={MapRenderer.MapInstance.class})
public abstract class MapRendererMixin {
    @Unique
    private static final RenderType MAP_ICONS = RenderType.text((ResourceLocation)new ResourceLocation("textures/map/map_icons.png"));
    @Shadow
    private MapItemSavedData data;

    @Unique
    private boolean isPlayerDecoration(MapDecoration.Type type) {
        return type.equals((Object)MapDecoration.Type.PLAYER) || type.equals((Object)MapDecoration.Type.PLAYER_OFF_MAP) || type.equals((Object)MapDecoration.Type.PLAYER_OFF_LIMITS);
    }

    @Redirect(method={"draw"}, at=@At(value="INVOKE", target="Ljava/lang/Iterable;iterator()Ljava/util/Iterator;"))
    Iterator<MapDecoration> drawDecorations(Iterable<MapDecoration> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false).filter(s -> !this.isPlayerDecoration(s.type())).iterator();
    }

    @Inject(method={"draw"}, at={@At(value="HEAD")})
    void draw(PoseStack poseStack, MultiBufferSource multiBufferSource, boolean bl, int i, CallbackInfo ci) {
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        if (!bl && ((Boolean)LegacyOptions.mapsWithCoords.get()).booleanValue()) {
            poseStack.pushPose();
            poseStack.translate(-0.2f, 0.4f, -0.1f);
            poseStack.scale(1.0f, 0.95f, 1.0f);
            font.drawInBatch(I18n.get((String)"legacy.map.coords", (Object[])new Object[]{(int)minecraft.player.getX(), (int)minecraft.player.getEyeY(), (int)minecraft.player.getZ()}), 0.0f, 0.0f, 0, false, poseStack.last().pose(), multiBufferSource, Font.DisplayMode.NORMAL, 0, i);
            poseStack.popPose();
        }
    }

    @Inject(method={"draw"}, at={@At(value="RETURN")})
    void drawReturn(PoseStack poseStack, MultiBufferSource multiBufferSource, boolean bl, int i, CallbackInfo ci) {
        int l = 0;
        for (MapDecoration mapDecoration : this.data.getDecorations()) {
            float[] fArray;
            LegacyPlayerInfo playerInfo;
            PlayerInfo playerInfo2;
            MapDecoration.Type type = mapDecoration.type();
            if (bl && !mapDecoration.renderOnFrame() || !this.isPlayerDecoration(type)) continue;
            poseStack.pushPose();
            poseStack.translate(0.0f + (float)mapDecoration.x() / 2.0f + 64.0f, 0.0f + (float)mapDecoration.y() / 2.0f + 64.0f, -0.02f);
            poseStack.mulPose(Axis.ZP.rotationDegrees((float)(mapDecoration.rot() * 360) / 16.0f));
            poseStack.scale(4.0f, 4.0f, 3.0f);
            poseStack.translate(-0.125f, 0.125f, 0.0f);
            Matrix4f matrix4f2 = poseStack.last().pose();
            Minecraft minecraft = Minecraft.getInstance();
            if (mapDecoration.name() == null || minecraft.getConnection() == null || !((playerInfo2 = minecraft.getConnection().getPlayerInfo(mapDecoration.name().getString())) instanceof LegacyPlayerInfo)) {
                v0 = null;
            } else {
                LegacyPlayerInfo info = (LegacyPlayerInfo)playerInfo2;
                v0 = playerInfo = info;
            }
            if (playerInfo == null) {
                float[] fArray2 = new float[3];
                fArray2[0] = 1.0f;
                fArray2[1] = 1.0f;
                fArray = fArray2;
                fArray2[2] = 1.0f;
            } else {
                fArray = Legacy4JClient.getVisualPlayerColor(playerInfo);
            }
            float[] color = fArray;
            byte image = playerInfo == null ? mapDecoration.getImage() : PlayerIdentifier.of(playerInfo.getIdentifierIndex()).indexByMapDecorationType(type);
            float g = (float)(image % 16) / 16.0f;
            float h = (float)(image / 16) / 16.0f;
            float m = (float)(image % 16 + 1) / 16.0f;
            float n = (float)(image / 16 + 1) / 16.0f;
            VertexConsumer vertexConsumer2 = multiBufferSource.getBuffer(MAP_ICONS);
            vertexConsumer2.vertex(matrix4f2, -1.0f, 1.0f, (float)l * -0.001f).color(color[0], color[1], color[2], 1.0f).uv(g, h).uv2(i).endVertex();
            vertexConsumer2.vertex(matrix4f2, 1.0f, 1.0f, (float)l * -0.001f).color(color[0], color[1], color[2], 1.0f).uv(m, h).uv2(i).endVertex();
            vertexConsumer2.vertex(matrix4f2, 1.0f, -1.0f, (float)l * -0.001f).color(color[0], color[1], color[2], 1.0f).uv(m, n).uv2(i).endVertex();
            vertexConsumer2.vertex(matrix4f2, -1.0f, -1.0f, (float)l * -0.001f).color(color[0], color[1], color[2], 1.0f).uv(g, n).uv2(i).endVertex();
            poseStack.popPose();
            ++l;
        }
    }
}

