/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.recipebook.GhostRecipe;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.legacy.client.screen.DisplayRecipe;
import wily.legacy.client.screen.LegacyIconHolder;
import wily.legacy.client.screen.LegacyMenuAccess;
import wily.legacy.util.ScreenUtil;

@Mixin(value={RecipeBookComponent.class})
public class RecipeBookComponentMixin {
    @Mutable
    @Shadow
    @Final
    protected GhostRecipe ghostRecipe;
    @Shadow
    protected Minecraft minecraft;
    @Shadow
    protected RecipeBookMenu<?> menu;
    @Shadow
    private int xOffset;
    @Shadow
    private boolean widthTooNarrow;

    @Redirect(method={"initVisuals"}, at=@At(value="FIELD", target="Lnet/minecraft/client/gui/screens/recipebook/RecipeBookComponent;xOffset:I", opcode=181))
    private void initVisuals(RecipeBookComponent instance, int value) {
        int n;
        if (this.widthTooNarrow) {
            n = 0;
        } else {
            Screen screen = this.minecraft.screen;
            if (screen instanceof LegacyMenuAccess) {
                LegacyMenuAccess a = (LegacyMenuAccess)screen;
                n = a.getMenuRectangle().width() / 2 - 2;
            } else {
                n = 86;
            }
        }
        this.xOffset = n;
    }

    @Inject(method={"init"}, at={@At(value="RETURN")})
    private void init(int i, int j, Minecraft minecraft, boolean bl, RecipeBookMenu<?> recipeBookMenu, CallbackInfo ci) {
        this.ghostRecipe = new DisplayRecipe();
    }

    @Redirect(method={"setupGhostRecipe"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/recipebook/GhostRecipe;addIngredient(Lnet/minecraft/world/item/crafting/Ingredient;II)V"))
    public void setupGhostRecipe(GhostRecipe instance, Ingredient ingredient, int i, int j, RecipeHolder<?> recipe, List<Slot> list) {
        ((DisplayRecipe)this.ghostRecipe).addIngredient(ingredient, list.get(0));
    }

    @Redirect(method={"addItemToSlot"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/recipebook/GhostRecipe;addIngredient(Lnet/minecraft/world/item/crafting/Ingredient;II)V"))
    public void addItemToSlot(GhostRecipe instance, Ingredient ingredient, int i, int j, Iterator<Ingredient> iterator, int index) {
        ((DisplayRecipe)this.ghostRecipe).addIngredient(ingredient, (Slot)this.menu.slots.get(index));
    }

    @Inject(method={"renderGhostRecipeTooltip"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderGhostRecipeTooltip(GuiGraphics guiGraphics, int leftPos, int topPos, int k, int l, CallbackInfo info) {
        info.cancel();
        ItemStack itemStack = null;
        for (int m = 0; m < this.ghostRecipe.size(); ++m) {
            LegacyIconHolder holder = ScreenUtil.iconHolderRenderer.slotBounds(((DisplayRecipe)this.ghostRecipe).ingredientSlots.get(m));
            int n = holder.getX() + leftPos;
            int o = holder.getY() + topPos;
            if (k < n || l < o || (float)k >= (float)n + holder.getSelectableWidth() || (float)l >= (float)o + holder.getSelectableHeight()) continue;
            itemStack = this.ghostRecipe.get(m).getItem();
        }
        if (itemStack != null && this.minecraft.screen != null) {
            guiGraphics.renderComponentTooltip(this.minecraft.font, Screen.getTooltipFromItem((Minecraft)this.minecraft, itemStack), k, l);
        }
    }
}

