/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.RecipeToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

@Mixin(value={RecipeToast.class})
public abstract class RecipeToastMixin
implements Toast {
    @Shadow
    @Final
    private static Component TITLE_TEXT;
    @Shadow
    @Final
    private static Component DESCRIPTION_TEXT;
    @Shadow
    private boolean changed;
    @Shadow
    @Final
    private List<RecipeHolder<?>> recipes;
    @Shadow
    private long lastChanged;

    public int width() {
        return 70 + 3 * Minecraft.getInstance().font.width((FormattedText)TITLE_TEXT) / 2;
    }

    public int height() {
        return 40;
    }

    @Inject(method={"addOrUpdate"}, at={@At(value="HEAD")}, cancellable=true)
    private static void addOrUpdate(CallbackInfo ci) {
        if (!ScreenUtil.hasClassicCrafting()) {
            ci.cancel();
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    public void render(GuiGraphics guiGraphics, ToastComponent toastComponent, long l, CallbackInfoReturnable<Toast.Visibility> cir) {
        if (this.changed) {
            this.lastChanged = l;
            this.changed = false;
        }
        if (this.recipes.isEmpty() || !ScreenUtil.hasClassicCrafting()) {
            cir.setReturnValue((Object)Toast.Visibility.HIDE);
            return;
        }
        RecipeHolder<?> recipeHolder = this.recipes.get((int)((double)l / Math.max(1.0, 5000.0 * toastComponent.getNotificationDisplayTimeMultiplier() / (double)this.recipes.size()) % (double)this.recipes.size()));
        ScreenUtil.renderPointerPanel(guiGraphics, 0, 0, this.width(), this.height());
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(((float)this.width() - 1.5f * (float)Minecraft.getInstance().font.width((FormattedText)TITLE_TEXT)) / 2.0f, 10.0f, 0.0f);
        guiGraphics.pose().scale(1.5f, 1.5f, 1.5f);
        guiGraphics.drawString(Minecraft.getInstance().font, TITLE_TEXT, 0, 0, 0xFFFFFF);
        guiGraphics.pose().popPose();
        guiGraphics.drawString(Minecraft.getInstance().font, DESCRIPTION_TEXT, (this.width() - Minecraft.getInstance().font.width((FormattedText)DESCRIPTION_TEXT)) / 2, 27, 0xFFFFFF);
        ItemStack toastSymbol = recipeHolder.value().getToastSymbol();
        ItemStack resultItem = recipeHolder.value().getResultItem(Minecraft.getInstance().level.registryAccess());
        ScreenUtil.iconHolderRenderer.itemHolder(8, (this.height() - 27) / 2, 27, 27, toastSymbol, false, Vec3.ZERO).renderItem(guiGraphics, 0, 0, 0.0f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SMALL_PANEL, this.width() - 36, (this.height() - 28) / 2, 28, 28);
        guiGraphics.renderItem(resultItem, this.width() - 30, (this.height() - 16) / 2);
        cir.setReturnValue((Object)((double)(l - this.lastChanged) >= 5000.0 * toastComponent.getNotificationDisplayTimeMultiplier() ? Toast.Visibility.HIDE : Toast.Visibility.SHOW));
    }
}

