/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stat;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.legacy.entity.LegacyPlayer;
import wily.legacy.entity.LegacyPlayerInfo;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends Player
implements LegacyPlayer,
LegacyPlayerInfo {
    @Shadow
    @Final
    public ServerPlayerGameMode gameMode;
    int position = -1;
    boolean classicCrafting = true;
    boolean classicTrading = true;
    boolean classicStonecutting = true;
    boolean classicLoom = true;
    boolean disableExhaustion = false;
    boolean mayFlySurvival = false;

    @Shadow
    public abstract void onUpdateAbilities();

    @Shadow
    public abstract ServerStatsCounter getStats();

    @Shadow
    public abstract ServerLevel serverLevel();

    public ServerPlayerMixin(Level level, BlockPos blockPos, float f, GameProfile gameProfile) {
        super(level, blockPos, f, gameProfile);
    }

    @Override
    public GameProfile legacyMinecraft$getProfile() {
        return this.getGameProfile();
    }

    @Override
    public int getIdentifierIndex() {
        return this.position;
    }

    @Override
    public void setIdentifierIndex(int i) {
        this.position = i;
    }

    @Override
    public boolean hasClassicCrafting() {
        return this.classicCrafting;
    }

    @Override
    public void setCrafting(boolean classic) {
        this.classicCrafting = classic;
    }

    @Override
    public boolean hasClassicTrading() {
        return this.classicTrading;
    }

    @Override
    public void setTrading(boolean classic) {
        this.classicTrading = classic;
    }

    @Override
    public boolean hasClassicStonecutting() {
        return this.classicStonecutting;
    }

    @Override
    public void setStonecutting(boolean classic) {
        this.classicStonecutting = classic;
    }

    @Override
    public boolean hasClassicLoom() {
        return this.classicLoom;
    }

    @Override
    public void setLoom(boolean classic) {
        this.classicLoom = classic;
    }

    @Override
    public boolean isExhaustionDisabled() {
        return this.disableExhaustion;
    }

    @Override
    public void setDisableExhaustion(boolean exhaustion) {
        this.disableExhaustion = exhaustion;
    }

    @Override
    public void setMayFlySurvival(boolean mayFlySurvival) {
        this.mayFlySurvival = mayFlySurvival;
    }

    @Override
    public boolean mayFlySurvival() {
        return this.mayFlySurvival;
    }

    @Override
    public boolean isVisible() {
        return !super.isInvisible();
    }

    @Override
    public Object2IntMap<Stat<?>> getStatsMap() {
        return this.getStats().stats;
    }

    @Override
    public void setStatsMap(Object2IntMap<Stat<?>> statsMap) {
        this.getStats().stats.clear();
        this.getStats().stats.putAll(statsMap);
    }

    @Override
    public void setVisibility(boolean visible) {
        super.setInvisible(!visible);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    public void addAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        compoundTag.putBoolean("DisableExhaustion", this.isExhaustionDisabled());
        compoundTag.putBoolean("MayFlySurvival", this.mayFlySurvival());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    public void readAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        this.setDisableExhaustion(compoundTag.getBoolean("DisableExhaustion"));
        this.setMayFlySurvival(compoundTag.getBoolean("MayFlySurvival"));
    }

    @Inject(method={"startSleepInBed"}, at={@At(value="RETURN")}, cancellable=true)
    public void startSleepInBed(BlockPos blockPos, CallbackInfoReturnable<Either<Player.BedSleepingProblem, Unit>> cir) {
        Either either = (Either)cir.getReturnValue();
        if (this.level().isDay() && either.left().isPresent() && either.left().get() == Player.BedSleepingProblem.NOT_POSSIBLE_NOW && !this.isCreative()) {
            Vec3 vec3 = Vec3.atBottomCenterOf((Vec3i)blockPos);
            if (!this.level().getEntitiesOfClass(Monster.class, new AABB(vec3.x() - 8.0, vec3.y() - 5.0, vec3.z() - 8.0, vec3.x() + 8.0, vec3.y() + 5.0, vec3.z() + 8.0), argx -> argx.isPreventingPlayerRest((Player)this)).isEmpty()) {
                cir.setReturnValue((Object)Either.left((Object)Player.BedSleepingProblem.NOT_SAFE));
            }
        }
    }

    @Inject(method={"drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;"}, at={@At(value="RETURN")})
    public void drop(ItemStack itemStack, boolean bl, boolean bl2, CallbackInfoReturnable<ItemEntity> cir) {
        if (cir.getReturnValue() != null && !this.level().isClientSide && bl2) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.ITEM_PICKUP, this.getSoundSource(), 1.0f, 1.0f);
        }
    }
}

