/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SnowLayerBlock.class})
public class SnowLayerBlockMixin
extends Block
implements Fallable {
    public SnowLayerBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void onPlace(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        level.scheduleTick(blockPos, (Block)this, this.getDelayAfterPlace());
    }

    @Inject(method={"updateShape"}, at={@At(value="HEAD")}, cancellable=true)
    private void updateShape(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2, CallbackInfoReturnable<BlockState> cir) {
        levelAccessor.scheduleTick(blockPos, (Block)this, this.getDelayAfterPlace());
        cir.setReturnValue((Object)super.updateShape(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2));
    }

    public void tick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (!FallingBlock.isFree((BlockState)serverLevel.getBlockState(blockPos.below())) || blockPos.getY() < serverLevel.getMinBuildHeight()) {
            return;
        }
        FallingBlockEntity.fall((Level)serverLevel, (BlockPos)blockPos, (BlockState)blockState);
    }

    protected int getDelayAfterPlace() {
        return 2;
    }

    public void animateTick(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        if (randomSource.nextInt(16) == 0 && FallingBlock.isFree((BlockState)level.getBlockState(blockPos.below()))) {
            ParticleUtils.spawnParticleBelow((Level)level, (BlockPos)blockPos, (RandomSource)randomSource, (ParticleOptions)new BlockParticleOption(ParticleTypes.FALLING_DUST, blockState));
        }
    }
}

