/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.brewing;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.BrewingStandScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.BrewingStandMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.util.LegacySprites;

@Mixin(value={BrewingStandScreen.class})
public abstract class BrewingStandScreenMixin
extends AbstractContainerScreen<BrewingStandMenu> {
    @Shadow
    @Final
    private static int[] BUBBLELENGTHS;
    private static final Vec3 BREWING_SLOT_OFFSET;
    private static final LegacySlotDisplay FIRST_BREWING_SLOT_DISPLAY;
    private static final LegacySlotDisplay SECOND_BREWING_SLOT_DISPLAY;
    private static final LegacySlotDisplay THIRD_BREWING_SLOT_DISPLAY;
    private static final LegacySlotDisplay FOURTH_BREWING_SLOT_DISPLAY;

    private static LegacySlotDisplay createBrewingSlotDisplay(final Vec3 offset) {
        return new LegacySlotDisplay(){

            @Override
            public Vec3 getOffset() {
                return offset;
            }

            @Override
            public int getWidth() {
                return 27;
            }

            @Override
            public ArbitrarySupplier<ResourceLocation> getIconHolderOverride() {
                return EMPTY_OVERRIDE;
            }
        };
    }

    public BrewingStandScreenMixin(BrewingStandMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
    }

    @Inject(method={"init"}, at={@At(value="HEAD")}, cancellable=true)
    public void init(CallbackInfo ci) {
        ci.cancel();
        this.imageWidth = 213;
        this.imageHeight = 225;
        this.inventoryLabelX = 13;
        this.inventoryLabelY = 115;
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
        this.titleLabelY = 11;
        super.init();
        this.topPos -= 20;
        for (int i = 0; i < ((BrewingStandMenu)this.menu).slots.size(); ++i) {
            final Slot s = (Slot)((BrewingStandMenu)this.menu).slots.get(i);
            if (i == 0) {
                LegacySlotDisplay.override(s, 60, 76, FIRST_BREWING_SLOT_DISPLAY);
                continue;
            }
            if (i == 1) {
                LegacySlotDisplay.override(s, 94, 87, SECOND_BREWING_SLOT_DISPLAY);
                continue;
            }
            if (i == 2) {
                LegacySlotDisplay.override(s, 129, 76, THIRD_BREWING_SLOT_DISPLAY);
                continue;
            }
            if (i == 3) {
                LegacySlotDisplay.override(s, 94, 25, FOURTH_BREWING_SLOT_DISPLAY);
                continue;
            }
            if (i == 4) {
                LegacySlotDisplay.override(s, 19, 25, new LegacySlotDisplay(){

                    @Override
                    public Vec3 getOffset() {
                        return BREWING_SLOT_OFFSET;
                    }

                    @Override
                    public int getWidth() {
                        return 27;
                    }

                    @Override
                    public ResourceLocation getIconSprite() {
                        return s.getItem().isEmpty() ? LegacySprites.BREWING_FUEL_SLOT : null;
                    }
                });
                continue;
            }
            if (i < ((BrewingStandMenu)this.menu).slots.size() - 9) {
                LegacySlotDisplay.override(s, 14 + (s.getContainerSlot() - 9) % 9 * 21, 126 + (s.getContainerSlot() - 9) / 9 * 21);
                continue;
            }
            LegacySlotDisplay.override(s, 14 + s.getContainerSlot() * 21, 195);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBg(guiGraphics, f, i, j);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int i, int j) {
        super.renderLabels(guiGraphics, i, j);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.BREWING_COIL_FLAME, 43, 42, 51, 33);
        int fuel = ((BrewingStandMenu)this.menu).getFuel();
        int n = Mth.clamp((int)((27 * fuel + 20 - 1) / 20), (int)0, (int)27);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(65.5f, 66.0f, 0.0f);
        if (n > 0) {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.FUEL_LENGTH_SPRITE, 27, 6, 0, 0, 0, 0, 0, n, 6);
        }
        guiGraphics.pose().popPose();
    }

    @Inject(method={"renderBg"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderBg(GuiGraphics guiGraphics, float f, int i, int j, CallbackInfo ci) {
        ci.cancel();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite((ResourceLocation)UIAccessor.of((Screen)this).getElementValue("imageSprite", (Object)LegacySprites.SMALL_PANEL, ResourceLocation.class), this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((double)((float)this.leftPos + 58.5f), (double)this.topPos + 22.5, 0.0);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.BREWING_SLOTS, 0, 0, 96, 96);
        guiGraphics.pose().popPose();
        int o = ((BrewingStandMenu)this.menu).getBrewingTicks();
        if (o > 0) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((double)((float)this.leftPos + 121.5f), (double)this.topPos + 22.5, 0.0);
            guiGraphics.pose().scale(0.5f, 0.5f, 0.5f);
            int p = (int)(84.0f * (1.0f - (float)o / 400.0f));
            if (p > 0) {
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.BREW_PROGRESS_SPRITE, 27, 84, 0, 0, 0, 0, 0, 27, p);
            }
            guiGraphics.pose().popPose();
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)this.leftPos + 71.0f, (float)(this.topPos + 21), 0.0f);
            guiGraphics.pose().scale(1.5f, 1.5f, 1.5f);
            p = BUBBLELENGTHS[o / 2 % 7];
            if (p > 0) {
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.BUBBLES_SPRITE, 12, 29, 0, 29 - p, 0, 29 - p, 0, 12, p);
            }
            guiGraphics.pose().popPose();
        }
    }

    static {
        BREWING_SLOT_OFFSET = new Vec3(0.0, 0.5, 0.0);
        FIRST_BREWING_SLOT_DISPLAY = BrewingStandScreenMixin.createBrewingSlotDisplay(BREWING_SLOT_OFFSET);
        SECOND_BREWING_SLOT_DISPLAY = BrewingStandScreenMixin.createBrewingSlotDisplay(new Vec3(0.5, 0.0, 0.0));
        THIRD_BREWING_SLOT_DISPLAY = BrewingStandScreenMixin.createBrewingSlotDisplay(BREWING_SLOT_OFFSET);
        FOURTH_BREWING_SLOT_DISPLAY = BrewingStandScreenMixin.createBrewingSlotDisplay(new Vec3(0.5, 0.5, 0.0));
    }
}

