/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.chat;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.CommandSuggestions;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.legacy.client.ControlType;
import wily.legacy.client.controller.BindingState;
import wily.legacy.client.controller.Controller;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.ScreenUtil;

@Mixin(value={ChatScreen.class})
public abstract class ChatScreenMixin
extends Screen
implements Controller.Event,
ControlTooltip.Event {
    @Shadow
    protected EditBox input;
    @Shadow
    CommandSuggestions commandSuggestions;

    @Shadow
    public abstract boolean handleChatInput(String var1, boolean var2);

    @Shadow
    private void setChatLine(String string) {
    }

    protected ChatScreenMixin(Component component) {
        super(component);
    }

    public void added() {
        super.added();
        ControlTooltip.Renderer.of(this).replace(1, i -> i, c -> ControlType.getActiveType().isKbm() ? (this.input.getValue().isBlank() ? null : (this.input.getValue().startsWith("/") ? LegacyComponents.SEND_COMMAND : LegacyComponents.SEND_MESSAGE)) : c).add(() -> !ControlType.getActiveType().isKbm() ? ControllerBinding.START.getIcon() : null, () -> this.commandSuggestions.isVisible() ? LegacyComponents.USE_SUGGESTION : (this.input.getValue().isBlank() ? null : (this.input.getValue().startsWith("/") ? LegacyComponents.SEND_COMMAND : LegacyComponents.SEND_MESSAGE)));
    }

    @Inject(method={"init"}, at={@At(value="FIELD", target="Lnet/minecraft/client/gui/screens/ChatScreen;input:Lnet/minecraft/client/gui/components/EditBox;", opcode=181, shift=At.Shift.AFTER)})
    private void init(CallbackInfo ci) {
        this.input.setHeight(20);
        this.input.setPosition(4 + Math.round(ScreenUtil.getChatSafeZone()), this.height - this.input.getHeight() + (int)(ScreenUtil.getHUDDistance() - 56.0));
        this.input.setWidth(this.width - (8 + Math.round(ScreenUtil.getChatSafeZone()) * 2));
    }

    public void tick() {
        super.tick();
        if (this.getFocused() != this.input) {
            this.setFocused((GuiEventListener)this.input);
        }
    }

    @Redirect(method={"init"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/EditBox;setBordered(Z)V"))
    private void setBordered(EditBox instance, boolean bl) {
    }

    @Redirect(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/CommandSuggestions;render(Lnet/minecraft/client/gui/GuiGraphics;II)V"))
    private void render(CommandSuggestions instance, GuiGraphics guiGraphics, int i, int j) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, (float)((int)(ScreenUtil.getHUDDistance() - 56.0)), 200.0f);
        instance.render(guiGraphics, i, j);
        guiGraphics.pose().popPose();
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/CommandSuggestions;render(Lnet/minecraft/client/gui/GuiGraphics;II)V"), index=2)
    private int render(int i) {
        return i - (int)(ScreenUtil.getHUDDistance() - 56.0);
    }

    @ModifyArg(method={"mouseClicked"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/CommandSuggestions;mouseClicked(DDI)Z"), index=1)
    private double mouseClicked(double d) {
        return d - (double)((int)(ScreenUtil.getHUDDistance() - 56.0));
    }

    @Redirect(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fill(IIIII)V"))
    private void render(GuiGraphics instance, int i, int j, int k, int l, int m) {
    }

    public void repositionElements() {
        String string = this.input.getValue();
        super.repositionElements();
        this.setChatLine(string);
        this.commandSuggestions.updateCommandInfo();
    }

    @Override
    public void bindingStateTick(BindingState state) {
        if (state.is(ControllerBinding.START) && state.justPressed) {
            if (this.commandSuggestions.isVisible()) {
                this.commandSuggestions.suggestions.useSuggestion();
                this.commandSuggestions.hide();
            } else {
                this.handleChatInput(this.input.getValue(), true);
                this.onClose();
            }
        }
    }
}

