/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.crafter;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CrafterScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CrafterMenu;
import net.minecraft.world.inventory.CrafterSlot;
import net.minecraft.world.inventory.Slot;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.util.LegacySprites;

@Mixin(value={CrafterScreen.class})
public abstract class CrafterScreenMixin
extends AbstractContainerScreen<CrafterMenu> {
    @Shadow
    @Final
    private static Component DISABLED_SLOT_TOOLTIP;
    @Shadow
    @Final
    private static ResourceLocation POWERED_REDSTONE_LOCATION_SPRITE;
    @Shadow
    @Final
    private static ResourceLocation UNPOWERED_REDSTONE_LOCATION_SPRITE;

    public CrafterScreenMixin(CrafterMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBg(guiGraphics, f, i, j);
    }

    @Inject(method={"renderSlot"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderSlot(GuiGraphics guiGraphics, Slot slot, CallbackInfo ci) {
        ci.cancel();
        super.renderSlot(guiGraphics, slot);
    }

    @Inject(method={"init"}, at={@At(value="HEAD")}, cancellable=true)
    public void init(CallbackInfo ci) {
        ci.cancel();
        this.imageWidth = 215;
        this.imageHeight = 202;
        this.inventoryLabelX = 14;
        this.inventoryLabelY = 90;
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
        this.titleLabelY = 11;
        super.init();
        for (int i = 0; i < ((CrafterMenu)this.menu).slots.size(); ++i) {
            final Slot s = (Slot)((CrafterMenu)this.menu).slots.get(i);
            if (i < 9) {
                LegacySlotDisplay.override(s, 34 + s.getContainerSlot() % 3 * 21, 23 + s.getContainerSlot() / 3 * 21, new LegacySlotDisplay(){

                    @Override
                    public ArbitrarySupplier<ResourceLocation> getIconHolderOverride() {
                        return () -> ((CrafterMenu)CrafterScreenMixin.this.menu).isSlotDisabled(s2.index) ? LegacySprites.DISABLED_CRAFTER_SLOT : LegacySprites.CRAFTER_SLOT;
                    }
                });
                continue;
            }
            if (i < ((CrafterMenu)this.menu).slots.size() - 10) {
                LegacySlotDisplay.override(s, 14 + (s.getContainerSlot() - 9) % 9 * 21, 102 + (s.getContainerSlot() - 9) / 9 * 21);
                continue;
            }
            if (i < ((CrafterMenu)this.menu).slots.size() - 1) {
                LegacySlotDisplay.override(s, 14 + s.getContainerSlot() * 21, 171);
                continue;
            }
            LegacySlotDisplay.override(s, 150, 39, new LegacySlotDisplay(){

                @Override
                public ArbitrarySupplier<ResourceLocation> getIconHolderOverride() {
                    return () -> LegacySprites.NON_INTERACTIVE_RESULT_SLOT;
                }

                @Override
                public int getWidth() {
                    return 32;
                }
            });
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    public void render(GuiGraphics guiGraphics, int i, int j, float f, CallbackInfo ci) {
        ci.cancel();
        super.render(guiGraphics, i, j, f);
        this.renderTooltip(guiGraphics, i, j);
        if (this.hoveredSlot instanceof CrafterSlot && !((CrafterMenu)this.menu).isSlotDisabled(this.hoveredSlot.index) && ((CrafterMenu)this.menu).getCarried().isEmpty() && !this.hoveredSlot.hasItem()) {
            guiGraphics.renderTooltip(this.font, DISABLED_SLOT_TOOLTIP, i, j);
        }
    }

    @Inject(method={"renderBg"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderBg(GuiGraphics guiGraphics, float f, int i, int j, CallbackInfo ci) {
        ci.cancel();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite((ResourceLocation)UIAccessor.of((Screen)this).getElementValue("imageSprite", (Object)LegacySprites.SMALL_PANEL, ResourceLocation.class), this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(((CrafterMenu)this.menu).isPowered() ? POWERED_REDSTONE_LOCATION_SPRITE : UNPOWERED_REDSTONE_LOCATION_SPRITE, this.leftPos + 105, this.topPos + 43, 24, 24);
    }
}

